/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyConstraintToRule;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.UpgradeDependencyVersion;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;

@Incubating(since="8.18.0")
public final class UpgradeTransitiveDependencyVersion
extends Recipe {
    private static final MethodMatcher DEPENDENCIES_DSL_MATCHER = new MethodMatcher("RewriteGradleProject dependencies(..)");
    private static final MethodMatcher CONSTRAINTS_MATCHER = new MethodMatcher("org.gradle.api.artifacts.dsl.DependencyHandler constraints(..)", true);
    private static final String CONSTRAINT_MATCHER = "org.gradle.api.artifacts.dsl.DependencyHandler *(..)";
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Because", description="The reason for upgrading the transitive dependency. For example, we could be responding to a vulnerability.", required=false, example="CVE-2021-1234")
    private final @Nullable String because;
    @Option(displayName="Include configurations", description="A list of configurations to consider during the upgrade. For example, For example using `implementation, runtimeOnly`, we could be responding to a deployable asset vulnerability only (ignoring test scoped vulnerabilities).", required=false, example="implementation, runtimeOnly")
    private final @Nullable List<String> onlyForConfigurations;
    private static final String INDIVIDUAL_CONSTRAINT_SNIPPET_GROOVY = "plugins {\n    id 'java'\n}\ndependencies {\n    constraints {\n        implementation('foobar')\n    }\n}";
    private static final String INDIVIDUAL_CONSTRAINT_SNIPPET_KOTLIN = "plugins {\n    id(\"java\")\n}\ndependencies {\n    constraints {\n        implementation(\"foobar\")\n    }\n}";
    private static final String INDIVIDUAL_CONSTRAINT_BECAUSE_SNIPPET_GROOVY = "plugins {\n    id 'java'\n}\ndependencies {\n    constraints {\n        implementation('foobar') {\n            because 'because'\n        }\n    }\n}";
    private static final String INDIVIDUAL_CONSTRAINT_BECAUSE_SNIPPET_KOTLIN = "plugins {\n    id(\"java\")\n}\ndependencies {\n    constraints {\n        implementation(\"foobar\") {\n            because(\"because\")\n        }\n    }\n}";

    private static Map<String, Optional<JavaSourceFile>> snippetCache(ExecutionContext ctx) {
        return (Map)ctx.getMessages().computeIfAbsent(UpgradeTransitiveDependencyVersion.class.getName() + ".snippetCache", k -> new HashMap());
    }

    private static Optional<JavaSourceFile> parseAsGradle(String snippet, boolean isKotlinDsl, ExecutionContext ctx) {
        return UpgradeTransitiveDependencyVersion.snippetCache(ctx).computeIfAbsent(snippet, s -> GradleParser.builder().build().parseInputs(Collections.singletonList(new Parser.Input(Paths.get("build.gradle" + (isKotlinDsl ? ".kts" : ""), new String[0]), () -> new ByteArrayInputStream(snippet.getBytes(StandardCharsets.UTF_8)))), null, ctx).findFirst().map(maybeCu -> {
            maybeCu.getMarkers().findFirst(ParseExceptionResult.class).ifPresent(per -> {
                throw new IllegalStateException("Encountered exception " + per.getExceptionType() + " with message " + per.getMessage() + " on snippet:\n" + snippet);
            });
            return (JavaSourceFile)maybeCu;
        }));
    }

    public String getDisplayName() {
        return "Upgrade transitive Gradle dependencies";
    }

    public String getDescription() {
        return "Upgrades the version of a transitive dependency in a Gradle build file. There are many ways to do this in Gradle, so the mechanism for upgrading a transitive dependency must be considered carefully depending on your style of dependency management.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final DependencyMatcher dependencyMatcher = new DependencyMatcher(this.groupId, this.artifactId, null);
        return Preconditions.check((Recipe)new FindGradleProject(FindGradleProject.SearchCriteria.Marker), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            GradleProject gradleProject;

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    this.gradleProject = (GradleProject)cu.getMarkers().findFirst(GradleProject.class).orElseThrow(() -> new IllegalStateException("Unable to find GradleProject marker."));
                    LinkedHashMap<GroupArtifact, Map<GradleDependencyConfiguration, String>> toUpdate = new LinkedHashMap<GroupArtifact, Map<GradleDependencyConfiguration, String>>();
                    DependencyVersionSelector versionSelector = new DependencyVersionSelector(UpgradeTransitiveDependencyVersion.this.metadataFailures, this.gradleProject, null);
                    for (GradleDependencyConfiguration gradleDependencyConfiguration : this.gradleProject.getConfigurations()) {
                        for (ResolvedDependency resolved : gradleDependencyConfiguration.getResolved()) {
                            if (resolved.getDepth() <= 0 || !dependencyMatcher.matches(resolved.getGroupId(), resolved.getArtifactId(), resolved.getVersion())) continue;
                            try {
                                GradleDependencyConfiguration constraintConfig;
                                String selected = versionSelector.select(resolved.getGav(), gradleDependencyConfiguration.getName(), UpgradeTransitiveDependencyVersion.this.version, UpgradeTransitiveDependencyVersion.this.versionPattern, ctx);
                                if (selected == null || resolved.getVersion().equals(selected) || (constraintConfig = this.constraintConfiguration(gradleDependencyConfiguration)) == null) continue;
                                toUpdate.merge(new GroupArtifact(resolved.getGroupId(), resolved.getArtifactId()), Collections.singletonMap(constraintConfig, selected), (existing, update) -> {
                                    LinkedHashMap all = new LinkedHashMap(existing);
                                    all.putAll(update);
                                    all.keySet().removeIf(c -> {
                                        if (c == null) {
                                            return true;
                                        }
                                        for (GradleDependencyConfiguration config : all.keySet()) {
                                            if (c.allExtendsFrom().contains(config)) {
                                                return true;
                                            }
                                            if (c.getName().equals("runtimeOnly") && config.getName().equals("implementation")) {
                                                return true;
                                            }
                                            if (!c.getName().equals("testRuntimeOnly") || !config.getName().equals("testImplementation") && !config.getName().equals("implementation")) continue;
                                            return true;
                                        }
                                        return false;
                                    });
                                    return all;
                                });
                            }
                            catch (MavenDownloadingException e) {
                                return (J)Markup.warn((Tree)cu, (Throwable)e);
                            }
                        }
                    }
                    if (!toUpdate.isEmpty()) {
                        cu = (JavaSourceFile)Preconditions.check((TreeVisitor)Preconditions.not((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                                if (tree instanceof G.CompilationUnit) {
                                    return new UsesMethod(CONSTRAINTS_MATCHER).visit(tree, (Object)ctx);
                                }
                                return (J)super.visit(tree, (Object)ctx);
                            }

                            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                                if (m.getSimpleName().equals("constraints") && UpgradeTransitiveDependencyVersion.withinBlock(this.getCursor(), "dependencies")) {
                                    return (J.MethodInvocation)SearchResult.found((Tree)m);
                                }
                                return m;
                            }
                        }), (TreeVisitor)new AddConstraintsBlock(cu instanceof K.CompilationUnit)).visitNonNull((Tree)cu, (Object)ctx);
                        for (Map.Entry entry : toUpdate.entrySet()) {
                            Map configs = (Map)entry.getValue();
                            for (Map.Entry config : configs.entrySet()) {
                                cu = (JavaSourceFile)new AddConstraint(cu instanceof K.CompilationUnit, ((GradleDependencyConfiguration)config.getKey()).getName(), new GroupArtifactVersion(((GroupArtifact)entry.getKey()).getGroupId(), ((GroupArtifact)entry.getKey()).getArtifactId(), (String)config.getValue()), UpgradeTransitiveDependencyVersion.this.because).visitNonNull((Tree)cu, ctx);
                            }
                        }
                        cu = (JavaSourceFile)cu.withMarkers(cu.getMarkers().setByType((Marker)this.updatedModel(this.gradleProject, toUpdate, ctx)));
                        if (this.gradleProject.getPlugins().stream().anyMatch(plugin -> "io.spring.dependency-management".equals(plugin.getId()))) {
                            cu = (JavaSourceFile)new DependencyConstraintToRule().getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                        }
                    }
                    return cu;
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            private GradleProject updatedModel(GradleProject gradleProject, Map<GroupArtifact, Map<GradleDependencyConfiguration, String>> toUpdate, ExecutionContext ctx) {
                GradleProject gp = gradleProject;
                Set<String> configNames = gp.getConfigurations().stream().map(GradleDependencyConfiguration::getName).collect(Collectors.toSet());
                LinkedHashSet<GroupArtifactVersion> gavs = new LinkedHashSet<GroupArtifactVersion>();
                for (Map.Entry<GroupArtifact, Map<GradleDependencyConfiguration, String>> update : toUpdate.entrySet()) {
                    Map<GradleDependencyConfiguration, String> configs = update.getValue();
                    String groupId = update.getKey().getGroupId();
                    String artifactId = update.getKey().getArtifactId();
                    for (Map.Entry<GradleDependencyConfiguration, String> configToVersion : configs.entrySet()) {
                        String newVersion = configToVersion.getValue();
                        gavs.add(new GroupArtifactVersion(groupId, artifactId, newVersion));
                    }
                }
                for (GroupArtifactVersion gav : gavs) {
                    gp = UpgradeDependencyVersion.replaceVersion(gp, ctx, gav, configNames);
                }
                return gp;
            }

            private @Nullable GradleDependencyConfiguration constraintConfiguration(GradleDependencyConfiguration config) {
                GradleDependencyConfiguration configuration;
                String constraintConfigName = config.getName();
                switch (constraintConfigName) {
                    case "compileClasspath": 
                    case "compileOnly": 
                    case "compile": {
                        constraintConfigName = "implementation";
                        break;
                    }
                    case "runtimeClasspath": 
                    case "runtime": {
                        constraintConfigName = "runtimeOnly";
                        break;
                    }
                    case "testCompileClasspath": 
                    case "testCompile": {
                        constraintConfigName = "testImplementation";
                        break;
                    }
                    case "testRuntimeClasspath": 
                    case "testRuntime": {
                        constraintConfigName = "testRuntimeOnly";
                    }
                }
                if (UpgradeTransitiveDependencyVersion.this.onlyForConfigurations != null) {
                    if (!UpgradeTransitiveDependencyVersion.this.onlyForConfigurations.contains(constraintConfigName)) {
                        return null;
                    }
                } else {
                    for (GradleDependencyConfiguration extended : config.getExtendsFrom()) {
                        if (!extended.getName().equals(constraintConfigName)) continue;
                        return extended;
                    }
                }
                if ((configuration = this.gradleProject.getConfiguration(constraintConfigName)) != null && configuration.isTransitive()) {
                    return configuration;
                }
                return null;
            }
        });
    }

    private static boolean withinBlock(Cursor cursor, String name) {
        for (Cursor parentCursor = cursor.getParent(); parentCursor != null; parentCursor = parentCursor.getParent()) {
            J.MethodInvocation m;
            if (!(parentCursor.getValue() instanceof J.MethodInvocation) || !(m = (J.MethodInvocation)parentCursor.getValue()).getSimpleName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable String getBecause() {
        return this.because;
    }

    @Generated
    public @Nullable List<String> getOnlyForConfigurations() {
        return this.onlyForConfigurations;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeTransitiveDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", because=" + this.getBecause() + ", onlyForConfigurations=" + this.getOnlyForConfigurations() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeTransitiveDependencyVersion)) {
            return false;
        }
        UpgradeTransitiveDependencyVersion other = (UpgradeTransitiveDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$because = this.getBecause();
        String other$because = other.getBecause();
        if (this$because == null ? other$because != null : !this$because.equals(other$because)) {
            return false;
        }
        List<String> this$onlyForConfigurations = this.getOnlyForConfigurations();
        List<String> other$onlyForConfigurations = other.getOnlyForConfigurations();
        return !(this$onlyForConfigurations == null ? other$onlyForConfigurations != null : !((Object)this$onlyForConfigurations).equals(other$onlyForConfigurations));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradeTransitiveDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $because = this.getBecause();
        result = result * 59 + ($because == null ? 43 : $because.hashCode());
        List<String> $onlyForConfigurations = this.getOnlyForConfigurations();
        result = result * 59 + ($onlyForConfigurations == null ? 43 : ((Object)$onlyForConfigurations).hashCode());
        return result;
    }

    @Generated
    public UpgradeTransitiveDependencyVersion(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String because, @Nullable List<String> onlyForConfigurations) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.because = because;
        this.onlyForConfigurations = onlyForConfigurations;
    }

    private static final class CreateBecauseVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final String because;
        private final boolean isKotlinDsl;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            J.Lambda becauseArg = !this.isKotlinDsl ? UpgradeTransitiveDependencyVersion.parseAsGradle(UpgradeTransitiveDependencyVersion.INDIVIDUAL_CONSTRAINT_BECAUSE_SNIPPET_GROOVY, false, ctx).map(G.CompilationUnit.class::cast).map(cu -> (J.MethodInvocation)cu.getStatements().get(1)).map(dependencies -> (J.Lambda)dependencies.getArguments().get(0)).map(dependenciesClosure -> (Statement)((J.Block)dependenciesClosure.getBody()).getStatements().get(0)).map(J.Return.class::cast).map(returnConstraints -> (Expression)((J.MethodInvocation)Objects.requireNonNull(returnConstraints.getExpression())).getArguments().get(0)).map(J.Lambda.class::cast).map(constraintsClosure -> (Statement)((J.Block)constraintsClosure.getBody()).getStatements().get(0)).map(J.Return.class::cast).map(returnImplementation -> (Expression)((J.MethodInvocation)Objects.requireNonNull(returnImplementation.getExpression())).getArguments().get(1)).map(J.Lambda.class::cast).map(it -> (J.Lambda)new GroovyIsoVisitor<Integer>(){

                public J.Literal visitLiteral(J.Literal literal, Integer integer) {
                    return literal.withValue((Object)because).withValueSource("'" + because + "'");
                }
            }.visitNonNull((Tree)it, (Object)0)).orElseThrow(() -> new IllegalStateException("Unable to parse because text")) : UpgradeTransitiveDependencyVersion.parseAsGradle(UpgradeTransitiveDependencyVersion.INDIVIDUAL_CONSTRAINT_BECAUSE_SNIPPET_KOTLIN, true, ctx).map(K.CompilationUnit.class::cast).map(cu -> (J.Block)cu.getStatements().get(0)).map(block -> (J.MethodInvocation)block.getStatements().get(1)).map(dependencies -> (J.Lambda)dependencies.getArguments().get(0)).map(dependenciesClosure -> (Statement)((J.Block)dependenciesClosure.getBody()).getStatements().get(0)).map(J.Return.class::cast).map(returnConstraints -> (Expression)((J.MethodInvocation)Objects.requireNonNull(returnConstraints.getExpression())).getArguments().get(0)).map(J.Lambda.class::cast).map(constraintsClosure -> (Statement)((J.Block)constraintsClosure.getBody()).getStatements().get(0)).map(J.Return.class::cast).map(returnImplementation -> (Expression)((J.MethodInvocation)Objects.requireNonNull(returnImplementation.getExpression())).getArguments().get(1)).map(J.Lambda.class::cast).map(it -> (J.Lambda)new KotlinIsoVisitor<Integer>(){

                public J.Literal visitLiteral(J.Literal literal, Integer integer) {
                    return literal.withValue((Object)because).withValueSource("\"" + because + "\"");
                }
            }.visitNonNull((Tree)it, (Object)0)).orElseThrow(() -> new IllegalStateException("Unable to parse because text"));
            m = m.withArguments(ListUtils.concat(m.getArguments().subList(0, 1), (Object)becauseArg));
            m = (J.MethodInvocation)this.autoFormat((J)m, ctx, this.getCursor().getParentOrThrow());
            return m;
        }

        @Generated
        public CreateBecauseVisitor(String because, boolean isKotlinDsl) {
            this.because = because;
            this.isKotlinDsl = isKotlinDsl;
        }

        @Generated
        public String getBecause() {
            return this.because;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.CreateBecauseVisitor(because=" + this.getBecause() + ", isKotlinDsl=" + this.isKotlinDsl() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateBecauseVisitor)) {
                return false;
            }
            CreateBecauseVisitor other = (CreateBecauseVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isKotlinDsl() != other.isKotlinDsl()) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof CreateBecauseVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }
    }

    private static final class UpdateBecauseTextVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final String because;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!"because".equals(m.getSimpleName())) {
                return m;
            }
            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                if (arg instanceof J.Literal) {
                    char quote = ((J.Literal)arg).getValueSource() == null ? (char)'\"' : (char)((J.Literal)arg).getValueSource().charAt(0);
                    return ((J.Literal)arg).withValue((Object)this.because).withValueSource(quote + this.because + quote);
                }
                return arg;
            }));
            return m;
        }

        @Generated
        public UpdateBecauseTextVisitor(String because) {
            this.because = because;
        }

        @Generated
        public String getBecause() {
            return this.because;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.UpdateBecauseTextVisitor(because=" + this.getBecause() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateBecauseTextVisitor)) {
                return false;
            }
            UpdateBecauseTextVisitor other = (UpdateBecauseTextVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof UpdateBecauseTextVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }
    }

    private static class RemoveVersionVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveVersionVisitor() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Return visitReturn(J.Return _return, ExecutionContext ctx) {
            J.Return r = super.visitReturn(_return, (Object)ctx);
            if (r.getExpression() == null) {
                return null;
            }
            return r;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if ("version".equals(m.getSimpleName()) && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Lambda) {
                return null;
            }
            return m;
        }
    }

    private static final class UpdateConstraintVersionVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final GroupArtifactVersion gav;
        private final J.MethodInvocation existingConstraint;
        private final @Nullable String because;
        private final boolean isKotlinDsl;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if ("version".equals(method.getSimpleName())) {
                return method;
            }
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (this.existingConstraint.isScope((Tree)m)) {
                AtomicBoolean updatedBecause = new AtomicBoolean(false);
                m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                    if (arg instanceof J.Literal) {
                        String valueSource = ((J.Literal)arg).getValueSource();
                        char quote = valueSource == null ? (char)'\'' : (char)valueSource.charAt(0);
                        return ((J.Literal)arg).withValue((Object)this.gav.toString()).withValueSource(quote + this.gav.toString() + quote);
                    }
                    if (arg instanceof J.Lambda) {
                        arg = (Expression)new RemoveVersionVisitor().visitNonNull((Tree)arg, ctx);
                    }
                    if (this.because != null) {
                        Expression arg2 = (Expression)new UpdateBecauseTextVisitor(this.because).visitNonNull((Tree)arg, ctx, this.getCursor());
                        if (arg2 != arg) {
                            updatedBecause.set(true);
                        }
                        return arg2;
                    }
                    return arg;
                }));
                if (this.because != null && !updatedBecause.get()) {
                    m = (J.MethodInvocation)new CreateBecauseVisitor(this.because, this.isKotlinDsl).visitNonNull((Tree)m, ctx, Objects.requireNonNull(this.getCursor().getParent()));
                }
            }
            return m;
        }

        @Generated
        public UpdateConstraintVersionVisitor(GroupArtifactVersion gav, J.MethodInvocation existingConstraint, @Nullable String because, boolean isKotlinDsl) {
            this.gav = gav;
            this.existingConstraint = existingConstraint;
            this.because = because;
            this.isKotlinDsl = isKotlinDsl;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public J.MethodInvocation getExistingConstraint() {
            return this.existingConstraint;
        }

        @Generated
        public @Nullable String getBecause() {
            return this.because;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.UpdateConstraintVersionVisitor(gav=" + this.getGav() + ", existingConstraint=" + this.getExistingConstraint() + ", because=" + this.getBecause() + ", isKotlinDsl=" + this.isKotlinDsl() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateConstraintVersionVisitor)) {
                return false;
            }
            UpdateConstraintVersionVisitor other = (UpdateConstraintVersionVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isKotlinDsl() != other.isKotlinDsl()) {
                return false;
            }
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !this$gav.equals(other$gav)) {
                return false;
            }
            J.MethodInvocation this$existingConstraint = this.getExistingConstraint();
            J.MethodInvocation other$existingConstraint = other.getExistingConstraint();
            if (this$existingConstraint == null ? other$existingConstraint != null : !this$existingConstraint.equals(other$existingConstraint)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof UpdateConstraintVersionVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : $gav.hashCode());
            J.MethodInvocation $existingConstraint = this.getExistingConstraint();
            result = result * 59 + ($existingConstraint == null ? 43 : $existingConstraint.hashCode());
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }
    }

    private static final class CreateConstraintVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final String config;
        private final GroupArtifactVersion gav;
        private final @Nullable String because;
        private final boolean isKotlinDsl;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if ("version".equals(method.getSimpleName())) {
                return method;
            }
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            J.MethodInvocation constraint = !this.isKotlinDsl ? UpgradeTransitiveDependencyVersion.parseAsGradle(this.because == null ? UpgradeTransitiveDependencyVersion.INDIVIDUAL_CONSTRAINT_SNIPPET_GROOVY : UpgradeTransitiveDependencyVersion.INDIVIDUAL_CONSTRAINT_BECAUSE_SNIPPET_GROOVY, false, ctx).map(G.CompilationUnit.class::cast).map(it -> (J.MethodInvocation)it.getStatements().get(1)).map(dependenciesMethod -> (J.Lambda)dependenciesMethod.getArguments().get(0)).map(dependenciesClosure -> (J.Block)dependenciesClosure.getBody()).map(dependenciesBody -> (J.Return)dependenciesBody.getStatements().get(0)).map(returnConstraints -> (J.MethodInvocation)returnConstraints.getExpression()).map(constraintsInvocation -> (J.Lambda)constraintsInvocation.getArguments().get(0)).map(constraintsLambda -> (J.Block)constraintsLambda.getBody()).map(constraintsBlock -> (J.Return)constraintsBlock.getStatements().get(0)).map(returnConfiguration -> (J.MethodInvocation)returnConfiguration.getExpression()).map(it -> it.withName(it.getName().withSimpleName(this.config)).withArguments(ListUtils.map((List)it.getArguments(), arg -> {
                if (arg instanceof J.Literal) {
                    return ((J.Literal)Objects.requireNonNull(arg)).withValue((Object)this.gav.toString()).withValueSource("'" + this.gav + "'");
                }
                if (arg instanceof J.Lambda && this.because != null) {
                    return (Expression)new GroovyIsoVisitor<Integer>(){

                        public J.Literal visitLiteral(J.Literal literal, Integer integer) {
                            return literal.withValue((Object)because).withValueSource("'" + because + "'");
                        }
                    }.visitNonNull((Tree)arg, (Object)0);
                }
                return arg;
            }))).map(it -> it.withId(Tree.randomId())).orElseThrow(() -> new IllegalStateException("Unable to find constraint")) : UpgradeTransitiveDependencyVersion.parseAsGradle(this.because == null ? UpgradeTransitiveDependencyVersion.INDIVIDUAL_CONSTRAINT_SNIPPET_KOTLIN : UpgradeTransitiveDependencyVersion.INDIVIDUAL_CONSTRAINT_BECAUSE_SNIPPET_KOTLIN, true, ctx).map(K.CompilationUnit.class::cast).map(it -> (J.Block)it.getStatements().get(0)).map(it -> (J.MethodInvocation)it.getStatements().get(1)).map(dependenciesMethod -> (J.Lambda)dependenciesMethod.getArguments().get(0)).map(dependenciesClosure -> (J.Block)dependenciesClosure.getBody()).map(dependenciesBody -> (J.MethodInvocation)dependenciesBody.getStatements().get(0)).map(constraintsInvocation -> (J.Lambda)constraintsInvocation.getArguments().get(0)).map(constraintsLambda -> (J.Block)constraintsLambda.getBody()).map(constraintsBlock -> (J.MethodInvocation)constraintsBlock.getStatements().get(0)).map(it -> it.withName(it.getName().withSimpleName(this.config)).withArguments(ListUtils.map((List)it.getArguments(), arg -> {
                if (arg instanceof J.Literal) {
                    return ChangeStringLiteral.withStringValue((J.Literal)Objects.requireNonNull(arg), this.gav.toString());
                }
                if (arg instanceof J.Lambda && this.because != null) {
                    return (Expression)new KotlinIsoVisitor<Integer>(){

                        public J.Literal visitLiteral(J.Literal literal, Integer integer) {
                            return ChangeStringLiteral.withStringValue(literal, because);
                        }
                    }.visitNonNull((Tree)arg, (Object)0);
                }
                return arg;
            }))).map(it -> it.withId(Tree.randomId())).orElseThrow(() -> new IllegalStateException("Unable to find constraint"));
            m = (J.MethodInvocation)this.autoFormat((J)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                if (!(arg instanceof J.Lambda)) {
                    return arg;
                }
                J.Lambda dependencies = (J.Lambda)arg;
                if (!(dependencies.getBody() instanceof J.Block)) {
                    return arg;
                }
                J.Block body = (J.Block)dependencies.getBody();
                return dependencies.withBody((J)body.withStatements(ListUtils.concat((Object)constraint, (List)body.getStatements())));
            })), ctx, this.getCursor().getParentOrThrow());
            return m;
        }

        @Generated
        public CreateConstraintVisitor(String config, GroupArtifactVersion gav, @Nullable String because, boolean isKotlinDsl) {
            this.config = config;
            this.gav = gav;
            this.because = because;
            this.isKotlinDsl = isKotlinDsl;
        }

        @Generated
        public String getConfig() {
            return this.config;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public @Nullable String getBecause() {
            return this.because;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.CreateConstraintVisitor(config=" + this.getConfig() + ", gav=" + this.getGav() + ", because=" + this.getBecause() + ", isKotlinDsl=" + this.isKotlinDsl() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateConstraintVisitor)) {
                return false;
            }
            CreateConstraintVisitor other = (CreateConstraintVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isKotlinDsl() != other.isKotlinDsl()) {
                return false;
            }
            String this$config = this.getConfig();
            String other$config = other.getConfig();
            if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
                return false;
            }
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !this$gav.equals(other$gav)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof CreateConstraintVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            String $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : $gav.hashCode());
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }
    }

    private static final class AddConstraint
    extends JavaIsoVisitor<ExecutionContext> {
        private final boolean isKotlinDsl;
        private final String config;
        private final GroupArtifactVersion gav;
        private final @Nullable String because;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!(CONSTRAINTS_MATCHER.matches((MethodCall)m) || this.isKotlinDsl && m.getSimpleName().equals("constraints") && UpgradeTransitiveDependencyVersion.withinBlock(this.getCursor(), "dependencies"))) {
                return m;
            }
            String ga = this.gav.getGroupId() + ":" + this.gav.getArtifactId();
            String existingConstraintVersion = null;
            J.MethodInvocation existingConstraint = null;
            MethodMatcher constraintMatcher = new MethodMatcher(UpgradeTransitiveDependencyVersion.CONSTRAINT_MATCHER, true);
            for (Statement statement : ((J.Block)((J.Lambda)m.getArguments().get(0)).getBody()).getStatements()) {
                if (!(statement instanceof J.MethodInvocation) && (!(statement instanceof J.Return) || !(((J.Return)statement).getExpression() instanceof J.MethodInvocation))) continue;
                J.MethodInvocation m2 = (J.MethodInvocation)(statement instanceof J.Return ? ((J.Return)statement).getExpression() : statement);
                if (constraintMatcher.matches((MethodCall)m2)) {
                    if (!m2.getSimpleName().equals(this.config) || !AddConstraint.matchesConstraint(m2, ga)) continue;
                    existingConstraint = m2;
                    existingConstraintVersion = DependencyStringNotationConverter.parse((String)Objects.requireNonNull(((J.Literal)m2.getArguments().get(0)).getValue())).getVersion();
                    continue;
                }
                if (!this.isKotlinDsl || !m.getSimpleName().equals("constraints") || !m2.getSimpleName().equals(this.config) || !AddConstraint.matchesConstraint(m2, ga)) continue;
                existingConstraint = m2;
                existingConstraintVersion = DependencyStringNotationConverter.parse((String)Objects.requireNonNull(((J.Literal)m2.getArguments().get(0)).getValue())).getVersion();
            }
            if (Objects.equals(this.gav.getVersion(), existingConstraintVersion)) {
                return m;
            }
            m = existingConstraint == null ? (J.MethodInvocation)new CreateConstraintVisitor(this.config, this.gav, this.because, this.isKotlinDsl).visitNonNull((Tree)m, ctx, Objects.requireNonNull(this.getCursor().getParent())) : (J.MethodInvocation)new UpdateConstraintVersionVisitor(this.gav, existingConstraint, this.because, this.isKotlinDsl).visitNonNull((Tree)m, ctx, Objects.requireNonNull(this.getCursor().getParent()));
            return m;
        }

        private static boolean matchesConstraint(J.MethodInvocation m, String ga) {
            Expression arg = (Expression)m.getArguments().get(0);
            if (!(arg instanceof J.Literal) || ((J.Literal)arg).getValue() == null) {
                return false;
            }
            String value = ((J.Literal)arg).getValue().toString();
            return value.startsWith(ga);
        }

        @Generated
        public AddConstraint(boolean isKotlinDsl, String config, GroupArtifactVersion gav, @Nullable String because) {
            this.isKotlinDsl = isKotlinDsl;
            this.config = config;
            this.gav = gav;
            this.because = because;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @Generated
        public String getConfig() {
            return this.config;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public @Nullable String getBecause() {
            return this.because;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.AddConstraint(isKotlinDsl=" + this.isKotlinDsl() + ", config=" + this.getConfig() + ", gav=" + this.getGav() + ", because=" + this.getBecause() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddConstraint)) {
                return false;
            }
            AddConstraint other = (AddConstraint)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isKotlinDsl() != other.isKotlinDsl()) {
                return false;
            }
            String this$config = this.getConfig();
            String other$config = other.getConfig();
            if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
                return false;
            }
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !this$gav.equals(other$gav)) {
                return false;
            }
            String this$because = this.getBecause();
            String other$because = other.getBecause();
            return !(this$because == null ? other$because != null : !this$because.equals(other$because));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof AddConstraint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            String $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : $gav.hashCode());
            String $because = this.getBecause();
            result = result * 59 + ($because == null ? 43 : $because.hashCode());
            return result;
        }
    }

    private static final class AddConstraintsBlock
    extends JavaIsoVisitor<ExecutionContext> {
        private final boolean isKotlinDsl;

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (DEPENDENCIES_DSL_MATCHER.matches((MethodCall)method)) {
                G.CompilationUnit withConstraints = (G.CompilationUnit)UpgradeTransitiveDependencyVersion.parseAsGradle("plugins { id 'java' }\ndependencies {\n    constraints {\n    }\n}\n", false, ctx).orElseThrow(() -> new IllegalStateException("Unable to parse constraints block"));
                J.MethodInvocation constraints = FindMethods.find((J)withConstraints, (String)"org.gradle.api.artifacts.dsl.DependencyHandler constraints(..)", (boolean)true).stream().filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(m2 -> m2.getSimpleName().equals("constraints")).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find constraints block")).withMarkers(Markers.EMPTY);
                return (J.MethodInvocation)this.autoFormat((J)m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg_0 -> AddConstraintsBlock.lambda$visitMethodInvocation$4(m, (Statement)constraints, arg_0))), (J)constraints, ctx, this.getCursor().getParentOrThrow());
            }
            if (this.isKotlinDsl && m.getSimpleName().equals("dependencies") && this.getCursor().getParent().firstEnclosing(J.MethodInvocation.class) == null) {
                K.CompilationUnit withConstraints = (K.CompilationUnit)UpgradeTransitiveDependencyVersion.parseAsGradle("plugins { id(\"java\") }\ndependencies {\n    constraints {}\n}\n", true, ctx).orElseThrow(() -> new IllegalStateException("Unable to parse constraints block"));
                J.MethodInvocation constraints = withConstraints.getStatements().stream().map(J.Block.class::cast).flatMap(block -> block.getStatements().stream()).filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(m2 -> m2.getSimpleName().equals("dependencies")).flatMap(dependencies -> ((J.Block)((J.Lambda)dependencies.getArguments().get(0)).getBody()).getStatements().stream()).filter(J.MethodInvocation.class::isInstance).map(J.MethodInvocation.class::cast).filter(m2 -> m2.getSimpleName().equals("constraints")).findFirst().map(m2 -> m2.withArguments(ListUtils.mapFirst((List)m2.getArguments(), arg -> {
                    J.Lambda lambda = (J.Lambda)arg;
                    return lambda.withBody((J)((J.Block)lambda.getBody()).withEnd(Space.format((String)"\n")));
                }))).orElseThrow(() -> new IllegalStateException("Unable to find constraints block")).withMarkers(Markers.EMPTY);
                return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                    if (!(arg instanceof J.Lambda)) {
                        return arg;
                    }
                    J.Lambda dependencies = (J.Lambda)arg;
                    if (!(dependencies.getBody() instanceof J.Block)) {
                        return m;
                    }
                    J.Block body = (J.Block)dependencies.getBody();
                    List statements = ListUtils.mapFirst((List)body.getStatements(), stat -> (Statement)stat.withPrefix(stat.getPrefix().withWhitespace(BlankLinesVisitor.minimumLines((String)stat.getPrefix().getWhitespace(), (int)1))));
                    return dependencies.withBody((J)body.withStatements(ListUtils.concat((Object)((Statement)this.autoFormat((J)constraints, ctx, this.getCursor().getParentOrThrow())), (List)statements)));
                }));
            }
            return m;
        }

        @Generated
        public AddConstraintsBlock(boolean isKotlinDsl) {
            this.isKotlinDsl = isKotlinDsl;
        }

        @Generated
        public boolean isKotlinDsl() {
            return this.isKotlinDsl;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeTransitiveDependencyVersion.AddConstraintsBlock(isKotlinDsl=" + this.isKotlinDsl() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddConstraintsBlock)) {
                return false;
            }
            AddConstraintsBlock other = (AddConstraintsBlock)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return this.isKotlinDsl() == other.isKotlinDsl();
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof AddConstraintsBlock;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isKotlinDsl() ? 79 : 97);
            return result;
        }

        private static /* synthetic */ Expression lambda$visitMethodInvocation$4(J.MethodInvocation m, Statement constraints, Expression arg) {
            if (!(arg instanceof J.Lambda)) {
                return arg;
            }
            J.Lambda dependencies = (J.Lambda)arg;
            if (!(dependencies.getBody() instanceof J.Block)) {
                return m;
            }
            J.Block body = (J.Block)dependencies.getBody();
            List statements = ListUtils.mapFirst((List)body.getStatements(), stat -> (Statement)stat.withPrefix(stat.getPrefix().withWhitespace(BlankLinesVisitor.minimumLines((String)stat.getPrefix().getWhitespace(), (int)1))));
            return dependencies.withBody((J)body.withStatements(ListUtils.concat((Object)constraints, (List)statements)));
        }
    }
}

