/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.Traits;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyExtension
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New extension", description="An artifact extension.", example="jar")
    private final String newExtension;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    private final @Nullable String configuration;

    public String getDisplayName() {
        return "Change a Gradle dependency extension";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s` to `%s`", this.groupId, this.artifactId, this.newExtension);
    }

    public String getDescription() {
        return "Changes extension of an existing dependency declared in `build.gradle` files.";
    }

    public Validated<Object> validate() {
        return super.validate().and(DependencyMatcher.build((String)(this.groupId + ":" + this.artifactId)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                GradleDependency.Matcher gradleDependencyMatcher = Traits.gradleDependency().configuration(ChangeDependencyExtension.this.configuration).groupId(ChangeDependencyExtension.this.groupId).artifactId(ChangeDependencyExtension.this.artifactId);
                if (!gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency dependency;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (dependency = DependencyStringNotationConverter.parse(gav)) != null && !ChangeDependencyExtension.this.newExtension.equals(dependency.getExt())) {
                        Dependency newDependency = dependency.withExt(ChangeDependencyExtension.this.newExtension);
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, newDependency.toStringNotation())));
                    }
                } else if (depArgs.get(0) instanceof G.MapEntry) {
                    G.MapEntry extensionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String extension = null;
                    String extensionStringDelimiter = "'";
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if ("name".equals(keyValue)) {
                            artifactId = valueValue;
                            continue;
                        }
                        if (!"ext".equals(keyValue) || ChangeDependencyExtension.this.newExtension.equals(valueValue)) continue;
                        if (value.getValueSource() != null) {
                            extensionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                        }
                        extensionEntry = arg2;
                        extension = valueValue;
                    }
                    if (groupId == null || artifactId == null || extension == null) {
                        return m;
                    }
                    String delimiter = extensionStringDelimiter;
                    G.MapEntry finalExtension = extensionEntry;
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                        if (arg == finalExtension) {
                            return finalExtension.withValue((Expression)((J.Literal)finalExtension.getValue()).withValue((Object)ChangeDependencyExtension.this.newExtension).withValueSource(delimiter + ChangeDependencyExtension.this.newExtension + delimiter));
                        }
                        return arg;
                    }));
                } else if (depArgs.get(0) instanceof G.MapLiteral) {
                    G.MapLiteral map = (G.MapLiteral)depArgs.get(0);
                    G.MapEntry extensionEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String extension = null;
                    String extensionStringDelimiter = "'";
                    for (G.MapEntry arg3 : map.getElements()) {
                        if (!(arg3.getKey() instanceof J.Literal) || !(arg3.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg3.getKey();
                        J.Literal value = (J.Literal)arg3.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if ("name".equals(keyValue)) {
                            artifactId = valueValue;
                            continue;
                        }
                        if (!"ext".equals(keyValue) || ChangeDependencyExtension.this.newExtension.equals(valueValue)) continue;
                        if (value.getValueSource() != null) {
                            extensionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                        }
                        extensionEntry = arg3;
                        extension = valueValue;
                    }
                    if (groupId == null || artifactId == null || extension == null) {
                        return m;
                    }
                    String delimiter = extensionStringDelimiter;
                    G.MapEntry finalExtension = extensionEntry;
                    m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                        G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                        return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> {
                            if (e == finalExtension) {
                                return finalExtension.withValue((Expression)((J.Literal)finalExtension.getValue()).withValue((Object)ChangeDependencyExtension.this.newExtension).withValueSource(delimiter + ChangeDependencyExtension.this.newExtension + delimiter));
                            }
                            return e;
                        }));
                    }));
                }
                return m;
            }
        });
    }

    @Generated
    public ChangeDependencyExtension(String groupId, String artifactId, String newExtension, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newExtension = newExtension;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getNewExtension() {
        return this.newExtension;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeDependencyExtension(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newExtension=" + this.getNewExtension() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyExtension)) {
            return false;
        }
        ChangeDependencyExtension other = (ChangeDependencyExtension)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newExtension = this.getNewExtension();
        String other$newExtension = other.getNewExtension();
        if (this$newExtension == null ? other$newExtension != null : !this$newExtension.equals(other$newExtension)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeDependencyExtension;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newExtension = this.getNewExtension();
        result = result * 59 + ($newExtension == null ? 43 : $newExtension.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

