/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public final class RemoveRepository
extends Recipe {
    @Option(displayName="Repository", description="The name of the repository to remove", example="jcenter")
    private final String repository;

    public String getDisplayName() {
        return "Remove repository";
    }

    public String getDescription() {
        return "Removes a repository from Gradle build scripts. Named repositories include \"jcenter\", \"mavenCentral\", \"mavenLocal\", and \"google\".";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (RemoveRepository.this.repository.equals(method.getSimpleName())) {
                    try {
                        Cursor cursor = this.getCursor().dropParentUntil(e -> e instanceof J.MethodInvocation);
                        if ("repositories".equals(((J.MethodInvocation)cursor.getValue()).getSimpleName())) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public RemoveRepository(String repository) {
        this.repository = repository;
    }

    @Generated
    public String getRepository() {
        return this.repository;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveRepository(repository=" + this.getRepository() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRepository)) {
            return false;
        }
        RemoveRepository other = (RemoveRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }
}

