/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.Traits;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;

public class DependencyUseMapNotation
extends Recipe {
    public String getDisplayName() {
        return "Use `Map` notation for Gradle dependency declarations";
    }

    public String getDescription() {
        return "In Gradle, dependencies can be expressed as a `String` like `\"groupId:artifactId:version\"`, or equivalently as a `Map` like `group: 'groupId', name: 'artifactId', version: 'version'` (groovy)or `group = \"groupId\", name = \"artifactId\", version = \"version\"` (kotlin). This recipe replaces dependencies represented as `Strings` with an equivalent dependency represented as a `Map`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new GroovyScriptVisitor(), new KotlinScriptVisitor()}));
    }

    private static <T extends Expression> J.MethodInvocation forBasicString(J.MethodInvocation m, BiFunction<String, String, T> mapper, BiFunction<T, Space, T> firstItemPrefixer, Function<J.MethodInvocation, J.MethodInvocation> typeAddition) {
        Expression lastArg;
        Expression e = (Expression)m.getArguments().get(0);
        if (!(e instanceof J.Literal)) {
            return m;
        }
        J.Literal arg = (J.Literal)e;
        if (arg.getType() != JavaType.Primitive.String) {
            return m;
        }
        String dependencyString = (String)arg.getValue();
        if (dependencyString == null) {
            return m;
        }
        Dependency dependency = DependencyStringNotationConverter.parse(dependencyString);
        if (dependency == null) {
            return m;
        }
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        arguments.add((Expression)firstItemPrefixer.apply((Expression)((Expression)mapper.apply("group", dependency.getGroupId())).withMarkers(arg.getMarkers()), arg.getPrefix()));
        arguments.add((Expression)((Expression)mapper.apply("name", dependency.getArtifactId())).withMarkers(arg.getMarkers()));
        if (dependency.getVersion() != null) {
            arguments.add((Expression)((Expression)mapper.apply("version", dependency.getVersion())).withMarkers(arg.getMarkers()));
        }
        if (dependency.getClassifier() != null) {
            arguments.add((Expression)((Expression)mapper.apply("classifier", dependency.getClassifier())).withMarkers(arg.getMarkers()));
        }
        if (dependency.getExt() != null) {
            arguments.add((Expression)((Expression)mapper.apply("ext", dependency.getExt())).withMarkers(arg.getMarkers()));
        }
        m = (lastArg = (Expression)m.getArguments().get(m.getArguments().size() - 1)) instanceof J.Lambda ? m.withArguments(ListUtils.concat(arguments, (Object)lastArg)) : m.withArguments(arguments);
        return typeAddition.apply(m);
    }

    private static <T extends Expression, P extends J, R extends Expression> J.MethodInvocation forStringTemplate(J.MethodInvocation m, Class<T> type, Function<T, List<J>> partsExtractor, Class<P> partsType, Function<P, Tree> getTreeFromTemplatePart, BiFunction<String, String, R> mapper, BiFunction<String, Expression, R> expressionMapper, BiFunction<R, Space, R> firstItemPrefixer, Function<J.MethodInvocation, J.MethodInvocation> typeAddition) {
        Expression e = (Expression)m.getArguments().get(0);
        if (!type.isInstance(e)) {
            return m;
        }
        Expression template = (Expression)type.cast(e);
        List<J> parts = partsExtractor.apply(template);
        if (parts.size() != 2 || !(parts.get(0) instanceof J.Literal) || !partsType.isInstance(parts.get(1))) {
            return m;
        }
        J.Literal arg1 = (J.Literal)parts.get(0);
        if (arg1.getType() != JavaType.Primitive.String || arg1.getValue() == null) {
            return m;
        }
        String[] ga = ((String)arg1.getValue()).split(":");
        if (ga.length != 2) {
            return m;
        }
        J arg2 = (J)partsType.cast(parts.get(1));
        Tree tree = getTreeFromTemplatePart.apply(arg2);
        if (!(tree instanceof Expression)) {
            return m;
        }
        Expression groupEntry = (Expression)firstItemPrefixer.apply((Expression)((Expression)mapper.apply("group", ga[0])).withMarkers(e.getMarkers()), e.getPrefix());
        Expression artifactEntry = (Expression)((Expression)mapper.apply("name", ga[1])).withMarkers(e.getMarkers());
        Expression versionEntry = (Expression)((Expression)expressionMapper.apply("version", (Expression)((Expression)tree).withPrefix(Space.SINGLE_SPACE))).withMarkers(e.getMarkers());
        Expression lastArg = (Expression)m.getArguments().get(m.getArguments().size() - 1);
        m = lastArg instanceof J.Lambda ? m.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry, lastArg)) : m.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry));
        return typeAddition.apply(m);
    }

    private static class GroovyScriptVisitor
    extends GroovyVisitor<ExecutionContext> {
        private GroovyScriptVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            GradleDependency.Matcher gradleDependencyMatcher = Traits.gradleDependency();
            if (!gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                return m;
            }
            m = DependencyUseMapNotation.forBasicString(m, this::mapEntry, G.MapEntry::withPrefix, this::updateTypeForMapArgument);
            m = DependencyUseMapNotation.forStringTemplate(m, G.GString.class, G.GString::getStrings, G.GString.Value.class, G.GString.Value::getTree, this::mapEntry, this::mapEntry, G.MapEntry::withPrefix, this::updateTypeForMapArgument);
            return m;
        }

        private J.MethodInvocation updateTypeForMapArgument(J.MethodInvocation m) {
            JavaType.Method mtype = m.getMethodType();
            if (mtype == null) {
                return m;
            }
            mtype = mtype.withParameterTypes(Collections.singletonList(JavaType.ShallowClass.build((String)"java.util.Map")));
            if (m.getName().getType() != null) {
                m = m.withName(m.getName().withType((JavaType)mtype));
            }
            return m.withMethodType(mtype);
        }

        private G.MapEntry mapEntry(String key, String value) {
            return this.mapEntry(key, (Expression)new J.Literal(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, (Object)value, "'" + value + "'", null, JavaType.Primitive.String));
        }

        private G.MapEntry mapEntry(String key, Expression e) {
            return new G.MapEntry(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), key, null, null)), e, null);
        }
    }

    private static class KotlinScriptVisitor
    extends KotlinVisitor<ExecutionContext> {
        private KotlinScriptVisitor() {
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            GradleDependency.Matcher gradleDependencyMatcher = Traits.gradleDependency();
            if (!gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                return m;
            }
            m = DependencyUseMapNotation.forBasicString(m, this::mapEntry, J.Assignment::withPrefix, Function.identity());
            m = DependencyUseMapNotation.forStringTemplate(m, K.StringTemplate.class, K.StringTemplate::getStrings, K.StringTemplate.Expression.class, K.StringTemplate.Expression::getTree, this::mapEntry, this::mapEntry, J.Assignment::withPrefix, Function.identity());
            return m;
        }

        private J.Assignment mapEntry(String key, String value) {
            return this.mapEntry(key, (Expression)new J.Literal(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, (Object)value, "\"" + value + "\"", null, JavaType.Primitive.String));
        }

        private J.Assignment mapEntry(String key, Expression e) {
            return new J.Assignment(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), key, null, null), JLeftPadded.build((Object)e).withBefore(Space.SINGLE_SPACE), null);
        }
    }
}

