/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.zip.Adler32;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.gradle.internal.GradleWrapperScriptLoader;
import org.openrewrite.gradle.util.DistributionInfos;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.LatestRelease;

public class GradleWrapperScriptDownloader {
    private static final Path WRAPPER_SCRIPTS = Paths.get("rewrite-gradle/src/main/resources/META-INF/rewrite/gradle-wrapper/", new String[0]);

    public static void main(String[] args) throws IOException, InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        List<GradleWrapper.GradleVersion> allGradleReleases = GradleWrapper.listAllVersions(null, (ExecutionContext)ctx);
        ConcurrentHashMap<String, GradleWrapperScriptLoader.Version> allDownloadedVersions = new ConcurrentHashMap<String, GradleWrapperScriptLoader.Version>(new GradleWrapperScriptLoader().getAllVersions());
        AtomicInteger i = new AtomicInteger();
        ForkJoinPool pool = ForkJoinPool.commonPool();
        pool.invokeAll(allGradleReleases.stream().map(version -> () -> {
            String v = version.getVersion();
            String threadName = " [" + Thread.currentThread().getName() + "]";
            if (allDownloadedVersions.containsKey(v)) {
                System.out.printf("%03d: %s already exists. Skipping.%s%n", i.incrementAndGet(), v, threadName);
                return null;
            }
            try {
                DistributionInfos infos = DistributionInfos.fetch(GradleWrapper.DistributionType.Bin, version, (ExecutionContext)ctx);
                GradleWrapper wrapper = new GradleWrapper(v, infos);
                String gradlewChecksum = GradleWrapperScriptDownloader.downloadScript(GradleWrapper.WRAPPER_SCRIPT_LOCATION, wrapper, "unix", ctx);
                String gradlewBatChecksum = GradleWrapperScriptDownloader.downloadScript(GradleWrapper.WRAPPER_BATCH_LOCATION, wrapper, "windows", ctx);
                lock.lock();
                allDownloadedVersions.put(v, new GradleWrapperScriptLoader.Version(v, gradlewChecksum, gradlewBatChecksum));
                ArrayList sortedVersions = new ArrayList(allDownloadedVersions.keySet());
                sortedVersions.sort(new LatestRelease(null).reversed());
                try (BufferedWriter writer = Files.newBufferedWriter(WRAPPER_SCRIPTS.resolve("versions.csv"), new OpenOption[0]);){
                    writer.write("version,gradlew,gradlewBat\n");
                    for (String sortedVersion : sortedVersions) {
                        GradleWrapperScriptLoader.Version version1 = (GradleWrapperScriptLoader.Version)allDownloadedVersions.get(sortedVersion);
                        writer.write(sortedVersion + "," + version1.getGradlewChecksum() + "," + version1.getGradlewBatChecksum() + "\n");
                    }
                }
                System.out.printf("%03d: %s downloaded.%s%n", i.incrementAndGet(), v, threadName);
            }
            catch (Throwable t) {
                System.out.printf("%03d: %s failed to download: %s.%s%n", i.incrementAndGet(), v, t.getMessage(), threadName);
                Void void_ = null;
                return void_;
            }
            finally {
                lock.unlock();
            }
            return null;
        }).collect(Collectors.toList()));
        while (pool.getActiveThreadCount() > 0) {
            Thread.sleep(100L);
        }
    }

    private static String downloadScript(Path wrapperScriptLocation, GradleWrapper wrapper, String os, InMemoryExecutionContext ctx) throws IOException, NoSuchAlgorithmException {
        InputStream is = Remote.builder((Path)wrapperScriptLocation).build(URI.create(wrapper.getDistributionInfos().getDownloadUrl()), new String[]{"gradle-[^\\/]+/(?:.*\\/)+gradle-plugins-.*\\.jar", "org/gradle/api/internal/plugins/" + os + "StartScript.txt"}).getInputStream((ExecutionContext)ctx);
        byte[] scriptText = StringUtils.readFully((InputStream)is).getBytes(StandardCharsets.UTF_8);
        Adler32 adler32 = new Adler32();
        adler32.update(scriptText, 0, scriptText.length);
        String scriptChecksum = Long.toHexString(adler32.getValue());
        Path scriptChecksumPath = WRAPPER_SCRIPTS.resolve(os).resolve(scriptChecksum + ".txt");
        if (!Files.exists(scriptChecksumPath, new LinkOption[0])) {
            Files.write(scriptChecksumPath, scriptText, new OpenOption[0]);
        }
        return scriptChecksum;
    }
}

