/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.UpdateDependencyLock;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.internal.Dependency;
import org.openrewrite.gradle.internal.DependencyStringNotationConverter;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.tree.Version;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradeDependencyVersion
extends ScanningRecipe<DependencyVersionState> {
    private static final String VERSION_VARIABLE_KEY = "VERSION_VARIABLE";
    private static final String GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="29.X", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'newVersion' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    private static final String UPDATE_VERSION_ERROR_KEY = "UPDATE_VERSION_ERROR_KEY";

    public String getDisplayName() {
        return "Upgrade Gradle dependency versions";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Upgrade the version of a dependency in a build.gradle file. Supports updating dependency declarations of various forms:\n * `String` notation: `\"group:artifact:version\"` \n * `Map` notation: `group: 'group', name: 'artifact', version: 'version'`\nCan update version numbers which are defined earlier in the same file in variable declarations.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public DependencyVersionState getInitialValue(ExecutionContext ctx) {
        return new DependencyVersionState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final DependencyVersionState acc) {
        return new JavaVisitor<ExecutionContext>(){
            @Nullable GradleProject gradleProject;

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof G.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle") || sourceFile instanceof K.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle.kts");
            }

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    this.gradleProject = tree.getMarkers().findFirst(GradleProject.class).orElse(null);
                    if (this.gradleProject != null) {
                        acc.modules.add(this.gradleProject);
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                GradleDependency.Matcher gradleDependencyMatcher = new GradleDependency.Matcher();
                if (gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                    if (m.getArguments().get(0) instanceof G.MapEntry) {
                        String declaredGroupId = null;
                        String declaredArtifactId = null;
                        String declaredVersion = null;
                        for (Expression e : m.getArguments()) {
                            G.GString.Value versionGStringValue;
                            Object strings;
                            J.Literal value;
                            G.MapEntry arg;
                            if (!(e instanceof G.MapEntry) || !((arg = (G.MapEntry)e).getKey() instanceof J.Literal)) continue;
                            J.Literal key = (J.Literal)arg.getKey();
                            String valueValue = null;
                            if (arg.getValue() instanceof J.Literal) {
                                value = (J.Literal)arg.getValue();
                                if (value.getValue() instanceof String) {
                                    valueValue = (String)value.getValue();
                                }
                            } else if (arg.getValue() instanceof J.Identifier) {
                                value = (J.Identifier)arg.getValue();
                                valueValue = value.getSimpleName();
                            } else if (arg.getValue() instanceof G.GString && !(strings = (value = (G.GString)arg.getValue()).getStrings()).isEmpty() && strings.get(0) instanceof G.GString.Value && (versionGStringValue = (G.GString.Value)strings.get(0)).getTree() instanceof J.Identifier) {
                                valueValue = ((J.Identifier)versionGStringValue.getTree()).getSimpleName();
                            }
                            if (!(key.getValue() instanceof String)) continue;
                            String keyValue = (String)key.getValue();
                            switch (keyValue) {
                                case "group": {
                                    declaredGroupId = valueValue;
                                    break;
                                }
                                case "name": {
                                    declaredArtifactId = valueValue;
                                    break;
                                }
                                case "version": {
                                    declaredVersion = valueValue;
                                }
                            }
                        }
                        if (declaredGroupId == null || declaredArtifactId == null || declaredVersion == null) {
                            return m;
                        }
                        String versionVariableName = declaredVersion;
                        GroupArtifact ga = new GroupArtifact(declaredGroupId, declaredArtifactId);
                        if (this.gradleProject != null) {
                            acc.getConfigurationPerGAPerModule().computeIfAbsent(UpgradeDependencyVersion.getGradleProjectKey(this.gradleProject), k -> new HashMap()).computeIfAbsent(ga, k -> new HashSet()).add(m.getSimpleName());
                        }
                        if (acc.gaToNewVersion.containsKey(ga) || !this.shouldResolveVersion(declaredGroupId, declaredArtifactId)) {
                            return m;
                        }
                        try {
                            String resolvedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(declaredGroupId, declaredArtifactId), m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                            acc.versionPropNameToGA.put(versionVariableName, ga);
                            acc.gaToNewVersion.put(ga, resolvedVersion);
                        }
                        catch (MavenDownloadingException e) {
                            acc.gaToNewVersion.put(ga, e);
                            return m;
                        }
                    } else if (m.getArguments().get(0) instanceof J.Assignment) {
                        String declaredGroupId = null;
                        String declaredArtifactId = null;
                        String declaredVersion = null;
                        for (Expression e : m.getArguments()) {
                            K.StringTemplate.Expression versionTemplateValue;
                            List strings;
                            Object value;
                            J.Assignment assignment;
                            if (!(e instanceof G.MapEntry) || !((assignment = (J.Assignment)e).getVariable() instanceof J.Identifier)) continue;
                            J.Identifier variable = (J.Identifier)assignment.getVariable();
                            String valueValue = null;
                            if (assignment.getAssignment() instanceof J.Literal) {
                                value = (J.Literal)assignment.getAssignment();
                                if (value.getValue() instanceof String) {
                                    valueValue = (String)value.getValue();
                                }
                            } else if (assignment.getAssignment() instanceof J.Identifier) {
                                value = (J.Identifier)assignment.getAssignment();
                                valueValue = value.getSimpleName();
                            } else if (assignment.getAssignment() instanceof K.StringTemplate && !(strings = (value = (K.StringTemplate)assignment.getAssignment()).getStrings()).isEmpty() && strings.get(0) instanceof K.StringTemplate.Expression && (versionTemplateValue = (K.StringTemplate.Expression)strings.get(0)).getTree() instanceof J.Identifier) {
                                valueValue = ((J.Identifier)versionTemplateValue.getTree()).getSimpleName();
                            }
                            switch (variable.getSimpleName()) {
                                case "group": {
                                    declaredGroupId = valueValue;
                                    break;
                                }
                                case "name": {
                                    declaredArtifactId = valueValue;
                                    break;
                                }
                                case "version": {
                                    declaredVersion = valueValue;
                                }
                            }
                        }
                        if (declaredGroupId == null || declaredArtifactId == null || declaredVersion == null) {
                            return m;
                        }
                        Iterator versionVariableName = declaredVersion;
                        GroupArtifact ga = new GroupArtifact(declaredGroupId, declaredArtifactId);
                        if (this.gradleProject != null) {
                            acc.getConfigurationPerGAPerModule().computeIfAbsent(UpgradeDependencyVersion.getGradleProjectKey(this.gradleProject), k -> new HashMap()).computeIfAbsent(ga, k -> new HashSet()).add(m.getSimpleName());
                        }
                        if (acc.gaToNewVersion.containsKey(ga) || !this.shouldResolveVersion(declaredGroupId, declaredArtifactId)) {
                            return m;
                        }
                        try {
                            String resolvedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(declaredGroupId, declaredArtifactId), m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                            acc.versionPropNameToGA.put(versionVariableName, ga);
                            acc.gaToNewVersion.put(ga, resolvedVersion);
                        }
                        catch (MavenDownloadingException e) {
                            acc.gaToNewVersion.put(ga, e);
                            return m;
                        }
                    } else {
                        for (Expression depArg : m.getArguments()) {
                            G.GString.Value versionValue;
                            J.Literal groupArtifact;
                            List strings;
                            Dependency dep = null;
                            String versionVariableName = null;
                            if (depArg instanceof J.Literal && ((J.Literal)depArg).getValue() instanceof String) {
                                String gav = (String)((J.Literal)depArg).getValue();
                                dep = DependencyStringNotationConverter.parse(gav);
                                if (dep != null) {
                                    versionVariableName = dep.getVersion();
                                }
                            } else if (depArg instanceof G.GString) {
                                G.GString gString = (G.GString)depArg;
                                strings = gString.getStrings();
                                if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) continue;
                                groupArtifact = (J.Literal)strings.get(0);
                                versionValue = (G.GString.Value)strings.get(1);
                                if (!(groupArtifact.getValue() instanceof String) || (dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue())) == null) continue;
                                if (versionValue.getTree() instanceof J.FieldAccess) {
                                    J.FieldAccess f = (J.FieldAccess)versionValue.getTree();
                                    versionVariableName = f.toString();
                                } else if (versionValue.getTree() instanceof J.Identifier) {
                                    versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                                }
                            } else if (depArg instanceof K.StringTemplate) {
                                K.StringTemplate template = (K.StringTemplate)depArg;
                                strings = template.getStrings();
                                if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof K.StringTemplate.Expression)) continue;
                                groupArtifact = (J.Literal)strings.get(0);
                                versionValue = (K.StringTemplate.Expression)strings.get(1);
                                if (!(versionValue.getTree() instanceof J.Identifier) || !(groupArtifact.getValue() instanceof String)) continue;
                                dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                                versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                            }
                            if (dep == null || versionVariableName == null) continue;
                            GroupArtifact ga = new GroupArtifact(dep.getGroupId(), dep.getArtifactId());
                            if (this.gradleProject != null) {
                                acc.getConfigurationPerGAPerModule().computeIfAbsent(UpgradeDependencyVersion.getGradleProjectKey(this.gradleProject), k -> new HashMap()).computeIfAbsent(ga, k -> new HashSet()).add(m.getSimpleName());
                            }
                            if (acc.gaToNewVersion.containsKey(ga) || !this.shouldResolveVersion(dep.getGroupId(), dep.getArtifactId())) continue;
                            try {
                                String resolvedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()), m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                                if (resolvedVersion == null) continue;
                                acc.versionPropNameToGA.put(versionVariableName, ga);
                                acc.gaToNewVersion.put(ga, resolvedVersion);
                            }
                            catch (MavenDownloadingException e) {
                                acc.gaToNewVersion.put(ga, e);
                            }
                        }
                    }
                }
                return m;
            }

            private boolean shouldResolveVersion(String declaredGroupId, String declaredArtifactId) {
                return UpgradeDependencyVersion.this.groupId == null || UpgradeDependencyVersion.this.artifactId == null || new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null).matches(declaredGroupId, declaredArtifactId);
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final DependencyVersionState acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){
            private final UpdateGradle updateGradle;
            private final UpdateProperties updateProperties;
            private final UpdateDependencyLock updateLockFile;
            {
                this.updateGradle = new UpdateGradle(acc);
                this.updateProperties = new UpdateProperties(acc);
                this.updateLockFile = new UpdateDependencyLock(acc.modules);
            }

            public boolean isAcceptable(SourceFile sf, ExecutionContext ctx) {
                return this.updateProperties.isAcceptable(sf, ctx) || this.updateGradle.isAcceptable(sf, ctx) || this.updateLockFile.isAcceptable(sf, ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t = tree;
                if (t instanceof SourceFile) {
                    SourceFile sf = (SourceFile)t;
                    if (this.updateProperties.isAcceptable(sf, ctx)) {
                        t = this.updateProperties.visitNonNull(t, ctx);
                    } else if (this.updateGradle.isAcceptable(sf, ctx)) {
                        t = this.updateGradle.visitNonNull(t, ctx);
                    }
                    Optional projectMarker = t.getMarkers().findFirst(GradleProject.class);
                    if ((tree != t || this.updateLockFile.isAcceptable(sf, ctx)) && projectMarker.isPresent()) {
                        GradleProject gradleProject = (GradleProject)projectMarker.get();
                        Map configurationsPerGa = acc.getConfigurationPerGAPerModule().getOrDefault(UpgradeDependencyVersion.getGradleProjectKey(gradleProject), Collections.emptyMap());
                        if (acc.getGaToNewVersion().isEmpty()) {
                            DependencyMatcher matcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
                            DependencyVersionSelector versionSelector = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, gradleProject, null);
                            for (GroupArtifact groupArtifact : configurationsPerGa.keySet()) {
                                if (!matcher.matches(groupArtifact.getGroupId(), groupArtifact.getArtifactId())) continue;
                                try {
                                    String selectedVersion = versionSelector.select(groupArtifact, null, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                                    GroupArtifactVersion gav = new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), selectedVersion);
                                    gradleProject = UpgradeDependencyVersion.replaceVersion(gradleProject, ctx, gav, configurationsPerGa.getOrDefault(gav.asGroupArtifact(), Collections.emptySet()));
                                }
                                catch (MavenDownloadingException mavenDownloadingException) {}
                            }
                        } else {
                            for (Map.Entry<GroupArtifact, Object> newVersion : acc.getGaToNewVersion().entrySet()) {
                                if (!(newVersion.getValue() instanceof String)) continue;
                                GroupArtifactVersion gav = new GroupArtifactVersion(newVersion.getKey().getGroupId(), newVersion.getKey().getArtifactId(), (String)newVersion.getValue());
                                gradleProject = UpgradeDependencyVersion.replaceVersion(gradleProject, ctx, gav, configurationsPerGa.getOrDefault(gav.asGroupArtifact(), Collections.emptySet()));
                            }
                        }
                        if (projectMarker.get() != gradleProject) {
                            t = t.withMarkers(t.getMarkers().setByType((Marker)gradleProject));
                        }
                    }
                    if (this.updateLockFile.isAcceptable(sf, ctx)) {
                        t = this.updateLockFile.visitNonNull(t, ctx);
                    }
                }
                return t;
            }
        };
    }

    public static GradleProject replaceVersion(GradleProject gp, ExecutionContext ctx, GroupArtifactVersion gav, Set<String> configurations) {
        try {
            if (gav.getGroupId() == null || gav.getArtifactId() == null) {
                return gp;
            }
            HashSet<String> remainingConfigurations = new HashSet<String>(configurations);
            remainingConfigurations.remove("classpath");
            if (remainingConfigurations.isEmpty()) {
                return gp;
            }
            MavenPomDownloader mpd = new MavenPomDownloader(ctx);
            Pom pom = mpd.download(gav, null, null, gp.getMavenRepositories());
            ResolvedPom resolvedPom = pom.resolve(Collections.emptyList(), mpd, gp.getMavenRepositories(), ctx);
            List transitiveDependencies = resolvedPom.resolveDependencies(Scope.Runtime, mpd, ctx);
            org.openrewrite.maven.tree.Dependency newRequested = org.openrewrite.maven.tree.Dependency.builder().gav(gav).build();
            ResolvedDependency newDep = ResolvedDependency.builder().gav(resolvedPom.getGav()).requested(newRequested).dependencies(transitiveDependencies).build();
            Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
            HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
            boolean anyChanged = false;
            for (GradleDependencyConfiguration gdc : nameToConfiguration.values()) {
                GradleDependencyConfiguration newGdc = gdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> UpgradeDependencyVersion.maybeUpdateDependency(requested, newRequested))).withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> UpgradeDependencyVersion.maybeUpdateResolvedDependency(gp, resolved, newDep, new HashSet<ResolvedDependency>())));
                if (UpgradeDependencyVersion.hasBomWithoutDependencies(newDep)) {
                    for (ResolvedManagedDependency resolvedDependency : resolvedPom.getDependencyManagement()) {
                        ResolvedGroupArtifactVersion resolvedGav = new ResolvedGroupArtifactVersion(null, resolvedDependency.getGroupId(), resolvedDependency.getArtifactId(), resolvedDependency.getVersion(), null);
                        newGdc = newGdc.withDirectResolved(ListUtils.map(newGdc.getDirectResolved(), resolved -> UpgradeDependencyVersion.maybeUpdateManagedResolvedDependency(gp, resolved, resolvedGav, new HashSet<ResolvedDependency>())));
                    }
                }
                anyChanged |= newGdc != gdc;
                newNameToConfiguration.put(newGdc.getName(), newGdc);
            }
            if (anyChanged) {
                return gp.withNameToConfiguration(newNameToConfiguration);
            }
        }
        catch (MavenDownloadingException | MavenDownloadingExceptions e) {
            return gp;
        }
        return gp;
    }

    private static org.openrewrite.maven.tree.Dependency maybeUpdateDependency(org.openrewrite.maven.tree.Dependency dep, org.openrewrite.maven.tree.Dependency newDep) {
        if (Objects.equals(dep.getGroupId(), newDep.getGroupId()) && Objects.equals(dep.getArtifactId(), newDep.getArtifactId()) && Objects.equals(dep.getVersion(), newDep.getVersion())) {
            return dep;
        }
        if (Objects.equals(dep.getGroupId(), newDep.getGroupId()) && Objects.equals(dep.getArtifactId(), newDep.getArtifactId())) {
            return newDep;
        }
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDependency maybeUpdateManagedResolvedDependency(GradleProject gp, ResolvedDependency dep, ResolvedGroupArtifactVersion gav, Set<ResolvedDependency> traversalHistory) {
        if (traversalHistory.contains(dep)) {
            return dep;
        }
        if (Objects.equals(dep.getGroupId(), gav.getGroupId()) && Objects.equals(dep.getArtifactId(), gav.getArtifactId()) && Objects.equals(dep.getVersion(), gav.getVersion()) || UpgradeDependencyVersion.wouldDowngrade(dep.getGav().asGroupArtifactVersion(), gav.asGroupArtifactVersion())) {
            return dep;
        }
        if (Objects.equals(dep.getGroupId(), gav.getGroupId()) && Objects.equals(dep.getArtifactId(), gav.getArtifactId()) && !UpgradeDependencyVersion.isSpringPluginManaged(gp, dep)) {
            return dep.withGav(gav);
        }
        boolean added = traversalHistory.add(dep);
        try {
            ResolvedDependency resolvedDependency = dep.withDependencies(ListUtils.map((List)dep.getDependencies(), d -> UpgradeDependencyVersion.maybeUpdateManagedResolvedDependency(gp, d, gav, traversalHistory)));
            return resolvedDependency;
        }
        finally {
            if (added) {
                traversalHistory.remove(dep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResolvedDependency maybeUpdateResolvedDependency(GradleProject gp, ResolvedDependency dep, ResolvedDependency newDep, Set<ResolvedDependency> traversalHistory) {
        if (traversalHistory.contains(dep)) {
            return dep;
        }
        if (Objects.equals(dep.getGroupId(), newDep.getGroupId()) && Objects.equals(dep.getArtifactId(), newDep.getArtifactId()) && Objects.equals(dep.getVersion(), newDep.getVersion()) || UpgradeDependencyVersion.wouldDowngrade(dep.getGav().asGroupArtifactVersion(), newDep.getGav().asGroupArtifactVersion())) {
            return dep;
        }
        if (Objects.equals(dep.getGroupId(), newDep.getGroupId()) && Objects.equals(dep.getArtifactId(), newDep.getArtifactId())) {
            if (UpgradeDependencyVersion.isSpringPluginManaged(gp, newDep)) {
                return dep.withGav(newDep.getGav());
            }
            return newDep;
        }
        boolean added = traversalHistory.add(dep);
        try {
            ResolvedDependency resolvedDependency = dep.withDependencies(ListUtils.map((List)dep.getDependencies(), d -> UpgradeDependencyVersion.maybeUpdateResolvedDependency(gp, d, newDep, traversalHistory)));
            return resolvedDependency;
        }
        finally {
            if (added) {
                traversalHistory.remove(dep);
            }
        }
    }

    private static boolean wouldDowngrade(GroupArtifactVersion from, GroupArtifactVersion to) {
        if (from.getGroupId().equals(to.getGroupId()) && from.getArtifactId().equals(to.getArtifactId())) {
            Version toVersion;
            Version fromVersion = new Version(from.getVersion());
            return fromVersion.compareTo(toVersion = new Version(to.getVersion())) > 0;
        }
        return false;
    }

    private static boolean isSpringPluginManaged(GradleProject gp, ResolvedDependency newDep) {
        if (gp.getPlugins().stream().anyMatch(plugin -> "io.spring.dependency-management".equals(plugin.getId()))) {
            return newDep.getGroupId().startsWith("org.springframework");
        }
        return false;
    }

    static boolean hasBomWithoutDependencies(ResolvedDependency dep) {
        if ("bom".equals(dep.getType()) && dep.getDependencies().isEmpty()) {
            return true;
        }
        for (ResolvedDependency d : dep.getDependencies()) {
            if (!UpgradeDependencyVersion.hasBomWithoutDependencies(d)) continue;
            return true;
        }
        return false;
    }

    static String getGradleProjectKey(GradleProject project) {
        if (StringUtils.isBlank((String)project.getGroup())) {
            return project.getName();
        }
        if (":".equals(project.getPath())) {
            return project.getGroup();
        }
        return project.getGroup() + project.getPath();
    }

    @Generated
    public UpgradeDependencyVersion(String groupId, String artifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeDependencyVersion(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }

    public static final class DependencyVersionState {
        private final Map<String, GroupArtifact> versionPropNameToGA = new HashMap<String, GroupArtifact>();
        private final Map<GroupArtifact, Object> gaToNewVersion = new HashMap<GroupArtifact, Object>();
        private final Map<String, Map<GroupArtifact, Set<String>>> configurationPerGAPerModule = new HashMap<String, Map<GroupArtifact, Set<String>>>();
        private final Set<GradleProject> modules = new HashSet<GradleProject>();

        @Generated
        public DependencyVersionState() {
        }

        @Generated
        public Map<String, GroupArtifact> getVersionPropNameToGA() {
            return this.versionPropNameToGA;
        }

        @Generated
        public Map<GroupArtifact, Object> getGaToNewVersion() {
            return this.gaToNewVersion;
        }

        @Generated
        public Map<String, Map<GroupArtifact, Set<String>>> getConfigurationPerGAPerModule() {
            return this.configurationPerGAPerModule;
        }

        @Generated
        public Set<GradleProject> getModules() {
            return this.modules;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyVersionState)) {
                return false;
            }
            DependencyVersionState other = (DependencyVersionState)o;
            Map<String, GroupArtifact> this$versionPropNameToGA = this.getVersionPropNameToGA();
            Map<String, GroupArtifact> other$versionPropNameToGA = other.getVersionPropNameToGA();
            if (this$versionPropNameToGA == null ? other$versionPropNameToGA != null : !((Object)this$versionPropNameToGA).equals(other$versionPropNameToGA)) {
                return false;
            }
            Map<GroupArtifact, Object> this$gaToNewVersion = this.getGaToNewVersion();
            Map<GroupArtifact, Object> other$gaToNewVersion = other.getGaToNewVersion();
            if (this$gaToNewVersion == null ? other$gaToNewVersion != null : !((Object)this$gaToNewVersion).equals(other$gaToNewVersion)) {
                return false;
            }
            Map<String, Map<GroupArtifact, Set<String>>> this$configurationPerGAPerModule = this.getConfigurationPerGAPerModule();
            Map<String, Map<GroupArtifact, Set<String>>> other$configurationPerGAPerModule = other.getConfigurationPerGAPerModule();
            if (this$configurationPerGAPerModule == null ? other$configurationPerGAPerModule != null : !((Object)this$configurationPerGAPerModule).equals(other$configurationPerGAPerModule)) {
                return false;
            }
            Set<GradleProject> this$modules = this.getModules();
            Set<GradleProject> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, GroupArtifact> $versionPropNameToGA = this.getVersionPropNameToGA();
            result = result * 59 + ($versionPropNameToGA == null ? 43 : ((Object)$versionPropNameToGA).hashCode());
            Map<GroupArtifact, Object> $gaToNewVersion = this.getGaToNewVersion();
            result = result * 59 + ($gaToNewVersion == null ? 43 : ((Object)$gaToNewVersion).hashCode());
            Map<String, Map<GroupArtifact, Set<String>>> $configurationPerGAPerModule = this.getConfigurationPerGAPerModule();
            result = result * 59 + ($configurationPerGAPerModule == null ? 43 : ((Object)$configurationPerGAPerModule).hashCode());
            Set<GradleProject> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpgradeDependencyVersion.DependencyVersionState(versionPropNameToGA=" + this.getVersionPropNameToGA() + ", gaToNewVersion=" + this.getGaToNewVersion() + ", configurationPerGAPerModule=" + this.getConfigurationPerGAPerModule() + ", modules=" + this.getModules() + ")";
        }
    }

    private class UpdateVariable
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames;
        private final @Nullable GradleProject gradleProject;

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
            if (!(v.getInitializer() instanceof J.Literal) || ((J.Literal)v.getInitializer()).getValue() == null || ((J.Literal)v.getInitializer()).getType() != JavaType.Primitive.String) {
                return v;
            }
            Map.Entry<GroupArtifact, Set<String>> gaWithConfigs = this.getGroupArtifactWithConfigs(v.getSimpleName());
            if (gaWithConfigs == null) {
                return v;
            }
            try {
                J.Literal newVersion = this.getNewVersion((J.Literal)v.getInitializer(), gaWithConfigs, ctx);
                return newVersion == null ? v : v.withInitializer((Expression)newVersion);
            }
            catch (MavenDownloadingException e) {
                return (J.VariableDeclarations.NamedVariable)e.warn((Tree)v);
            }
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment a = super.visitAssignment(assignment, (Object)ctx);
            if (!(a.getVariable() instanceof J.Identifier) || !(a.getAssignment() instanceof J.Literal) || ((J.Literal)a.getAssignment()).getValue() == null || ((J.Literal)a.getAssignment()).getType() != JavaType.Primitive.String) {
                return a;
            }
            Map.Entry<GroupArtifact, Set<String>> gaWithConfigs = this.getGroupArtifactWithConfigs(((J.Identifier)a.getVariable()).getSimpleName());
            if (gaWithConfigs == null) {
                return a;
            }
            try {
                J.Literal newVersion = this.getNewVersion((J.Literal)a.getAssignment(), gaWithConfigs, ctx);
                return newVersion == null ? a : a.withAssignment((Expression)newVersion);
            }
            catch (MavenDownloadingException e) {
                return (J.Assignment)e.warn((Tree)a);
            }
        }

        private @Nullable Map.Entry<GroupArtifact, Set<String>> getGroupArtifactWithConfigs(String identifier) {
            for (Map.Entry<String, Map<GroupArtifact, Set<String>>> versionVariableNameEntry : this.versionVariableNames.entrySet()) {
                if (!versionVariableNameEntry.getKey().equals(identifier)) continue;
                return versionVariableNameEntry.getValue().entrySet().iterator().next();
            }
            return null;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal getNewVersion(J.Literal literal, Map.Entry<GroupArtifact, Set<String>> gaWithConfigurations, ExecutionContext ctx) throws MavenDownloadingException {
            String selectedVersion;
            GroupArtifact ga = gaWithConfigurations.getKey();
            DependencyVersionSelector dependencyVersionSelector = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null);
            GroupArtifactVersion gav = new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), (String)literal.getValue());
            try {
                selectedVersion = dependencyVersionSelector.select(gav, null, UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
            }
            catch (MavenDownloadingException e) {
                if (!gaWithConfigurations.getValue().contains("classpath")) {
                    throw e;
                }
                selectedVersion = dependencyVersionSelector.select(gav, "classpath", UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
            }
            if (selectedVersion == null) {
                return null;
            }
            return ChangeStringLiteral.withStringValue(literal, selectedVersion);
        }

        @Generated
        public UpdateVariable(@Nullable Map<String, Map<GroupArtifact, Set<String>>> versionVariableNames, GradleProject gradleProject) {
            this.versionVariableNames = versionVariableNames;
            this.gradleProject = gradleProject;
        }
    }

    private class UpdateGradle
    extends JavaVisitor<ExecutionContext> {
        final DependencyVersionState acc;
        @Nullable GradleProject gradleProject;
        final DependencyMatcher dependencyMatcher;

        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return sourceFile instanceof G.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle") || sourceFile instanceof K.CompilationUnit && sourceFile.getSourcePath().toString().endsWith(".gradle.kts");
        }

        public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile sourceFile = (JavaSourceFile)tree;
                this.gradleProject = sourceFile.getMarkers().findFirst(GradleProject.class).orElse(null);
                return (J)super.visit((Tree)sourceFile, (Object)ctx);
            }
            return (J)super.visit(tree, (Object)ctx);
        }

        public J postVisit(J tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)tree;
                Map variableNames = (Map)this.getCursor().getMessage(UpgradeDependencyVersion.VERSION_VARIABLE_KEY);
                if (variableNames != null) {
                    cu = (JavaSourceFile)new UpdateVariable(variableNames, this.gradleProject).visitNonNull((Tree)cu, ctx);
                }
                return cu;
            }
            return tree;
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
            GradleDependency.Matcher gradleDependencyMatcher = new GradleDependency.Matcher();
            if (gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal || depArgs.get(0) instanceof G.GString || depArgs.get(0) instanceof G.MapEntry || depArgs.get(0) instanceof J.Assignment || depArgs.get(0) instanceof K.StringTemplate) {
                    m = this.updateDependency(m, ctx);
                } else if (depArgs.get(0) instanceof J.MethodInvocation && (((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("platform") || ((J.MethodInvocation)depArgs.get(0)).getSimpleName().equals("enforcedPlatform"))) {
                    m = m.withArguments(ListUtils.mapFirst((List)depArgs, platform -> this.updateDependency((J.MethodInvocation)platform, ctx)));
                }
            } else if ("ext".equals(method.getSimpleName()) && this.isSettingsGradle()) {
                m = (J.MethodInvocation)new JavaIsoVisitor<ExecutionContext>(){

                    public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext executionContext) {
                        J.Assignment a = super.visitAssignment(assignment, (Object)executionContext);
                        if (!(a.getVariable() instanceof J.Identifier)) {
                            return a;
                        }
                        GroupArtifact ga = (GroupArtifact)UpdateGradle.this.acc.versionPropNameToGA.get("gradle." + a.getVariable());
                        if (ga == null) {
                            return a;
                        }
                        String newVersion = (String)UpdateGradle.this.acc.gaToNewVersion.get(ga);
                        if (newVersion == null) {
                            return a;
                        }
                        if (!(a.getAssignment() instanceof J.Literal)) {
                            return a;
                        }
                        J.Literal l = (J.Literal)a.getAssignment();
                        if (J.Literal.isLiteralValue((Expression)l, (Object)newVersion)) {
                            return a;
                        }
                        String quote = l.getValueSource() == null ? "\"" : l.getValueSource().substring(0, 1);
                        a = a.withAssignment((Expression)l.withValue((Object)newVersion).withValueSource(quote + newVersion + quote));
                        return a;
                    }
                }.visitNonNull((Tree)m, (Object)ctx, this.getCursor().getParentTreeCursor());
            }
            return m;
        }

        private boolean isSettingsGradle() {
            String path = Objects.requireNonNull((SourceFile)this.getCursor().firstEnclosing(SourceFile.class)).getSourcePath().toString();
            return path.endsWith("settings.gradle") || path.endsWith("settings.gradle.kts");
        }

        private J.MethodInvocation updateDependency(J.MethodInvocation method, ExecutionContext ctx) {
            List depArgs;
            J.MethodInvocation m = method;
            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                if (arg instanceof G.GString) {
                    G.GString gString = (G.GString)arg;
                    List strings = gString.getStrings();
                    if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof G.GString.Value)) {
                        return arg;
                    }
                    J.Literal groupArtifact = (J.Literal)strings.get(0);
                    G.GString.Value versionValue = (G.GString.Value)strings.get(1);
                    if (!(versionValue.getTree() instanceof J.Identifier) || !(groupArtifact.getValue() instanceof String)) {
                        return arg;
                    }
                    Dependency dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                    if (dep != null && this.dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId())) {
                        Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()));
                        if (scanResult instanceof Exception) {
                            this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, scanResult);
                            return arg;
                        }
                        String versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                        this.replaceVariableValue(versionVariableName, method, dep.getGroupId(), dep.getArtifactId());
                    }
                } else if (arg instanceof K.StringTemplate) {
                    K.StringTemplate template = (K.StringTemplate)arg;
                    List strings = template.getStrings();
                    if (strings.size() != 2 || !(strings.get(0) instanceof J.Literal) || !(strings.get(1) instanceof K.StringTemplate.Expression)) {
                        return arg;
                    }
                    J.Literal groupArtifact = (J.Literal)strings.get(0);
                    K.StringTemplate.Expression versionValue = (K.StringTemplate.Expression)strings.get(1);
                    if (!(versionValue.getTree() instanceof J.Identifier) || !(groupArtifact.getValue() instanceof String)) {
                        return arg;
                    }
                    Dependency dep = DependencyStringNotationConverter.parse((String)groupArtifact.getValue());
                    if (dep != null && this.dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId())) {
                        Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()));
                        if (scanResult instanceof Exception) {
                            this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, scanResult);
                            return arg;
                        }
                        String versionVariableName = ((J.Identifier)versionValue.getTree()).getSimpleName();
                        this.replaceVariableValue(versionVariableName, method, dep.getGroupId(), dep.getArtifactId());
                    }
                } else if (arg instanceof J.Literal) {
                    J.Literal literal = (J.Literal)arg;
                    if (literal.getType() != JavaType.Primitive.String) {
                        return arg;
                    }
                    String gav = (String)literal.getValue();
                    if (gav == null) {
                        this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, (Object)new IllegalStateException("Unable to update version"));
                        return arg;
                    }
                    Dependency dep = DependencyStringNotationConverter.parse(gav);
                    if (dep != null && this.dependencyMatcher.matches(dep.getGroupId(), dep.getArtifactId()) && dep.getVersion() != null && !dep.getVersion().startsWith("$")) {
                        Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact(dep.getGroupId(), dep.getArtifactId()));
                        if (scanResult instanceof Exception) {
                            this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, scanResult);
                            return arg;
                        }
                        try {
                            String selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(dep.getGav(), method.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                            if (selectedVersion == null || dep.getVersion().equals(selectedVersion)) {
                                return arg;
                            }
                            String newGav = dep.withVersion(selectedVersion).toStringNotation();
                            return literal.withValue((Object)newGav).withValueSource(literal.getValueSource() == null ? newGav : literal.getValueSource().replace(gav, newGav));
                        }
                        catch (MavenDownloadingException e) {
                            this.getCursor().putMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY, (Object)e);
                        }
                    }
                }
                return arg;
            }));
            Exception err = (Exception)this.getCursor().pollMessage(UpgradeDependencyVersion.UPDATE_VERSION_ERROR_KEY);
            if (err != null) {
                m = (J.MethodInvocation)Markup.warn((Tree)m, (Throwable)err);
            }
            if ((depArgs = m.getArguments()).size() >= 3) {
                if (depArgs.get(0) instanceof G.MapEntry && depArgs.get(1) instanceof G.MapEntry && depArgs.get(2) instanceof G.MapEntry) {
                    Expression groupValue = ((G.MapEntry)depArgs.get(0)).getValue();
                    Expression artifactValue = ((G.MapEntry)depArgs.get(1)).getValue();
                    if (!(groupValue instanceof J.Literal) || !(artifactValue instanceof J.Literal)) {
                        return m;
                    }
                    J.Literal groupLiteral = (J.Literal)groupValue;
                    J.Literal artifactLiteral = (J.Literal)artifactValue;
                    if (groupLiteral.getValue() == null || artifactLiteral.getValue() == null || !this.dependencyMatcher.matches((String)groupLiteral.getValue(), (String)artifactLiteral.getValue())) {
                        return m;
                    }
                    Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact((String)groupLiteral.getValue(), (String)artifactLiteral.getValue()));
                    if (scanResult instanceof Exception) {
                        return (J.MethodInvocation)Markup.warn((Tree)m, (Throwable)((Exception)scanResult));
                    }
                    G.MapEntry versionEntry = (G.MapEntry)depArgs.get(2);
                    Expression versionExp = versionEntry.getValue();
                    if (versionExp instanceof J.Literal && ((J.Literal)versionExp).getValue() instanceof String) {
                        String selectedVersion;
                        J.Literal versionLiteral = (J.Literal)versionExp;
                        String version = (String)versionLiteral.getValue();
                        if (version.startsWith("$")) {
                            return m;
                        }
                        try {
                            GroupArtifactVersion gav = new GroupArtifactVersion((String)groupLiteral.getValue(), (String)artifactLiteral.getValue(), version);
                            selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(gav, m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (selectedVersion == null || version.equals(selectedVersion)) {
                            return m;
                        }
                        ArrayList<Object> newArgs = new ArrayList<Object>(3);
                        newArgs.add((Expression)depArgs.get(0));
                        newArgs.add((Expression)depArgs.get(1));
                        newArgs.add(versionEntry.withValue((Expression)versionLiteral.withValueSource(versionLiteral.getValueSource() == null ? selectedVersion : versionLiteral.getValueSource().replace(version, selectedVersion)).withValue((Object)selectedVersion)));
                        newArgs.addAll(depArgs.subList(3, depArgs.size()));
                        return m.withArguments(newArgs);
                    }
                    if (versionExp instanceof J.Identifier) {
                        String versionVariableName = ((J.Identifier)versionExp).getSimpleName();
                        this.replaceVariableValue(versionVariableName, m, (String)groupLiteral.getValue(), (String)artifactLiteral.getValue());
                    } else if (versionExp instanceof G.GString) {
                        G.GString gString = (G.GString)versionExp;
                        if (gString.getStrings().size() != 1) {
                            return m;
                        }
                        G.GString.Value versionLiteral = (G.GString.Value)gString.getStrings().get(0);
                        String versionVariableName = versionLiteral.printTrimmed(this.getCursor());
                        if (versionVariableName.startsWith("$")) {
                            versionVariableName = versionVariableName.replaceAll("^\\$\\{?|}?$", "");
                        }
                        this.replaceVariableValue(versionVariableName, m, (String)groupLiteral.getValue(), (String)artifactLiteral.getValue());
                    }
                } else if (depArgs.get(0) instanceof J.Assignment && depArgs.get(1) instanceof J.Assignment && depArgs.get(2) instanceof J.Assignment) {
                    Expression groupValue = ((J.Assignment)depArgs.get(0)).getAssignment();
                    Expression artifactValue = ((J.Assignment)depArgs.get(1)).getAssignment();
                    if (!(groupValue instanceof J.Literal) || !(artifactValue instanceof J.Literal)) {
                        return m;
                    }
                    J.Literal groupLiteral = (J.Literal)groupValue;
                    J.Literal artifactLiteral = (J.Literal)artifactValue;
                    if (groupLiteral.getValue() == null || artifactLiteral.getValue() == null || !this.dependencyMatcher.matches((String)groupLiteral.getValue(), (String)artifactLiteral.getValue())) {
                        return m;
                    }
                    Object scanResult = this.acc.gaToNewVersion.get(new GroupArtifact((String)groupLiteral.getValue(), (String)artifactLiteral.getValue()));
                    if (scanResult instanceof Exception) {
                        return (J.MethodInvocation)Markup.warn((Tree)m, (Throwable)((Exception)scanResult));
                    }
                    J.Assignment versionEntry = (J.Assignment)depArgs.get(2);
                    Expression versionExp = versionEntry.getAssignment();
                    if (versionExp instanceof J.Literal && ((J.Literal)versionExp).getValue() instanceof String) {
                        String selectedVersion;
                        J.Literal versionLiteral = (J.Literal)versionExp;
                        String version = (String)versionLiteral.getValue();
                        if (version.startsWith("$")) {
                            return m;
                        }
                        try {
                            GroupArtifactVersion gav = new GroupArtifactVersion((String)groupLiteral.getValue(), (String)artifactLiteral.getValue(), version);
                            selectedVersion = new DependencyVersionSelector(UpgradeDependencyVersion.this.metadataFailures, this.gradleProject, null).select(gav, m.getSimpleName(), UpgradeDependencyVersion.this.newVersion, UpgradeDependencyVersion.this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (selectedVersion == null || version.equals(selectedVersion)) {
                            return m;
                        }
                        ArrayList<Object> newArgs = new ArrayList<Object>(3);
                        newArgs.add((Expression)depArgs.get(0));
                        newArgs.add((Expression)depArgs.get(1));
                        newArgs.add(versionEntry.withAssignment((Expression)versionLiteral.withValueSource(versionLiteral.getValueSource() == null ? selectedVersion : versionLiteral.getValueSource().replace(version, selectedVersion)).withValue((Object)selectedVersion)));
                        newArgs.addAll(depArgs.subList(3, depArgs.size()));
                        return m.withArguments(newArgs);
                    }
                    if (versionExp instanceof J.Identifier) {
                        String versionVariableName = ((J.Identifier)versionExp).getSimpleName();
                        this.replaceVariableValue(versionVariableName, m, (String)groupLiteral.getValue(), (String)artifactLiteral.getValue());
                    } else if (versionExp instanceof K.StringTemplate) {
                        K.StringTemplate kString = (K.StringTemplate)versionExp;
                        if (kString.getStrings().size() != 1) {
                            return m;
                        }
                        K.StringTemplate.Expression versionLiteral = (K.StringTemplate.Expression)kString.getStrings().get(0);
                        String versionVariableName = versionLiteral.printTrimmed(this.getCursor());
                        if (versionVariableName.startsWith("$")) {
                            versionVariableName = versionVariableName.replaceAll("^\\$\\{?|}?$", "");
                        }
                        this.replaceVariableValue(versionVariableName, m, (String)groupLiteral.getValue(), (String)artifactLiteral.getValue());
                    }
                }
            }
            return m;
        }

        private void replaceVariableValue(String versionVariableName, J.MethodInvocation m, String groupId, String artifactId) {
            ((HashMap)this.getCursor().dropParentUntil(p -> p instanceof SourceFile).computeMessageIfAbsent(UpgradeDependencyVersion.VERSION_VARIABLE_KEY, v -> new HashMap())).computeIfAbsent(versionVariableName, it -> new HashMap()).computeIfAbsent(new GroupArtifact(groupId, artifactId), it -> new HashSet()).add(m.getSimpleName());
        }

        @Generated
        public UpdateGradle(DependencyVersionState acc) {
            this.dependencyMatcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
            this.acc = acc;
        }
    }

    private class UpdateProperties
    extends PropertiesVisitor<ExecutionContext> {
        final DependencyVersionState acc;
        final DependencyMatcher dependencyMatcher;

        public Properties visitFile(Properties.File file, ExecutionContext ctx) {
            if (!file.getSourcePath().endsWith(UpgradeDependencyVersion.GRADLE_PROPERTIES_FILE_NAME)) {
                return file;
            }
            return super.visitFile(file, (Object)ctx);
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
            if (this.acc.versionPropNameToGA.containsKey(entry.getKey())) {
                GroupArtifact ga = (GroupArtifact)this.acc.versionPropNameToGA.get(entry.getKey());
                if (ga == null || !this.dependencyMatcher.matches(ga.getGroupId(), ga.getArtifactId())) {
                    return entry;
                }
                Object result = this.acc.gaToNewVersion.get(ga);
                if (result == null || result instanceof Exception) {
                    return entry;
                }
                VersionComparator versionComparator = (VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpgradeDependencyVersion.this.newVersion) ? "latest.release" : UpgradeDependencyVersion.this.newVersion), (String)UpgradeDependencyVersion.this.versionPattern).getValue();
                if (versionComparator == null) {
                    return entry;
                }
                Optional finalVersion = versionComparator.upgrade(entry.getValue().getText(), Collections.singletonList((String)result));
                return (Properties)finalVersion.map(v -> entry.withValue(entry.getValue().withText(v))).orElse(entry);
            }
            return entry;
        }

        @Generated
        public UpdateProperties(DependencyVersionState acc) {
            this.dependencyMatcher = new DependencyMatcher(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId, null);
            this.acc = acc;
        }
    }
}

