/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.search.DependencyInsight;
import org.openrewrite.internal.lang.NonNull;

public final class DoesNotIncludeDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. Supports glob.", example="guava")
    private final String artifactId;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If not specified, all configurations will be searched.", example="compileClasspath", required=false)
    private final @Nullable String configuration;

    public String getDisplayName() {
        return "Does not include Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "A precondition which returns false if visiting a Gradle file which includes the specified dependency in the classpath of some scope. For compatibility with multimodule projects, this should most often be applied as a precondition.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.notBlank((String)"groupId", (String)this.groupId)).and(Validated.notBlank((String)"artifactId", (String)this.artifactId));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.not(new DependencyInsight(this.groupId, this.artifactId, null, this.configuration).getVisitor());
    }

    @Generated
    public DoesNotIncludeDependency(String groupId, String artifactId, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DoesNotIncludeDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotIncludeDependency)) {
            return false;
        }
        DoesNotIncludeDependency other = (DoesNotIncludeDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DoesNotIncludeDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

