/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.internal.AddDependencyVisitor;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

public class JvmTestSuite
implements Trait<Statement> {
    private static final String[] JVM_TEST_SUITE_SUFFIXES = new String[]{"annotationProcessor", "compileOnly", "implementation", "runtimeOnly"};
    Cursor cursor;
    GradleProject gradleProject;
    String name;

    public TreeVisitor<J, ExecutionContext> addDependency(String configuration, final String groupId, final String artifactId, final @Nullable String version, @Nullable String versionPattern, final @Nullable String classifier, final @Nullable String extension, MavenMetadataFailures metadataFailures, final  @Nullable AddDependencyVisitor.DependencyModifier dependencyModifier, ExecutionContext ctx) {
        if (!this.isAcceptable(configuration)) {
            return TreeVisitor.noop();
        }
        final String resolvedConfiguration = configuration.startsWith(this.name) ? Character.toLowerCase(configuration.charAt(this.name.length())) + configuration.substring(this.name.length() + 1) : configuration;
        final String targetConfiguration = configuration.startsWith(this.name) ? configuration : this.name + Character.toUpperCase(configuration.charAt(0)) + configuration.substring(1);
        final boolean isKotlinDsl = this.isKotlinDsl();
        try {
            final String resolvedVersion = this.resolveVersion(resolvedConfiguration, groupId, artifactId, version, versionPattern, metadataFailures, ctx);
            return new JavaIsoVisitor<ExecutionContext>(){

                public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                    J j = (J)new AddDependencyVisitor(resolvedConfiguration, groupId, artifactId, version, classifier, extension, x$0 -> JvmTestSuite.this.isScope(x$0), dependencyModifier, isKotlinDsl).visit(tree, ctx, this.getCursor());
                    if (j instanceof JavaSourceFile && j != tree) {
                        return AddDependencyVisitor.addDependency((JavaSourceFile)j, JvmTestSuite.this.gradleProject.getConfiguration(targetConfiguration), new GroupArtifactVersion(groupId, artifactId, resolvedVersion), classifier, ctx);
                    }
                    return j;
                }
            };
        }
        catch (MavenDownloadingException e) {
            return new JavaVisitor<ExecutionContext>(){

                public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                    if (tree == null) {
                        return null;
                    }
                    return (J)e.warn(tree);
                }
            };
        }
    }

    private @Nullable String resolveVersion(String configuration, String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, MavenMetadataFailures metadataFailures, ExecutionContext ctx) throws MavenDownloadingException {
        if (version == null) {
            return null;
        }
        if (version.startsWith("$")) {
            return version;
        }
        return new DependencyVersionSelector(metadataFailures, this.gradleProject, null).select(new GroupArtifact(groupId, artifactId), configuration, version, versionPattern, ctx);
    }

    public boolean isAcceptable(String configuration) {
        for (String suffix : JVM_TEST_SUITE_SUFFIXES) {
            if (configuration.equals(suffix)) {
                return true;
            }
            if (!configuration.equals(this.name + Character.toUpperCase(suffix.charAt(0)) + suffix.substring(1))) continue;
            return true;
        }
        return false;
    }

    private boolean isKotlinDsl() {
        return this.getCursor().firstEnclosing(JavaSourceFile.class) instanceof K.CompilationUnit;
    }

    private boolean isScope(Cursor cursor) {
        Statement statement = (Statement)this.getTree();
        Cursor c = cursor.dropParentUntil(value -> value instanceof J && statement.isScope((Tree)((J)value)) || value instanceof J.MethodInvocation && !"registering".equals(((J.MethodInvocation)value).getSimpleName()) && !"getting".equals(((J.MethodInvocation)value).getSimpleName()) || value == "root");
        return !c.isRoot() && statement.isScope((Tree)c.getValue());
    }

    @Generated
    public JvmTestSuite(Cursor cursor, GradleProject gradleProject, String name) {
        this.cursor = cursor;
        this.gradleProject = gradleProject;
        this.name = name;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    public static class Matcher
    extends GradleTraitMatcher<JvmTestSuite> {
        protected @Nullable String name;
        private transient Map<GradleProject, Set<String>> sourceSets = new HashMap<GradleProject, Set<String>>();

        public Matcher name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<JvmTestSuite, P> visitor) {
            return new JavaVisitor<P>(){

                public J visitMethodInvocation(J.MethodInvocation method, P p) {
                    JvmTestSuite suite = this.test(this.getCursor());
                    return suite != null ? (J)visitor.visit((Trait)suite, p) : super.visitMethodInvocation(method, p);
                }

                public J visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
                    JvmTestSuite suite = this.test(this.getCursor());
                    return suite != null ? (J)visitor.visit((Trait)suite, p) : super.visitVariableDeclarations(multiVariable, p);
                }
            };
        }

        protected @Nullable JvmTestSuite test(Cursor cursor) {
            if (!this.withinSuitesBlock(cursor)) {
                return null;
            }
            if (cursor.getValue() instanceof J.MethodInvocation) {
                J.MethodInvocation m = (J.MethodInvocation)cursor.getValue();
                if ("register".equals(m.getSimpleName())) {
                    if (!(m.getArguments().get(0) instanceof J.Literal)) {
                        return null;
                    }
                    J.Literal literal = (J.Literal)m.getArguments().get(0);
                    if (literal.getType() != JavaType.Primitive.String) {
                        return null;
                    }
                    if (literal.getValue() == null) {
                        return null;
                    }
                    return this.maybeJvmTestSuite(cursor, (String)literal.getValue());
                }
                return this.maybeJvmTestSuite(cursor, m.getSimpleName());
            }
            J.VariableDeclarations variables = (J.VariableDeclarations)cursor.getValue();
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)variables.getVariables().get(0);
            if (!(variable.getInitializer() instanceof J.MethodInvocation)) {
                return null;
            }
            J.MethodInvocation initializer = (J.MethodInvocation)variable.getInitializer();
            if (!"getting".equals(initializer.getSimpleName()) && !"registering".equals(initializer.getSimpleName())) {
                return null;
            }
            return this.maybeJvmTestSuite(cursor, variable.getSimpleName());
        }

        private @Nullable JvmTestSuite maybeJvmTestSuite(Cursor cursor, String simpleName) {
            Set<String> sourceSets = this.getSourceSets(cursor);
            if (sourceSets.isEmpty() ? !this.hasDependenciesBlock(cursor) : !sourceSets.contains(simpleName)) {
                return null;
            }
            if (!StringUtils.isBlank((String)this.name) && !this.name.equals(simpleName)) {
                return null;
            }
            return new JvmTestSuite(cursor, this.getGradleProject(cursor), simpleName);
        }

        private boolean withinBlock(Cursor cursor, String name) {
            for (Cursor parentCursor = cursor.getParent(); parentCursor != null; parentCursor = parentCursor.getParent()) {
                J.MethodInvocation m;
                if (!(parentCursor.getValue() instanceof J.MethodInvocation) || !(m = (J.MethodInvocation)parentCursor.getValue()).getSimpleName().equals(name)) continue;
                return true;
            }
            return false;
        }

        private boolean withinTestingBlock(Cursor cursor) {
            return this.withinBlock(cursor, "testing");
        }

        private boolean withinSuitesBlock(Cursor cursor) {
            return this.withinBlock(cursor, "suites") && this.withinTestingBlock(cursor);
        }

        private Set<String> getSourceSets(Cursor cursor) {
            GradleProject gp = this.getGradleProject(cursor);
            if (gp == null) {
                return Collections.emptySet();
            }
            return this.sourceSets.computeIfAbsent(gp, key -> {
                HashSet<String> sourceSets = new HashSet<String>();
                for (GradleDependencyConfiguration configuration : gp.getConfigurations()) {
                    String maybeSourceSet = Matcher.removeSuffix(configuration.getName());
                    if (maybeSourceSet == null) continue;
                    sourceSets.add(maybeSourceSet);
                }
                return sourceSets;
            });
        }

        private boolean hasDependenciesBlock(Cursor cursor) {
            Statement original = (Statement)cursor.getValue();
            Statement updated = (Statement)new JavaIsoVisitor<Integer>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer ctx) {
                    J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                    if (m.getSimpleName().equals("dependencies")) {
                        return (J.MethodInvocation)SearchResult.found((Tree)m);
                    }
                    return m;
                }
            }.visitNonNull((Tree)original, (Object)0);
            return updated != original;
        }

        private static @Nullable String removeSuffix(String configuration) {
            for (String suffix : JVM_TEST_SUITE_SUFFIXES) {
                if (configuration.equals(suffix)) {
                    return "main";
                }
                if (!configuration.endsWith(Character.toUpperCase(suffix.charAt(0)) + suffix.substring(1))) continue;
                return configuration.substring(0, configuration.length() - suffix.length());
            }
            return null;
        }
    }
}

