/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.marker.GradleDependencyConstraint;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.attributes.Attributed;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.Version;

public final class GradleDependencyConfiguration
implements Serializable,
Attributed {
    private final String name;
    private final @Nullable String description;
    private final boolean isTransitive;
    private final boolean isCanBeResolved;
    private final boolean isCanBeConsumed;
    private final boolean isCanBeDeclared;
    private List<GradleDependencyConfiguration> extendsFrom;
    private final List<Dependency> requested;
    private final List<ResolvedDependency> directResolved;
    private final @Nullable String exceptionType;
    private final @Nullable String message;
    private final List<GradleDependencyConstraint> constraints;
    private final Map<String, String> attributes;

    public List<ResolvedDependency> getDirectResolved() {
        return this.directResolved == null ? Collections.emptyList() : this.directResolved;
    }

    public List<ResolvedDependency> getResolved() {
        ArrayList<ResolvedDependency> resolved = new ArrayList<ResolvedDependency>(this.getDirectResolved());
        HashMap<GroupArtifact, ResolvedDependency> alreadyResolved = new HashMap<GroupArtifact, ResolvedDependency>();
        GradleDependencyConfiguration.resolveTransitiveDependencies(resolved, alreadyResolved);
        return new ArrayList<ResolvedDependency>(alreadyResolved.values());
    }

    List<GradleDependencyConstraint> getAllConstraints() {
        LinkedHashSet<GradleDependencyConstraint> constraintSet = new LinkedHashSet<GradleDependencyConstraint>(this.constraints);
        for (GradleDependencyConfiguration parentConfiguration : this.allExtendsFrom()) {
            constraintSet.addAll(parentConfiguration.getConstraints());
        }
        return new ArrayList<GradleDependencyConstraint>(constraintSet);
    }

    @Deprecated
    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message) {
        this(name, description, isTransitive, isCanBeResolved, isCanBeConsumed, !name.endsWith("Classpath"), extendsFrom, requested, directResolved, exceptionType, message);
    }

    @Deprecated
    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, boolean isCanBeDeclared, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.isCanBeConsumed = isCanBeConsumed;
        this.isCanBeDeclared = isCanBeDeclared;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.directResolved = directResolved;
        this.exceptionType = exceptionType;
        this.message = message;
        this.constraints = Collections.emptyList();
        this.attributes = Collections.emptyMap();
    }

    public List<GradleDependencyConfiguration> allExtendsFrom() {
        LinkedHashSet<GradleDependencyConfiguration> result = new LinkedHashSet<GradleDependencyConfiguration>();
        for (GradleDependencyConfiguration parentConfiguration : this.getExtendsFrom()) {
            result.add(parentConfiguration);
            result.addAll(parentConfiguration.allExtendsFrom());
        }
        return new ArrayList<GradleDependencyConfiguration>(result);
    }

    public @Nullable Dependency findRequestedDependency(String groupId, String artifactId) {
        for (Dependency d : this.requested) {
            if (!StringUtils.matchesGlob((String)d.getGav().getGroupId(), (String)groupId) || !StringUtils.matchesGlob((String)d.getGav().getArtifactId(), (String)artifactId)) continue;
            return d;
        }
        return null;
    }

    public @Nullable ResolvedDependency findResolvedDependency(String groupId, String artifactId) {
        for (ResolvedDependency d : this.directResolved) {
            ResolvedDependency dependency = d.findDependency(groupId, artifactId);
            if (dependency == null) continue;
            return dependency;
        }
        return null;
    }

    public void unsafeSetExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        this.extendsFrom = extendsFrom;
    }

    private static void resolveTransitiveDependencies(List<ResolvedDependency> resolved, Map<GroupArtifact, ResolvedDependency> alreadyResolved) {
        for (ResolvedDependency dependency : resolved) {
            GroupArtifact ga = dependency.getGav().asGroupArtifact();
            if (alreadyResolved.containsKey(ga)) {
                ResolvedDependency alreadyPresent = alreadyResolved.get(ga);
                Version newVersion = new Version(dependency.getVersion());
                Version presentVersion = new Version(alreadyPresent.getVersion());
                int compared = presentVersion.compareTo(newVersion);
                if (compared > 0 || compared == 0 && alreadyPresent.getDependencies().size() == dependency.getDependencies().size()) continue;
            }
            alreadyResolved.put(ga, dependency);
            GradleDependencyConfiguration.resolveTransitiveDependencies(dependency.getDependencies(), alreadyResolved);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Generated
    public boolean isCanBeResolved() {
        return this.isCanBeResolved;
    }

    @Generated
    public boolean isCanBeConsumed() {
        return this.isCanBeConsumed;
    }

    @Generated
    public boolean isCanBeDeclared() {
        return this.isCanBeDeclared;
    }

    @Generated
    public List<GradleDependencyConfiguration> getExtendsFrom() {
        return this.extendsFrom;
    }

    @Generated
    public List<Dependency> getRequested() {
        return this.requested;
    }

    @Generated
    public @Nullable String getExceptionType() {
        return this.exceptionType;
    }

    @Generated
    public @Nullable String getMessage() {
        return this.message;
    }

    @Generated
    public List<GradleDependencyConstraint> getConstraints() {
        return this.constraints;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleDependencyConfiguration)) {
            return false;
        }
        GradleDependencyConfiguration other = (GradleDependencyConfiguration)o;
        if (this.isTransitive() != other.isTransitive()) {
            return false;
        }
        if (this.isCanBeResolved() != other.isCanBeResolved()) {
            return false;
        }
        if (this.isCanBeConsumed() != other.isCanBeConsumed()) {
            return false;
        }
        if (this.isCanBeDeclared() != other.isCanBeDeclared()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<GradleDependencyConfiguration> this$extendsFrom = this.getExtendsFrom();
        List<GradleDependencyConfiguration> other$extendsFrom = other.getExtendsFrom();
        if (this$extendsFrom == null ? other$extendsFrom != null : !((Object)this$extendsFrom).equals(other$extendsFrom)) {
            return false;
        }
        List<Dependency> this$requested = this.getRequested();
        List<Dependency> other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested)) {
            return false;
        }
        List<ResolvedDependency> this$directResolved = this.getDirectResolved();
        List<ResolvedDependency> other$directResolved = other.getDirectResolved();
        if (this$directResolved == null ? other$directResolved != null : !((Object)this$directResolved).equals(other$directResolved)) {
            return false;
        }
        String this$exceptionType = this.getExceptionType();
        String other$exceptionType = other.getExceptionType();
        if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<GradleDependencyConstraint> this$constraints = this.getConstraints();
        List<GradleDependencyConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransitive() ? 79 : 97);
        result = result * 59 + (this.isCanBeResolved() ? 79 : 97);
        result = result * 59 + (this.isCanBeConsumed() ? 79 : 97);
        result = result * 59 + (this.isCanBeDeclared() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<GradleDependencyConfiguration> $extendsFrom = this.getExtendsFrom();
        result = result * 59 + ($extendsFrom == null ? 43 : ((Object)$extendsFrom).hashCode());
        List<Dependency> $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
        List<ResolvedDependency> $directResolved = this.getDirectResolved();
        result = result * 59 + ($directResolved == null ? 43 : ((Object)$directResolved).hashCode());
        String $exceptionType = this.getExceptionType();
        result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<GradleDependencyConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleDependencyConfiguration(name=" + this.getName() + ", description=" + this.getDescription() + ", isTransitive=" + this.isTransitive() + ", isCanBeResolved=" + this.isCanBeResolved() + ", isCanBeConsumed=" + this.isCanBeConsumed() + ", isCanBeDeclared=" + this.isCanBeDeclared() + ", extendsFrom=" + this.getExtendsFrom() + ", requested=" + this.getRequested() + ", directResolved=" + this.getDirectResolved() + ", exceptionType=" + this.getExceptionType() + ", message=" + this.getMessage() + ", constraints=" + this.getConstraints() + ", attributes=" + this.getAttributes() + ")";
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withName(String name) {
        return this.name == name ? this : new GradleDependencyConfiguration(name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withDescription(@Nullable String description) {
        return this.description == description ? this : new GradleDependencyConfiguration(this.name, description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withTransitive(boolean isTransitive) {
        return this.isTransitive == isTransitive ? this : new GradleDependencyConfiguration(this.name, this.description, isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withCanBeResolved(boolean isCanBeResolved) {
        return this.isCanBeResolved == isCanBeResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withCanBeConsumed(boolean isCanBeConsumed) {
        return this.isCanBeConsumed == isCanBeConsumed ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withCanBeDeclared(boolean isCanBeDeclared) {
        return this.isCanBeDeclared == isCanBeDeclared ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withExtendsFrom(List<GradleDependencyConfiguration> extendsFrom) {
        return this.extendsFrom == extendsFrom ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withRequested(List<Dependency> requested) {
        return this.requested == requested ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, requested, this.directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withDirectResolved(List<ResolvedDependency> directResolved) {
        return this.directResolved == directResolved ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, directResolved, this.exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withExceptionType(@Nullable String exceptionType) {
        return this.exceptionType == exceptionType ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, exceptionType, this.message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withMessage(@Nullable String message) {
        return this.message == message ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, message, this.constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withConstraints(List<GradleDependencyConstraint> constraints) {
        return this.constraints == constraints ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, constraints, this.attributes);
    }

    @NonNull
    @Generated
    public GradleDependencyConfiguration withAttributes(Map<String, String> attributes) {
        return this.attributes == attributes ? this : new GradleDependencyConfiguration(this.name, this.description, this.isTransitive, this.isCanBeResolved, this.isCanBeConsumed, this.isCanBeDeclared, this.extendsFrom, this.requested, this.directResolved, this.exceptionType, this.message, this.constraints, attributes);
    }

    @JsonCreator
    @Generated
    public GradleDependencyConfiguration(String name, @Nullable String description, boolean isTransitive, boolean isCanBeResolved, boolean isCanBeConsumed, boolean isCanBeDeclared, List<GradleDependencyConfiguration> extendsFrom, List<Dependency> requested, List<ResolvedDependency> directResolved, @Nullable String exceptionType, @Nullable String message, List<GradleDependencyConstraint> constraints, Map<String, String> attributes) {
        this.name = name;
        this.description = description;
        this.isTransitive = isTransitive;
        this.isCanBeResolved = isCanBeResolved;
        this.isCanBeConsumed = isCanBeConsumed;
        this.isCanBeDeclared = isCanBeDeclared;
        this.extendsFrom = extendsFrom;
        this.requested = requested;
        this.directResolved = directResolved;
        this.exceptionType = exceptionType;
        this.message = message;
        this.constraints = constraints;
        this.attributes = attributes;
    }
}

