/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.SourceFile;
import org.openrewrite.gradle.internal.GradleWrapperScriptLoader;
import org.openrewrite.gradle.util.DistributionInfos;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.remote.Remote;
import org.openrewrite.remote.RemoteArchive;
import org.openrewrite.remote.RemoteResource;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class GradleWrapper {
    private static final String GRADLE_SERVICES_URL = "https://services.gradle.org";
    private static final String GRADLE_DISTRIBUTIONS_URL = "https://services.gradle.org/distributions";
    private static final String GRADLE_VERSIONS_ALL_URL = "https://services.gradle.org/versions/all";
    public static final String WRAPPER_JAR_LOCATION_RELATIVE_PATH = "gradle/wrapper/gradle-wrapper.jar";
    public static final String WRAPPER_PROPERTIES_LOCATION_RELATIVE_PATH = "gradle/wrapper/gradle-wrapper.properties";
    public static final String WRAPPER_SCRIPT_LOCATION_RELATIVE_PATH = "gradlew";
    public static final String WRAPPER_BATCH_LOCATION_RELATIVE_PATH = "gradlew.bat";
    public static final Path WRAPPER_JAR_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]);
    public static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.properties", new String[0]);
    public static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("gradlew", new String[0]);
    public static final Path WRAPPER_BATCH_LOCATION = Paths.get("gradlew.bat", new String[0]);
    private final String version;
    private final DistributionInfos distributionInfos;
    private static final Pattern GRADLE_VERSION_PATTERN = Pattern.compile("gradle-([0-9.]+)");
    static final FileAttributes WRAPPER_JAR_FILE_ATTRIBUTES = new FileAttributes(null, null, null, true, true, false, 0L);

    public static GradleWrapper create(@Nullable String distributionTypeName, @Nullable String version, ExecutionContext ctx) {
        return GradleWrapper.create(null, distributionTypeName, version, ctx);
    }

    public static GradleWrapper create(@Nullable String currentDistributionUrl, @Nullable String distributionTypeName, @Nullable String version, ExecutionContext ctx) {
        String normalizedCurrentDistributionUrl = currentDistributionUrl == null ? null : currentDistributionUrl.replace("\\", "");
        DistributionType distributionType = Arrays.stream(DistributionType.values()).filter(dt -> dt.name().equalsIgnoreCase(distributionTypeName)).findAny().orElse(DistributionType.Bin);
        LatestRelease versionComparator = StringUtils.isBlank((String)version) ? new LatestRelease(null) : Objects.requireNonNull((VersionComparator)Semver.validate((String)version, null).getValue());
        try {
            GradleVersion gradleVersion = GradleWrapper.determineGradleVersion(normalizedCurrentDistributionUrl, version, (VersionComparator)versionComparator, distributionType, ctx);
            DistributionInfos infos = DistributionInfos.fetch(gradleVersion, ctx);
            return new GradleWrapper(gradleVersion.version, infos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static GradleVersion determineGradleVersion(@Nullable String currentDistributionUrl, @Nullable String version, VersionComparator versionComparator, DistributionType distributionType, ExecutionContext ctx) {
        if (currentDistributionUrl == null || currentDistributionUrl.startsWith(GRADLE_SERVICES_URL)) {
            if (!(versionComparator instanceof ExactVersion)) {
                List<GradleVersion> allVersions = GradleWrapper.listAllPublicVersions(ctx);
                return allVersions.stream().filter(v -> versionComparator.isValid(null, ((GradleVersion)v).version)).filter(v -> ((GradleVersion)v).distributionType == distributionType).max((v1, v2) -> versionComparator.compare(null, ((GradleVersion)v1).version, ((GradleVersion)v2).version)).orElseThrow(() -> new IllegalStateException(String.format("Expected to find at least one Gradle wrapper version to select from %s.", GRADLE_SERVICES_URL)));
            }
            return new GradleVersion(version, "https://services.gradle.org/distributions/gradle-" + version + "-" + distributionType.getFileSuffix() + ".zip", distributionType, "https://services.gradle.org/distributions/gradle-" + version + "-" + distributionType.getFileSuffix() + ".zip.sha256", "https://services.gradle.org/distributions/gradle-" + version + "-wrapper.jar.sha256");
        }
        if (currentDistributionUrl.contains("/artifactory")) {
            String artifactoryUrl = currentDistributionUrl.substring(0, currentDistributionUrl.lastIndexOf("/"));
            List<GradleVersion> allVersions = GradleWrapper.listAllPrivateArtifactoryVersions(artifactoryUrl, ctx);
            return allVersions.stream().filter(v -> versionComparator.isValid(null, ((GradleVersion)v).version)).filter(v -> ((GradleVersion)v).distributionType == distributionType).max((v1, v2) -> versionComparator.compare(null, ((GradleVersion)v1).version, ((GradleVersion)v2).version)).orElseThrow(() -> new IllegalStateException(String.format("Expected to find at least one Gradle wrapper version to select from %s.", artifactoryUrl)));
        }
        if (versionComparator instanceof ExactVersion) {
            return new GradleVersion(version, currentDistributionUrl.replaceAll("(.*gradle-)(\\d+\\.\\d+(?:\\.\\d+)?)(.*-)(?:bin|all).zip", "$1" + version + "$3" + distributionType.getFileSuffix() + ".zip"), distributionType, null, null);
        }
        throw new IllegalStateException("Unsupported distribution url for Gradle wrapper version detection: " + currentDistributionUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<GradleVersion> listAllPublicVersions(ExecutionContext ctx) {
        HttpSender httpSender = HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender();
        try (HttpSender.Response resp = httpSender.send(httpSender.get(GRADLE_VERSIONS_ALL_URL).build());){
            if (!resp.isSuccessful()) throw new IOException("Could not get Gradle versions from https://services.gradle.org/versions/all: HTTP " + resp.getCode());
            List gradleVersions = (List)new ObjectMapper().registerModule((Module)new ParameterNamesModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(resp.getBody(), (TypeReference)new TypeReference<List<GradleVersion>>(){});
            ArrayList<GradleVersion> allGradleVersions = new ArrayList<GradleVersion>(gradleVersions.size() * 2);
            for (GradleVersion gradleVersion : gradleVersions) {
                allGradleVersions.add(new GradleVersion(gradleVersion.version, gradleVersion.downloadUrl, DistributionType.Bin, gradleVersion.checksumUrl, gradleVersion.wrapperChecksumUrl));
                allGradleVersions.add(new GradleVersion(gradleVersion.version, gradleVersion.downloadUrl.replace("-bin.zip", "-all.zip"), DistributionType.All, gradleVersion.checksumUrl == null ? null : gradleVersion.checksumUrl.replace("-bin.zip", "-all.zip"), gradleVersion.wrapperChecksumUrl));
            }
            ArrayList<GradleVersion> arrayList = allGradleVersions;
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<GradleVersion> listAllPrivateArtifactoryVersions(String artifactoryUrl, ExecutionContext ctx) {
        URI artifactoryUri = URI.create(artifactoryUrl);
        String artifactoryApiUrl = String.format("%s://%s%s", artifactoryUri.getScheme(), artifactoryUri.getHost(), artifactoryUri.getPath().replace("/artifactory", "/artifactory/api/storage"));
        HttpSender httpSender = HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender();
        try (HttpSender.Response resp = httpSender.send(httpSender.get(artifactoryApiUrl).build());){
            if (!resp.isSuccessful()) throw new IOException("Could not get Gradle versions from " + artifactoryApiUrl + ": HTTP " + resp.getCode());
            JsonNode node = new ObjectMapper().readTree(resp.getBody());
            ArrayList<GradleVersion> gradleVersions = new ArrayList<GradleVersion>();
            for (JsonNode child : node.get("children")) {
                String uri;
                Matcher matcher;
                boolean folder = child.get("folder").asBoolean();
                if (folder || !(matcher = GRADLE_VERSION_PATTERN.matcher(uri = child.get("uri").asText())).find()) continue;
                String version = matcher.group(1);
                gradleVersions.add(new GradleVersion(version, artifactoryUrl + uri, uri.endsWith("-all.zip") ? DistributionType.All : DistributionType.Bin, null, null));
            }
            ArrayList<GradleVersion> arrayList = gradleVersions;
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static GradleWrapper create(URI fullDistributionUri, ExecutionContext ctx) {
        String version = "";
        Matcher matcher = GRADLE_VERSION_PATTERN.matcher(fullDistributionUri.toString());
        if (matcher.find()) {
            version = matcher.group(1);
        }
        return new GradleWrapper(version, new DistributionInfos(fullDistributionUri.toString(), null, null));
    }

    public String getDistributionUrl() {
        return this.distributionInfos.getDownloadUrl();
    }

    public String getPropertiesFormattedUrl() {
        return StringUtils.formatUriForPropertiesFile((String)this.getDistributionUrl());
    }

    public @Nullable Checksum getDistributionChecksum() {
        return this.distributionInfos.getChecksum();
    }

    public RemoteArchive wrapperJar() {
        return Remote.builder((Path)WRAPPER_JAR_LOCATION).build(URI.create(this.distributionInfos.getDownloadUrl()), new String[]{"gradle-[^\\/]+\\/(?:.*\\/)+gradle-(plugins|wrapper)-(?!shared).*\\.jar", "gradle-wrapper.jar"});
    }

    public RemoteArchive wrapperJar(SourceFile before) {
        return Remote.builder((SourceFile)before).build(URI.create(this.distributionInfos.getDownloadUrl()), new String[]{"gradle-[^\\/]+\\/(?:.*\\/)+gradle-(plugins|wrapper)-(?!shared).*\\.jar", "gradle-wrapper.jar"});
    }

    public RemoteResource gradlew() {
        return new GradleWrapperScriptLoader().findNearest(this.version).gradlew();
    }

    public RemoteResource gradlewBat() {
        return new GradleWrapperScriptLoader().findNearest(this.version).gradlewBat();
    }

    @Generated
    public GradleWrapper(String version, DistributionInfos distributionInfos) {
        this.version = version;
        this.distributionInfos = distributionInfos;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public DistributionInfos getDistributionInfos() {
        return this.distributionInfos;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleWrapper)) {
            return false;
        }
        GradleWrapper other = (GradleWrapper)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        DistributionInfos this$distributionInfos = this.getDistributionInfos();
        DistributionInfos other$distributionInfos = other.getDistributionInfos();
        return !(this$distributionInfos == null ? other$distributionInfos != null : !((Object)this$distributionInfos).equals(other$distributionInfos));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        DistributionInfos $distributionInfos = this.getDistributionInfos();
        result = result * 59 + ($distributionInfos == null ? 43 : ((Object)$distributionInfos).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleWrapper(version=" + this.getVersion() + ", distributionInfos=" + this.getDistributionInfos() + ")";
    }

    public static enum DistributionType {
        Bin("bin"),
        All("all");

        private final String fileSuffix;

        private DistributionType(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }
    }

    public static final class GradleVersion {
        private final String version;
        private final String downloadUrl;
        private final DistributionType distributionType;
        private final @Nullable String checksumUrl;
        private final @Nullable String wrapperChecksumUrl;

        @Generated
        public GradleVersion(String version, String downloadUrl, DistributionType distributionType, @Nullable String checksumUrl, @Nullable String wrapperChecksumUrl) {
            this.version = version;
            this.downloadUrl = downloadUrl;
            this.distributionType = distributionType;
            this.checksumUrl = checksumUrl;
            this.wrapperChecksumUrl = wrapperChecksumUrl;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Generated
        public DistributionType getDistributionType() {
            return this.distributionType;
        }

        @Generated
        public @Nullable String getChecksumUrl() {
            return this.checksumUrl;
        }

        @Generated
        public @Nullable String getWrapperChecksumUrl() {
            return this.wrapperChecksumUrl;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleVersion)) {
                return false;
            }
            GradleVersion other = (GradleVersion)o;
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$downloadUrl = this.getDownloadUrl();
            String other$downloadUrl = other.getDownloadUrl();
            if (this$downloadUrl == null ? other$downloadUrl != null : !this$downloadUrl.equals(other$downloadUrl)) {
                return false;
            }
            DistributionType this$distributionType = this.getDistributionType();
            DistributionType other$distributionType = other.getDistributionType();
            if (this$distributionType == null ? other$distributionType != null : !((Object)((Object)this$distributionType)).equals((Object)other$distributionType)) {
                return false;
            }
            String this$checksumUrl = this.getChecksumUrl();
            String other$checksumUrl = other.getChecksumUrl();
            if (this$checksumUrl == null ? other$checksumUrl != null : !this$checksumUrl.equals(other$checksumUrl)) {
                return false;
            }
            String this$wrapperChecksumUrl = this.getWrapperChecksumUrl();
            String other$wrapperChecksumUrl = other.getWrapperChecksumUrl();
            return !(this$wrapperChecksumUrl == null ? other$wrapperChecksumUrl != null : !this$wrapperChecksumUrl.equals(other$wrapperChecksumUrl));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $downloadUrl = this.getDownloadUrl();
            result = result * 59 + ($downloadUrl == null ? 43 : $downloadUrl.hashCode());
            DistributionType $distributionType = this.getDistributionType();
            result = result * 59 + ($distributionType == null ? 43 : ((Object)((Object)$distributionType)).hashCode());
            String $checksumUrl = this.getChecksumUrl();
            result = result * 59 + ($checksumUrl == null ? 43 : $checksumUrl.hashCode());
            String $wrapperChecksumUrl = this.getWrapperChecksumUrl();
            result = result * 59 + ($wrapperChecksumUrl == null ? 43 : $wrapperChecksumUrl.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "GradleWrapper.GradleVersion(version=" + this.getVersion() + ", downloadUrl=" + this.getDownloadUrl() + ", distributionType=" + (Object)((Object)this.getDistributionType()) + ", checksumUrl=" + this.getChecksumUrl() + ", wrapperChecksumUrl=" + this.getWrapperChecksumUrl() + ")";
        }
    }
}

