/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;
import org.openrewrite.trait.VisitFunction2;

public class GradleDependencies
implements Trait<J.MethodInvocation> {
    private static final MethodMatcher DEPENDENCY_DSL_MATCHER = new MethodMatcher("DependencyHandlerSpec *(..)");
    private final Cursor cursor;

    public @Nullable GradleDependencies removeDependency(@Nullable String group, @Nullable String artifact) {
        return this.filterStatements(statement -> !new GradleDependency.Matcher().artifactId(artifact).groupId(group).get((Tree)statement, this.getCursor()).isPresent());
    }

    public @Nullable GradleDependencies filterStatements(Predicate<Statement> predicate) {
        return this.mapStatements(statement -> predicate.test((Statement)statement) ? statement : null);
    }

    public @Nullable GradleDependencies mapStatements(Function<Statement, @Nullable Statement> mapper) {
        GradleProject gradleProject = this.getGradleProject();
        if (gradleProject == null) {
            return this;
        }
        List arguments = ListUtils.mapFirst((List)((J.MethodInvocation)this.getTree()).getArguments(), expression -> {
            if (expression instanceof J.Lambda) {
                J.Lambda lambda = (J.Lambda)expression;
                if (lambda.getBody() instanceof J.Block) {
                    return new Block.Matcher().get((Tree)lambda.getBody(), new Cursor(this.cursor, (Object)lambda)).map(block -> block.mapStatements(mapper)).map(Trait::getTree).filter(block -> !block.getStatements().isEmpty() || !block.getComments().isEmpty() || !block.getEnd().getComments().isEmpty()).map(arg_0 -> ((J.Lambda)lambda).withBody(arg_0)).orElse(null);
                }
                return lambda;
            }
            return expression;
        });
        if (arguments.isEmpty()) {
            return null;
        }
        Cursor newCursor = new Cursor(this.cursor.getParent(), (Object)((J.MethodInvocation)this.getTree()).withArguments(arguments));
        return new GradleDependencies(newCursor);
    }

    private @Nullable GradleProject getGradleProject() {
        SourceFile sourceFile = (SourceFile)this.cursor.firstEnclosing(SourceFile.class);
        if (sourceFile == null) {
            return null;
        }
        Optional maybeGp = sourceFile.getMarkers().findFirst(GradleProject.class);
        return maybeGp.orElse(null);
    }

    @Generated
    public GradleDependencies(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    private static class Block
    implements Trait<J.Block> {
        private final Cursor cursor;

        public Block mapStatements(Function<Statement, @Nullable Statement> mapper) {
            return this.mapStatements(mapper, J.Return::withExpression);
        }

        public Block mapStatements(Function<Statement, @Nullable Statement> mapper, BiFunction<J.Return, Expression, J.Return> returnMapper) {
            J.Block block = (J.Block)this.getTree();
            List statements = block.getStatements();
            List<Statement> newStatements = new LinkedList();
            LinkedList<Object> comments = new LinkedList<Comment>();
            String whitespace = null;
            boolean lastStatementWasKept = false;
            for (Statement statement : statements) {
                List statementComments;
                Statement mappedStatement;
                if (statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof Statement) {
                    statement = (Statement)((J.Return)statement).getExpression().withPrefix(statement.getPrefix());
                }
                if ((mappedStatement = mapper.apply(statement)) != null) {
                    int j;
                    statementComments = mappedStatement.getComments();
                    if (!comments.isEmpty() && whitespace != null) {
                        Comment last = comments.removeLast();
                        if (mappedStatement.getPrefix().getWhitespace().contains("\n")) {
                            comments.addLast(last.withSuffix(mappedStatement.getPrefix().getWhitespace()));
                            comments.addAll(statementComments);
                        } else {
                            for (j = 0; j < statementComments.size() && !((Comment)statementComments.get(j)).getSuffix().contains("\n"); ++j) {
                            }
                            comments.add(last.withSuffix(((Comment)statementComments.get(j)).getSuffix()));
                            if (j + 1 < statementComments.size()) {
                                comments.addAll(statementComments.subList(j + 1, statementComments.size()));
                            }
                        }
                        statement = (Statement)mappedStatement.withPrefix(mappedStatement.getPrefix().withWhitespace(whitespace).withComments(comments));
                    } else if (!lastStatementWasKept && !statement.getPrefix().getWhitespace().contains("\n") && whitespace != null) {
                        int startIndex = 0;
                        for (j = 0; j < statementComments.size() && !((Comment)statementComments.get(j)).getSuffix().contains("\n"); ++j) {
                        }
                        if (j + 1 <= statementComments.size()) {
                            startIndex = j + 1;
                        }
                        if (startIndex < statementComments.size()) {
                            if (startIndex > 0) {
                                statement = (Statement)statement.withPrefix(statement.getPrefix().withWhitespace(((Comment)statementComments.get(startIndex - 1)).getSuffix()).withComments(statementComments.subList(startIndex, statementComments.size())));
                            }
                        } else {
                            statement = (Statement)statement.withPrefix(statement.getPrefix().withWhitespace(whitespace).withComments(Collections.emptyList()));
                        }
                    }
                    comments = new LinkedList();
                    whitespace = null;
                    newStatements.add(statement);
                    lastStatementWasKept = true;
                    continue;
                }
                statementComments = statement.getComments();
                if (!comments.isEmpty() && whitespace != null) {
                    int startIndex = 0;
                    int endIndex = Block.findIndexOfLastCommentOnNewLine(statementComments) + 1;
                    if (!statement.getPrefix().getWhitespace().contains("\n")) {
                        int j;
                        for (j = 0; j < statementComments.size() && !((Comment)statementComments.get(j)).getSuffix().contains("\n"); ++j) {
                        }
                        Comment last = (Comment)comments.removeLast();
                        comments.add(last.withSuffix(((Comment)statementComments.get(j)).getSuffix()));
                        if (j + 1 <= statementComments.size()) {
                            startIndex = j + 1;
                        }
                    }
                    if (startIndex < endIndex) {
                        comments.addAll(statementComments.subList(startIndex, endIndex));
                    }
                } else if (lastStatementWasKept) {
                    comments.addAll(statementComments.subList(0, Block.findIndexOfLastCommentOnNewLine(statementComments) + 1));
                    whitespace = statement.getPrefix().getWhitespace();
                } else {
                    int startIndex = Block.findIndexOfFirstCommentOnNewLine(statementComments, statement.getPrefix());
                    comments.addAll(statementComments.subList(startIndex, Block.findIndexOfLastCommentOnNewLine(statementComments) + 1));
                    whitespace = startIndex == 0 ? statement.getPrefix().getWhitespace() : ((Comment)statementComments.get(startIndex - 1)).getSuffix();
                }
                lastStatementWasKept = false;
            }
            if (statements.equals(newStatements = ListUtils.mapLast(newStatements, newLast -> {
                Statement currentLast = (Statement)statements.get(statements.size() - 1);
                if (currentLast instanceof J.Return && !(newLast instanceof J.Return) && newLast instanceof Expression) {
                    J.Return currentReturn;
                    Space statementPrefix = (currentReturn = (J.Return)currentLast).getMarkers().findFirst(ImplicitReturn.class).isPresent() ? Space.EMPTY : Space.SINGLE_SPACE;
                    J.Return mappedReturn = (J.Return)returnMapper.apply(currentReturn, (Expression)newLast.withPrefix(statementPrefix));
                    if (mappedReturn.getExpression() instanceof Statement ? mapper.apply((Statement)mappedReturn.getExpression()) == null : mapper.apply((Statement)mappedReturn) == null) {
                        throw new IllegalArgumentException("The return statement replacement result should not be one that gets filtered out to avoid cyclic changes that result in the entire block being cleared. Did you return something from the old return that still return null when the mapper would be applied?");
                    }
                    return mappedReturn.withPrefix(newLast.getPrefix());
                }
                return newLast;
            })) && comments.isEmpty()) {
                return this;
            }
            if (!lastStatementWasKept) {
                block = block.withEnd(this.buildEnd(block.getEnd(), comments, whitespace));
            }
            block = block.withStatements(newStatements);
            return new Block(new Cursor(this.cursor.getParent(), (Object)block));
        }

        private Space buildEnd(Space end, List<Comment> comments, @Nullable String endWhitespace) {
            ArrayList<Object> newComments = new ArrayList<Object>();
            String endBlockWhitespace = null;
            if (!comments.isEmpty()) {
                for (Comment comment : comments) {
                    if (!(comment instanceof TextComment)) continue;
                    newComments.add(comment);
                    if (endBlockWhitespace != null) continue;
                    endBlockWhitespace = endWhitespace;
                }
            }
            ArrayList<Comment> existingEndComments = new ArrayList<Comment>();
            boolean eolComments = !end.getWhitespace().contains("\n");
            String whitespace = null;
            if (!eolComments) {
                whitespace = end.getWhitespace();
            }
            if (!end.getComments().isEmpty()) {
                for (Comment comment : end.getComments()) {
                    if (!(comment instanceof TextComment)) continue;
                    if (!eolComments) {
                        existingEndComments.add(comment);
                    } else if (comment.getSuffix().contains("\n")) {
                        eolComments = false;
                    }
                    if (whitespace != null) continue;
                    whitespace = comment.getSuffix();
                }
            }
            if (!newComments.isEmpty()) {
                newComments.set(newComments.size() - 1, ((Comment)newComments.get(newComments.size() - 1)).withSuffix(whitespace == null ? "" : whitespace));
            } else {
                endBlockWhitespace = whitespace;
            }
            newComments.addAll(existingEndComments);
            return end.withWhitespace(endBlockWhitespace == null ? end.getWhitespace() : endBlockWhitespace).withComments(newComments);
        }

        private static int findIndexOfFirstCommentOnNewLine(List<Comment> comments, Space prefix) {
            int index;
            if (prefix.getWhitespace().contains("\n")) {
                return 0;
            }
            for (index = 0; index < comments.size(); ++index) {
                Comment comment = comments.get(index);
                if (!comment.getSuffix().contains("\n")) continue;
                break;
            }
            return index;
        }

        private static int findIndexOfLastCommentOnNewLine(List<Comment> comments) {
            int index;
            for (index = comments.size() - 1; index >= 0; --index) {
                Comment comment = comments.get(index);
                if (comment.isMultiline()) {
                    if (!comment.getSuffix().contains("\n")) continue;
                    return index;
                }
                return index;
            }
            return index;
        }

        @Generated
        public Block(Cursor cursor) {
            this.cursor = cursor;
        }

        @Generated
        public Cursor getCursor() {
            return this.cursor;
        }

        private static class Matcher
        extends SimpleTraitMatcher<Block> {
            private Matcher() {
            }

            public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<Block, P> visitor) {
                return new JavaVisitor<P>(){

                    public J visitBlock(J.Block block, P p) {
                        Block trait = this.test(this.getCursor());
                        return trait != null ? (J)visitor.visit((Trait)trait, p) : super.visitBlock(block, p);
                    }
                };
            }

            protected @Nullable Block test(Cursor cursor) {
                Object object = cursor.getValue();
                if (object instanceof J.Block) {
                    return new Block(cursor);
                }
                return null;
            }
        }
    }

    public static class Matcher
    extends GradleTraitMatcher<GradleDependencies> {
        public <P> TreeVisitor<? extends Tree, P> asVisitor(final VisitFunction2<GradleDependencies, P> visitor) {
            return new JavaVisitor<P>(){

                public J visitMethodInvocation(J.MethodInvocation method, P p) {
                    GradleDependencies dependencies = this.test(this.getCursor());
                    return dependencies != null ? (J)visitor.visit((Trait)dependencies, p) : super.visitMethodInvocation(method, p);
                }
            };
        }

        protected @Nullable GradleDependencies test(Cursor cursor) {
            Object object = cursor.getValue();
            if (object instanceof J.MethodInvocation) {
                J.MethodInvocation methodInvocation = (J.MethodInvocation)object;
                if (!"dependencies".equals(methodInvocation.getSimpleName())) {
                    return null;
                }
                GradleProject gradleProject = this.getGradleProject(cursor);
                if (gradleProject == null && !DEPENDENCY_DSL_MATCHER.matches((MethodCall)methodInvocation)) {
                    return null;
                }
                return new GradleDependencies(cursor);
            }
            return null;
        }
    }
}

