/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyPrinter;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.internal.GroovyWhitespaceValidationService;
import org.openrewrite.internal.WhitespaceValidationService;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public interface G
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptGroovy((GroovyVisitor)v.adapt(GroovyVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(GroovyVisitor.class);
    }

    @Nullable
    default public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class Range
    implements G,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression from;
        private final JLeftPadded<Boolean> inclusive;
        private final Expression to;

        public boolean getInclusive() {
            return (Boolean)this.inclusive.getElement();
        }

        public Range withInclusive(boolean inclusive) {
            return this.getPadding().withInclusive((JLeftPadded<Boolean>)this.inclusive.withElement((Object)inclusive));
        }

        public JavaType getType() {
            return this.from.getType();
        }

        public Range withType(@Nullable JavaType type) {
            return this.withFrom((Expression)this.from.withType(type)).withTo((Expression)this.to.withType(type));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitRange(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Range(UUID id, Space prefix, Markers markers, Expression from, JLeftPadded<Boolean> inclusive, Expression to) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.inclusive = inclusive;
            this.to = to;
        }

        private Range(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression from, JLeftPadded<Boolean> inclusive, Expression to) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.inclusive = inclusive;
            this.to = to;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getFrom() {
            return this.from;
        }

        public Expression getTo() {
            return this.to;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        public String toString() {
            return "G.Range(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", from=" + this.getFrom() + ", inclusive=" + this.getInclusive() + ", to=" + this.getTo() + ")";
        }

        @NonNull
        public Range withId(UUID id) {
            return this.id == id ? this : new Range(this.padding, id, this.prefix, this.markers, this.from, this.inclusive, this.to);
        }

        @NonNull
        public Range withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Range(this.padding, this.id, prefix, this.markers, this.from, this.inclusive, this.to);
        }

        @NonNull
        public Range withMarkers(Markers markers) {
            return this.markers == markers ? this : new Range(this.padding, this.id, this.prefix, markers, this.from, this.inclusive, this.to);
        }

        @NonNull
        public Range withFrom(Expression from) {
            return this.from == from ? this : new Range(this.padding, this.id, this.prefix, this.markers, from, this.inclusive, this.to);
        }

        @NonNull
        public Range withTo(Expression to) {
            return this.to == to ? this : new Range(this.padding, this.id, this.prefix, this.markers, this.from, this.inclusive, to);
        }

        public static class Padding {
            private final Range t;

            public JLeftPadded<Boolean> getInclusive() {
                return this.t.inclusive;
            }

            public Range withInclusive(JLeftPadded<Boolean> inclusive) {
                return this.t.inclusive == inclusive ? this.t : new Range(this.t.id, this.t.prefix, this.t.markers, this.t.from, inclusive, this.t.to);
            }

            public Padding(Range t) {
                this.t = t;
            }
        }
    }

    public static final class Binary
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final Space after;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type;
        }

        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public Space getAfter() {
            return this.after;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        public String toString() {
            return "G.Binary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", after=" + this.getAfter() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.after, this.type);
        }

        @NonNull
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.after, this.type);
        }

        @NonNull
        public Binary withAfter(Space after) {
            return this.after == after ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, after, this.type);
        }

        @NonNull
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, type);
        }

        public static enum Type {
            Find,
            Match,
            In,
            Access;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.after, this.t.type);
            }

            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class GString
    implements G,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String delimiter;
        private final List<J> strings;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitGString(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GString;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public GString(UUID id, Space prefix, Markers markers, String delimiter, List<J> strings, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.strings = strings;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public List<J> getStrings() {
            return this.strings;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "G.GString(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + this.getDelimiter() + ", strings=" + this.getStrings() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public GString withId(UUID id) {
            return this.id == id ? this : new GString(id, this.prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        @NonNull
        public GString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new GString(this.id, prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        @NonNull
        public GString withMarkers(Markers markers) {
            return this.markers == markers ? this : new GString(this.id, this.prefix, markers, this.delimiter, this.strings, this.type);
        }

        @NonNull
        public GString withDelimiter(String delimiter) {
            return this.delimiter == delimiter ? this : new GString(this.id, this.prefix, this.markers, delimiter, this.strings, this.type);
        }

        @NonNull
        public GString withStrings(List<J> strings) {
            return this.strings == strings ? this : new GString(this.id, this.prefix, this.markers, this.delimiter, strings, this.type);
        }

        @NonNull
        public GString withType(@Nullable JavaType type) {
            return this.type == type ? this : new GString(this.id, this.prefix, this.markers, this.delimiter, this.strings, type);
        }

        public static final class Value
        implements G {
            private final UUID id;
            private final Markers markers;
            private final J tree;
            private final Space after;
            private final boolean enclosedInBraces;

            public <J2 extends J> J2 withPrefix(Space space) {
                return (J2)this;
            }

            @Override
            public Space getPrefix() {
                return Space.EMPTY;
            }

            public Space getAfter() {
                return this.after == null ? Space.EMPTY : this.after;
            }

            @Override
            public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
                return v.visitGStringValue(this, p);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof Value;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public Value(UUID id, Markers markers, J tree, Space after, boolean enclosedInBraces) {
                this.id = id;
                this.markers = markers;
                this.tree = tree;
                this.after = after;
                this.enclosedInBraces = enclosedInBraces;
            }

            public UUID getId() {
                return this.id;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public J getTree() {
                return this.tree;
            }

            public boolean isEnclosedInBraces() {
                return this.enclosedInBraces;
            }

            @NonNull
            public String toString() {
                return "G.GString.Value(id=" + this.getId() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", after=" + this.getAfter() + ", enclosedInBraces=" + this.isEnclosedInBraces() + ")";
            }

            @NonNull
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.markers, this.tree, this.after, this.enclosedInBraces);
            }

            @NonNull
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, markers, this.tree, this.after, this.enclosedInBraces);
            }

            @NonNull
            public Value withTree(J tree) {
                return this.tree == tree ? this : new Value(this.id, this.markers, tree, this.after, this.enclosedInBraces);
            }

            @NonNull
            public Value withAfter(Space after) {
                return this.after == after ? this : new Value(this.id, this.markers, this.tree, after, this.enclosedInBraces);
            }

            @NonNull
            public Value withEnclosedInBraces(boolean enclosedInBraces) {
                return this.enclosedInBraces == enclosedInBraces ? this : new Value(this.id, this.markers, this.tree, this.after, enclosedInBraces);
            }
        }
    }

    public static final class ListLiteral
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        @Nullable
        private final JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public ListLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitListLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListLiteral)) {
                return false;
            }
            ListLiteral other = (ListLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ListLiteral(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        private ListLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ListLiteral withId(UUID id) {
            return this.id == id ? this : new ListLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ListLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ListLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ListLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new ListLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public ListLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new ListLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final ListLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public ListLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new ListLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(ListLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class MapLiteral
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<MapEntry> elements;
        @Nullable
        private final JavaType type;

        public List<MapEntry> getElements() {
            return this.elements.getElements();
        }

        public MapLiteral withElements(List<MapEntry> elements) {
            return this.getPadding().withElements((JContainer<MapEntry>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitMapLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapLiteral)) {
                return false;
            }
            MapLiteral other = (MapLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MapLiteral(UUID id, Space prefix, Markers markers, JContainer<MapEntry> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        private MapLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<MapEntry> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MapLiteral withId(UUID id) {
            return this.id == id ? this : new MapLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MapLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MapLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public MapLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new MapLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final MapLiteral t;

            public JContainer<MapEntry> getElements() {
                return this.t.elements;
            }

            public MapLiteral withElements(JContainer<MapEntry> elements) {
                return this.t.elements == elements ? this.t : new MapLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(MapLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class MapEntry
    implements G,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> key;
        private final Expression value;
        @Nullable
        private final JavaType type;

        public Expression getKey() {
            return (Expression)this.key.getElement();
        }

        public MapEntry withKey(@Nullable Expression key) {
            return this.getPadding().withKey((JRightPadded<Expression>)JRightPadded.withElement(this.key, (Object)key));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitMapEntry(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapEntry)) {
                return false;
            }
            MapEntry other = (MapEntry)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MapEntry(UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        private MapEntry(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MapEntry withId(UUID id) {
            return this.id == id ? this : new MapEntry(this.padding, id, this.prefix, this.markers, this.key, this.value, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MapEntry withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MapEntry(this.padding, this.id, prefix, this.markers, this.key, this.value, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MapEntry withMarkers(Markers markers) {
            return this.markers == markers ? this : new MapEntry(this.padding, this.id, this.prefix, markers, this.key, this.value, this.type);
        }

        public Expression getValue() {
            return this.value;
        }

        @NonNull
        public MapEntry withValue(Expression value) {
            return this.value == value ? this : new MapEntry(this.padding, this.id, this.prefix, this.markers, this.key, value, this.type);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public MapEntry withType(@Nullable JavaType type) {
            return this.type == type ? this : new MapEntry(this.padding, this.id, this.prefix, this.markers, this.key, this.value, type);
        }

        public static class Padding {
            private final MapEntry t;

            @Nullable
            public JRightPadded<Expression> getKey() {
                return this.t.key;
            }

            public MapEntry withKey(@Nullable JRightPadded<Expression> key) {
                return this.t.key == key ? this.t : new MapEntry(this.t.id, this.t.prefix, this.t.markers, key, this.t.value, this.t.type);
            }

            public Padding(MapEntry t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionStatement
    implements G,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        public ExpressionStatement(Expression expression) {
            this.id = Tree.randomId();
            this.expression = expression;
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @NonNull
        public String toString() {
            return "G.ExpressionStatement(id=" + this.getId() + ", expression=" + this.getExpression() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        @NonNull
        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }

        public Expression getExpression() {
            return this.expression;
        }
    }

    public static final class CompilationUnit
    implements G,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        @Nullable
        private final String shebang;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        @Nullable
        private final JRightPadded<J.Package> packageDeclaration;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Nullable
        public J.Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : (J.Package)this.packageDeclaration.getElement();
        }

        public CompilationUnit withPackageDeclaration(J.Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration((JRightPadded<J.Package>)JRightPadded.withElement(this.packageDeclaration, (Object)packageDeclaration));
        }

        public <S, T extends S> T service(Class<S> service) {
            if (WhitespaceValidationService.class.getName().equals(service.getName())) {
                return (T)new GroovyWhitespaceValidationService();
            }
            return (T)super.service(service);
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.Import> getImports() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.Import.class::isInstance).map(J.Import.class::cast).collect(Collectors.toList());
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.getPadding().getImports(), imports));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this.getPadding().withClasses(JRightPadded.withElements(this.getPadding().getClasses(), classes));
        }

        @Override
        public <P> J acceptGroovy(GroovyVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new GroovyPrinter();
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "G.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", shebang=" + this.getShebang() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", packageDeclaration=" + this.getPackageDeclaration() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, @Nullable String shebang, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<J.Package> packageDeclaration, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.shebang = shebang;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.statements = statements;
            this.eof = eof;
        }

        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, @Nullable String shebang, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<J.Package> packageDeclaration, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.shebang = shebang;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.statements = statements;
            this.eof = eof;
        }

        @NonNull
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public CompilationUnit withShebang(@Nullable String shebang) {
            return this.shebang == shebang ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Nullable
        public String getShebang() {
            return this.shebang;
        }

        @NonNull
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @NonNull
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @NonNull
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.packageDeclaration, this.statements, this.eof);
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.shebang, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.statements, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<J.Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<J.Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, packageDeclaration, this.t.statements, this.t.eof);
            }

            @Transient
            public List<JRightPadded<J.ClassDeclaration>> getClasses() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.ClassDeclaration).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withClasses(List<JRightPadded<J.ClassDeclaration>> classes) {
                JRightPadded statement;
                List<JRightPadded<Statement>> statements = this.t.statements.stream().filter(s -> !(s.getElement() instanceof J.ClassDeclaration)).collect(Collectors.toList());
                int insertionIdx = 0;
                Iterator iterator = statements.iterator();
                while (iterator.hasNext() && (statement = (JRightPadded)iterator.next()).getElement() instanceof J.Import) {
                    ++insertionIdx;
                }
                statements.addAll(insertionIdx, classes.stream().map(i -> i).collect(Collectors.toList()));
                return this.t.getPadding().getClasses() == classes ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            @Transient
            public List<JRightPadded<J.Import>> getImports() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.Import).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                List<JRightPadded<Statement>> statements = this.t.statements.stream().filter(s -> !(s.getElement() instanceof J.Import)).collect(Collectors.toList());
                statements.addAll(0, imports.stream().map(i -> i).collect(Collectors.toList()));
                return this.t.getPadding().getImports() == imports ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.shebang, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, (JRightPadded<J.Package>)this.t.packageDeclaration, statements, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

