/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.openrewrite.ParseWarning;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.ExceptionUtils;

public class ParseWarningCollector
extends ErrorCollector {
    private final List<ParseWarning> warningMarkers = new ArrayList<ParseWarning>();
    private final Class<? extends GroovyParser> parserClass;

    public ParseWarningCollector(CompilerConfiguration configuration, GroovyParser parser) {
        super(configuration);
        this.parserClass = parser.getClass();
    }

    public void addErrorAndContinue(Message message) throws CompilationFailedException {
        super.addErrorAndContinue(message);
        Object t = null;
        if (message instanceof SyntaxErrorMessage) {
            t = ((SyntaxErrorMessage)message).getCause();
        } else if (message instanceof ExceptionMessage) {
            t = ((ExceptionMessage)message).getCause();
        }
        if (t != null) {
            this.warningMarkers.add(new ParseWarning(Tree.randomId(), ExceptionUtils.sanitizeStackTrace((Throwable)t, this.parserClass)));
        }
    }

    protected void failIfErrors() throws CompilationFailedException {
    }

    public List<ParseWarning> getWarningMarkers() {
        return this.warningMarkers;
    }
}

