/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.format.BlankLinesStyle;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclRightPadded;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;

public class BlankLinesVisitor<P>
extends HclIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final BlankLinesStyle style;

    public BlankLinesVisitor(BlankLinesStyle style) {
        this(style, null);
    }

    public BlankLinesVisitor(BlankLinesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile configFile, P p) {
        Hcl c = super.visitConfigFile(configFile, (Object)p);
        c = ((Hcl.ConfigFile)c).withBody(ListUtils.map(((Hcl.ConfigFile)c).getBody(), (i, b) -> b.withPrefix(this.minimumLines(this.keepMaximumLines(b.getPrefix(), (int)this.style.getKeepMaximum().getInBodyContent()), i == 0 ? 0 : this.style.getMinimum().getBeforeBodyContent()))));
        return c;
    }

    @Override
    public Hcl.Block visitBlock(Hcl.Block block, P p) {
        Hcl c = super.visitBlock(block, (Object)p);
        c = ((Hcl.Block)c).withBody(ListUtils.map(((Hcl.Block)c).getBody(), (i, b) -> b.withPrefix(this.minimumLines(this.keepMaximumLines(b.getPrefix(), (int)this.style.getKeepMaximum().getInBodyContent()), i == 0 ? 0 : this.style.getMinimum().getBeforeBodyContent()))));
        c = ((Hcl.Block)c).withEnd(this.keepMaximumLines(((Hcl.Block)c).getEnd(), (int)this.style.getKeepMaximum().getBeforeEndOfBlock()));
        return c;
    }

    private <H extends Hcl> H keepMaximumLines(H tree, int max) {
        return tree.withPrefix(this.keepMaximumLines(tree.getPrefix(), max));
    }

    private Space keepMaximumLines(Space prefix, int max) {
        return prefix.withWhitespace(this.keepMaximumLines(prefix.getWhitespace(), max));
    }

    private String keepMaximumLines(String whitespace, int max) {
        long blankLines = whitespace.chars().filter(c -> c == 10).count() - 1L;
        if (blankLines > (long)max) {
            int startWhitespaceAtIndex = 0;
            int i = 0;
            while ((long)i < blankLines - (long)max + 1L) {
                startWhitespaceAtIndex = whitespace.indexOf(10, startWhitespaceAtIndex);
                ++i;
                ++startWhitespaceAtIndex;
            }
            return whitespace.substring(--startWhitespaceAtIndex);
        }
        return whitespace;
    }

    private <H extends Hcl> HclRightPadded<H> minimumLines(HclRightPadded<H> tree, int min) {
        return tree.withElement(this.minimumLines((Hcl)tree.getElement(), min));
    }

    private <H extends Hcl> H minimumLines(H tree, int min) {
        return tree.withPrefix(this.minimumLines(tree.getPrefix(), min));
    }

    private Space minimumLines(Space prefix, int min) {
        if (prefix.getComments().isEmpty() || prefix.getWhitespace().contains("\n")) {
            return prefix.withWhitespace(this.minimumLines(prefix.getWhitespace(), min));
        }
        return prefix.withComments(ListUtils.map(prefix.getComments(), (i, c) -> i == 0 ? c.withSuffix(this.minimumLines(c.getSuffix(), min)) : c));
    }

    private String minimumLines(String whitespace, int min) {
        if (min == 0) {
            return whitespace;
        }
        String minWhitespace = whitespace;
        int i = 0;
        while ((long)i < (long)min - whitespace.chars().filter(c -> c == 10).count() + 1L) {
            minWhitespace = "\n" + minWhitespace;
            ++i;
        }
        return minWhitespace;
    }

    @Nullable
    public Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }
}

