/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;

public class Java11Parser
implements JavaParser {
    private final JavaParser delegate;

    Java11Parser(JavaParser delegate) {
        this.delegate = delegate;
    }

    public List<J.CompilationUnit> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.delegate.parseInputs(sourceFiles, relativeTo, ctx);
    }

    public JavaParser reset() {
        this.delegate.reset();
        return this;
    }

    public void setClasspath(Collection<Path> classpath) {
        this.delegate.setClasspath(classpath);
    }

    public void setSourceSet(String sourceSet) {
        this.delegate.setSourceSet(sourceSet);
    }

    public JavaSourceSet getSourceSet(ExecutionContext ctx) {
        return this.delegate.getSourceSet(ctx);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class UnrestrictedModuleClassLoader
    extends ClassLoader {
        final List<Path> modules;

        private UnrestrictedModuleClassLoader(ClassLoader parentClassloader) {
            super(parentClassloader);
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            this.modules = List.of(fs.getPath("modules", "jdk.compiler"), fs.getPath("modules", "java.compiler"), fs.getPath("modules", "java.base"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                String internalName = name.replace('.', '/') + ".class";
                Class<?> _class = this.loadIsolatedClass(name);
                if (_class != null) {
                    return _class;
                }
                if (name.startsWith("com.sun") || name.startsWith("sun")) {
                    try {
                        for (Path path : this.modules) {
                            Path classFile = path.resolve(internalName);
                            if (!Files.exists(classFile, new LinkOption[0])) continue;
                            byte[] bytes = Files.readAllBytes(classFile);
                            return this.defineClass(name, bytes, 0, bytes.length);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return super.loadClass(name);
        }

        @Nullable
        private Class<?> loadIsolatedClass(String className) {
            Class<?> clazz;
            block11: {
                if (!className.startsWith("org.openrewrite.java.isolated")) {
                    return null;
                }
                String internalName = className.replace('.', '/') + ".class";
                URL url = Java11Parser.class.getClassLoader().getResource(internalName);
                if (url == null) {
                    return null;
                }
                InputStream stream = url.openStream();
                try {
                    int bytesRead;
                    ByteArrayOutputStream classBytes = new ByteArrayOutputStream();
                    byte[] bytes = new byte[4096];
                    while ((bytesRead = stream.read(bytes)) > 0) {
                        classBytes.write(bytes, 0, bytesRead);
                    }
                    clazz = this.defineClass(className, classBytes.toByteArray(), 0, classBytes.size());
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                stream.close();
            }
            return clazz;
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static class Builder
    extends JavaParser.Builder<Java11Parser, Builder> {
        @Nullable
        private static ClassLoader moduleClassLoader;

        static synchronized void lazyInitClassLoaders() {
            if (moduleClassLoader != null) {
                return;
            }
            ClassLoader appClassLoader = Java11Parser.class.getClassLoader();
            moduleClassLoader = new UnrestrictedModuleClassLoader(appClassLoader);
        }

        public Java11Parser build() {
            Builder.lazyInitClassLoaders();
            try {
                Class<?> parserImplementation = Class.forName("org.openrewrite.java.isolated.ReloadableJava11Parser", true, moduleClassLoader);
                Constructor<?> parserConstructor = parserImplementation.getDeclaredConstructor(Boolean.TYPE, Collection.class, Collection.class, Collection.class, Charset.class, Collection.class, JavaTypeCache.class);
                parserConstructor.setAccessible(true);
                JavaParser delegate = (JavaParser)parserConstructor.newInstance(this.logCompilationWarningsAndErrors, this.classpath, this.classBytesClasspath, this.dependsOn, this.charset, this.styles, this.javaTypeCache);
                return new Java11Parser(delegate);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to construct Java11Parser.", e);
            }
        }
    }
}

