/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ExplicitLambdaArgumentTypes
extends Recipe {
    public String getDisplayName() {
        return "Use explicit types on lambda arguments";
    }

    public String getDescription() {
        return "Adds explicit types on lambda arguments, which are otherwise optional. This can make the code clearer and easier to read. This does not add explicit types on arguments when the lambda has one or two parameters and does not have a block body, as things are considered more readable in those cases. For example, `stream.map((a, b) -> a.length);` will not have explicit types added.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2211");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ExplicitLambdaArgumentTypesVisitor();
    }

    private static class ExplicitLambdaArgumentTypesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String ADDED_EXPLICIT_TYPE_KEY = "ADDED_EXPLICIT_TYPE";

        private ExplicitLambdaArgumentTypesVisitor() {
        }

        @Nullable
        private static String buildName(@Nullable JavaType type) {
            if (type != null) {
                if (type instanceof JavaType.FullyQualified) {
                    JavaType.FullyQualified asFQN = TypeUtils.asFullyQualified(type);
                    assert (asFQN != null);
                    return asFQN.getClassName();
                }
                if (type instanceof JavaType.Primitive) {
                    JavaType.Primitive asPrimitive = TypeUtils.asPrimitive(type);
                    assert (asPrimitive != null);
                    return asPrimitive.getKeyword();
                }
                if (type instanceof JavaType.Array) {
                    JavaType.Array arrayType = TypeUtils.asArray(type);
                    assert (arrayType != null);
                    StringBuilder typeAsString = new StringBuilder();
                    JavaType elemType = arrayType.getElemType();
                    if (elemType instanceof JavaType.Primitive) {
                        typeAsString.append(ExplicitLambdaArgumentTypesVisitor.buildName(elemType));
                    } else if (elemType instanceof JavaType.FullyQualified) {
                        typeAsString.append(ExplicitLambdaArgumentTypesVisitor.buildName(elemType));
                    } else if (elemType instanceof JavaType.Array) {
                        JavaType typeOfArray = ((JavaType.Array)elemType).getElemType();
                        typeAsString.append(ExplicitLambdaArgumentTypesVisitor.buildName(typeOfArray));
                        while (arrayType.getElemType() instanceof JavaType.Array) {
                            typeAsString.append("[]");
                            arrayType = (JavaType.Array)arrayType.getElemType();
                        }
                    }
                    typeAsString.append("[]");
                    return typeAsString.toString();
                }
            }
            return null;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            if (multiVariable.getTypeExpression() == null) {
                if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Lambda) {
                    J.VariableDeclarations.NamedVariable nv = multiVariable.getVariables().get(0);
                    String name = ExplicitLambdaArgumentTypesVisitor.buildName(nv.getType());
                    assert (name != null);
                    multiVariable = multiVariable.withTypeExpression(J.Identifier.build(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, nv.getType()));
                    this.getCursor().dropParentUntil(J.Lambda.class::isInstance).putMessage(ADDED_EXPLICIT_TYPE_KEY, (Object)true);
                }
            }
            return super.visitVariableDeclarations(multiVariable, ctx);
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J nv = super.visitVariable(variable, ctx);
            Cursor c = this.getCursor().dropParentUntil(J.class::isInstance).dropParentUntil(J.class::isInstance);
            if (c.getValue() instanceof J.Lambda && c.getMessage(ADDED_EXPLICIT_TYPE_KEY) != null) {
                nv = ((J.VariableDeclarations.NamedVariable)nv).withPrefix(((J.VariableDeclarations.NamedVariable)nv).getPrefix().withWhitespace(" "));
            }
            return nv;
        }

        @Override
        public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            if (lambda.getParameters().getParameters().size() <= 2 && !(lambda.getBody() instanceof J.Block)) {
                return lambda;
            }
            J l = super.visitLambda(lambda, ctx);
            if (this.getCursor().getMessage(ADDED_EXPLICIT_TYPE_KEY) != null) {
                l = ((J.Lambda)l).withParameters(((J.Lambda)l).getParameters().withParenthesized(true));
            }
            return l;
        }
    }
}

