/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class RedundantFileCreation
extends Recipe {
    public String getDisplayName() {
        return "Redundant file creation";
    }

    public String getDescription() {
        return "Remove unnecessary intermediate creations of files.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.io.FileInputStream");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J n = super.visitNewClass(newClass, executionContext);
                if (((J.NewClass)n).getClazz() != null && TypeUtils.isOfClassType(((J.NewClass)n).getClazz().getType(), "java.io.FileInputStream")) {
                    n = ((J.NewClass)n).withArguments(ListUtils.map(((J.NewClass)n).getArguments(), arg -> {
                        J.NewClass newClassArg;
                        if (arg instanceof J.NewClass && (newClassArg = (J.NewClass)arg).getClazz() != null && TypeUtils.isOfClassType(newClassArg.getClazz().getType(), "java.io.File") && newClassArg.getArguments() != null && newClassArg.getArguments().size() == 1) {
                            this.maybeRemoveImport("java.io.File");
                            return newClassArg.getArguments().get(0);
                        }
                        return arg;
                    }));
                }
                return n;
            }
        };
    }
}

