/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class AddSerialVersionUidToSerializable
extends Recipe {
    private static final JavaType.Class SERIALIZABLE_FQ = JavaType.Class.build("java.io.Serializable");
    private static final JavaType.Class COLLECTION_FQ = JavaType.Class.build("java.util.Collection");
    private static final JavaType.Class MAP_FQ = JavaType.Class.build("java.util.Map");
    private static final JavaType.Class THROWABLE_FQ = JavaType.Class.build("java.lang.Throwable");

    public String getDisplayName() {
        return "Add `SerialVersionUID` to a Serializable class when it's missing.";
    }

    public String getDescription() {
        return "A `serialVersionUID` field is strongly recommended in all `Serializable` classes. If this is not defined on a `Serializable` class, the compiler will generate this value. If a change is later made to the class, the generated value will change and attempts to deserialize the class will fail.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2057");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), "private static final long serialVersionUID = 1").build();

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J c = super.visitClassDeclaration(classDecl, ctx);
                if (AddSerialVersionUidToSerializable.implementsSerializable(((J.ClassDeclaration)c).getType())) {
                    AtomicBoolean serializedFound = new AtomicBoolean(false);
                    c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withStatements(ListUtils.map(((J.ClassDeclaration)c).getBody().getStatements(), (i, s) -> {
                        if (s instanceof J.VariableDeclarations) {
                            J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)s;
                            for (J.VariableDeclarations.NamedVariable v : variableDeclarations.getVariables()) {
                                JavaType.Primitive variableType;
                                if (!v.getSimpleName().equals("serialVersionUID")) continue;
                                serializedFound.set(true);
                                List<J.Modifier> modifiers = variableDeclarations.getModifiers();
                                if (!(J.Modifier.hasModifier(modifiers, J.Modifier.Type.Private) && J.Modifier.hasModifier(modifiers, J.Modifier.Type.Static) && J.Modifier.hasModifier(modifiers, J.Modifier.Type.Final))) {
                                    variableDeclarations = variableDeclarations.withModifiers(Arrays.asList(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList()), new J.Modifier(Tree.randomId(), Space.format(" "), Markers.EMPTY, J.Modifier.Type.Static, Collections.emptyList()), new J.Modifier(Tree.randomId(), Space.format(" "), Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList())));
                                }
                                if ((variableType = TypeUtils.asPrimitive(variableDeclarations.getType())) != JavaType.Primitive.Long) {
                                    variableDeclarations = variableDeclarations.withTypeExpression(new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JavaType.Primitive.Long));
                                }
                                if (s == variableDeclarations) continue;
                                return this.autoFormat(variableDeclarations, ctx).withPrefix(s.getPrefix());
                            }
                        }
                        return s;
                    })));
                    if (!serializedFound.get()) {
                        c = (J.ClassDeclaration)c.withTemplate(this.template, ((J.ClassDeclaration)c).getBody().getCoordinates().firstStatement(), new Object[0]);
                    }
                }
                return c;
            }
        };
    }

    public static boolean implementsSerializable(@Nullable JavaType type) {
        JavaType.FullyQualified fq;
        if (type == null) {
            return false;
        }
        if (type instanceof JavaType.Primitive) {
            return true;
        }
        if (type instanceof JavaType.Array) {
            return AddSerialVersionUidToSerializable.implementsSerializable(((JavaType.Array)type).getElemType());
        }
        if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            if (COLLECTION_FQ.isAssignableFrom(parameterized) || MAP_FQ.isAssignableFrom(parameterized)) {
                boolean typeParametersSerializable = true;
                for (JavaType typeParameter : parameterized.getTypeParameters()) {
                    typeParametersSerializable = typeParametersSerializable && AddSerialVersionUidToSerializable.implementsSerializable(typeParameter);
                }
                return typeParametersSerializable;
            }
        } else if (type instanceof JavaType.FullyQualified && (fq = (JavaType.FullyQualified)type).getKind() != JavaType.Class.Kind.Interface && !THROWABLE_FQ.isAssignableFrom(fq)) {
            return SERIALIZABLE_FQ.isAssignableFrom(fq);
        }
        return false;
    }
}

