/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.FallThroughVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.FallThroughStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class FallThrough
extends Recipe {
    public String getDisplayName() {
        return "Fall through";
    }

    public String getDescription() {
        return "Checks for fall-through in switch statements, adding `break` statements in locations where a case contains Java code but does not have a `break`, `return`, `throw`, or `continue` statement.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-128");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FallThroughFromCompilationUnitStyle();
    }

    private static class FallThroughFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private FallThroughFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            FallThroughStyle style = (FallThroughStyle)((SourceFile)cu).getStyle(FallThroughStyle.class);
            if (style == null) {
                style = Checkstyle.fallThrough();
            }
            this.doAfterVisit(new FallThroughVisitor(style));
            return cu;
        }
    }
}

