/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class RenameLocalVariablesToCamelCase
extends Recipe {
    public String getDisplayName() {
        return "Reformat local variable names to camelCase";
    }

    public String getDescription() {
        return "Reformat local variable and method parameter names to camelCase to comply with Java naming convention. The recipe will not rename variables declared in for loop controls or catches with a single character. The first character is set to lower case and existing capital letters are preserved. Special characters that are allowed in java field names `$` and `_` are removed. If a special character is removed the next valid alpha-numeric will be capitalized. Currently, does not support renaming members of classes. The recipe will not rename a variable if the result already exists in the class, conflicts with a java reserved keyword, or the result is blank.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-117");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RenameNonCompliantNames();
    }

    private static class RenameNonCompliantNames
    extends JavaIsoVisitor<ExecutionContext> {
        private final Pattern namingConvention = Pattern.compile("^[a-z][a-zA-Z0-9]*$");

        private RenameNonCompliantNames() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            LinkedHashMap<J.VariableDeclarations.NamedVariable, String> renameVariablesMap = new LinkedHashMap<J.VariableDeclarations.NamedVariable, String>();
            HashSet hasNameSet = new HashSet();
            this.getCursor().putMessage("RENAME_VARIABLES_KEY", renameVariablesMap);
            this.getCursor().putMessage("HAS_NAME_KEY", hasNameSet);
            super.visitJavaSourceFile(cu, ctx);
            renameVariablesMap.forEach((key, value) -> {
                if (!hasNameSet.contains(value)) {
                    this.doAfterVisit(new RenameVariable((J.VariableDeclarations.NamedVariable)key, (String)value));
                    hasNameSet.add(value);
                }
            });
            return cu;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            Cursor parentScope = RenameNonCompliantNames.getCursorToParentScope(this.getCursor());
            if (!(parentScope.getParent() != null && parentScope.getParent().getValue() instanceof J.ClassDeclaration || parentScope.getParent().getValue() instanceof J.NewClass || parentScope.getValue() instanceof J.ForLoop.Control || (parentScope.getValue() instanceof J.Try.Catch || parentScope.getValue() instanceof J.MultiCatch) && variable.getSimpleName().length() == 1 || this.namingConvention.matcher(variable.getSimpleName()).matches())) {
                String toName = RenameNonCompliantNames.convertToCamelCase(variable.getSimpleName());
                ((Map)this.getCursor().getNearestMessage("RENAME_VARIABLES_KEY")).put(variable, toName);
            }
            return variable;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            ((Set)this.getCursor().getNearestMessage("HAS_NAME_KEY")).add(identifier.getSimpleName());
            return identifier;
        }

        private static Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
        }

        private static String convertToCamelCase(String oldName) {
            StringBuilder builder = new StringBuilder();
            boolean setCaps = false;
            block3: for (int i = 0; i < oldName.length(); ++i) {
                char c = oldName.charAt(i);
                switch (c) {
                    case '$': 
                    case '_': {
                        if (builder.length() <= 0) continue block3;
                        setCaps = true;
                        continue block3;
                    }
                    default: {
                        if (builder.length() == 0) {
                            builder.append(String.valueOf(oldName.charAt(i)).toLowerCase());
                            continue block3;
                        }
                        if (setCaps) {
                            builder.append(String.valueOf(oldName.charAt(i)).toUpperCase());
                            setCaps = false;
                            continue block3;
                        }
                        builder.append(oldName.charAt(i));
                    }
                }
            }
            return builder.toString();
        }
    }
}

