/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.style.GeneralFormatStyle;

public class NormalizeLineBreaksVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final GeneralFormatStyle style;
    private final JavadocVisitor<Integer> lineBreakJavadocVisitor = new JavadocVisitor<Integer>(){

        @Override
        public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, Integer integer) {
            return lineBreak.withMargin(NormalizeLineBreaksVisitor.normalizeNewLines(lineBreak.getMargin(), NormalizeLineBreaksVisitor.this.style.isUseCRLFNewLines()));
        }
    };

    public NormalizeLineBreaksVisitor(GeneralFormatStyle style) {
        this(style, null);
    }

    public NormalizeLineBreaksVisitor(GeneralFormatStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        Space s = space.withWhitespace(NormalizeLineBreaksVisitor.normalizeNewLines(space.getWhitespace(), this.style.isUseCRLFNewLines()));
        return s.withComments(ListUtils.map(s.getComments(), comment -> {
            Comment c = comment;
            if (c.isMultiline()) {
                if (c instanceof Javadoc) {
                    c = c.withSuffix(NormalizeLineBreaksVisitor.normalizeNewLines(c.getSuffix(), this.style.isUseCRLFNewLines()));
                    return (Comment)this.lineBreakJavadocVisitor.visitNonNull((Javadoc)((Object)c), 0);
                }
                TextComment textComment = (TextComment)c;
                c = textComment.withText(NormalizeLineBreaksVisitor.normalizeNewLines(textComment.getText(), this.style.isUseCRLFNewLines()));
            }
            return c.withSuffix(NormalizeLineBreaksVisitor.normalizeNewLines(c.getSuffix(), this.style.isUseCRLFNewLines()));
        }));
    }

    private static String normalizeNewLines(String text, boolean useCrlf) {
        if (!text.contains("\n")) {
            return text;
        }
        StringBuilder normalized = new StringBuilder();
        char[] charArray = text.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (useCrlf && c == '\n' && (i == 0 || text.charAt(i - 1) != '\r')) {
                normalized.append('\r').append('\n');
                continue;
            }
            if (!useCrlf && c == '\r') continue;
            normalized.append(c);
        }
        return normalized.toString();
    }

    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return tree;
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

