/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.DefaultComesLastVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.DefaultComesLastStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class DefaultComesLast
extends Recipe {
    public String getDisplayName() {
        return "Default comes last";
    }

    public String getDescription() {
        return "Ensure the `default` case comes last after all the cases in a switch statement.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4524");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DefaultComesLastFromCompilationUnitStyle();
    }

    private static class DefaultComesLastFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private DefaultComesLastFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            DefaultComesLastStyle style = (DefaultComesLastStyle)((SourceFile)cu).getStyle(DefaultComesLastStyle.class);
            if (style == null) {
                style = Checkstyle.defaultComesLast();
            }
            this.doAfterVisit(new DefaultComesLastVisitor(style));
            return cu;
        }
    }
}

