/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.ExplicitInitializationVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.ExplicitInitializationStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class ExplicitInitialization
extends Recipe {
    public String getDisplayName() {
        return "Explicit initialization";
    }

    public String getDescription() {
        return "Checks if any class or object member is explicitly initialized to default for its type value (`null` for object references, zero for numeric types and `char` and `false` for `boolean`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3052");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ExplicitInitializationFromCompilationUnitStyle();
    }

    private static class ExplicitInitializationFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private ExplicitInitializationFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            ExplicitInitializationStyle style = (ExplicitInitializationStyle)((SourceFile)cu).getStyle(ExplicitInitializationStyle.class);
            if (style == null) {
                style = Checkstyle.explicitInitialization();
            }
            this.doAfterVisit(new ExplicitInitializationVisitor(style));
            return cu;
        }
    }
}

