/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class IsEmptyCallOnCollections
extends Recipe {
    private static final MethodMatcher COLLECTION_SIZE = new MethodMatcher("java.util.Collection size()", true);

    public String getDisplayName() {
        return "Use `Collections#isEmpty()` instead of comparing `size()`";
    }

    public String getDescription() {
        return "Also check for _not_ `isEmpty()` when testing for not equal to zero size.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3981");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(COLLECTION_SIZE);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate isEmpty = JavaTemplate.builder(() -> (this).getCursor(), "#{}#{any(java.util.Collection)}.isEmpty()").build();

            @Override
            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                if ((binary.getOperator() == J.Binary.Type.Equal || binary.getOperator() == J.Binary.Type.NotEqual) && (COLLECTION_SIZE.matches(binary.getLeft()) || COLLECTION_SIZE.matches(binary.getRight())) && (IsEmptyCallOnCollections.isZero(binary.getLeft()) || IsEmptyCallOnCollections.isZero(binary.getRight()))) {
                    J.MethodInvocation sizeCall = (J.MethodInvocation)(COLLECTION_SIZE.matches(binary.getLeft()) ? binary.getLeft() : binary.getRight());
                    return sizeCall.withTemplate(this.isEmpty, sizeCall.getCoordinates().replace(), binary.getOperator() == J.Binary.Type.Equal ? "" : "!", sizeCall.getSelect()).withPrefix(binary.getPrefix());
                }
                return super.visitBinary(binary, ctx);
            }
        };
    }

    private static boolean isZero(Expression expression) {
        return expression instanceof J.Literal && Integer.valueOf(0).equals(((J.Literal)expression).getValue());
    }
}

