/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class RemoveExtraSemicolons
extends Recipe {
    public String getDisplayName() {
        return "Remove extra semicolons";
    }

    public String getDescription() {
        return "Optional semicolons at the end of try-with-resources are also removed.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1116", "RSPEC-2959"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitEmpty(J.Empty empty, ExecutionContext ctx) {
                if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Block) {
                    return null;
                }
                return super.visitEmpty(empty, ctx);
            }

            @Override
            public J visitTry(J.Try tryable, ExecutionContext ctx) {
                return tryable.withResources(ListUtils.map(tryable.getResources(), r -> r.withTerminatedWithSemicolon(false))).withBody((J.Block)super.visit((Tree)tryable.getBody(), (Object)ctx)).withCatches(ListUtils.map(tryable.getCatches(), c -> (J.Try.Catch)super.visit((Tree)c, (Object)ctx))).withFinally((J.Block)super.visit((Tree)tryable.getFinally(), (Object)ctx));
            }
        };
    }
}

