/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AtomicPrimitiveEqualsUsesGet
extends Recipe {
    public String getDisplayName() {
        return "Atomic Boolean, Integer, and Long equality checks compare their values";
    }

    public String getDescription() {
        return "`AtomicBoolean#equals(Object)`, `AtomicInteger#equals(Object)` and `AtomicLong#equals(Object)` are only equal to their instance. This recipe converts `a.equals(b)` to `a.get() == b.get()`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2204");
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                this.doAfterVisit(new UsesType("java.util.concurrent.atomic.AtomicBoolean"));
                this.doAfterVisit(new UsesType("java.util.concurrent.atomic.AtomicInteger"));
                this.doAfterVisit(new UsesType("java.util.concurrent.atomic.AtomicLong"));
                return cu;
            }
        };
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher aiMethodMatcher = new MethodMatcher("java.lang.Object equals(java.lang.Object)");

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                JavaType.FullyQualified fqt;
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (mi.getSelect() != null && this.isAtomicEqualsType(mi.getSelect().getType()) && this.aiMethodMatcher.matches(mi) && TypeUtils.isOfType(mi.getSelect().getType(), mi.getArguments().get(0).getType()) && (fqt = TypeUtils.asFullyQualified(mi.getSelect().getType())) != null) {
                    String templateString = "#{any(" + fqt.getFullyQualifiedName() + ")}.get() == #{any(" + fqt.getFullyQualifiedName() + ")}.get()";
                    return mi.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), templateString).imports(fqt.getFullyQualifiedName()).build(), mi.getCoordinates().replace(), mi.getSelect(), mi.getArguments().get(0));
                }
                return mi;
            }

            private boolean isAtomicEqualsType(@Nullable JavaType type) {
                if (type != null) {
                    for (String fqn : new String[]{"java.util.concurrent.atomic.AtomicBoolean", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong"}) {
                        if (!TypeUtils.isOfClassType(type, fqn)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

