/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class NoEmptyCollectionWithRawType
extends Recipe {
    public String getDisplayName() {
        return "Use `Collections#emptyList()`, `emptyMap()`, and `emptySet()`";
    }

    public String getDescription() {
        return "Replaces `Collections#EMPTY_..` with methods that return generic types.";
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.util.Collections");
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1596");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        final HashMap<String, String> updateFields = new HashMap<String, String>();
        updateFields.put("EMPTY_LIST", "emptyList");
        updateFields.put("EMPTY_MAP", "emptyMap");
        updateFields.put("EMPTY_SET", "emptySet");
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitImport(J.Import anImport, ExecutionContext executionContext) {
                J.Identifier name = anImport.getQualid().getName();
                if (anImport.isStatic() && name.getSimpleName().startsWith("EMPTY_") && TypeUtils.isOfClassType(anImport.getQualid().getTarget().getType(), "java.util.Collections")) {
                    return anImport.withQualid(anImport.getQualid().withName(name.withSimpleName((String)updateFields.get(name.getSimpleName()))));
                }
                return super.visitImport(anImport, executionContext);
            }

            @Override
            public J visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                J.Identifier id = (J.Identifier)super.visitIdentifier(identifier, ctx);
                JavaType.Variable varType = id.getFieldType();
                if (varType != null && TypeUtils.isOfClassType(varType.getOwner(), "java.util.Collections") && varType.getName().startsWith("EMPTY_")) {
                    J.Identifier methodId = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (String)updateFields.get(varType.getName()), null, null);
                    JavaType.Method method = null;
                    for (JavaType.Method m : TypeUtils.asFullyQualified(varType.getOwner()).getMethods()) {
                        if (!m.getName().equals(updateFields.get(id.getSimpleName()))) continue;
                        method = m;
                        break;
                    }
                    return new J.MethodInvocation(Tree.randomId(), id.getPrefix(), id.getMarkers(), null, null, methodId, JContainer.build(Collections.emptyList()), method);
                }
                return id;
            }
        };
    }
}

