/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.NoMissingTypes;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnusedPrivateMethods
extends Recipe {
    public String getDisplayName() {
        return "Remove unused private methods";
    }

    public String getDescription() {
        return "`private` methods that are never executed are dead code and should be removed.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1144");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new NoMissingTypes();
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                JavaType.Method methodType = method.getMethodType();
                if (methodType != null && methodType.hasFlags(Flag.Private) && !method.isConstructor() && method.getAllAnnotations().isEmpty()) {
                    J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class);
                    if (TypeUtils.isAssignableTo("java.io.Serializable", (JavaType)classDeclaration.getType())) {
                        switch (((J.MethodDeclaration)m).getSimpleName()) {
                            case "readObject": 
                            case "readObjectNoData": 
                            case "readResolve": 
                            case "writeObject": {
                                return m;
                            }
                        }
                    }
                    J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class);
                    for (JavaType.Method usedMethodType : cu.getTypesInUse().getUsedMethods()) {
                        if (!methodType.getName().equals(usedMethodType.getName()) || !methodType.equals(usedMethodType)) continue;
                        return m;
                    }
                    for (JavaType javaType : cu.getTypesInUse().getTypesInUse()) {
                        if (!TypeUtils.isOfClassType(javaType, "org.junit.jupiter.params.provider.MethodSource")) continue;
                        return m;
                    }
                    for (JavaType.Method usedMethodType : cu.getTypesInUse().getDeclaredMethods()) {
                        if (!methodType.getName().equals(usedMethodType.getName()) || !methodType.equals(usedMethodType) || !((J.MethodDeclaration)m).toString().contains("Generic{")) continue;
                        return m;
                    }
                    return null;
                }
                return m;
            }
        };
    }
}

