/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.JavaSourceFile;

public class BlankLines
extends Recipe {
    public String getDisplayName() {
        return "Blank lines";
    }

    public String getDescription() {
        return "Add and/or remove blank lines.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new BlankLinesFromCompilationUnitStyle();
    }

    private static class BlankLinesFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private BlankLinesFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            BlankLinesStyle style = (BlankLinesStyle)((SourceFile)cu).getStyle(BlankLinesStyle.class);
            if (style == null) {
                style = IntelliJ.blankLines();
            }
            this.doAfterVisit(new BlankLinesVisitor(style));
            return cu;
        }
    }
}

