/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.dataflow.ExternalFlowModels;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Incubating(since="7.24.0")
public abstract class LocalFlowSpec<Source extends Expression, Sink extends J> {
    protected final Type sourceType;
    protected final Type sinkType;

    protected LocalFlowSpec() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: LocalFlowSpec constructed without actual type information");
        }
        this.sourceType = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.sinkType = ((ParameterizedType)superClass).getActualTypeArguments()[1];
    }

    public Class<?> getSourceType() {
        return (Class)this.sourceType;
    }

    public Class<?> getSinkType() {
        return (Class)this.sinkType;
    }

    public abstract boolean isSource(Source var1, Cursor var2);

    public abstract boolean isSink(Sink var1, Cursor var2);

    public final boolean isFlowStep(Expression startExpression, Cursor startCursor, Expression endExpression, Cursor endCursor) {
        return ExternalFlowModels.instance().isAdditionalFlowStep(startExpression, startCursor, endExpression, endCursor) || this.isAdditionalFlowStep(startExpression, startCursor, endExpression, endCursor);
    }

    public boolean isAdditionalFlowStep(Expression startExpression, Cursor startCursor, Expression endExpression, Cursor endCursor) {
        return false;
    }

    public boolean isBarrierGuard(Expression expr) {
        return false;
    }
}

