/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@FunctionalInterface
@Incubating(since="7.25.0")
public interface InvocationMatcher {
    public boolean matches(Expression var1);

    default public AdvancedInvocationMatcher advanced() {
        return new AdvancedInvocationMatcher(this);
    }

    public static InvocationMatcher fromMethodMatcher(MethodMatcher methodMatcher) {
        return methodMatcher::matches;
    }

    public static InvocationMatcher fromInvocationMatchers(Collection<InvocationMatcher> matchers) {
        if (matchers.size() > 750) {
            return expression -> matchers.parallelStream().anyMatch(matcher -> matcher.matches(expression));
        }
        return expression -> matchers.stream().anyMatch(matcher -> matcher.matches(expression));
    }

    public static InvocationMatcher fromInvocationMatchers(MethodMatcher ... methodMatchers) {
        return InvocationMatcher.fromInvocationMatchers(Stream.of(methodMatchers).map(InvocationMatcher::fromMethodMatcher).collect(Collectors.toList()));
    }

    public static InvocationMatcher fromMethodMatchers(Collection<MethodMatcher> matchers) {
        return InvocationMatcher.fromInvocationMatchers(matchers.stream().map(InvocationMatcher::fromMethodMatcher).collect(Collectors.toList()));
    }

    public static class AdvancedInvocationMatcher {
        InvocationMatcher matcher;

        public boolean isSelect(Cursor cursor) {
            Expression expression = AdvancedInvocationMatcher.ensureCursorIsExpression(cursor);
            assert (expression == cursor.getValue()) : "expression != cursor.getValue()";
            J.MethodInvocation maybeMethodInvocation = (J.MethodInvocation)cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class);
            return maybeMethodInvocation != null && maybeMethodInvocation.getSelect() == expression && this.matcher.matches(maybeMethodInvocation);
        }

        public boolean isAnyArgument(Cursor cursor) {
            Expression expression = AdvancedInvocationMatcher.ensureCursorIsExpression(cursor);
            return AdvancedInvocationMatcher.extractCallExpression(cursor).map(call -> AdvancedInvocationMatcher.getCallArguments(call).contains(expression) && this.matcher.matches((Expression)call)).orElse(false);
        }

        public boolean isFirstParameter(Cursor cursor) {
            return this.isParameter(cursor, 0);
        }

        public boolean isParameter(Cursor cursor, int parameterIndex) {
            Expression expression = AdvancedInvocationMatcher.ensureCursorIsExpression(cursor);
            return AdvancedInvocationMatcher.extractCallExpression(cursor).map(call -> {
                int finalParameterIndex;
                List<Expression> arguments = AdvancedInvocationMatcher.getCallArguments(call);
                if (parameterIndex >= arguments.size()) {
                    return false;
                }
                if (AdvancedInvocationMatcher.doesMethodHaveVarargs(call) && (finalParameterIndex = AdvancedInvocationMatcher.getType(call).getParameterTypes().size() - 1) == parameterIndex) {
                    List<Expression> varargs = arguments.subList(finalParameterIndex, arguments.size());
                    return varargs.contains(expression) && this.matcher.matches((Expression)call);
                }
                return arguments.get(parameterIndex) == expression && this.matcher.matches((Expression)call);
            }).orElse(false);
        }

        private static boolean doesMethodHaveVarargs(Expression expression) {
            return AdvancedInvocationMatcher.getType(expression).hasFlags(Flag.Varargs);
        }

        private static JavaType.Method getType(Expression expression) {
            JavaType.Method type;
            if (expression instanceof J.MethodInvocation) {
                type = ((J.MethodInvocation)expression).getMethodType();
            } else if (expression instanceof J.NewClass) {
                type = ((J.NewClass)expression).getConstructorType();
            } else {
                throw new IllegalArgumentException("Expression is not a method invocation or new class");
            }
            if (type == null) {
                throw new IllegalArgumentException("Type information is missing for " + expression);
            }
            return type;
        }

        private static List<Expression> getCallArguments(Expression call) {
            if (call instanceof J.MethodInvocation) {
                return ((J.MethodInvocation)call).getArguments();
            }
            if (call instanceof J.NewClass) {
                List<Expression> arguments = ((J.NewClass)call).getArguments();
                return arguments == null ? Collections.emptyList() : arguments;
            }
            throw new IllegalArgumentException("Unknown call type: " + call.getClass());
        }

        private static Optional<Expression> extractCallExpression(Cursor cursor) {
            J stop = (J)cursor.dropParentUntil(v -> v instanceof J.MethodInvocation || v instanceof J.NewClass || v instanceof J.Block).getValue();
            if (stop instanceof J.Block) {
                return Optional.empty();
            }
            return Optional.of((Expression)stop);
        }

        private static Expression ensureCursorIsExpression(Cursor cursor) {
            if (cursor.getValue() instanceof Expression) {
                return (Expression)cursor.getValue();
            }
            throw new IllegalArgumentException("Cursor is not an expression. Was " + cursor.getValue().getClass());
        }

        private AdvancedInvocationMatcher(InvocationMatcher matcher) {
            this.matcher = matcher;
        }
    }
}

