/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class BlockStatementTemplateGenerator {
    private static final String TEMPLATE_COMMENT = "__TEMPLATE__";
    private static final String STOP_COMMENT = "__TEMPLATE_STOP__";
    static final String EXPR_STATEMENT_PARAM = "class __P__ {  static native <T> T p();  static native <T> T[] arrp();  static native boolean booleanp();  static native byte bytep();  static native char charp();  static native double doublep();  static native int intp();  static native long longp();  static native short shortp();  static native float floatp();}";
    private static final String METHOD_INVOCATION_STUBS = "class __M__ {  static native Object any(Object o);  static native <T> Object anyT();}";
    private final Set<String> imports;

    public String template(Cursor cursor, String template, Space.Location location) {
        return (String)Timer.builder((String)"rewrite.template.generate.statement").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            if (cursor.getValue() instanceof J.MethodDeclaration && location.equals((Object)Space.Location.BLOCK_PREFIX)) {
                J.MethodDeclaration method = (J.MethodDeclaration)cursor.getValue();
                J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
                before.insert(0, m.printTrimmed(cursor.getParentOrThrow()).trim() + '{');
                after.append('}');
            }
            this.template(this.next(cursor), (J)cursor.getValue(), before, after, Collections.newSetFromMap(new IdentityHashMap()));
            return before.toString().trim() + "\n/*" + TEMPLATE_COMMENT + "*/" + template + "\n" + after;
        });
    }

    public <J2 extends J> List<J2> listTemplatedTrees(JavaSourceFile cu, final Class<J2> expected) {
        final ArrayList js = new ArrayList();
        new JavaIsoVisitor<Integer>(){
            boolean done = false;
            @Nullable
            J.Block blockEnclosingTemplateComment;

            @Override
            public J.Block visitBlock(J.Block block, Integer p) {
                J b = super.visitBlock(block, p);
                if (b == this.blockEnclosingTemplateComment) {
                    this.done = true;
                }
                return b;
            }

            @Nullable
            public J visit(@Nullable Tree tree, Integer p) {
                J trimmed;
                if (this.done) {
                    return (J)tree;
                }
                if (expected.isInstance(tree)) {
                    J t = (J)tree;
                    if (this.blockEnclosingTemplateComment != null) {
                        J trimmed2 = TemplatedTreeTrimmer.trimTree(t);
                        if (trimmed2 != null) {
                            js.add(trimmed2);
                        } else {
                            this.done = true;
                        }
                        return t;
                    }
                    List<Comment> comments = t.getPrefix().getComments();
                    for (int i = 0; i < comments.size(); ++i) {
                        Comment comment = comments.get(i);
                        if (!(comment instanceof TextComment) || !((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.TEMPLATE_COMMENT)) continue;
                        this.blockEnclosingTemplateComment = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
                        J trimmed3 = TemplatedTreeTrimmer.trimTree(t);
                        if (t != trimmed3) {
                            this.done = true;
                        }
                        if (trimmed3 != null) {
                            js.add(trimmed3.withPrefix(trimmed3.getPrefix().withComments(comments.subList(i + 1, comments.size()))));
                        }
                        return t;
                    }
                } else if (tree != null && !js.isEmpty() && (trimmed = TemplatedTreeTrimmer.trimTree((J)tree)) != tree) {
                    this.done = true;
                }
                return (J)super.visit(tree, (Object)p);
            }
        }.visit(cu, 0);
        return js;
    }

    private void template(Cursor cursor, J prior, StringBuilder before, StringBuilder after, Set<J> templated) {
        templated.add((J)cursor.getValue());
        J j = (J)cursor.getValue();
        if (j instanceof JavaSourceFile) {
            before.insert(0, "class __P__ {  static native <T> T p();  static native <T> T[] arrp();  static native boolean booleanp();  static native byte bytep();  static native char charp();  static native double doublep();  static native int intp();  static native long longp();  static native short shortp();  static native float floatp();}class __M__ {  static native Object any(Object o);  static native <T> Object anyT();}");
            JavaSourceFile cu = (JavaSourceFile)j;
            for (J.Import import_ : cu.getImports()) {
                before.insert(0, import_.withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            for (String string : this.imports) {
                before.insert(0, string);
            }
            if (cu.getPackageDeclaration() != null) {
                before.insert(0, cu.getPackageDeclaration().withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            return;
        }
        if (j instanceof J.Block) {
            J parent = (J)this.next(cursor).getValue();
            if (parent instanceof J.ClassDeclaration) {
                J.ClassDeclaration c = (J.ClassDeclaration)parent;
                if (c.getKind() == J.ClassDeclaration.Kind.Type.Enum) {
                    this.enumClassDeclaration(prior, c, before, after, templated, cursor);
                } else {
                    this.classDeclaration(prior, before, after, (J.ClassDeclaration)parent, templated, cursor, false);
                }
            } else if (parent instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)parent;
                assert (m.getBody() != null);
                for (Statement statement : m.getBody().getStatements()) {
                    if (BlockStatementTemplateGenerator.referToSameElement(prior, statement)) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true, cursor) + ";\n");
                }
                if (m.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(m.getReturnTypeExpression().getType())) {
                    before.insert(0, "if(true) {");
                    after.append("}\nreturn ").append(this.valueOfType(m.getReturnTypeExpression().getType())).append(";\n");
                }
                before.insert(0, m.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + '{');
            } else if (parent instanceof J.Block || parent instanceof J.Lambda) {
                J.Block b = (J.Block)j;
                for (Statement statement : b.getStatements()) {
                    if (BlockStatementTemplateGenerator.referToSameElement(prior, statement)) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true, cursor) + ";\n");
                }
                before.insert(0, "{\n");
                if (b.isStatic()) {
                    before.insert(0, "static");
                }
            } else {
                before.insert(0, "{\n");
            }
            after.append('}');
        } else if (j instanceof J.NewClass) {
            J.NewClass n = (J.NewClass)j;
            if (n.getClazz() != null) {
                if (n.getArguments().stream().anyMatch(arg -> BlockStatementTemplateGenerator.referToSameElement(prior, arg))) {
                    StringBuilder beforeSegments = new StringBuilder();
                    StringBuilder stringBuilder = new StringBuilder();
                    beforeSegments.append("new ").append(n.getClazz().printTrimmed(cursor)).append("(");
                    boolean priorFound = false;
                    for (Expression arg2 : n.getArguments()) {
                        if (!priorFound) {
                            if (BlockStatementTemplateGenerator.referToSameElement(prior, arg2)) {
                                priorFound = true;
                                continue;
                            }
                            beforeSegments.append(this.valueOfType(arg2.getType())).append(",");
                            continue;
                        }
                        stringBuilder.append(",/*__TEMPLATE_STOP__*/").append(this.valueOfType(arg2.getType()));
                    }
                    stringBuilder.append(")");
                    before.insert(0, beforeSegments);
                    after.append((CharSequence)stringBuilder);
                    if (this.next(cursor).getValue() instanceof J.Block) {
                        after.append(";");
                    }
                } else {
                    n = n.withBody(null).withPrefix(Space.EMPTY);
                    before.insert(0, n.printTrimmed(cursor.getParentOrThrow()).trim());
                    if (!(this.next(cursor).getValue() instanceof MethodCall)) {
                        after.append(';');
                    }
                }
            }
        } else if (j instanceof J.ForLoop) {
            J.ForLoop f = (J.ForLoop)j;
            f = f.withBody(null).withPrefix(Space.EMPTY).withControl(f.getControl().withCondition(null).withUpdate(Collections.emptyList()));
            before.insert(0, f.printTrimmed(cursor).trim());
        } else if (j instanceof J.ForEachLoop.Control) {
            J.ForEachLoop.Control c = (J.ForEachLoop.Control)j;
            if (c.getVariable() == prior) {
                after.append(" = /*__TEMPLATE_STOP__/*").append(c.getIterable().printTrimmed(cursor));
            }
        } else if (j instanceof J.ForEachLoop) {
            J.ForEachLoop f = (J.ForEachLoop)j;
            if (!BlockStatementTemplateGenerator.referToSameElement(prior, f.getControl())) {
                f = f.withBody(null).withPrefix(Space.EMPTY);
                before.insert(0, f.printTrimmed(cursor).trim());
            }
        } else if (j instanceof J.Try) {
            J.Try t = (J.Try)j;
            if (t.getResources() != null) {
                before.insert(0, ")");
                for (J.Try.Resource resource : t.getResources()) {
                    before.insert(0, resource.withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + ';');
                }
                before.insert(0, "try(");
            }
        } else if (j instanceof J.Lambda) {
            J.Lambda l = (J.Lambda)j;
            if (l.getBody() instanceof Expression) {
                before.insert(0, "return ");
                after.append(";");
            }
            before.insert(0, l.withBody(null).withPrefix(Space.EMPTY).printTrimmed(cursor.getParentOrThrow()).trim() + "{ if(true) {");
            after.append("}\n");
            JavaType.Method mt = BlockStatementTemplateGenerator.findSingleAbstractMethod(l.getType());
            if (mt == null) {
                after.append("return null;\n");
            } else if (mt.getReturnType() != JavaType.Primitive.Void) {
                after.append("return ").append(this.valueOfType(mt.getReturnType())).append(";\n");
            }
            after.append("}");
            if (this.next(cursor).getValue() instanceof J.Block) {
                after.append(";");
            }
        } else if (j instanceof J.VariableDeclarations) {
            before.insert(0, this.variable((J.VariableDeclarations)j, false, cursor) + '=');
        } else if (j instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)j;
            if (m.getArguments().stream().anyMatch(arg -> BlockStatementTemplateGenerator.referToSameElement(prior, arg))) {
                before.insert(0, "__M__.any(");
                if (cursor.getParentOrThrow().firstEnclosing(J.class) instanceof J.Block) {
                    after.append(");");
                } else {
                    after.append(")");
                }
            } else if (m.getTypeParameters() != null && m.getTypeParameters().stream().anyMatch(tp -> BlockStatementTemplateGenerator.referToSameElement(prior, tp))) {
                before.insert(0, "__M__.anyT<");
                if (cursor.getParentOrThrow().firstEnclosing(J.class) instanceof J.Block) {
                    after.append(">();");
                } else {
                    after.append(">()");
                }
            } else if (m.getSelect() == prior) {
                ArrayList<Comment> comments = new ArrayList<Comment>(1);
                comments.add(new TextComment(true, STOP_COMMENT, "", Markers.EMPTY));
                after.append(".").append(m.withSelect(null).withComments(comments).printTrimmed(cursor.getParentOrThrow()));
            }
        } else if (j instanceof J.Return) {
            before.insert(0, "return ");
            after.append(";");
        } else if (j instanceof J.If) {
            J.If iff = (J.If)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, iff.getIfCondition())) {
                before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ =");
                after.append(";");
            }
        } else if (j instanceof J.WhileLoop) {
            J.WhileLoop wl = (J.WhileLoop)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, wl.getCondition())) {
                before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ =");
                after.append(";");
            }
        } else if (j instanceof J.Assignment) {
            J.Assignment as = (J.Assignment)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, as.getAssignment())) {
                before.insert(0, as.getVariable() + " = ");
                after.append(";");
            }
        } else if (j instanceof J.EnumValue) {
            J.EnumValue ev = (J.EnumValue)j;
            if (ev.getInitializer() != null) {
                before.insert(0, "(");
                after.append(")");
            }
            before.insert(0, ev.getName());
        } else if (j instanceof J.EnumValueSet) {
            after.append(";");
        }
        this.template(this.next(cursor), j, before, after, templated);
    }

    private void enumClassDeclaration(@Nullable J prior, J.ClassDeclaration c, StringBuilder before, StringBuilder after, Set<J> templated, Cursor cursor) {
        before.insert(0, "\nenum " + c.getSimpleName() + "{\n");
        List<Statement> statements = c.getBody().getStatements();
        for (int i = 1; i < statements.size(); ++i) {
            Statement statement = statements.get(i);
            if (templated.contains(statement)) continue;
            if (statement instanceof J.VariableDeclarations) {
                after.append(this.variable((J.VariableDeclarations)statement, false, cursor)).append(";\n");
                continue;
            }
            if (statement instanceof J.MethodDeclaration) {
                if (BlockStatementTemplateGenerator.referToSameElement(statement, prior)) continue;
                after.append(this.method((J.MethodDeclaration)statement, cursor));
                continue;
            }
            if (!(statement instanceof J.ClassDeclaration)) continue;
            this.classDeclaration(null, before, after, (J.ClassDeclaration)statement, templated, cursor, true);
        }
        after.append("\n");
    }

    private void classDeclaration(@Nullable J prior, StringBuilder before, StringBuilder after, J.ClassDeclaration parent, Set<J> templated, Cursor cursor, boolean appendToAfter) {
        J.ClassDeclaration c = parent;
        List<Statement> statements = c.getBody().getStatements();
        for (int i = statements.size() - 1; i >= 0; --i) {
            Statement statement = statements.get(i);
            if (templated.contains(statement)) continue;
            if (statement instanceof J.VariableDeclarations) {
                String stmt = this.variable((J.VariableDeclarations)statement, false, cursor) + ";\n";
                if (appendToAfter) {
                    after.append(stmt);
                    continue;
                }
                before.insert(0, stmt);
                continue;
            }
            if (statement instanceof J.MethodDeclaration) {
                if (BlockStatementTemplateGenerator.referToSameElement(statement, prior)) continue;
                String m = this.method((J.MethodDeclaration)statement, cursor);
                if (appendToAfter) {
                    after.append(m);
                    continue;
                }
                before.insert(0, m);
                continue;
            }
            if (statement instanceof J.ClassDeclaration) {
                if (appendToAfter) {
                    after.append('}');
                } else {
                    before.insert(0, '}');
                }
                this.classDeclaration(null, before, after, (J.ClassDeclaration)statement, templated, cursor, appendToAfter);
                continue;
            }
            if (!(statement instanceof J.EnumValueSet)) continue;
            J.EnumValueSet enumValues = (J.EnumValueSet)statement;
            if (appendToAfter) {
                after.append(";");
            } else {
                before.insert(0, ";");
            }
            StringJoiner enumStr = new StringJoiner(",");
            for (J.EnumValue anEnum : enumValues.getEnums()) {
                enumStr.add(anEnum.getName().getSimpleName());
            }
            if (appendToAfter) {
                after.append(enumStr);
                continue;
            }
            before.insert(0, enumStr);
        }
        c = c.withBody(null).withLeadingAnnotations(null).withPrefix(Space.EMPTY);
        if (appendToAfter) {
            after.append(c.printTrimmed(cursor).trim()).append('{');
        } else {
            before.insert(0, c.printTrimmed(cursor).trim() + '{');
        }
    }

    private String method(J.MethodDeclaration method, Cursor cursor) {
        if (method.isAbstract()) {
            return "\n" + method.withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + ";\n";
        }
        StringBuilder methodBuilder = new StringBuilder("\n");
        J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
        methodBuilder.append(m.printTrimmed(cursor).trim()).append('{');
        if (method.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(method.getReturnTypeExpression().getType())) {
            methodBuilder.append("\nreturn ").append(this.valueOfType(method.getReturnTypeExpression().getType())).append(";\n");
        }
        methodBuilder.append("}\n");
        return methodBuilder.toString();
    }

    private String variable(J.VariableDeclarations variable, boolean initializer, Cursor cursor) {
        StringBuilder varBuilder = new StringBuilder();
        for (J.Modifier modifier : variable.getModifiers()) {
            varBuilder.append(modifier.getType().toString().toLowerCase()).append(' ');
        }
        List<J.VariableDeclarations.NamedVariable> variables = variable.getVariables();
        int variablesSize = variables.size();
        for (int i = 0; i < variablesSize; ++i) {
            J.VariableDeclarations.NamedVariable nv = variables.get(i);
            if (i == 0) {
                if (variable.getTypeExpression() != null) {
                    varBuilder.append(variable.getTypeExpression().withPrefix(Space.EMPTY).printTrimmed(cursor));
                }
                if (nv.getType() instanceof JavaType.Array) {
                    varBuilder.append("[]");
                }
                varBuilder.append(" ");
            }
            varBuilder.append(nv.getSimpleName());
            JavaType type = nv.getType();
            if (initializer && type != null) {
                varBuilder.append('=').append(this.valueOfType(type));
            }
            if (i >= variables.size() - 1) continue;
            varBuilder.append(',');
        }
        return varBuilder.toString();
    }

    private String valueOfType(@Nullable JavaType type) {
        JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return "true";
                }
                case Byte: 
                case Char: 
                case Int: 
                case Double: 
                case Float: 
                case Long: 
                case Short: {
                    return "0";
                }
                case String: 
                case Null: {
                    return "null";
                }
            }
            return "";
        }
        return "null";
    }

    private Cursor next(Cursor c) {
        return c.getParentTreeCursor();
    }

    private static boolean referToSameElement(@Nullable Tree t1, @Nullable Tree t2) {
        return t1 == t2 || t1 != null && t2 != null && t1.getId().equals(t2.getId());
    }

    @Nullable
    private static JavaType.Method findSingleAbstractMethod(@Nullable JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        JavaType.FullyQualified fq = TypeUtils.asFullyQualified(javaType);
        if (fq == null) {
            return null;
        }
        return fq.getMethods().stream().filter(method -> method.hasFlags(Flag.Abstract)).findAny().orElse(null);
    }

    public BlockStatementTemplateGenerator(Set<String> imports) {
        this.imports = imports;
    }

    private static class TemplatedTreeTrimmer {
        private TemplatedTreeTrimmer() {
        }

        @Nullable
        static J trimTree(J j) {
            J trimmed = new TemplatedTreeTrimmerVisitor().visit((Tree)j, 0);
            if (trimmed == null || trimmed.getMarkers().findFirst(RemoveTreeMarker.class).isPresent()) {
                return null;
            }
            return trimmed;
        }

        private static class TemplatedTreeTrimmerVisitor
        extends JavaVisitor<Integer> {
            private TemplatedTreeTrimmerVisitor() {
            }

            private boolean stopCommentExists(@Nullable J j) {
                if (j != null) {
                    for (Comment comment : j.getComments()) {
                        if (!(comment instanceof TextComment) || !((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.STOP_COMMENT)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Nullable
            public J visit(@Nullable Tree tree, Integer integer) {
                Cursor parent;
                J j = (J)super.visit(tree, (Object)integer);
                if (this.stopCommentExists(j) && ((parent = this.getCursor().getParent()) == null || !(parent.getValue() instanceof J.MethodInvocation))) {
                    return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new RemoveTreeMarker(Tree.randomId())));
                }
                return j;
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, integer);
                if (this.stopCommentExists(mi.getName())) {
                    return mi.getSelect();
                }
                return mi;
            }
        }

        private static final class RemoveTreeMarker
        implements Marker {
            private final UUID id;

            public UUID getId() {
                return this.id;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RemoveTreeMarker)) {
                    return false;
                }
                RemoveTreeMarker other = (RemoveTreeMarker)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            public String toString() {
                return "BlockStatementTemplateGenerator.TemplatedTreeTrimmer.RemoveTreeMarker(id=" + this.getId() + ")";
            }

            public RemoveTreeMarker(UUID id) {
                this.id = id;
            }

            @NonNull
            public RemoveTreeMarker withId(UUID id) {
                return this.id == id ? this : new RemoveTreeMarker(id);
            }
        }
    }
}

