/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class AddSerialVersionUidToSerializable
extends Recipe {
    public String getDisplayName() {
        return "Add `serialVersionUID` to a `Serializable` class when missing";
    }

    public String getDescription() {
        return "A `serialVersionUID` field is strongly recommended in all `Serializable` classes. If this is not defined on a `Serializable` class, the compiler will generate this value. If a change is later made to the class, the generated value will change and attempts to deserialize the class will fail.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2057");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), "private static final long serialVersionUID = 1;").build();

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                return method;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                return multiVariable;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J c = super.visitClassDeclaration(classDecl, ctx);
                if (((J.ClassDeclaration)c).getKind() != J.ClassDeclaration.Kind.Type.Class || !this.requiresSerialVersionField(classDecl.getType())) {
                    return c;
                }
                AtomicBoolean needsSerialVersionId = new AtomicBoolean(true);
                J.Block body = ((J.ClassDeclaration)c).getBody();
                c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withStatements(ListUtils.map(((J.ClassDeclaration)c).getBody().getStatements(), s -> {
                    if (!(s instanceof J.VariableDeclarations)) {
                        return s;
                    }
                    J.VariableDeclarations varDecls = (J.VariableDeclarations)s;
                    for (J.VariableDeclarations.NamedVariable v : varDecls.getVariables()) {
                        if (!"serialVersionUID".equals(v.getSimpleName())) continue;
                        needsSerialVersionId.set(false);
                        return this.maybeAutoFormat(varDecls, this.maybeFixVariableDeclarations(varDecls), ctx, new Cursor(this.getCursor(), (Object)body));
                    }
                    return s;
                })));
                if (needsSerialVersionId.get()) {
                    c = (J.ClassDeclaration)c.withTemplate(this.template, ((J.ClassDeclaration)c).getBody().getCoordinates().firstStatement(), new Object[0]);
                }
                return c;
            }

            private J.VariableDeclarations maybeFixVariableDeclarations(J.VariableDeclarations varDecls) {
                List<J.Modifier> modifiers = varDecls.getModifiers();
                if (!(J.Modifier.hasModifier(modifiers, J.Modifier.Type.Private) && J.Modifier.hasModifier(modifiers, J.Modifier.Type.Static) && J.Modifier.hasModifier(modifiers, J.Modifier.Type.Final))) {
                    Space singleSpace = Space.build(" ", Collections.emptyList());
                    varDecls = varDecls.withModifiers(Arrays.asList(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList()), new J.Modifier(Tree.randomId(), singleSpace, Markers.EMPTY, J.Modifier.Type.Static, Collections.emptyList()), new J.Modifier(Tree.randomId(), singleSpace, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList())));
                }
                if (TypeUtils.asPrimitive(varDecls.getType()) != JavaType.Primitive.Long) {
                    varDecls = varDecls.withTypeExpression(new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JavaType.Primitive.Long));
                }
                return varDecls;
            }

            private boolean requiresSerialVersionField(@Nullable JavaType type) {
                if (type == null) {
                    return false;
                }
                if (type instanceof JavaType.Primitive) {
                    return true;
                }
                if (type instanceof JavaType.Array) {
                    return this.requiresSerialVersionField(((JavaType.Array)type).getElemType());
                }
                if (type instanceof JavaType.Parameterized) {
                    JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
                    if (parameterized.isAssignableTo("java.util.Collection") || parameterized.isAssignableTo("java.util.Map")) {
                        boolean typeParametersSerializable = true;
                        for (JavaType typeParameter : parameterized.getTypeParameters()) {
                            typeParametersSerializable = typeParametersSerializable && this.requiresSerialVersionField(typeParameter);
                        }
                        return typeParametersSerializable;
                    }
                } else if (type instanceof JavaType.FullyQualified) {
                    JavaType.FullyQualified fq = (JavaType.FullyQualified)type;
                    if (fq.getKind() == JavaType.FullyQualified.Kind.Enum) {
                        return false;
                    }
                    if (fq.getKind() != JavaType.FullyQualified.Kind.Interface && !fq.isAssignableTo("java.lang.Throwable")) {
                        return fq.isAssignableTo("java.io.Serializable");
                    }
                }
                return false;
            }
        };
    }
}

