/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class UnnecessaryCatch
extends Recipe {
    public String getDisplayName() {
        return "Remove catch for a checked exception if the try block does not throw that exception";
    }

    public String getDescription() {
        return "A refactoring operation may result in a checked exception that is no longer thrown from a `try` block. This recipe will find and remove unnecessary catch blocks.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J b = super.visitBlock(block, ctx);
                return ((J.Block)b).withStatements(ListUtils.flatMap(((J.Block)b).getStatements(), statement -> {
                    J.Try aTry;
                    if (statement instanceof J.Try && (aTry = (J.Try)statement).getCatches().isEmpty() && aTry.getResources() == null && aTry.getFinally() == null) {
                        return ListUtils.map(aTry.getBody().getStatements(), tryStat -> this.autoFormat(tryStat, ctx, this.getCursor()));
                    }
                    return statement;
                }));
            }

            @Override
            public J.Try visitTry(J.Try tryable, ExecutionContext executionContext) {
                J t = super.visitTry(tryable, executionContext);
                final ArrayList thrownExceptions = new ArrayList();
                final AtomicBoolean missingTypeInformation = new AtomicBoolean(false);
                new JavaIsoVisitor<Integer>(){

                    @Override
                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                        JavaType.Method methodType = method.getMethodType();
                        if (methodType == null) {
                            missingTypeInformation.set(true);
                        } else {
                            thrownExceptions.addAll(methodType.getThrownExceptions());
                        }
                        return super.visitMethodInvocation(method, integer);
                    }
                }.visit(((J.Try)t).getBody(), 0);
                if (missingTypeInformation.get()) {
                    return t;
                }
                return ((J.Try)t).withCatches(ListUtils.map(((J.Try)t).getCatches(), (i, aCatch) -> {
                    JavaType parameterType = aCatch.getParameter().getType();
                    if (parameterType == null || TypeUtils.isAssignableTo("java.lang.RuntimeException", parameterType)) {
                        return aCatch;
                    }
                    for (JavaType.FullyQualified e : thrownExceptions) {
                        if (!TypeUtils.isAssignableTo(e, parameterType)) continue;
                        return aCatch;
                    }
                    this.maybeRemoveImport(TypeUtils.asFullyQualified(parameterType));
                    return null;
                }));
            }
        };
    }
}

