/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.BeforeEach;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaParserTestUtil;

interface JavaTreeTest {
    default public ExecutionContext getExecutionContext() {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(t -> Assertions.fail((String)"Failed to parse", (Throwable)t));
        ctx.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)true);
        return ctx;
    }

    @BeforeEach
    default public void beforeEachJavaTreeTest() {
        J.clearCaches();
    }

    default public void assertParsePrintAndProcess(JavaParser parser, NestingLevel nestingLevel, @Language(value="java") String code, String ... imports) {
        String source = Arrays.stream(imports).map(i -> "import " + i + ";").collect(Collectors.joining(""));
        switch (nestingLevel) {
            case Block: {
                source = source + "class A" + System.nanoTime() + "{{" + code + "}}";
                break;
            }
            case Class: {
                source = source + "class A" + System.nanoTime() + "{" + code + "}";
                break;
            }
            case CompilationUnit: {
                source = source + "/*<START>*/" + code;
            }
        }
        J.CompilationUnit cu = parser.parse(this.getExecutionContext(), source).iterator().next();
        J processed = (J)new JavaVisitor().visit(cu, new Object());
        ((ObjectAssert)Assertions.assertThat((Object)processed).as("Processing is idempotent", new Object[0])).isSameAs((Object)cu);
        ((AbstractStringAssert)Assertions.assertThat((String)JavaParserTestUtil.print(nestingLevel, cu)).as("Source code is printed the same after parsing", new Object[0])).isEqualTo(StringUtils.trimIndent((String)code));
    }

    public static enum NestingLevel {
        Block,
        Class,
        CompilationUnit;

    }
}

