/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.21.0")
public class RemoveUnneededBlock
extends Recipe {
    public String getDisplayName() {
        return "Remove unneeded block";
    }

    public String getDescription() {
        return "Flatten blocks into inline statements when possible.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new RemoveUnneededBlockStatementVisitor();
    }

    static class RemoveUnneededBlockStatementVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        RemoveUnneededBlockStatementVisitor() {
        }

        @Override
        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            J bl = super.visitBlock(block, ctx);
            J directParent = (J)this.getCursor().getParentTreeCursor().getValue();
            if (directParent instanceof J.NewClass || directParent instanceof J.ClassDeclaration) {
                return bl;
            }
            if (((J.Block)bl).getStatements().isEmpty()) {
                return bl;
            }
            Statement lastStatement = ((J.Block)bl).getStatements().get(((J.Block)bl).getStatements().size() - 1);
            J.Block flattened = ((J.Block)bl).withStatements(ListUtils.flatMap(((J.Block)bl).getStatements(), (i, stmt) -> {
                if (!(stmt instanceof J.Block) || ((J.Block)stmt).getStatements().stream().anyMatch(s -> s instanceof J.VariableDeclarations)) {
                    return stmt;
                }
                J.Block nested = (J.Block)stmt;
                return ListUtils.map(nested.getStatements(), (j, inlinedStmt) -> {
                    if (j == 0) {
                        inlinedStmt = (Statement)inlinedStmt.withPrefix(inlinedStmt.getPrefix().withComments(ListUtils.concat(nested.getComments(), inlinedStmt.getComments())));
                    }
                    return this.autoFormat(inlinedStmt, ctx, this.getCursor());
                });
            }));
            if (flattened == bl) {
                return bl;
            }
            if (lastStatement instanceof J.Block) {
                flattened = flattened.withEnd(flattened.getEnd().withComments(ListUtils.concat(((J.Block)lastStatement).getEnd().getComments(), flattened.getEnd().getComments())));
            }
            return flattened;
        }
    }
}

