/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindDeprecatedMethods
extends Recipe {
    private static final AnnotationMatcher DEPRECATED_MATCHER = new AnnotationMatcher("java.lang.Deprecated");
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.List add(..)", required=false)
    @Nullable
    private final String methodPattern;
    @Option(displayName="Ignore deprecated scopes", description="When set to `true` deprecated methods used within deprecated methods or classes will be ignored.", required=false)
    @Nullable
    private final Boolean ignoreDeprecatedScopes;

    public String getDisplayName() {
        return "Find uses of deprecated methods";
    }

    public String getInstanceNameSuffix() {
        if (this.methodPattern != null) {
            return "matching `" + this.methodPattern + "`";
        }
        return super.getInstanceNameSuffix();
    }

    public String getDescription() {
        return "Find uses of deprecated methods in any API.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = this.methodPattern == null || this.methodPattern.isEmpty() ? null : new MethodMatcher(this.methodPattern, true);
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    for (JavaType.Method method : cu.getTypesInUse().getUsedMethods()) {
                        if (methodMatcher != null && !methodMatcher.matches(method)) continue;
                        for (JavaType.FullyQualified annotation : method.getAnnotations()) {
                            if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                            return (J)SearchResult.found((Tree)cu);
                        }
                    }
                }
                return (J)tree;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (method.getMethodType() != null) {
                    for (JavaType.FullyQualified annotation : method.getMethodType().getAnnotations()) {
                        if (methodMatcher != null && !methodMatcher.matches(method) || !TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        if (Boolean.TRUE.equals(FindDeprecatedMethods.this.ignoreDeprecatedScopes)) {
                            Iterator cursorPath = this.getCursor().getPathAsCursors();
                            while (cursorPath.hasNext()) {
                                Cursor ancestor = (Cursor)cursorPath.next();
                                if (ancestor.getValue() instanceof J.MethodDeclaration && this.isDeprecated(ancestor)) {
                                    return m;
                                }
                                if (!(ancestor.getValue() instanceof J.ClassDeclaration) || !this.isDeprecated(ancestor)) continue;
                                return m;
                            }
                        }
                        m = (J.MethodInvocation)SearchResult.found((Tree)m);
                    }
                }
                return m;
            }

            private boolean isDeprecated(Cursor cursor) {
                return this.service(AnnotationService.class).matches(cursor, DEPRECATED_MATCHER);
            }
        });
    }

    public FindDeprecatedMethods(@Nullable String methodPattern, @Nullable Boolean ignoreDeprecatedScopes) {
        this.methodPattern = methodPattern;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Nullable
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Nullable
    public Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @NonNull
    public String toString() {
        return "FindDeprecatedMethods(methodPattern=" + this.getMethodPattern() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedMethods)) {
            return false;
        }
        FindDeprecatedMethods other = (FindDeprecatedMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindDeprecatedMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

