/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public final class ReorderMethodArguments
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="com.yourorg.A foo(String, Integer, Integer)")
    private final String methodPattern;
    @Option(displayName="New parameter names", description="An array of parameter names that indicates the new order in which those arguments should be arranged.", example="[foo, bar, baz]")
    private final String[] newParameterNames;
    @Option(displayName="Old parameter names", description="If the original method signature is not type-attributed, this is an optional list that indicates the original order in which the arguments were arranged.", required=false, example="[baz, bar, foo]")
    @Nullable
    private final String[] oldParameterNames;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", required=false)
    @Nullable
    private final Boolean ignoreDefinition;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;

    public String getDisplayName() {
        return "Reorder method arguments";
    }

    public String getDescription() {
        return "Reorder method arguments into the specified order.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    J j;
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    if (Boolean.TRUE.equals(ReorderMethodArguments.this.ignoreDefinition) && cu != (j = (J)new DeclaresMethod(ReorderMethodArguments.this.methodPattern, true).visitNonNull(cu, ctx))) {
                        return cu;
                    }
                    return (J)new UsesMethod(ReorderMethodArguments.this.methodPattern).visitNonNull(cu, ctx);
                }
                return (J)super.visit(tree, (Object)ctx);
            }
        }, (TreeVisitor)new ReorderMethodArgumentsVisitor(new MethodMatcher(this.methodPattern, this.matchOverrides)));
    }

    public ReorderMethodArguments(String methodPattern, String[] newParameterNames, @Nullable String[] oldParameterNames, @Nullable Boolean ignoreDefinition, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.newParameterNames = newParameterNames;
        this.oldParameterNames = oldParameterNames;
        this.ignoreDefinition = ignoreDefinition;
        this.matchOverrides = matchOverrides;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String[] getNewParameterNames() {
        return this.newParameterNames;
    }

    @Nullable
    public String[] getOldParameterNames() {
        return this.oldParameterNames;
    }

    @Nullable
    public Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @Nullable
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    public String toString() {
        return "ReorderMethodArguments(methodPattern=" + this.getMethodPattern() + ", newParameterNames=" + Arrays.deepToString(this.getNewParameterNames()) + ", oldParameterNames=" + Arrays.deepToString(this.getOldParameterNames()) + ", ignoreDefinition=" + this.getIgnoreDefinition() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderMethodArguments)) {
            return false;
        }
        ReorderMethodArguments other = (ReorderMethodArguments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNewParameterNames(), other.getNewParameterNames())) {
            return false;
        }
        return Arrays.deepEquals(this.getOldParameterNames(), other.getOldParameterNames());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReorderMethodArguments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNewParameterNames());
        result = result * 59 + Arrays.deepHashCode(this.getOldParameterNames());
        return result;
    }

    private class ReorderMethodArgumentsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private ReorderMethodArgumentsVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            return (J.MethodInvocation)this.visitMethodCall((MethodCall)super.visitMethodInvocation(method, ctx));
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            return (J.NewClass)this.visitMethodCall((MethodCall)super.visitNewClass(newClass, ctx));
        }

        /*
         * WARNING - void declaration
         */
        private MethodCall visitMethodCall(MethodCall m) {
            if (this.methodMatcher.matches(m) && m.getMethodType() != null) {
                void var13_16;
                List<String> paramNames = ReorderMethodArguments.this.oldParameterNames == null || ReorderMethodArguments.this.oldParameterNames.length == 0 ? m.getMethodType().getParameterNames() : Arrays.asList(ReorderMethodArguments.this.oldParameterNames);
                List<JRightPadded<Expression>> originalArgs = this.getPaddedArguments(m);
                int resolvedParamCount = m.getMethodType().getParameterTypes().size();
                int i = 0;
                ArrayList<JRightPadded<Expression>> reordered = new ArrayList<JRightPadded<Expression>>(originalArgs.size());
                ArrayList<String> reorderedNames = new ArrayList<String>(originalArgs.size());
                ArrayList<JavaType> reorderedTypes = new ArrayList<JavaType>(originalArgs.size());
                ArrayList<Space> formattings = new ArrayList<Space>(originalArgs.size());
                ArrayList<Space> rightFormattings = new ArrayList<Space>(originalArgs.size());
                String[] stringArray = ReorderMethodArguments.this.newParameterNames;
                int n = stringArray.length;
                boolean bl = false;
                while (var13_16 < n) {
                    String name = stringArray[var13_16];
                    int fromPos = paramNames.indexOf(name);
                    if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                        List<JRightPadded<Expression>> varargs = originalArgs.subList(fromPos, originalArgs.size());
                        reordered.addAll(varargs);
                        for (int j = 0; j < varargs.size(); ++j) {
                            reorderedNames.add(name + j);
                            reorderedTypes.add(varargs.get(j).getElement().getType());
                        }
                        for (JRightPadded<Expression> exp : originalArgs.subList(i, i++ + varargs.size())) {
                            formattings.add(exp.getElement().getPrefix());
                            rightFormattings.add(exp.getAfter());
                        }
                    } else if (fromPos >= 0 && originalArgs.size() > fromPos) {
                        JRightPadded<Expression> originalArg = originalArgs.get(fromPos);
                        reordered.add(originalArg);
                        reorderedNames.add(name);
                        reorderedTypes.add(originalArg.getElement().getType());
                        formattings.add(originalArgs.get(i).getElement().getPrefix());
                        rightFormattings.add(originalArgs.get(i++).getAfter());
                    }
                    ++var13_16;
                }
                boolean changed = false;
                i = 0;
                for (JRightPadded jRightPadded : reordered) {
                    int index = i;
                    reordered.set(i, jRightPadded.map(e -> (Expression)e.withPrefix((Space)formattings.get(index))).withAfter((Space)rightFormattings.get(index)));
                    if (reordered.get(i) != originalArgs.get(i)) {
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    JavaType.Method mt = m.getMethodType().withParameterNames(reorderedNames).withParameterTypes(reorderedTypes);
                    if ((m = this.withPaddedArguments(m, reordered).withMethodType(mt)) instanceof J.MethodInvocation && ((J.MethodInvocation)m).getName().getType() != null) {
                        m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withType(mt));
                    }
                }
            }
            return m;
        }

        private List<JRightPadded<Expression>> getPaddedArguments(MethodCall m) {
            if (m instanceof J.MethodInvocation) {
                return ((J.MethodInvocation)m).getPadding().getArguments().getPadding().getElements();
            }
            if (m instanceof J.NewClass) {
                return ((J.NewClass)m).getPadding().getArguments().getPadding().getElements();
            }
            throw new IllegalArgumentException("Unknown MethodCall type");
        }

        private MethodCall withPaddedArguments(MethodCall m, List<JRightPadded<Expression>> reordered) {
            if (m instanceof J.MethodInvocation) {
                J.MethodInvocation mi = (J.MethodInvocation)m;
                return mi.getPadding().withArguments(mi.getPadding().getArguments().getPadding().withElements(reordered));
            }
            if (m instanceof J.NewClass) {
                J.NewClass nc = (J.NewClass)m;
                return nc.getPadding().withArguments(nc.getPadding().getArguments().getPadding().withElements(reordered));
            }
            throw new IllegalArgumentException("Unknown MethodCall type");
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
    }
}

