/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.table.MethodCalls;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public final class FindMethods
extends Recipe {
    private final transient MethodCalls methodCalls = new MethodCalls(this);
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.List add(..)")
    private final String methodPattern;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;

    public String getDisplayName() {
        return "Find method usages";
    }

    public String getDescription() {
        return "Find method calls by pattern.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern, this.matchOverrides), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher methodMatcher;
            {
                this.methodMatcher = new MethodMatcher(FindMethods.this.methodPattern, FindMethods.this.matchOverrides);
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                J i = super.visitIdentifier(identifier, ctx);
                if (((J.Identifier)i).getType() instanceof JavaType.Method && this.methodMatcher.matches((JavaType.Method)((J.Identifier)i).getType()) && !(this.getCursor().getParentTreeCursor().getValue() instanceof J.MethodInvocation)) {
                    JavaType.Method m = (JavaType.Method)((J.Identifier)i).getType();
                    JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                    if (javaSourceFile != null) {
                        FindMethods.this.methodCalls.insertRow(ctx, new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), m.getName(), m.getDeclaringType().getFullyQualifiedName(), m.getName(), m.getParameterTypes().stream().map(String::valueOf).collect(Collectors.joining(", "))));
                    }
                    i = (J.Identifier)SearchResult.found((Tree)i);
                }
                return i;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (this.methodMatcher.matches(method)) {
                    JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                    if (javaSourceFile != null) {
                        FindMethods.this.methodCalls.insertRow(ctx, new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), method.printTrimmed(this.getCursor()), method.getMethodType().getDeclaringType().getFullyQualifiedName(), method.getSimpleName(), method.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                    }
                    m = (J.MethodInvocation)SearchResult.found((Tree)m);
                }
                return m;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J m = super.visitMemberReference(memberRef, ctx);
                if (this.methodMatcher.matches(((J.MemberReference)m).getMethodType())) {
                    JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                    if (javaSourceFile != null) {
                        FindMethods.this.methodCalls.insertRow(ctx, new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), memberRef.printTrimmed(this.getCursor()), memberRef.getMethodType().getDeclaringType().getFullyQualifiedName(), memberRef.getMethodType().getName(), memberRef.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                    }
                    m = ((J.MemberReference)m).withReference((J.Identifier)SearchResult.found((Tree)((J.MemberReference)m).getReference()));
                }
                return m;
            }

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J n = super.visitNewClass(newClass, ctx);
                if (this.methodMatcher.matches(newClass)) {
                    JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                    if (javaSourceFile != null) {
                        FindMethods.this.methodCalls.insertRow(ctx, new MethodCalls.Row(javaSourceFile.getSourcePath().toString(), newClass.printTrimmed(this.getCursor()), newClass.getType().toString(), "<constructor>", newClass.getArguments().stream().map(Expression::getType).map(String::valueOf).collect(Collectors.joining(", "))));
                    }
                    n = (J.NewClass)SearchResult.found((Tree)n);
                }
                return n;
            }
        });
    }

    public static Set<J> find(J j, String methodPattern) {
        return FindMethods.find(j, methodPattern, false);
    }

    public static Set<J> find(J j, String methodPattern, boolean matchOverrides) {
        FindMethods findMethods = new FindMethods(methodPattern, matchOverrides);
        findMethods.methodCalls.setEnabled(false);
        return ((HashSet)TreeVisitor.collect(findMethods.getVisitor(), (Tree)j, new HashSet())).stream().filter(t -> t instanceof J.MethodInvocation || t instanceof J.MemberReference || t instanceof J.NewClass).map(t -> (J)t).collect(Collectors.toSet());
    }

    public static Set<J.MethodDeclaration> findDeclaration(J j, String methodPattern) {
        return FindMethods.findDeclaration(j, methodPattern, false);
    }

    public static Set<J.MethodDeclaration> findDeclaration(J j, final String methodPattern, final boolean matchOverrides) {
        return ((HashSet)TreeVisitor.collect((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher methodMatcher;
            {
                this.methodMatcher = new MethodMatcher(methodPattern, matchOverrides);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (enclosingClass != null && this.methodMatcher.matches(method, (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class))) {
                    return (J.MethodDeclaration)SearchResult.found((Tree)method);
                }
                if (this.methodMatcher.matches(method.getMethodType())) {
                    return (J.MethodDeclaration)SearchResult.found((Tree)method);
                }
                return super.visitMethodDeclaration(method, ctx);
            }
        }, (Tree)j, new HashSet())).stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).collect(Collectors.toSet());
    }

    public FindMethods(String methodPattern, @Nullable Boolean matchOverrides) {
        this.methodPattern = methodPattern;
        this.matchOverrides = matchOverrides;
    }

    public MethodCalls getMethodCalls() {
        return this.methodCalls;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Nullable
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @NonNull
    public String toString() {
        return "FindMethods(methodCalls=" + (Object)((Object)this.getMethodCalls()) + ", methodPattern=" + this.getMethodPattern() + ", matchOverrides=" + this.getMatchOverrides() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMethods)) {
            return false;
        }
        FindMethods other = (FindMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

