/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public class UsesAllMethods<P>
extends JavaIsoVisitor<P> {
    private final List<MethodMatcher> methodMatchers;

    public UsesAllMethods(MethodMatcher ... methodMatchers) {
        this(Arrays.asList(methodMatchers));
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            ArrayList<MethodMatcher> unmatched = new ArrayList<MethodMatcher>(this.methodMatchers);
            for (JavaType.Method type : cu.getTypesInUse().getUsedMethods()) {
                if (!unmatched.removeIf(matcher -> matcher.matches(type)) || !unmatched.isEmpty()) continue;
                return (J)SearchResult.found((Tree)cu);
            }
        }
        return (J)tree;
    }

    @Generated
    public UsesAllMethods(List<MethodMatcher> methodMatchers) {
        this.methodMatchers = methodMatchers;
    }
}

