/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.LoathingOfOthers;
import org.openrewrite.internal.SelfLoathing;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public interface J
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJava((JavaVisitor)v.adapt(JavaVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JavaVisitor.class);
    }

    @Nullable
    default public <P> J acceptJava(JavaVisitor<P> v, P p) {
        return (J)v.defaultValue(this, p);
    }

    public <J2 extends J> J2 withPrefix(Space var1);

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    default public <J2 extends J> J2 withComments(List<Comment> comments) {
        return this.withPrefix(this.getPrefix().withComments(comments));
    }

    @Deprecated
    default public String print() {
        PrintOutputCapture outputCapture = new PrintOutputCapture((Object)0);
        new JavaPrinter().visit(this, outputCapture);
        return outputCapture.getOut();
    }

    @Deprecated
    default public String printTrimmed() {
        return StringUtils.trimIndent((String)this.print());
    }

    public static final class Unknown
    implements J,
    Statement,
    Expression,
    TypeTree,
    TypedTree,
    NameTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Source source;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitUnknown(this, p);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return null;
        }

        public Unknown withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unknown)) {
                return false;
            }
            Unknown other = (Unknown)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Unknown(UUID id, Space prefix, Markers markers, Source source) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.source = source;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Source getSource() {
            return this.source;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Unknown(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", source=" + this.getSource() + ")";
        }

        @NonNull
        @Generated
        public Unknown withId(UUID id) {
            return this.id == id ? this : new Unknown(id, this.prefix, this.markers, this.source);
        }

        @NonNull
        @Generated
        public Unknown withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unknown(this.id, prefix, this.markers, this.source);
        }

        @NonNull
        @Generated
        public Unknown withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unknown(this.id, this.prefix, markers, this.source);
        }

        @NonNull
        @Generated
        public Unknown withSource(Source source) {
            return this.source == source ? this : new Unknown(this.id, this.prefix, this.markers, source);
        }

        public static class Source
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final String text;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitUnknownSource(this, p);
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Source)) {
                    return false;
                }
                Source other = (Source)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Source;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Source(UUID id, Space prefix, Markers markers, String text) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.text = text;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public String getText() {
                return this.text;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.Unknown.Source(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
            }

            @NonNull
            @Generated
            public Source withId(UUID id) {
                return this.id == id ? this : new Source(id, this.prefix, this.markers, this.text);
            }

            @NonNull
            @Generated
            public Source withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Source(this.id, prefix, this.markers, this.text);
            }

            @NonNull
            @Generated
            public Source withMarkers(Markers markers) {
                return this.markers == markers ? this : new Source(this.id, this.prefix, markers, this.text);
            }

            @NonNull
            @Generated
            public Source withText(String text) {
                return this.text == text ? this : new Source(this.id, this.prefix, this.markers, text);
            }
        }
    }

    public static final class Yield
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final boolean implicit;
        private final Expression value;

        @Override
        public CoordinateBuilder.Yield getCoordinates() {
            return new CoordinateBuilder.Yield(this);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitYield(this, p);
        }

        @Generated
        public Yield(UUID id, Space prefix, Markers markers, boolean implicit, Expression value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.implicit = implicit;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public boolean isImplicit() {
            return this.implicit;
        }

        @Generated
        public Expression getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Yield(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", implicit=" + this.isImplicit() + ", value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Yield)) {
                return false;
            }
            Yield other = (Yield)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Yield withId(UUID id) {
            return this.id == id ? this : new Yield(id, this.prefix, this.markers, this.implicit, this.value);
        }

        @NonNull
        @Generated
        public Yield withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Yield(this.id, prefix, this.markers, this.implicit, this.value);
        }

        @NonNull
        @Generated
        public Yield withMarkers(Markers markers) {
            return this.markers == markers ? this : new Yield(this.id, this.prefix, markers, this.implicit, this.value);
        }

        @NonNull
        @Generated
        public Yield withImplicit(boolean implicit) {
            return this.implicit == implicit ? this : new Yield(this.id, this.prefix, this.markers, implicit, this.value);
        }

        @NonNull
        @Generated
        public Yield withValue(Expression value) {
            return this.value == value ? this : new Yield(this.id, this.prefix, this.markers, this.implicit, value);
        }
    }

    public static final class Wildcard
    implements J,
    Expression,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JLeftPadded<Bound> bound;
        @Nullable
        private final NameTree boundedType;

        @Nullable
        public Bound getBound() {
            return this.bound == null ? null : this.bound.getElement();
        }

        public Wildcard withBound(@Nullable Bound bound) {
            return this.getPadding().withBound(JLeftPadded.withElement(this.bound, bound));
        }

        @Override
        public JavaType getType() {
            return null;
        }

        public Wildcard withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wildcard)) {
                return false;
            }
            Wildcard other = (Wildcard)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Wildcard(UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<Bound> bound, @Nullable NameTree boundedType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        @Generated
        private Wildcard(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<Bound> bound, @Nullable NameTree boundedType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        @NonNull
        @Generated
        public Wildcard withId(UUID id) {
            return this.id == id ? this : new Wildcard(this.padding, id, this.prefix, this.markers, this.bound, this.boundedType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Wildcard withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Wildcard(this.padding, this.id, prefix, this.markers, this.bound, this.boundedType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Wildcard withMarkers(Markers markers) {
            return this.markers == markers ? this : new Wildcard(this.padding, this.id, this.prefix, markers, this.bound, this.boundedType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Wildcard withBoundedType(@Nullable NameTree boundedType) {
            return this.boundedType == boundedType ? this : new Wildcard(this.padding, this.id, this.prefix, this.markers, this.bound, boundedType);
        }

        @Nullable
        @Generated
        public NameTree getBoundedType() {
            return this.boundedType;
        }

        public static enum Bound {
            Extends,
            Super;

        }

        public static class Padding {
            private final Wildcard t;

            @Nullable
            public JLeftPadded<Bound> getBound() {
                return this.t.bound;
            }

            public Wildcard withBound(@Nullable JLeftPadded<Bound> bound) {
                return this.t.bound == bound ? this.t : new Wildcard(this.t.id, this.t.prefix, this.t.markers, bound, this.t.boundedType);
            }

            @Generated
            public Padding(Wildcard t) {
                this.t = t;
            }
        }
    }

    public static final class WhileLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> condition;
        private final JRightPadded<Statement> body;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public WhileLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWhileLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.WhileLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhileLoop)) {
                return false;
            }
            WhileLoop other = (WhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public WhileLoop(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        @Generated
        private WhileLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        @NonNull
        @Generated
        public WhileLoop withId(UUID id) {
            return this.id == id ? this : new WhileLoop(this.padding, id, this.prefix, this.markers, this.condition, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public WhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WhileLoop(this.padding, this.id, prefix, this.markers, this.condition, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public WhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhileLoop(this.padding, this.id, this.prefix, markers, this.condition, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public WhileLoop withCondition(ControlParentheses<Expression> condition) {
            return this.condition == condition ? this : new WhileLoop(this.padding, this.id, this.prefix, this.markers, condition, this.body);
        }

        @Generated
        public ControlParentheses<Expression> getCondition() {
            return this.condition;
        }

        public static class Padding {
            private final WhileLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public WhileLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new WhileLoop(this.t.id, this.t.prefix, this.t.markers, this.t.condition, body);
            }

            @Generated
            public Padding(WhileLoop t) {
                this.t = t;
            }
        }
    }

    public static final class VariableDeclarations
    implements J,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> leadingAnnotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeTree typeExpression;
        @Nullable
        private final Space varargs;
        @Deprecated
        private final List<JLeftPadded<Space>> dimensionsBeforeName;
        private final List<JRightPadded<NamedVariable>> variables;

        public List<NamedVariable> getVariables() {
            return JRightPadded.getElements(this.variables);
        }

        public VariableDeclarations withVariables(List<NamedVariable> vars) {
            return this.getPadding().withVariables(JRightPadded.withElements(this.variables, vars));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitVariableDeclarations(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.VariableDeclarations getCoordinates() {
            return new CoordinateBuilder.VariableDeclarations(this);
        }

        @Deprecated
        public List<Annotation> getAllAnnotations() {
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.leadingAnnotations);
            for (Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            if (this.typeExpression != null && this.typeExpression instanceof AnnotatedType) {
                allAnnotations.addAll(((AnnotatedType)this.typeExpression).getAnnotations());
            }
            return allAnnotations;
        }

        @Nullable
        public JavaType.FullyQualified getTypeAsFullyQualified() {
            return this.typeExpression == null ? null : TypeUtils.asFullyQualified(this.typeExpression.getType());
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.typeExpression == null ? null : this.typeExpression.getType();
        }

        public VariableDeclarations withType(@Nullable JavaType type) {
            return this.typeExpression == null ? this : this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableDeclarations)) {
                return false;
            }
            VariableDeclarations other = (VariableDeclarations)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public VariableDeclarations(UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeTree typeExpression, @Nullable Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVariable>> variables) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.variables = variables;
        }

        @Generated
        private VariableDeclarations(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeTree typeExpression, @Nullable Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVariable>> variables) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.variables = variables;
        }

        @NonNull
        @Generated
        public VariableDeclarations withId(UUID id) {
            return this.id == id ? this : new VariableDeclarations(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public VariableDeclarations withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableDeclarations(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public VariableDeclarations withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableDeclarations(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public VariableDeclarations withLeadingAnnotations(List<Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Generated
        public List<Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        @Generated
        public VariableDeclarations withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Generated
        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public VariableDeclarations withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Nullable
        @Generated
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        @Generated
        public VariableDeclarations withVarargs(@Nullable Space varargs) {
            return this.varargs == varargs ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, varargs, this.dimensionsBeforeName, this.variables);
        }

        @Nullable
        @Generated
        public Space getVarargs() {
            return this.varargs;
        }

        @NonNull
        @Deprecated
        @Generated
        public VariableDeclarations withDimensionsBeforeName(List<JLeftPadded<Space>> dimensionsBeforeName) {
            return this.dimensionsBeforeName == dimensionsBeforeName ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, dimensionsBeforeName, this.variables);
        }

        @Deprecated
        @Generated
        public List<JLeftPadded<Space>> getDimensionsBeforeName() {
            return this.dimensionsBeforeName;
        }

        public static class Padding {
            private final VariableDeclarations t;

            public List<JRightPadded<NamedVariable>> getVariables() {
                return this.t.variables;
            }

            public VariableDeclarations withVariables(List<JRightPadded<NamedVariable>> variables) {
                return this.t.variables == variables ? this.t : new VariableDeclarations(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeExpression, this.t.varargs, this.t.dimensionsBeforeName, variables);
            }

            @Generated
            public Padding(VariableDeclarations t) {
                this.t = t;
            }
        }

        public static final class NamedVariable
        implements J,
        NameTree {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Identifier name;
            private final List<JLeftPadded<Space>> dimensionsAfterName;
            @Nullable
            private final JLeftPadded<Expression> initializer;
            @Nullable
            private final JavaType.Variable variableType;

            @Nullable
            public Expression getInitializer() {
                return this.initializer == null ? null : this.initializer.getElement();
            }

            public NamedVariable withInitializer(@Nullable Expression initializer) {
                if (initializer == null) {
                    return this.initializer == null ? this : new NamedVariable(this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, null, this.variableType);
                }
                return this.getPadding().withInitializer(JLeftPadded.withElement(this.initializer, initializer));
            }

            @Override
            public JavaType getType() {
                return this.variableType != null ? this.variableType.getType() : null;
            }

            public NamedVariable withType(@Nullable JavaType type) {
                return this.variableType != null ? this.withVariableType(this.variableType.withType(type)) : this;
            }

            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitVariable(this, p);
            }

            public Cursor getDeclaringScope(Cursor cursor) {
                return cursor.dropParentUntil(it -> it instanceof Block || it instanceof Lambda || it instanceof MethodDeclaration || it == "root");
            }

            public boolean isField(Cursor cursor) {
                Cursor declaringScope = this.getDeclaringScope(cursor);
                return declaringScope.getValue() instanceof Block && declaringScope.getParentTreeCursor().getValue() instanceof ClassDeclaration;
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NamedVariable)) {
                    return false;
                }
                NamedVariable other = (NamedVariable)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public NamedVariable(UUID id, Space prefix, Markers markers, Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable JLeftPadded<Expression> initializer, @Nullable JavaType.Variable variableType) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.variableType = variableType;
            }

            @Generated
            private NamedVariable(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable JLeftPadded<Expression> initializer, @Nullable JavaType.Variable variableType) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.variableType = variableType;
            }

            @NonNull
            @Generated
            public NamedVariable withId(UUID id) {
                return this.id == id ? this : new NamedVariable(this.padding, id, this.prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public NamedVariable withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new NamedVariable(this.padding, this.id, prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public NamedVariable withMarkers(Markers markers) {
                return this.markers == markers ? this : new NamedVariable(this.padding, this.id, this.prefix, markers, this.name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            @Generated
            public NamedVariable withName(Identifier name) {
                return this.name == name ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            @Generated
            public Identifier getName() {
                return this.name;
            }

            @NonNull
            @Generated
            public NamedVariable withDimensionsAfterName(List<JLeftPadded<Space>> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, this.name, dimensionsAfterName, this.initializer, this.variableType);
            }

            @Generated
            public List<JLeftPadded<Space>> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            @NonNull
            @Generated
            public NamedVariable withVariableType(@Nullable JavaType.Variable variableType) {
                return this.variableType == variableType ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, variableType);
            }

            @Nullable
            @Generated
            public JavaType.Variable getVariableType() {
                return this.variableType;
            }

            public static class Padding {
                private final NamedVariable t;

                @Nullable
                public JLeftPadded<Expression> getInitializer() {
                    return this.t.initializer;
                }

                public NamedVariable withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                    return this.t.initializer == initializer ? this.t : new NamedVariable(this.t.id, this.t.prefix, this.t.markers, this.t.name, this.t.dimensionsAfterName, initializer, this.t.variableType);
                }

                @Generated
                public Padding(NamedVariable t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Unary
    implements J,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expression;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Unary withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Unary(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.getOperator().isModifying() ? Collections.singletonList(this) : this.expression.getSideEffects();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        private Unary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @NonNull
        @Generated
        public Unary withId(UUID id) {
            return this.id == id ? this : new Unary(this.padding, id, this.prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, expression, this.type);
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public Unary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, this.expression, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static enum Type {
            PreIncrement,
            PreDecrement,
            PostIncrement,
            PostDecrement,
            Positive,
            Negative,
            Complement,
            Not;


            public boolean isModifying() {
                switch (this) {
                    case PreIncrement: 
                    case PreDecrement: 
                    case PostIncrement: 
                    case PostDecrement: {
                        return true;
                    }
                }
                return false;
            }
        }

        public static class Padding {
            private final Unary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Unary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Unary(this.t.id, this.t.prefix, this.t.markers, operator, this.t.expression, this.t.type);
            }

            @Generated
            public Padding(Unary t) {
                this.t = t;
            }
        }
    }

    public static final class TypeParameters
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<JRightPadded<TypeParameter>> typeParameters;

        public List<TypeParameter> getTypeParameters() {
            return JRightPadded.getElements(this.typeParameters);
        }

        public TypeParameters withTypeParameters(List<TypeParameter> typeParameters) {
            return this.getPadding().withTypeParameters(JRightPadded.withElements(this.typeParameters, typeParameters));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameters)) {
                return false;
            }
            TypeParameters other = (TypeParameters)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeParameters(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<JRightPadded<TypeParameter>> typeParameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeParameters = typeParameters;
        }

        @Generated
        private TypeParameters(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<JRightPadded<TypeParameter>> typeParameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeParameters = typeParameters;
        }

        @NonNull
        @Generated
        public TypeParameters withId(UUID id) {
            return this.id == id ? this : new TypeParameters(this.padding, id, this.prefix, this.markers, this.annotations, this.typeParameters);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public TypeParameters withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeParameters(this.padding, this.id, prefix, this.markers, this.annotations, this.typeParameters);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public TypeParameters withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameters(this.padding, this.id, this.prefix, markers, this.annotations, this.typeParameters);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public TypeParameters withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameters(this.padding, this.id, this.prefix, this.markers, annotations, this.typeParameters);
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public static class Padding {
            private final TypeParameters t;

            public List<JRightPadded<TypeParameter>> getTypeParameters() {
                return this.t.typeParameters;
            }

            public TypeParameters withTypeParameters(List<JRightPadded<TypeParameter>> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new TypeParameters(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, typeParameters);
            }

            @Generated
            public Padding(TypeParameters t) {
                this.t = t;
            }
        }
    }

    public static final class TypeParameter
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        private final Expression name;
        @Nullable
        private final JContainer<TypeTree> bounds;

        @Nullable
        public List<TypeTree> getBounds() {
            return this.bounds == null ? null : this.bounds.getElements();
        }

        public TypeParameter withBounds(@Nullable List<TypeTree> bounds) {
            return this.getPadding().withBounds(JContainer.withElementsNullable(this.bounds, bounds));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeParameter(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.TypeParameter(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", modifiers=" + this.getModifiers() + ", name=" + this.getName() + ", bounds=" + this.getBounds() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameter)) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeParameter(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, Expression name, @Nullable JContainer<TypeTree> bounds) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.name = name;
            this.bounds = bounds;
        }

        @Generated
        private TypeParameter(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<Modifier> modifiers, Expression name, @Nullable JContainer<TypeTree> bounds) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.name = name;
            this.bounds = bounds;
        }

        @NonNull
        @Generated
        public TypeParameter withId(UUID id) {
            return this.id == id ? this : new TypeParameter(this.padding, id, this.prefix, this.markers, this.annotations, this.modifiers, this.name, this.bounds);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public TypeParameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeParameter(this.padding, this.id, prefix, this.markers, this.annotations, this.modifiers, this.name, this.bounds);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public TypeParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameter(this.padding, this.id, this.prefix, markers, this.annotations, this.modifiers, this.name, this.bounds);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public TypeParameter withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, annotations, this.modifiers, this.name, this.bounds);
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        @Generated
        public TypeParameter withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, this.annotations, modifiers, this.name, this.bounds);
        }

        @Generated
        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public TypeParameter withName(Expression name) {
            return this.name == name ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, this.annotations, this.modifiers, name, this.bounds);
        }

        @Generated
        public Expression getName() {
            return this.name;
        }

        public static class Padding {
            private final TypeParameter t;

            @Nullable
            public JContainer<TypeTree> getBounds() {
                return this.t.bounds;
            }

            public TypeParameter withBounds(@Nullable JContainer<TypeTree> bounds) {
                return this.t.bounds == bounds ? this.t : new TypeParameter(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.modifiers, this.t.name, bounds);
            }

            @Generated
            public Padding(TypeParameter t) {
                this.t = t;
            }
        }
    }

    public static final class TypeCast
    implements J,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<TypeTree> clazz;
        private final Expression expression;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public TypeCast withType(@Nullable JavaType type) {
            return this.withClazz((ControlParentheses<TypeTree>)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeCast(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.expression.getSideEffects();
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCast)) {
                return false;
            }
            TypeCast other = (TypeCast)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeCast(UUID id, Space prefix, Markers markers, ControlParentheses<TypeTree> clazz, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public ControlParentheses<TypeTree> getClazz() {
            return this.clazz;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public TypeCast withId(UUID id) {
            return this.id == id ? this : new TypeCast(id, this.prefix, this.markers, this.clazz, this.expression);
        }

        @NonNull
        @Generated
        public TypeCast withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeCast(this.id, prefix, this.markers, this.clazz, this.expression);
        }

        @NonNull
        @Generated
        public TypeCast withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeCast(this.id, this.prefix, markers, this.clazz, this.expression);
        }

        @NonNull
        @Generated
        public TypeCast withClazz(ControlParentheses<TypeTree> clazz) {
            return this.clazz == clazz ? this : new TypeCast(this.id, this.prefix, this.markers, clazz, this.expression);
        }

        @NonNull
        @Generated
        public TypeCast withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeCast(this.id, this.prefix, this.markers, this.clazz, expression);
        }
    }

    public static final class Try
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JContainer<Resource> resources;
        private final Block body;
        private final List<Catch> catches;
        @Nullable
        private final JLeftPadded<Block> finallie;

        @Nullable
        public List<Resource> getResources() {
            return this.resources == null ? null : this.resources.getElements();
        }

        public Try withResources(@Nullable List<Resource> resources) {
            return this.getPadding().withResources(JContainer.withElementsNullable(this.resources, resources));
        }

        @Nullable
        public Block getFinally() {
            return this.finallie == null ? null : this.finallie.getElement();
        }

        public Try withFinally(@Nullable Block finallie) {
            return this.getPadding().withFinally(JLeftPadded.withElement(this.finallie, finallie));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTry(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Try(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", resources=" + this.getResources() + ", body=" + this.getBody() + ", catches=" + this.getCatches() + ", finallie=" + this.finallie + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Try)) {
                return false;
            }
            Try other = (Try)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Try(UUID id, Space prefix, Markers markers, @Nullable JContainer<Resource> resources, Block body, List<Catch> catches, @Nullable JLeftPadded<Block> finallie) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        @Generated
        private Try(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JContainer<Resource> resources, Block body, List<Catch> catches, @Nullable JLeftPadded<Block> finallie) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        @NonNull
        @Generated
        public Try withId(UUID id) {
            return this.id == id ? this : new Try(this.padding, id, this.prefix, this.markers, this.resources, this.body, this.catches, this.finallie);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Try withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Try(this.padding, this.id, prefix, this.markers, this.resources, this.body, this.catches, this.finallie);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Try withMarkers(Markers markers) {
            return this.markers == markers ? this : new Try(this.padding, this.id, this.prefix, markers, this.resources, this.body, this.catches, this.finallie);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Try withBody(Block body) {
            return this.body == body ? this : new Try(this.padding, this.id, this.prefix, this.markers, this.resources, body, this.catches, this.finallie);
        }

        @Generated
        public Block getBody() {
            return this.body;
        }

        @NonNull
        @Generated
        public Try withCatches(List<Catch> catches) {
            return this.catches == catches ? this : new Try(this.padding, this.id, this.prefix, this.markers, this.resources, this.body, catches, this.finallie);
        }

        @Generated
        public List<Catch> getCatches() {
            return this.catches;
        }

        public static class Padding {
            private final Try t;

            @Nullable
            public JContainer<Resource> getResources() {
                return this.t.resources;
            }

            public Try withResources(@Nullable JContainer<Resource> resources) {
                return this.t.resources == resources ? this.t : new Try(this.t.id, this.t.prefix, this.t.markers, resources, this.t.body, this.t.catches, this.t.finallie);
            }

            @Nullable
            public JLeftPadded<Block> getFinally() {
                return this.t.finallie;
            }

            public Try withFinally(@Nullable JLeftPadded<Block> finallie) {
                return this.t.finallie == finallie ? this.t : new Try(this.t.id, this.t.prefix, this.t.markers, this.t.resources, this.t.body, this.t.catches, finallie);
            }

            @Generated
            public Padding(Try t) {
                this.t = t;
            }
        }

        public static final class Catch
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final ControlParentheses<VariableDeclarations> parameter;
            private final Block body;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitCatch(this, p);
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Catch)) {
                    return false;
                }
                Catch other = (Catch)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Catch(UUID id, Space prefix, Markers markers, ControlParentheses<VariableDeclarations> parameter, Block body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parameter = parameter;
                this.body = body;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public ControlParentheses<VariableDeclarations> getParameter() {
                return this.parameter;
            }

            @Generated
            public Block getBody() {
                return this.body;
            }

            @NonNull
            @Generated
            public Catch withId(UUID id) {
                return this.id == id ? this : new Catch(id, this.prefix, this.markers, this.parameter, this.body);
            }

            @NonNull
            @Generated
            public Catch withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Catch(this.id, prefix, this.markers, this.parameter, this.body);
            }

            @NonNull
            @Generated
            public Catch withMarkers(Markers markers) {
                return this.markers == markers ? this : new Catch(this.id, this.prefix, markers, this.parameter, this.body);
            }

            @NonNull
            @Generated
            public Catch withParameter(ControlParentheses<VariableDeclarations> parameter) {
                return this.parameter == parameter ? this : new Catch(this.id, this.prefix, this.markers, parameter, this.body);
            }

            @NonNull
            @Generated
            public Catch withBody(Block body) {
                return this.body == body ? this : new Catch(this.id, this.prefix, this.markers, this.parameter, body);
            }
        }

        public static final class Resource
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final TypedTree variableDeclarations;
            private final boolean terminatedWithSemicolon;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitTryResource(this, p);
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resource)) {
                    return false;
                }
                Resource other = (Resource)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Resource(UUID id, Space prefix, Markers markers, TypedTree variableDeclarations, boolean terminatedWithSemicolon) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variableDeclarations = variableDeclarations;
                this.terminatedWithSemicolon = terminatedWithSemicolon;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public TypedTree getVariableDeclarations() {
                return this.variableDeclarations;
            }

            @Generated
            public boolean isTerminatedWithSemicolon() {
                return this.terminatedWithSemicolon;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.Try.Resource(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variableDeclarations=" + this.getVariableDeclarations() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
            }

            @NonNull
            @Generated
            public Resource withId(UUID id) {
                return this.id == id ? this : new Resource(id, this.prefix, this.markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            @Generated
            public Resource withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Resource(this.id, prefix, this.markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            @Generated
            public Resource withMarkers(Markers markers) {
                return this.markers == markers ? this : new Resource(this.id, this.prefix, markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            @Generated
            public Resource withVariableDeclarations(TypedTree variableDeclarations) {
                return this.variableDeclarations == variableDeclarations ? this : new Resource(this.id, this.prefix, this.markers, variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            @Generated
            public Resource withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
                return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new Resource(this.id, this.prefix, this.markers, this.variableDeclarations, terminatedWithSemicolon);
            }
        }
    }

    public static final class Throw
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression exception;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitThrow(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Throw(UUID id, Space prefix, Markers markers, Expression exception) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exception = exception;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getException() {
            return this.exception;
        }

        @NonNull
        @Generated
        public Throw withId(UUID id) {
            return this.id == id ? this : new Throw(id, this.prefix, this.markers, this.exception);
        }

        @NonNull
        @Generated
        public Throw withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Throw(this.id, prefix, this.markers, this.exception);
        }

        @NonNull
        @Generated
        public Throw withMarkers(Markers markers) {
            return this.markers == markers ? this : new Throw(this.id, this.prefix, markers, this.exception);
        }

        @NonNull
        @Generated
        public Throw withException(Expression exception) {
            return this.exception == exception ? this : new Throw(this.id, this.prefix, this.markers, exception);
        }
    }

    public static final class Ternary
    implements J,
    Expression,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        private final JLeftPadded<Expression> truePart;
        private final JLeftPadded<Expression> falsePart;
        @Nullable
        private final JavaType type;

        public Expression getTruePart() {
            return this.truePart.getElement();
        }

        public Ternary withTruePart(Expression truePart) {
            return this.getPadding().withTruePart(this.truePart.withElement(truePart));
        }

        public Expression getFalsePart() {
            return this.falsePart.getElement();
        }

        public Ternary withFalsePart(Expression falsePart) {
            return this.getPadding().withFalsePart(this.falsePart.withElement(falsePart));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTernary(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ternary)) {
                return false;
            }
            Ternary other = (Ternary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Ternary(UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        @Generated
        private Ternary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        @NonNull
        @Generated
        public Ternary withId(UUID id) {
            return this.id == id ? this : new Ternary(this.padding, id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Ternary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Ternary(this.padding, this.id, prefix, this.markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Ternary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ternary(this.padding, this.id, this.prefix, markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Ternary withCondition(Expression condition) {
            return this.condition == condition ? this : new Ternary(this.padding, this.id, this.prefix, this.markers, condition, this.truePart, this.falsePart, this.type);
        }

        @Generated
        public Expression getCondition() {
            return this.condition;
        }

        @NonNull
        @Generated
        public Ternary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Ternary(this.padding, this.id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Ternary t;

            public JLeftPadded<Expression> getTruePart() {
                return this.t.truePart;
            }

            public Ternary withTruePart(JLeftPadded<Expression> truePart) {
                return this.t.truePart == truePart ? this.t : new Ternary(this.t.id, this.t.prefix, this.t.markers, this.t.condition, truePart, this.t.falsePart, this.t.type);
            }

            public JLeftPadded<Expression> getFalsePart() {
                return this.t.falsePart;
            }

            public Ternary withFalsePart(JLeftPadded<Expression> falsePart) {
                return this.t.falsePart == falsePart ? this.t : new Ternary(this.t.id, this.t.prefix, this.t.markers, this.t.condition, this.t.truePart, falsePart, this.t.type);
            }

            @Generated
            public Padding(Ternary t) {
                this.t = t;
            }
        }
    }

    public static final class Synchronized
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> lock;
        private final Block body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSynchronized(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synchronized)) {
                return false;
            }
            Synchronized other = (Synchronized)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Synchronized(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> lock, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lock = lock;
            this.body = body;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public ControlParentheses<Expression> getLock() {
            return this.lock;
        }

        @Generated
        public Block getBody() {
            return this.body;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Synchronized(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lock=" + this.getLock() + ", body=" + this.getBody() + ")";
        }

        @NonNull
        @Generated
        public Synchronized withId(UUID id) {
            return this.id == id ? this : new Synchronized(id, this.prefix, this.markers, this.lock, this.body);
        }

        @NonNull
        @Generated
        public Synchronized withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Synchronized(this.id, prefix, this.markers, this.lock, this.body);
        }

        @NonNull
        @Generated
        public Synchronized withMarkers(Markers markers) {
            return this.markers == markers ? this : new Synchronized(this.id, this.prefix, markers, this.lock, this.body);
        }

        @NonNull
        @Generated
        public Synchronized withLock(ControlParentheses<Expression> lock) {
            return this.lock == lock ? this : new Synchronized(this.id, this.prefix, this.markers, lock, this.body);
        }

        @NonNull
        @Generated
        public Synchronized withBody(Block body) {
            return this.body == body ? this : new Synchronized(this.id, this.prefix, this.markers, this.lock, body);
        }
    }

    public static final class SwitchExpression
    implements J,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> selector;
        private final Block cases;

        @Override
        @Transient
        @Nullable
        public JavaType getType() {
            return (JavaType)((AtomicReference)new JavaVisitor<AtomicReference<JavaType>>(){

                @Override
                public J visitBlock(Block block, AtomicReference<JavaType> javaType) {
                    if (!block.getStatements().isEmpty()) {
                        Case caze = (Case)block.getStatements().get(0);
                        javaType.set(caze.getExpressions().get(0).getType());
                    }
                    return block;
                }
            }.reduce(this, new AtomicReference())).get();
        }

        @Override
        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSwitchExpression(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwitchExpression)) {
                return false;
            }
            SwitchExpression other = (SwitchExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public SwitchExpression(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> selector, Block cases) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.cases = cases;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        @Generated
        public Block getCases() {
            return this.cases;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.SwitchExpression(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ")";
        }

        @NonNull
        @Generated
        public SwitchExpression withId(UUID id) {
            return this.id == id ? this : new SwitchExpression(id, this.prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        @Generated
        public SwitchExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SwitchExpression(this.id, prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        @Generated
        public SwitchExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new SwitchExpression(this.id, this.prefix, markers, this.selector, this.cases);
        }

        @NonNull
        @Generated
        public SwitchExpression withSelector(ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new SwitchExpression(this.id, this.prefix, this.markers, selector, this.cases);
        }

        @NonNull
        @Generated
        public SwitchExpression withCases(Block cases) {
            return this.cases == cases ? this : new SwitchExpression(this.id, this.prefix, this.markers, this.selector, cases);
        }
    }

    public static final class Switch
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> selector;
        private final Block cases;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSwitch(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch other = (Switch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Switch(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> selector, Block cases) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.cases = cases;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        @Generated
        public Block getCases() {
            return this.cases;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Switch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ")";
        }

        @NonNull
        @Generated
        public Switch withId(UUID id) {
            return this.id == id ? this : new Switch(id, this.prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        @Generated
        public Switch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Switch(this.id, prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        @Generated
        public Switch withMarkers(Markers markers) {
            return this.markers == markers ? this : new Switch(this.id, this.prefix, markers, this.selector, this.cases);
        }

        @NonNull
        @Generated
        public Switch withSelector(ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new Switch(this.id, this.prefix, this.markers, selector, this.cases);
        }

        @NonNull
        @Generated
        public Switch withCases(Block cases) {
            return this.cases == cases ? this : new Switch(this.id, this.prefix, this.markers, this.selector, cases);
        }
    }

    public static final class Return
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Expression expression;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitReturn(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Return(UUID id, Space prefix, Markers markers, @Nullable Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public Return withId(UUID id) {
            return this.id == id ? this : new Return(id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public Return withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Return(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        @Generated
        public Return withExpression(@Nullable Expression expression) {
            return this.expression == expression ? this : new Return(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class Primitive
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JavaType.Primitive type;

        public Primitive withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (!(type instanceof JavaType.Primitive)) {
                throw new IllegalArgumentException("Cannot apply a non-primitive type to Primitive");
            }
            return new Primitive(this.id, this.prefix, this.markers, (JavaType.Primitive)type);
        }

        @Override
        @NonNull
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Primitive(UUID id, Space prefix, Markers markers, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        @NonNull
        @Generated
        public Primitive withId(UUID id) {
            return this.id == id ? this : new Primitive(id, this.prefix, this.markers, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Primitive withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Primitive(this.id, prefix, this.markers, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Primitive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Primitive(this.id, this.prefix, markers, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ControlParentheses<J2 extends J>
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        public J2 getTree() {
            return (J2)((J)this.tree.getElement());
        }

        public ControlParentheses<J2> withTree(J2 tree) {
            return this.getPadding().withTree(this.tree.withElement(tree));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitControlParentheses(this, p);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.tree.getElement() instanceof Expression ? ((Expression)this.tree.getElement()).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            J element = (J)this.tree.getElement();
            if (element instanceof Expression) {
                return ((Expression)element).getType();
            }
            if (element instanceof NameTree) {
                return ((NameTree)element).getType();
            }
            if (element instanceof VariableDeclarations) {
                return ((VariableDeclarations)element).getType();
            }
            return null;
        }

        public ControlParentheses<J2> withType(@Nullable JavaType type) {
            return this.tree.getElement() instanceof Expression ? this.withTree(((Expression)this.tree.getElement()).withType(type)) : (this.tree.getElement() instanceof NameTree ? this.withTree(((NameTree)this.tree.getElement()).withType(type)) : this);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlParentheses)) {
                return false;
            }
            ControlParentheses other = (ControlParentheses)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ControlParentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        @Generated
        private ControlParentheses(@Nullable WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        @NonNull
        @Generated
        public ControlParentheses<J2> withId(UUID id) {
            return this.id == id ? this : new ControlParentheses<J2>(this.padding, id, this.prefix, this.markers, this.tree);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ControlParentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ControlParentheses<J2>(this.padding, this.id, prefix, this.markers, this.tree);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ControlParentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new ControlParentheses<J2>(this.padding, this.id, this.prefix, markers, this.tree);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends J> {
            private final ControlParentheses<J2> t;

            public JRightPadded<J2> getTree() {
                return ((ControlParentheses)this.t).tree;
            }

            public ControlParentheses<J2> withTree(JRightPadded<J2> tree) {
                return ((ControlParentheses)this.t).tree == tree ? this.t : new ControlParentheses<J2>(((ControlParentheses)this.t).id, ((ControlParentheses)this.t).prefix, ((ControlParentheses)this.t).markers, tree);
            }

            @Generated
            public Padding(ControlParentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static class Parentheses<J2 extends J>
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        public J2 getTree() {
            return (J2)((J)this.tree.getElement());
        }

        public Parentheses<J2> withTree(J2 tree) {
            return this.getPadding().withTree(this.tree.withElement(tree));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParentheses(this, p);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.tree.getElement() instanceof Expression ? ((Expression)this.tree.getElement()).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree.getElement() instanceof Expression ? ((Expression)this.tree.getElement()).getType() : (this.tree.getElement() instanceof NameTree ? ((NameTree)this.tree.getElement()).getType() : null);
        }

        public Parentheses<J2> withType(@Nullable JavaType type) {
            return this.tree.getElement() instanceof Expression ? this.withTree(((Expression)this.tree.getElement()).withType(type)) : (this.tree.getElement() instanceof NameTree ? this.withTree(((NameTree)this.tree.getElement()).withType(type)) : this);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parentheses;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Parentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        @Generated
        private Parentheses(@Nullable WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        @NonNull
        @Generated
        public Parentheses<J2> withId(UUID id) {
            return this.id == id ? this : new Parentheses<J2>(this.padding, id, this.prefix, this.markers, this.tree);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Parentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parentheses<J2>(this.padding, this.id, prefix, this.markers, this.tree);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Parentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses<J2>(this.padding, this.id, this.prefix, markers, this.tree);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends J> {
            private final Parentheses<J2> t;

            public JRightPadded<J2> getTree() {
                return ((Parentheses)this.t).tree;
            }

            public Parentheses<J2> withTree(JRightPadded<J2> tree) {
                return ((Parentheses)this.t).tree == tree ? this.t : new Parentheses<J2>(((Parentheses)this.t).id, ((Parentheses)this.t).prefix, ((Parentheses)this.t).markers, tree);
            }

            @Generated
            public Padding(Parentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static final class ParameterizedType
    implements J,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree clazz;
        @Nullable
        private final JContainer<Expression> typeParameters;
        @Nullable
        private final JavaType type;

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public ParameterizedType withTypeParameters(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParameterizedType(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ParameterizedType(UUID id, Space prefix, Markers markers, NameTree clazz, @Nullable JContainer<Expression> typeParameters, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
            this.type = type;
        }

        @Generated
        private ParameterizedType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, NameTree clazz, @Nullable JContainer<Expression> typeParameters, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
            this.type = type;
        }

        @NonNull
        @Generated
        public ParameterizedType withId(UUID id) {
            return this.id == id ? this : new ParameterizedType(this.padding, id, this.prefix, this.markers, this.clazz, this.typeParameters, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ParameterizedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ParameterizedType(this.padding, this.id, prefix, this.markers, this.clazz, this.typeParameters, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ParameterizedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ParameterizedType(this.padding, this.id, this.prefix, markers, this.clazz, this.typeParameters, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ParameterizedType withClazz(NameTree clazz) {
            return this.clazz == clazz ? this : new ParameterizedType(this.padding, this.id, this.prefix, this.markers, clazz, this.typeParameters, this.type);
        }

        @Generated
        public NameTree getClazz() {
            return this.clazz;
        }

        @NonNull
        @Generated
        public ParameterizedType withType(@Nullable JavaType type) {
            return this.type == type ? this : new ParameterizedType(this.padding, this.id, this.prefix, this.markers, this.clazz, this.typeParameters, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ParameterizedType t;

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public ParameterizedType withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new ParameterizedType(this.t.id, this.t.prefix, this.t.markers, this.t.clazz, typeParameters, this.t.type);
            }

            @Generated
            public Padding(ParameterizedType t) {
                this.t = t;
            }
        }
    }

    public static final class Package
    implements Statement,
    J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final List<Annotation> annotations;

        public String getPackageName() {
            return this.expression.withPrefix(Space.EMPTY).print(new Cursor(null, (Object)new CompilationUnit(null, null, Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null, null, false, null, null, null, null, Space.EMPTY)));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Package getCoordinates() {
            return new CoordinateBuilder.Package(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Package(UUID id, Space prefix, Markers markers, Expression expression, List<Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.annotations = annotations;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Package(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ", annotations=" + this.getAnnotations() + ")";
        }

        @NonNull
        @Generated
        public Package withId(UUID id) {
            return this.id == id ? this : new Package(id, this.prefix, this.markers, this.expression, this.annotations);
        }

        @NonNull
        @Generated
        public Package withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Package(this.id, prefix, this.markers, this.expression, this.annotations);
        }

        @NonNull
        @Generated
        public Package withMarkers(Markers markers) {
            return this.markers == markers ? this : new Package(this.id, this.prefix, markers, this.expression, this.annotations);
        }

        @NonNull
        @Generated
        public Package withExpression(Expression expression) {
            return this.expression == expression ? this : new Package(this.id, this.prefix, this.markers, expression, this.annotations);
        }

        @NonNull
        @Generated
        public Package withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new Package(this.id, this.prefix, this.markers, this.expression, annotations);
        }
    }

    @Incubating(since="8.12.0")
    public static class NullableType
    implements J,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final JRightPadded<TypeTree> typeTree;

        public TypeTree getTypeTree() {
            return this.typeTree.getElement();
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.typeTree.getElement().getType();
        }

        public NullableType withType(@Nullable JavaType type) {
            JRightPadded<TypeTree> rp = this.getPadding().getTypeTree();
            TypeTree tt = rp.getElement();
            tt = (TypeTree)tt.withType(type);
            return this.getPadding().withTypeTree(rp.withElement(tt));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNullableType(this, p);
        }

        @Override
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NullableType)) {
                return false;
            }
            NullableType other = (NullableType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof NullableType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public NullableType(UUID id, Space prefix, Markers markers, List<Annotation> annotations, JRightPadded<TypeTree> typeTree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeTree = typeTree;
        }

        @Generated
        private NullableType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, JRightPadded<TypeTree> typeTree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeTree = typeTree;
        }

        @NonNull
        @Generated
        public NullableType withPadding(@Nullable WeakReference<Padding> padding) {
            return this.padding == padding ? this : new NullableType(padding, this.id, this.prefix, this.markers, this.annotations, this.typeTree);
        }

        @NonNull
        @Generated
        public NullableType withId(UUID id) {
            return this.id == id ? this : new NullableType(this.padding, id, this.prefix, this.markers, this.annotations, this.typeTree);
        }

        @NonNull
        @Generated
        public NullableType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NullableType(this.padding, this.id, prefix, this.markers, this.annotations, this.typeTree);
        }

        @NonNull
        @Generated
        public NullableType withMarkers(Markers markers) {
            return this.markers == markers ? this : new NullableType(this.padding, this.id, this.prefix, markers, this.annotations, this.typeTree);
        }

        @NonNull
        @Generated
        public NullableType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new NullableType(this.padding, this.id, this.prefix, this.markers, annotations, this.typeTree);
        }

        @NonNull
        @Generated
        public NullableType withTypeTree(JRightPadded<TypeTree> typeTree) {
            return this.typeTree == typeTree ? this : new NullableType(this.padding, this.id, this.prefix, this.markers, this.annotations, typeTree);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public static class Padding {
            private final NullableType t;

            public JRightPadded<TypeTree> getTypeTree() {
                return this.t.typeTree;
            }

            public NullableType withTypeTree(JRightPadded<TypeTree> typeTree) {
                return this.t.typeTree == typeTree ? this.t : new NullableType(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, typeTree);
            }

            @Generated
            public Padding(NullableType t) {
                this.t = t;
            }
        }
    }

    public static final class NewClass
    implements J,
    Statement,
    Expression,
    TypedTree,
    MethodCall {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> enclosing;
        private final Space nooh;
        @Nullable
        private final TypeTree clazz;
        private final JContainer<Expression> arguments;
        @Nullable
        private final Block body;
        @Nullable
        private final JavaType.Method constructorType;

        @Nullable
        public Expression getEnclosing() {
            return this.enclosing == null ? null : this.enclosing.getElement();
        }

        public NewClass withEnclosing(Expression enclosing) {
            return this.getPadding().withEnclosing(JRightPadded.withElement(this.enclosing, enclosing));
        }

        public Space getNew() {
            return this.nooh;
        }

        public NewClass withNew(Space nooh) {
            if (nooh == this.nooh) {
                return this;
            }
            return new NewClass(this.id, this.prefix, this.markers, this.enclosing, nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        @Override
        public List<Expression> getArguments() {
            return this.arguments.getElements();
        }

        @Override
        public NewClass withArguments(List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElements(this.arguments, arguments));
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.constructorType == null ? null : this.constructorType.getReturnType();
        }

        @Override
        @Nullable
        public JavaType.Method getMethodType() {
            return this.getConstructorType();
        }

        @Override
        public NewClass withMethodType(@Nullable JavaType.Method methodType) {
            return this.withConstructorType(methodType);
        }

        @Override
        public NewClass withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this new class, use withConstructorType(..)");
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewClass(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewClass)) {
                return false;
            }
            NewClass other = (NewClass)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public NewClass(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> enclosing, Space nooh, @Nullable TypeTree clazz, JContainer<Expression> arguments, @Nullable Block body, @Nullable JavaType.Method constructorType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enclosing = enclosing;
            this.nooh = nooh;
            this.clazz = clazz;
            this.arguments = arguments;
            this.body = body;
            this.constructorType = constructorType;
        }

        @Generated
        private NewClass(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> enclosing, Space nooh, @Nullable TypeTree clazz, JContainer<Expression> arguments, @Nullable Block body, @Nullable JavaType.Method constructorType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enclosing = enclosing;
            this.nooh = nooh;
            this.clazz = clazz;
            this.arguments = arguments;
            this.body = body;
            this.constructorType = constructorType;
        }

        @NonNull
        @Generated
        public NewClass withId(UUID id) {
            return this.id == id ? this : new NewClass(this.padding, id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public NewClass withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewClass(this.padding, this.id, prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public NewClass withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewClass(this.padding, this.id, this.prefix, markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public NewClass withClazz(@Nullable TypeTree clazz) {
            return this.clazz == clazz ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, clazz, this.arguments, this.body, this.constructorType);
        }

        @Nullable
        @Generated
        public TypeTree getClazz() {
            return this.clazz;
        }

        @NonNull
        @Generated
        public NewClass withBody(@Nullable Block body) {
            return this.body == body ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, body, this.constructorType);
        }

        @Nullable
        @Generated
        public Block getBody() {
            return this.body;
        }

        @NonNull
        @Generated
        public NewClass withConstructorType(@Nullable JavaType.Method constructorType) {
            return this.constructorType == constructorType ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, constructorType);
        }

        @Nullable
        @Generated
        public JavaType.Method getConstructorType() {
            return this.constructorType;
        }

        public static class Padding {
            private final NewClass t;

            @Nullable
            public JRightPadded<Expression> getEnclosing() {
                return this.t.enclosing;
            }

            public NewClass withEnclosing(@Nullable JRightPadded<Expression> enclosing) {
                return this.t.enclosing == enclosing ? this.t : new NewClass(this.t.id, this.t.prefix, this.t.markers, enclosing, this.t.nooh, this.t.clazz, this.t.arguments, this.t.body, this.t.constructorType);
            }

            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public NewClass withArguments(JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new NewClass(this.t.id, this.t.prefix, this.t.markers, this.t.enclosing, this.t.nooh, this.t.clazz, arguments, this.t.body, this.t.constructorType);
            }

            @Generated
            public Padding(NewClass t) {
                this.t = t;
            }
        }
    }

    public static final class ArrayDimension
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> index;

        public Expression getIndex() {
            return this.index.getElement();
        }

        public ArrayDimension withIndex(Expression index) {
            return this.getPadding().withIndex(this.index.withElement(index));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayDimension(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayDimension)) {
                return false;
            }
            ArrayDimension other = (ArrayDimension)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ArrayDimension(UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        @Generated
        private ArrayDimension(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        @NonNull
        @Generated
        public ArrayDimension withId(UUID id) {
            return this.id == id ? this : new ArrayDimension(this.padding, id, this.prefix, this.markers, this.index);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ArrayDimension withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayDimension(this.padding, this.id, prefix, this.markers, this.index);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ArrayDimension withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayDimension(this.padding, this.id, this.prefix, markers, this.index);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final ArrayDimension t;

            public JRightPadded<Expression> getIndex() {
                return this.t.index;
            }

            public ArrayDimension withIndex(JRightPadded<Expression> index) {
                return this.t.index == index ? this.t : new ArrayDimension(this.t.id, this.t.prefix, this.t.markers, index);
            }

            @Generated
            public Padding(ArrayDimension t) {
                this.t = t;
            }
        }
    }

    public static final class NewArray
    implements J,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final TypeTree typeExpression;
        private final List<ArrayDimension> dimensions;
        @Nullable
        private final JContainer<Expression> initializer;
        @Nullable
        private final JavaType type;

        @Nullable
        public List<Expression> getInitializer() {
            return this.initializer == null ? null : this.initializer.getElements();
        }

        public NewArray withInitializer(List<Expression> initializer) {
            return this.getPadding().withInitializer(JContainer.withElementsNullable(this.initializer, initializer));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewArray(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.NewArray(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", typeExpression=" + this.getTypeExpression() + ", dimensions=" + this.getDimensions() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewArray)) {
                return false;
            }
            NewArray other = (NewArray)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public NewArray(UUID id, Space prefix, Markers markers, @Nullable TypeTree typeExpression, List<ArrayDimension> dimensions, @Nullable JContainer<Expression> initializer, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        @Generated
        private NewArray(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable TypeTree typeExpression, List<ArrayDimension> dimensions, @Nullable JContainer<Expression> initializer, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        @NonNull
        @Generated
        public NewArray withId(UUID id) {
            return this.id == id ? this : new NewArray(this.padding, id, this.prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public NewArray withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewArray(this.padding, this.id, prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public NewArray withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewArray(this.padding, this.id, this.prefix, markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public NewArray withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Nullable
        @Generated
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        @Generated
        public NewArray withDimensions(List<ArrayDimension> dimensions) {
            return this.dimensions == dimensions ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, this.typeExpression, dimensions, this.initializer, this.type);
        }

        @Generated
        public List<ArrayDimension> getDimensions() {
            return this.dimensions;
        }

        @NonNull
        @Generated
        public NewArray withType(@Nullable JavaType type) {
            return this.type == type ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NewArray t;

            @Nullable
            public JContainer<Expression> getInitializer() {
                return this.t.initializer;
            }

            public NewArray withInitializer(@Nullable JContainer<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new NewArray(this.t.id, this.t.prefix, this.t.markers, this.t.typeExpression, this.t.dimensions, initializer, this.t.type);
            }

            @Generated
            public Padding(NewArray t) {
                this.t = t;
            }
        }
    }

    public static final class MultiCatch
    implements J,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<NameTree>> alternatives;

        public List<NameTree> getAlternatives() {
            return JRightPadded.getElements(this.alternatives);
        }

        public MultiCatch withAlternatives(List<NameTree> alternatives) {
            return this.getPadding().withAlternatives(JRightPadded.withElements(this.alternatives, alternatives));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMultiCatch(this, p);
        }

        public MultiCatch withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public JavaType getType() {
            return new JavaType.MultiCatch(this.alternatives.stream().filter(Objects::nonNull).map(alt -> ((NameTree)alt.getElement()).getType()).collect(Collectors.toList()));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MultiCatch(UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        @Generated
        private MultiCatch(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        @NonNull
        @Generated
        public MultiCatch withId(UUID id) {
            return this.id == id ? this : new MultiCatch(this.padding, id, this.prefix, this.markers, this.alternatives);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MultiCatch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MultiCatch(this.padding, this.id, prefix, this.markers, this.alternatives);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MultiCatch withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiCatch(this.padding, this.id, this.prefix, markers, this.alternatives);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final MultiCatch t;

            public List<JRightPadded<NameTree>> getAlternatives() {
                return this.t.alternatives;
            }

            public MultiCatch withAlternatives(List<JRightPadded<NameTree>> alternatives) {
                return this.t.alternatives == alternatives ? this.t : new MultiCatch(this.t.id, this.t.prefix, this.t.markers, alternatives);
            }

            @Generated
            public Padding(MultiCatch t) {
                this.t = t;
            }
        }
    }

    public static final class Modifier
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String keyword;
        private final Type type;
        private final List<Annotation> annotations;

        public static boolean hasModifier(Collection<Modifier> modifiers, Type modifier) {
            for (Modifier m : modifiers) {
                if (m.getType() != modifier) continue;
                return true;
            }
            return false;
        }

        @Deprecated
        public Modifier(UUID id, Space prefix, Markers markers, Type type, List<Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.keyword = null;
            this.type = type;
            this.annotations = annotations;
        }

        public String toString() {
            return this.type.toString().toLowerCase();
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @Generated
        public Modifier(UUID id, Space prefix, Markers markers, @Nullable String keyword, Type type, List<Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.keyword = keyword;
            this.type = type;
            this.annotations = annotations;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        @Generated
        public String getKeyword() {
            return this.keyword;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public Modifier withId(UUID id) {
            return this.id == id ? this : new Modifier(id, this.prefix, this.markers, this.keyword, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Modifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Modifier(this.id, prefix, this.markers, this.keyword, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Modifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Modifier(this.id, this.prefix, markers, this.keyword, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Modifier withKeyword(@Nullable String keyword) {
            return this.keyword == keyword ? this : new Modifier(this.id, this.prefix, this.markers, keyword, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Modifier withType(Type type) {
            return this.type == type ? this : new Modifier(this.id, this.prefix, this.markers, this.keyword, type, this.annotations);
        }

        @NonNull
        @Generated
        public Modifier withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new Modifier(this.id, this.prefix, this.markers, this.keyword, this.type, annotations);
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public static enum Type {
            Default,
            Public,
            Protected,
            Private,
            Abstract,
            Static,
            Final,
            Sealed,
            NonSealed,
            Transient,
            Volatile,
            Synchronized,
            Native,
            Strictfp,
            Async,
            Reified,
            Inline,
            LanguageExtension;

        }
    }

    public static final class MethodInvocation
    implements J,
    Statement,
    Expression,
    TypedTree,
    MethodCall {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> select;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final Identifier name;
        private final JContainer<Expression> arguments;
        @Nullable
        private final JavaType.Method methodType;

        @Nullable
        public Expression getSelect() {
            return this.select == null ? null : this.select.getElement();
        }

        public MethodInvocation withSelect(@Nullable Expression select) {
            return this.getPadding().withSelect(JRightPadded.withElement(this.select, select));
        }

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public MethodInvocation withName(Identifier name) {
            if (this.name == name) {
                return this;
            }
            JavaType.Method newType = null;
            if (this.methodType != null) {
                newType = name.getType() instanceof JavaType.Method && name.getType() != this.methodType ? (JavaType.Method)name.getType() : (this.methodType.getName().equals(name.getSimpleName()) ? this.methodType : this.methodType.withName(name.getSimpleName()));
            }
            return new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, name.withType(newType), this.arguments, newType);
        }

        @Override
        public List<Expression> getArguments() {
            return this.arguments.getElements();
        }

        @Override
        public MethodInvocation withArguments(List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElements(this.arguments, arguments));
        }

        @Override
        public MethodInvocation withMethodType(@Nullable JavaType.Method type) {
            if (type == this.methodType) {
                return this;
            }
            return new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, type);
        }

        @Override
        public MethodInvocation withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this method invocation, use withMethodType(..)");
        }

        public MethodInvocation withDeclaringType(JavaType.FullyQualified type) {
            if (this.methodType == null) {
                return this;
            }
            return this.withMethodType(this.methodType.withDeclaringType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodInvocation(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.MethodInvocation getCoordinates() {
            return new CoordinateBuilder.MethodInvocation(this);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.methodType == null ? null : this.methodType.getReturnType();
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInvocation)) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MethodInvocation(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> select, @Nullable JContainer<Expression> typeParameters, Identifier name, JContainer<Expression> arguments, @Nullable JavaType.Method methodType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.arguments = arguments;
            this.methodType = methodType;
        }

        @Generated
        private MethodInvocation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> select, @Nullable JContainer<Expression> typeParameters, Identifier name, JContainer<Expression> arguments, @Nullable JavaType.Method methodType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.arguments = arguments;
            this.methodType = methodType;
        }

        @NonNull
        @Generated
        public MethodInvocation withId(UUID id) {
            return this.id == id ? this : new MethodInvocation(this.padding, id, this.prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, this.methodType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MethodInvocation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodInvocation(this.padding, this.id, prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, this.methodType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MethodInvocation withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodInvocation(this.padding, this.id, this.prefix, markers, this.select, this.typeParameters, this.name, this.arguments, this.methodType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public MethodInvocation withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodInvocation(this.padding, this.id, this.prefix, this.markers, this.select, typeParameters, this.name, this.arguments, this.methodType);
        }

        @Generated
        public Identifier getName() {
            return this.name;
        }

        @Override
        @Nullable
        @Generated
        public JavaType.Method getMethodType() {
            return this.methodType;
        }

        public static class Padding {
            private final MethodInvocation t;

            @Nullable
            public JRightPadded<Expression> getSelect() {
                return this.t.select;
            }

            public MethodInvocation withSelect(@Nullable JRightPadded<Expression> select) {
                return this.t.select == select ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, select, this.t.typeParameters, this.t.name, this.t.arguments, this.t.methodType);
            }

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodInvocation withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.select, typeParameters, this.t.name, this.t.arguments, this.t.methodType);
            }

            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public MethodInvocation withArguments(JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.select, this.t.typeParameters, this.t.name, arguments, this.t.methodType);
            }

            @Generated
            public Padding(MethodInvocation t) {
                this.t = t;
            }
        }
    }

    public static final class MethodDeclaration
    implements J,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        @Nullable
        private transient WeakReference<Annotations> annotations;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> leadingAnnotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeParameters typeParameters;
        @Nullable
        private final TypeTree returnTypeExpression;
        private final IdentifierWithAnnotations name;
        private final JContainer<Statement> parameters;
        @Nullable
        private final JContainer<NameTree> throwz;
        @Nullable
        private final Block body;
        @Nullable
        private final JLeftPadded<Expression> defaultValue;
        @Nullable
        private final JavaType.Method methodType;

        @Nullable
        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getTypeParameters();
        }

        public MethodDeclaration withTypeParameters(@Nullable List<TypeParameter> typeParameters) {
            Annotations annotations = this.getAnnotations();
            if (typeParameters == null) {
                if (annotations.getTypeParameters() == null) {
                    return this;
                }
                return annotations.withTypeParameters(null);
            }
            TypeParameters currentTypeParameters = annotations.getTypeParameters();
            if (currentTypeParameters == null) {
                return annotations.withTypeParameters(new TypeParameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, typeParameters.stream().map(JRightPadded::build).collect(Collectors.toList())));
            }
            return annotations.withTypeParameters(currentTypeParameters.withTypeParameters(typeParameters));
        }

        public Identifier getName() {
            return this.name.getIdentifier();
        }

        public MethodDeclaration withName(Identifier name) {
            return this.getAnnotations().withName(this.name.withIdentifier(name));
        }

        public List<Statement> getParameters() {
            return this.parameters.getElements();
        }

        public MethodDeclaration withParameters(List<Statement> parameters) {
            return this.getPadding().withParameters(JContainer.withElements(this.parameters, parameters));
        }

        @Nullable
        public List<NameTree> getThrows() {
            return this.throwz == null ? null : this.throwz.getElements();
        }

        public MethodDeclaration withThrows(@Nullable List<NameTree> throwz) {
            return this.getPadding().withThrows(JContainer.withElementsNullable(this.throwz, throwz));
        }

        @Nullable
        public Expression getDefaultValue() {
            return this.defaultValue == null ? null : this.defaultValue.getElement();
        }

        public MethodDeclaration withDefaultValue(@Nullable Expression defaultValue) {
            return this.getPadding().withDefaultValue(JLeftPadded.withElement(this.defaultValue, defaultValue));
        }

        public MethodDeclaration withMethodType(@Nullable JavaType.Method type) {
            if (type == this.methodType) {
                return this;
            }
            return new MethodDeclaration(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, type);
        }

        @Override
        public JavaType getType() {
            return this.methodType == null ? null : this.methodType.getReturnType();
        }

        public MethodDeclaration withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this method declaration, use withMethodType(..)");
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodDeclaration(this, p);
        }

        public boolean isAbstract() {
            return this.body == null;
        }

        public boolean isConstructor() {
            return this.getReturnTypeExpression() == null;
        }

        public String getSimpleName() {
            return this.name.getIdentifier().getSimpleName();
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        @Override
        @Transient
        public CoordinateBuilder.MethodDeclaration getCoordinates() {
            return new CoordinateBuilder.MethodDeclaration(this);
        }

        @Deprecated
        public List<Annotation> getAllAnnotations() {
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.leadingAnnotations);
            for (Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            if (this.typeParameters != null) {
                allAnnotations.addAll(this.typeParameters.getAnnotations());
            }
            if (this.returnTypeExpression instanceof AnnotatedType) {
                allAnnotations.addAll(((AnnotatedType)this.returnTypeExpression).getAnnotations());
            }
            allAnnotations.addAll(this.name.getAnnotations());
            return allAnnotations;
        }

        public String toString() {
            return "MethodDeclaration{" + (this.getMethodType() == null ? "unknown" : this.getMethodType()) + "}";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public Annotations getAnnotations() {
            Annotations a;
            if (this.annotations == null) {
                a = new Annotations(this);
                this.annotations = new WeakReference<Annotations>(a);
            } else {
                a = (Annotations)this.annotations.get();
                if (a == null || a.t != this) {
                    a = new Annotations(this);
                    this.annotations = new WeakReference<Annotations>(a);
                }
            }
            return a;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDeclaration)) {
                return false;
            }
            MethodDeclaration other = (MethodDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MethodDeclaration(UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeParameters typeParameters, @Nullable TypeTree returnTypeExpression, IdentifierWithAnnotations name, JContainer<Statement> parameters, @Nullable JContainer<NameTree> throwz, @Nullable Block body, @Nullable JLeftPadded<Expression> defaultValue, @Nullable JavaType.Method methodType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.methodType = methodType;
        }

        @Generated
        private MethodDeclaration(@Nullable WeakReference<Padding> padding, @Nullable WeakReference<Annotations> annotations, UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeParameters typeParameters, @Nullable TypeTree returnTypeExpression, IdentifierWithAnnotations name, JContainer<Statement> parameters, @Nullable JContainer<NameTree> throwz, @Nullable Block body, @Nullable JLeftPadded<Expression> defaultValue, @Nullable JavaType.Method methodType) {
            this.padding = padding;
            this.annotations = annotations;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.methodType = methodType;
        }

        @NonNull
        @Generated
        public MethodDeclaration withId(UUID id) {
            return this.id == id ? this : new MethodDeclaration(this.padding, this.annotations, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MethodDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodDeclaration(this.padding, this.annotations, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MethodDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public MethodDeclaration withLeadingAnnotations(List<Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Generated
        public List<Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        @Generated
        public MethodDeclaration withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Generated
        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public MethodDeclaration withReturnTypeExpression(@Nullable TypeTree returnTypeExpression) {
            return this.returnTypeExpression == returnTypeExpression ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Nullable
        @Generated
        public TypeTree getReturnTypeExpression() {
            return this.returnTypeExpression;
        }

        @NonNull
        @Generated
        public MethodDeclaration withBody(@Nullable Block body) {
            return this.body == body ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, body, this.defaultValue, this.methodType);
        }

        @Nullable
        @Generated
        public Block getBody() {
            return this.body;
        }

        @Nullable
        @Generated
        public JavaType.Method getMethodType() {
            return this.methodType;
        }

        public static final class IdentifierWithAnnotations {
            private final Identifier identifier;
            private final List<Annotation> annotations;

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof IdentifierWithAnnotations;
            }

            @Generated
            public int hashCode() {
                boolean result = true;
                return 1;
            }

            @Generated
            public IdentifierWithAnnotations(Identifier identifier, List<Annotation> annotations) {
                this.identifier = identifier;
                this.annotations = annotations;
            }

            @Generated
            public Identifier getIdentifier() {
                return this.identifier;
            }

            @Generated
            public List<Annotation> getAnnotations() {
                return this.annotations;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.MethodDeclaration.IdentifierWithAnnotations(identifier=" + this.getIdentifier() + ", annotations=" + this.getAnnotations() + ")";
            }

            @NonNull
            @Generated
            public IdentifierWithAnnotations withIdentifier(Identifier identifier) {
                return this.identifier == identifier ? this : new IdentifierWithAnnotations(identifier, this.annotations);
            }

            @NonNull
            @Generated
            public IdentifierWithAnnotations withAnnotations(List<Annotation> annotations) {
                return this.annotations == annotations ? this : new IdentifierWithAnnotations(this.identifier, annotations);
            }
        }

        public static class Annotations {
            private final MethodDeclaration t;

            @Nullable
            public TypeParameters getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodDeclaration withTypeParameters(@Nullable TypeParameters typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            public IdentifierWithAnnotations getName() {
                return this.t.name;
            }

            public MethodDeclaration withName(IdentifierWithAnnotations name) {
                return this.t.name == name ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            @Generated
            public Annotations(MethodDeclaration t) {
                this.t = t;
            }
        }

        public static class Padding {
            private final MethodDeclaration t;

            public JContainer<Statement> getParameters() {
                return this.t.parameters;
            }

            public MethodDeclaration withParameters(JContainer<Statement> parameters) {
                return this.t.parameters == parameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            @Nullable
            public JContainer<NameTree> getThrows() {
                return this.t.throwz;
            }

            public MethodDeclaration withThrows(@Nullable JContainer<NameTree> throwz) {
                return this.t.throwz == throwz ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            @Nullable
            public JLeftPadded<Expression> getDefaultValue() {
                return this.t.defaultValue;
            }

            public MethodDeclaration withDefaultValue(@Nullable JLeftPadded<Expression> defaultValue) {
                return this.t.defaultValue == defaultValue ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, defaultValue, this.t.methodType);
            }

            @Nullable
            public TypeParameters getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodDeclaration withTypeParameters(@Nullable TypeParameters typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            @Generated
            public Padding(MethodDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class MemberReference
    implements J,
    Expression,
    TypedTree,
    MethodCall {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> containing;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final JLeftPadded<Identifier> reference;
        @Nullable
        private final JavaType type;
        @Nullable
        private final JavaType.Method methodType;
        @Nullable
        private final JavaType.Variable variableType;

        public Expression getContaining() {
            return this.containing.getElement();
        }

        public MemberReference withContaining(Expression containing) {
            return this.getPadding().withContaining(JRightPadded.withElement(this.containing, containing));
        }

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public MemberReference withTypeParameters(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Override
        public List<Expression> getArguments() {
            return Collections.emptyList();
        }

        @Override
        public MemberReference withArguments(List<Expression> arguments) {
            return this;
        }

        public Identifier getReference() {
            return this.reference.getElement();
        }

        public MemberReference withReference(Identifier reference) {
            return this.getPadding().withReference(this.reference.withElement(reference));
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMemberReference(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberReference)) {
                return false;
            }
            MemberReference other = (MemberReference)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MemberReference(UUID id, Space prefix, Markers markers, JRightPadded<Expression> containing, @Nullable JContainer<Expression> typeParameters, JLeftPadded<Identifier> reference, @Nullable JavaType type, @Nullable JavaType.Method methodType, @Nullable JavaType.Variable variableType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.methodType = methodType;
            this.variableType = variableType;
        }

        @Generated
        private MemberReference(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> containing, @Nullable JContainer<Expression> typeParameters, JLeftPadded<Identifier> reference, @Nullable JavaType type, @Nullable JavaType.Method methodType, @Nullable JavaType.Variable variableType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.methodType = methodType;
            this.variableType = variableType;
        }

        @NonNull
        @Generated
        public MemberReference withId(UUID id) {
            return this.id == id ? this : new MemberReference(this.padding, id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, this.variableType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MemberReference withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MemberReference(this.padding, this.id, prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, this.variableType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MemberReference withMarkers(Markers markers) {
            return this.markers == markers ? this : new MemberReference(this.padding, this.id, this.prefix, markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, this.variableType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        @NonNull
        @Generated
        public MemberReference withType(@Nullable JavaType type) {
            return this.type == type ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, type, this.methodType, this.variableType);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Override
        @NonNull
        @Generated
        public MemberReference withMethodType(@Nullable JavaType.Method methodType) {
            return this.methodType == methodType ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, methodType, this.variableType);
        }

        @Override
        @Nullable
        @Generated
        public JavaType.Method getMethodType() {
            return this.methodType;
        }

        @NonNull
        @Generated
        public MemberReference withVariableType(@Nullable JavaType.Variable variableType) {
            return this.variableType == variableType ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, variableType);
        }

        @Nullable
        @Generated
        public JavaType.Variable getVariableType() {
            return this.variableType;
        }

        public static class Padding {
            private final MemberReference t;

            public JRightPadded<Expression> getContaining() {
                return this.t.containing;
            }

            public MemberReference withContaining(JRightPadded<Expression> containing) {
                return this.t.containing == containing ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, containing, this.t.typeParameters, this.t.reference, this.t.type, this.t.methodType, this.t.variableType);
            }

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MemberReference withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, this.t.containing, typeParameters, this.t.reference, this.t.type, this.t.methodType, this.t.variableType);
            }

            public JLeftPadded<Identifier> getReference() {
                return this.t.reference;
            }

            public MemberReference withReference(JLeftPadded<Identifier> reference) {
                return this.t.reference == reference ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, this.t.containing, this.t.typeParameters, reference, this.t.type, this.t.methodType, this.t.variableType);
            }

            @Generated
            public Padding(MemberReference t) {
                this.t = t;
            }
        }
    }

    public static final class Literal
    implements J,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Object value;
        @Nullable
        private final String valueSource;
        @Nullable
        private final List<UnicodeEscape> unicodeEscapes;
        private final JavaType.Primitive type;

        public Literal withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type instanceof JavaType.Primitive) {
                return new Literal(this.id, this.prefix, this.markers, this.value, this.valueSource, this.unicodeEscapes, (JavaType.Primitive)type);
            }
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Incubating(since="7.25.0")
        public static boolean isLiteralValue(@Nullable Expression maybeLiteral, Object value) {
            if (maybeLiteral instanceof Literal) {
                Literal literal = (Literal)maybeLiteral;
                return literal.getValue() != null && literal.getValue().equals(value);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Literal(UUID id, Space prefix, Markers markers, @Nullable Object value, @Nullable String valueSource, @Nullable List<UnicodeEscape> unicodeEscapes, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
            this.unicodeEscapes = unicodeEscapes;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        @Generated
        public Object getValue() {
            return this.value;
        }

        @Nullable
        @Generated
        public String getValueSource() {
            return this.valueSource;
        }

        @Nullable
        @Generated
        public List<UnicodeEscape> getUnicodeEscapes() {
            return this.unicodeEscapes;
        }

        @Override
        @Generated
        public JavaType.Primitive getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.prefix, this.markers, this.value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        @Generated
        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        @Generated
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        @Generated
        public Literal withValue(@Nullable Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        @Generated
        public Literal withValueSource(@Nullable String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.prefix, this.markers, this.value, valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        @Generated
        public Literal withUnicodeEscapes(@Nullable List<UnicodeEscape> unicodeEscapes) {
            return this.unicodeEscapes == unicodeEscapes ? this : new Literal(this.id, this.prefix, this.markers, this.value, this.valueSource, unicodeEscapes, this.type);
        }

        public static final class UnicodeEscape {
            private final int valueSourceIndex;
            private final String codePoint;

            @Generated
            public UnicodeEscape(int valueSourceIndex, String codePoint) {
                this.valueSourceIndex = valueSourceIndex;
                this.codePoint = codePoint;
            }

            @Generated
            public int getValueSourceIndex() {
                return this.valueSourceIndex;
            }

            @Generated
            public String getCodePoint() {
                return this.codePoint;
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UnicodeEscape)) {
                    return false;
                }
                UnicodeEscape other = (UnicodeEscape)o;
                if (this.getValueSourceIndex() != other.getValueSourceIndex()) {
                    return false;
                }
                String this$codePoint = this.getCodePoint();
                String other$codePoint = other.getCodePoint();
                return !(this$codePoint == null ? other$codePoint != null : !this$codePoint.equals(other$codePoint));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getValueSourceIndex();
                String $codePoint = this.getCodePoint();
                result = result * 59 + ($codePoint == null ? 43 : $codePoint.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.Literal.UnicodeEscape(valueSourceIndex=" + this.getValueSourceIndex() + ", codePoint=" + this.getCodePoint() + ")";
            }

            @NonNull
            @Generated
            public UnicodeEscape withValueSourceIndex(int valueSourceIndex) {
                return this.valueSourceIndex == valueSourceIndex ? this : new UnicodeEscape(valueSourceIndex, this.codePoint);
            }

            @NonNull
            @Generated
            public UnicodeEscape withCodePoint(String codePoint) {
                return this.codePoint == codePoint ? this : new UnicodeEscape(this.valueSourceIndex, codePoint);
            }
        }
    }

    public static final class Lambda
    implements J,
    Statement,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Parameters parameters;
        private final Space arrow;
        private final J body;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLambda(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lambda)) {
                return false;
            }
            Lambda other = (Lambda)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Lambda(UUID id, Space prefix, Markers markers, Parameters parameters, Space arrow, J body, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Parameters getParameters() {
            return this.parameters;
        }

        @Generated
        public Space getArrow() {
            return this.arrow;
        }

        @Generated
        public J getBody() {
            return this.body;
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Lambda(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parameters=" + this.getParameters() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Lambda withId(UUID id) {
            return this.id == id ? this : new Lambda(id, this.prefix, this.markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        @Generated
        public Lambda withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Lambda(this.id, prefix, this.markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        @Generated
        public Lambda withMarkers(Markers markers) {
            return this.markers == markers ? this : new Lambda(this.id, this.prefix, markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        @Generated
        public Lambda withParameters(Parameters parameters) {
            return this.parameters == parameters ? this : new Lambda(this.id, this.prefix, this.markers, parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        @Generated
        public Lambda withArrow(Space arrow) {
            return this.arrow == arrow ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, arrow, this.body, this.type);
        }

        @NonNull
        @Generated
        public Lambda withBody(J body) {
            return this.body == body ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, body, this.type);
        }

        @NonNull
        @Generated
        public Lambda withType(@Nullable JavaType type) {
            return this.type == type ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, this.body, type);
        }

        public static final class Parameters
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final boolean parenthesized;
            private final List<JRightPadded<J>> parameters;

            public List<J> getParameters() {
                return JRightPadded.getElements(this.parameters);
            }

            public Parameters withParameters(List<J> parameters) {
                return this.getPadding().withParameters(JRightPadded.withElements(this.parameters, parameters));
            }

            @Transient
            public CoordinateBuilder.Lambda.Parameters getCoordinates() {
                return new CoordinateBuilder.Lambda.Parameters(this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.Lambda.Parameters(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parenthesized=" + this.isParenthesized() + ", parameters=" + this.getParameters() + ")";
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Parameters(UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> parameters) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.parameters = parameters;
            }

            @Generated
            private Parameters(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> parameters) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.parameters = parameters;
            }

            @NonNull
            @Generated
            public Parameters withId(UUID id) {
                return this.id == id ? this : new Parameters(this.padding, id, this.prefix, this.markers, this.parenthesized, this.parameters);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public Parameters withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Parameters(this.padding, this.id, prefix, this.markers, this.parenthesized, this.parameters);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public Parameters withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameters(this.padding, this.id, this.prefix, markers, this.parenthesized, this.parameters);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            @Generated
            public Parameters withParenthesized(boolean parenthesized) {
                return this.parenthesized == parenthesized ? this : new Parameters(this.padding, this.id, this.prefix, this.markers, parenthesized, this.parameters);
            }

            @Generated
            public boolean isParenthesized() {
                return this.parenthesized;
            }

            public static class Padding {
                private final Parameters t;

                public List<JRightPadded<J>> getParameters() {
                    return this.t.parameters;
                }

                public Parameters withParameters(List<JRightPadded<J>> parameters) {
                    return this.t.parameters == parameters ? this.t : new Parameters(this.t.id, this.t.prefix, this.t.markers, this.t.parenthesized, parameters);
                }

                @Deprecated
                public List<JRightPadded<J>> getParams() {
                    return this.t.parameters;
                }

                @Deprecated
                public Parameters withParams(List<JRightPadded<J>> parameters) {
                    return this.t.parameters == parameters ? this.t : new Parameters(this.t.id, this.t.prefix, this.t.markers, this.t.parenthesized, parameters);
                }

                @Generated
                public Padding(Parameters t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Label
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Identifier> label;
        private final Statement statement;

        public Identifier getLabel() {
            return this.label.getElement();
        }

        public Label withLabel(Identifier label) {
            return this.getPadding().withLabel(this.label.withElement(label));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLabel(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Label)) {
                return false;
            }
            Label other = (Label)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Label(UUID id, Space prefix, Markers markers, JRightPadded<Identifier> label, Statement statement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        @Generated
        private Label(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Identifier> label, Statement statement) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        @NonNull
        @Generated
        public Label withId(UUID id) {
            return this.id == id ? this : new Label(this.padding, id, this.prefix, this.markers, this.label, this.statement);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Label withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Label(this.padding, this.id, prefix, this.markers, this.label, this.statement);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Label withMarkers(Markers markers) {
            return this.markers == markers ? this : new Label(this.padding, this.id, this.prefix, markers, this.label, this.statement);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Label withStatement(Statement statement) {
            return this.statement == statement ? this : new Label(this.padding, this.id, this.prefix, this.markers, this.label, statement);
        }

        @Generated
        public Statement getStatement() {
            return this.statement;
        }

        public static class Padding {
            private final Label t;

            public JRightPadded<Identifier> getLabel() {
                return this.t.label;
            }

            public Label withLabel(JRightPadded<Identifier> label) {
                return this.t.label == label ? this.t : new Label(this.t.id, this.t.prefix, this.t.markers, label, this.t.statement);
            }

            @Generated
            public Padding(Label t) {
                this.t = t;
            }
        }
    }

    public static final class IntersectionType
    implements J,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<TypeTree> bounds;

        public List<TypeTree> getBounds() {
            return this.bounds.getElements();
        }

        public IntersectionType withBounds(List<TypeTree> bounds) {
            return this.getPadding().withBounds(JContainer.withElementsNullable(this.bounds, bounds));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIntersectionType(this, p);
        }

        public IntersectionType withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public JavaType getType() {
            return new JavaType.Intersection(this.bounds.getPadding().getElements().stream().filter(Objects::nonNull).map(b -> ((TypeTree)b.getElement()).getType()).collect(Collectors.toList()));
        }

        @Override
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntersectionType)) {
                return false;
            }
            IntersectionType other = (IntersectionType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public IntersectionType(UUID id, Space prefix, Markers markers, JContainer<TypeTree> bounds) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bounds = bounds;
        }

        @Generated
        private IntersectionType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<TypeTree> bounds) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bounds = bounds;
        }

        @NonNull
        @Generated
        public IntersectionType withId(UUID id) {
            return this.id == id ? this : new IntersectionType(this.padding, id, this.prefix, this.markers, this.bounds);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public IntersectionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new IntersectionType(this.padding, this.id, prefix, this.markers, this.bounds);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public IntersectionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new IntersectionType(this.padding, this.id, this.prefix, markers, this.bounds);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final IntersectionType t;

            @Nullable
            public JContainer<TypeTree> getBounds() {
                return this.t.bounds;
            }

            public IntersectionType withBounds(@Nullable JContainer<TypeTree> bounds) {
                return this.t.bounds == bounds ? this.t : new IntersectionType(this.t.id, this.t.prefix, this.t.markers, bounds);
            }

            @Generated
            public Padding(IntersectionType t) {
                this.t = t;
            }
        }
    }

    public static final class InstanceOf
    implements J,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> expression;
        private final J clazz;
        @Nullable
        private final J pattern;
        @Nullable
        private final JavaType type;

        public Expression getExpression() {
            return this.expression.getElement();
        }

        public InstanceOf withExpression(Expression expression) {
            return this.getPadding().withExpression(this.expression.withElement(expression));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitInstanceOf(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.expression.getElement().getSideEffects();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            InstanceOf other = (InstanceOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public InstanceOf(UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, J clazz, @Nullable J pattern, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.clazz = clazz;
            this.pattern = pattern;
            this.type = type;
        }

        @Generated
        private InstanceOf(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, J clazz, @Nullable J pattern, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.clazz = clazz;
            this.pattern = pattern;
            this.type = type;
        }

        @NonNull
        @Generated
        public InstanceOf withId(UUID id) {
            return this.id == id ? this : new InstanceOf(this.padding, id, this.prefix, this.markers, this.expression, this.clazz, this.pattern, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public InstanceOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new InstanceOf(this.padding, this.id, prefix, this.markers, this.expression, this.clazz, this.pattern, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public InstanceOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new InstanceOf(this.padding, this.id, this.prefix, markers, this.expression, this.clazz, this.pattern, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public InstanceOf withClazz(J clazz) {
            return this.clazz == clazz ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, clazz, this.pattern, this.type);
        }

        @Generated
        public J getClazz() {
            return this.clazz;
        }

        @NonNull
        @Generated
        public InstanceOf withPattern(@Nullable J pattern) {
            return this.pattern == pattern ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, this.clazz, pattern, this.type);
        }

        @Nullable
        @Generated
        public J getPattern() {
            return this.pattern;
        }

        @NonNull
        @Generated
        public InstanceOf withType(@Nullable JavaType type) {
            return this.type == type ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, this.clazz, this.pattern, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final InstanceOf t;

            public JRightPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public InstanceOf withExpression(JRightPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new InstanceOf(this.t.id, this.t.prefix, this.t.markers, expression, this.t.clazz, this.t.pattern, this.t.type);
            }

            @Deprecated
            public JRightPadded<Expression> getExpr() {
                return this.t.expression;
            }

            @Deprecated
            public InstanceOf withExpr(JRightPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new InstanceOf(this.t.id, this.t.prefix, this.t.markers, expression, this.t.clazz, this.t.pattern, this.t.type);
            }

            @Generated
            public Padding(InstanceOf t) {
                this.t = t;
            }
        }
    }

    public static final class Import
    implements Statement,
    Comparable<Import> {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> statik;
        private final FieldAccess qualid;
        @Nullable
        private final JLeftPadded<Identifier> alias;

        public boolean isStatic() {
            return this.statik.getElement();
        }

        public Import withStatic(boolean statik) {
            return this.getPadding().withStatic(this.statik.withElement(statik));
        }

        @Nullable
        public Identifier getAlias() {
            if (this.alias == null) {
                return null;
            }
            return this.alias.getElement();
        }

        public Import withAlias(@Nullable Identifier alias) {
            if (this.alias == null) {
                if (alias == null) {
                    return this;
                }
                return new Import(null, this.id, this.prefix, this.markers, this.statik, this.qualid, JLeftPadded.build(alias).withBefore(Space.format(" ")));
            }
            if (alias == null) {
                return new Import(null, this.id, this.prefix, this.markers, this.statik, this.qualid, null);
            }
            return this.getPadding().withAlias(this.alias.withElement(alias));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitImport(this, p);
        }

        public String getTypeName() {
            if (this.isStatic()) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified(this.qualid.getType());
                Expression target = this.qualid.getTarget();
                if (fq == null) {
                    String possibleInnerClassFqn = this.getTypeName(this.qualid);
                    String possibleInnerClassName = possibleInnerClassFqn.substring(possibleInnerClassFqn.lastIndexOf(36) + 1);
                    if ("*".equals(possibleInnerClassName)) {
                        return possibleInnerClassFqn.substring(0, possibleInnerClassFqn.lastIndexOf(36));
                    }
                    while (possibleInnerClassName.indexOf(36) >= 0) {
                        possibleInnerClassName = possibleInnerClassName.substring(possibleInnerClassName.indexOf(36) + 1);
                    }
                    JavaType.Class owner = TypeUtils.asClass(target.getType());
                    if (owner != null && !(target.getType() instanceof JavaType.ShallowClass)) {
                        Iterator<JavaType.Method> visibleMethods = owner.getVisibleMethods();
                        while (visibleMethods.hasNext()) {
                            JavaType.Method method = visibleMethods.next();
                            if (!method.getName().equals(possibleInnerClassName)) continue;
                            return possibleInnerClassFqn.substring(0, possibleInnerClassFqn.lastIndexOf(36));
                        }
                        Iterator<JavaType.Variable> visibleMembers = owner.getVisibleMembers();
                        while (visibleMembers.hasNext()) {
                            JavaType.Variable member = visibleMembers.next();
                            if (!member.getName().equals(possibleInnerClassName)) continue;
                            return possibleInnerClassFqn.substring(0, possibleInnerClassFqn.lastIndexOf(36));
                        }
                        return possibleInnerClassFqn;
                    }
                }
                return target instanceof Identifier ? ((Identifier)target).getSimpleName() : this.getTypeName((FieldAccess)target);
            }
            return this.getTypeName(this.qualid);
        }

        private String getTypeName(FieldAccess type) {
            StringBuilder typeName = new StringBuilder();
            FieldAccess part = type;
            while (true) {
                String name = part.getSimpleName();
                if (part.getTarget() instanceof Identifier) {
                    typeName.insert(0, ((Identifier)part.getTarget()).getSimpleName() + "." + name);
                    break;
                }
                if (!(part.getTarget() instanceof FieldAccess)) break;
                String delim = Character.isUpperCase((part = (FieldAccess)part.getTarget()).getSimpleName().charAt(0)) ? "$" : ".";
                typeName.insert(0, delim + name);
            }
            return typeName.toString();
        }

        public String getPackageName() {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified(this.qualid.getType());
            if (fq != null) {
                return fq.getPackageName();
            }
            String typeName = this.getTypeName();
            int lastDot = typeName.lastIndexOf(46);
            return lastDot < 0 ? "" : typeName.substring(0, lastDot);
        }

        public String getClassName() {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified(this.qualid.getType());
            if (fq != null) {
                return fq.getClassName();
            }
            String typeName = this.getTypeName();
            int lastDot = typeName.lastIndexOf(46);
            return lastDot < 0 ? typeName : typeName.substring(lastDot + 1);
        }

        @Override
        public int compareTo(Import o) {
            String p1 = this.getPackageName();
            String p2 = o.getPackageName();
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : this.getQualid().getSimpleName().compareTo(o.getQualid().getSimpleName());
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Import(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> statik, FieldAccess qualid, @Nullable JLeftPadded<Identifier> alias) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
            this.alias = alias;
        }

        @Generated
        private Import(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> statik, FieldAccess qualid, @Nullable JLeftPadded<Identifier> alias) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
            this.alias = alias;
        }

        @NonNull
        @Generated
        public Import withId(UUID id) {
            return this.id == id ? this : new Import(this.padding, id, this.prefix, this.markers, this.statik, this.qualid, this.alias);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Import withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Import(this.padding, this.id, prefix, this.markers, this.statik, this.qualid, this.alias);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.padding, this.id, this.prefix, markers, this.statik, this.qualid, this.alias);
        }

        @NonNull
        @Generated
        public Import withQualid(FieldAccess qualid) {
            return this.qualid == qualid ? this : new Import(this.padding, this.id, this.prefix, this.markers, this.statik, qualid, this.alias);
        }

        @Generated
        public FieldAccess getQualid() {
            return this.qualid;
        }

        public static class Padding {
            private final Import t;

            public JLeftPadded<Boolean> getStatic() {
                return this.t.statik;
            }

            public Import withStatic(JLeftPadded<Boolean> statik) {
                return this.t.statik == statik ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, statik, this.t.qualid, this.t.alias);
            }

            @Nullable
            public JLeftPadded<Identifier> getAlias() {
                return this.t.alias;
            }

            public Import withAlias(@Nullable JLeftPadded<Identifier> alias) {
                return this.t.alias == alias ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, this.t.statik, this.t.qualid, alias);
            }

            @Generated
            public Padding(Import t) {
                this.t = t;
            }
        }
    }

    public static final class If
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> ifCondition;
        private final JRightPadded<Statement> thenPart;
        @Nullable
        private final Else elsePart;

        public Statement getThenPart() {
            return this.thenPart.getElement();
        }

        public If withThenPart(Statement thenPart) {
            return this.getPadding().withThenPart(this.thenPart.withElement(thenPart));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIf(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.If(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", ifCondition=" + this.getIfCondition() + ", thenPart=" + this.getThenPart() + ", elsePart=" + this.getElsePart() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof If)) {
                return false;
            }
            If other = (If)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public If(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, @Nullable Else elsePart) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        @Generated
        private If(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, @Nullable Else elsePart) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        @NonNull
        @Generated
        public If withId(UUID id) {
            return this.id == id ? this : new If(this.padding, id, this.prefix, this.markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public If withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new If(this.padding, this.id, prefix, this.markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public If withMarkers(Markers markers) {
            return this.markers == markers ? this : new If(this.padding, this.id, this.prefix, markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public If withIfCondition(ControlParentheses<Expression> ifCondition) {
            return this.ifCondition == ifCondition ? this : new If(this.padding, this.id, this.prefix, this.markers, ifCondition, this.thenPart, this.elsePart);
        }

        @Generated
        public ControlParentheses<Expression> getIfCondition() {
            return this.ifCondition;
        }

        @NonNull
        @Generated
        public If withElsePart(@Nullable Else elsePart) {
            return this.elsePart == elsePart ? this : new If(this.padding, this.id, this.prefix, this.markers, this.ifCondition, this.thenPart, elsePart);
        }

        @Nullable
        @Generated
        public Else getElsePart() {
            return this.elsePart;
        }

        public static final class Else
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Statement> body;

            public Statement getBody() {
                return this.body.getElement();
            }

            public Else withBody(Statement body) {
                return this.getPadding().withBody(this.body.withElement(body));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitElse(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.If.Else(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ")";
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Else)) {
                    return false;
                }
                Else other = (Else)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Else(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            @Generated
            private Else(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            @NonNull
            @Generated
            public Else withId(UUID id) {
                return this.id == id ? this : new Else(this.padding, id, this.prefix, this.markers, this.body);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public Else withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Else(this.padding, this.id, prefix, this.markers, this.body);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public Else withMarkers(Markers markers) {
                return this.markers == markers ? this : new Else(this.padding, this.id, this.prefix, markers, this.body);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Else t;

                public JRightPadded<Statement> getBody() {
                    return this.t.body;
                }

                public Else withBody(JRightPadded<Statement> body) {
                    return this.t.body == body ? this.t : new Else(this.t.id, this.t.prefix, this.t.markers, body);
                }

                @Generated
                public Padding(Else t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final If t;

            public JRightPadded<Statement> getThenPart() {
                return this.t.thenPart;
            }

            public If withThenPart(JRightPadded<Statement> thenPart) {
                return this.t.thenPart == thenPart ? this.t : new If(this.t.id, this.t.prefix, this.t.markers, this.t.ifCondition, thenPart, this.t.elsePart);
            }

            @Generated
            public Padding(If t) {
                this.t = t;
            }
        }
    }

    public static final class Identifier
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final String simpleName;
        @Nullable
        private final JavaType type;
        @Nullable
        private final JavaType.Variable fieldType;

        @Deprecated
        public Identifier(UUID id, Space prefix, Markers markers, String simpleName, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = Collections.emptyList();
            this.simpleName = simpleName;
            this.type = type;
            this.fieldType = fieldType;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Identifier getCoordinates() {
            return new CoordinateBuilder.Identifier(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public String getSimpleName() {
            return this.simpleName;
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Nullable
        @Generated
        public JavaType.Variable getFieldType() {
            return this.fieldType;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @Generated
        public Identifier(UUID id, Space prefix, Markers markers, List<Annotation> annotations, String simpleName, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.simpleName = simpleName;
            this.type = type;
            this.fieldType = fieldType;
        }

        @NonNull
        @Generated
        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.annotations, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        @Generated
        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.annotations, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        @Generated
        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.annotations, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        @Generated
        public Identifier withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new Identifier(this.id, this.prefix, this.markers, annotations, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        @Generated
        public Identifier withSimpleName(String simpleName) {
            return this.simpleName == simpleName ? this : new Identifier(this.id, this.prefix, this.markers, this.annotations, simpleName, this.type, this.fieldType);
        }

        @NonNull
        @Generated
        public Identifier withType(@Nullable JavaType type) {
            return this.type == type ? this : new Identifier(this.id, this.prefix, this.markers, this.annotations, this.simpleName, type, this.fieldType);
        }

        @NonNull
        @Generated
        public Identifier withFieldType(@Nullable JavaType.Variable fieldType) {
            return this.fieldType == fieldType ? this : new Identifier(this.id, this.prefix, this.markers, this.annotations, this.simpleName, this.type, fieldType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ParenthesizedTypeTree
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final Parentheses<TypeTree> parenthesizedType;

        @Override
        @Nullable
        public JavaType getType() {
            return this.parenthesizedType.getType();
        }

        public ParenthesizedTypeTree withType(@Nullable JavaType type) {
            return this.withParenthesizedType((Parentheses<TypeTree>)this.parenthesizedType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParenthesizedTypeTree(this, p);
        }

        @Override
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Parentheses<TypeTree> getParenthesizedType() {
            return this.parenthesizedType;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.ParenthesizedTypeTree(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", parenthesizedType=" + this.getParenthesizedType() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParenthesizedTypeTree)) {
                return false;
            }
            ParenthesizedTypeTree other = (ParenthesizedTypeTree)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @Generated
        public ParenthesizedTypeTree(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Parentheses<TypeTree> parenthesizedType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.parenthesizedType = parenthesizedType;
        }

        @NonNull
        @Generated
        public ParenthesizedTypeTree withId(UUID id) {
            return this.id == id ? this : new ParenthesizedTypeTree(id, this.prefix, this.markers, this.annotations, this.parenthesizedType);
        }

        @NonNull
        @Generated
        public ParenthesizedTypeTree withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ParenthesizedTypeTree(this.id, prefix, this.markers, this.annotations, this.parenthesizedType);
        }

        @NonNull
        @Generated
        public ParenthesizedTypeTree withMarkers(Markers markers) {
            return this.markers == markers ? this : new ParenthesizedTypeTree(this.id, this.prefix, markers, this.annotations, this.parenthesizedType);
        }

        @NonNull
        @Generated
        public ParenthesizedTypeTree withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new ParenthesizedTypeTree(this.id, this.prefix, this.markers, annotations, this.parenthesizedType);
        }

        @NonNull
        @Generated
        public ParenthesizedTypeTree withParenthesizedType(Parentheses<TypeTree> parenthesizedType) {
            return this.parenthesizedType == parenthesizedType ? this : new ParenthesizedTypeTree(this.id, this.prefix, this.markers, this.annotations, parenthesizedType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ForLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public ForLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.ForLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ForLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @Generated
        private ForLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @NonNull
        @Generated
        public ForLoop withId(UUID id) {
            return this.id == id ? this : new ForLoop(this.padding, id, this.prefix, this.markers, this.control, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ForLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ForLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ForLoop withControl(Control control) {
            return this.control == control ? this : new ForLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        @Generated
        public Control getControl() {
            return this.control;
        }

        public static final class Control
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final List<JRightPadded<Statement>> init;
            private final JRightPadded<Expression> condition;
            private final List<JRightPadded<Statement>> update;

            public List<Statement> getInit() {
                return JRightPadded.getElements(this.init);
            }

            public Control withInit(List<Statement> init) {
                return this.getPadding().withInit(JRightPadded.withElements(this.init, init));
            }

            public Expression getCondition() {
                return this.condition.getElement();
            }

            public Control withCondition(Expression condition) {
                return this.getPadding().withCondition(this.condition.withElement(condition));
            }

            public List<Statement> getUpdate() {
                return JRightPadded.getElements(this.update);
            }

            public Control withUpdate(List<Statement> update) {
                return this.getPadding().withUpdate(JRightPadded.withElements(this.update, update));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForControl(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Control(UUID id, Space prefix, Markers markers, List<JRightPadded<Statement>> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            @Generated
            private Control(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Statement>> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            @NonNull
            @Generated
            public Control withId(UUID id) {
                return this.id == id ? this : new Control(this.padding, id, this.prefix, this.markers, this.init, this.condition, this.update);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.padding, this.id, prefix, this.markers, this.init, this.condition, this.update);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.padding, this.id, this.prefix, markers, this.init, this.condition, this.update);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Control t;

                public List<JRightPadded<Statement>> getInit() {
                    return this.t.init;
                }

                public Control withInit(List<JRightPadded<Statement>> init) {
                    return this.t.init == init ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, init, this.t.condition, this.t.update);
                }

                public JRightPadded<Expression> getCondition() {
                    return this.t.condition;
                }

                public Control withCondition(JRightPadded<Expression> condition) {
                    return this.t.condition == condition ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.init, condition, this.t.update);
                }

                public List<JRightPadded<Statement>> getUpdate() {
                    return this.t.update;
                }

                public Control withUpdate(List<JRightPadded<Statement>> update) {
                    return this.t.update == update ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.init, this.t.condition, update);
                }

                @Generated
                public Padding(Control t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final ForLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            @Generated
            public Padding(ForLoop t) {
                this.t = t;
            }
        }
    }

    public static final class ForEachLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public ForEachLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForEachLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.ForEachLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForEachLoop)) {
                return false;
            }
            ForEachLoop other = (ForEachLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ForEachLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @Generated
        private ForEachLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @NonNull
        @Generated
        public ForEachLoop withId(UUID id) {
            return this.id == id ? this : new ForEachLoop(this.padding, id, this.prefix, this.markers, this.control, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ForEachLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForEachLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ForEachLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForEachLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ForEachLoop withControl(Control control) {
            return this.control == control ? this : new ForEachLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        @Generated
        public Control getControl() {
            return this.control;
        }

        public static final class Control
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<VariableDeclarations> variable;
            private final JRightPadded<Expression> iterable;

            public VariableDeclarations getVariable() {
                return this.variable.getElement();
            }

            public Control withVariable(VariableDeclarations variable) {
                return this.getPadding().withVariable(this.variable.withElement(variable));
            }

            public Expression getIterable() {
                return this.iterable.getElement();
            }

            public Control withIterable(Expression iterable) {
                return this.getPadding().withIterable(this.iterable.withElement(iterable));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForEachControl(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Control(UUID id, Space prefix, Markers markers, JRightPadded<VariableDeclarations> variable, JRightPadded<Expression> iterable) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            @Generated
            private Control(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<VariableDeclarations> variable, JRightPadded<Expression> iterable) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            @NonNull
            @Generated
            public Control withId(UUID id) {
                return this.id == id ? this : new Control(this.padding, id, this.prefix, this.markers, this.variable, this.iterable);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.padding, this.id, prefix, this.markers, this.variable, this.iterable);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.padding, this.id, this.prefix, markers, this.variable, this.iterable);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Control t;

                public JRightPadded<VariableDeclarations> getVariable() {
                    return this.t.variable;
                }

                public Control withVariable(JRightPadded<VariableDeclarations> variable) {
                    return this.t.variable == variable ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, variable, this.t.iterable);
                }

                public JRightPadded<Expression> getIterable() {
                    return this.t.iterable;
                }

                public Control withIterable(JRightPadded<Expression> iterable) {
                    return this.t.iterable == iterable ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.variable, iterable);
                }

                @Generated
                public Padding(Control t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final ForEachLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForEachLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForEachLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            @Generated
            public Padding(ForEachLoop t) {
                this.t = t;
            }
        }
    }

    public static final class FieldAccess
    implements J,
    TypeTree,
    Expression,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression target;
        private final JLeftPadded<Identifier> name;
        @Nullable
        private final JavaType type;

        public Identifier getName() {
            return this.name.getElement();
        }

        public FieldAccess withName(Identifier name) {
            return this.getPadding().withName(this.name.withElement(name));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitFieldAccess(this, p);
        }

        public String getSimpleName() {
            return this.name.getElement().getSimpleName();
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.target.getSideEffects();
        }

        @Nullable
        public NameTree asClassReference() {
            if (this.target instanceof NameTree) {
                String fqn = null;
                if (this.type instanceof JavaType.FullyQualified) {
                    fqn = ((JavaType.FullyQualified)this.type).getFullyQualifiedName();
                }
                return "java.lang.Class".equals(fqn) ? (NameTree)((Object)this.target) : null;
            }
            return null;
        }

        public boolean isFullyQualifiedClassReference(String className) {
            return this.isFullyQualifiedClassReference(this, className);
        }

        private boolean isFullyQualifiedClassReference(FieldAccess fieldAccess, String className) {
            if (!className.contains(".")) {
                return false;
            }
            if (!fieldAccess.getName().getSimpleName().equals(className.substring(className.lastIndexOf(46) + 1))) {
                return false;
            }
            if (fieldAccess.getTarget() instanceof FieldAccess) {
                return this.isFullyQualifiedClassReference((FieldAccess)fieldAccess.getTarget(), className.substring(0, className.lastIndexOf(46)));
            }
            if (fieldAccess.getTarget() instanceof Identifier) {
                return ((Identifier)fieldAccess.getTarget()).getSimpleName().equals(className.substring(0, className.lastIndexOf(46)));
            }
            return false;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess other = (FieldAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public FieldAccess(UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Identifier> name, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        @Generated
        private FieldAccess(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Identifier> name, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        @NonNull
        @Generated
        public FieldAccess withId(UUID id) {
            return this.id == id ? this : new FieldAccess(this.padding, id, this.prefix, this.markers, this.target, this.name, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public FieldAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FieldAccess(this.padding, this.id, prefix, this.markers, this.target, this.name, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public FieldAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new FieldAccess(this.padding, this.id, this.prefix, markers, this.target, this.name, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public FieldAccess withTarget(Expression target) {
            return this.target == target ? this : new FieldAccess(this.padding, this.id, this.prefix, this.markers, target, this.name, this.type);
        }

        @Generated
        public Expression getTarget() {
            return this.target;
        }

        @NonNull
        @Generated
        public FieldAccess withType(@Nullable JavaType type) {
            return this.type == type ? this : new FieldAccess(this.padding, this.id, this.prefix, this.markers, this.target, this.name, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final FieldAccess t;

            public JLeftPadded<Identifier> getName() {
                return this.t.name;
            }

            public FieldAccess withName(JLeftPadded<Identifier> name) {
                return this.t.name == name ? this.t : new FieldAccess(this.t.id, this.t.prefix, this.t.markers, this.t.target, name, this.t.type);
            }

            @Generated
            public Padding(FieldAccess t) {
                this.t = t;
            }
        }
    }

    public static final class EnumValueSet
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<EnumValue>> enums;
        private final boolean terminatedWithSemicolon;

        public List<EnumValue> getEnums() {
            return JRightPadded.getElements(this.enums);
        }

        public EnumValueSet withEnums(List<EnumValue> enums) {
            return this.getPadding().withEnums(JRightPadded.withElements(this.enums, enums));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValueSet(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.EnumValueSet(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", enums=" + this.getEnums() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValueSet)) {
                return false;
            }
            EnumValueSet other = (EnumValueSet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public EnumValueSet(UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        @Generated
        private EnumValueSet(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        @NonNull
        @Generated
        public EnumValueSet withId(UUID id) {
            return this.id == id ? this : new EnumValueSet(this.padding, id, this.prefix, this.markers, this.enums, this.terminatedWithSemicolon);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public EnumValueSet withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValueSet(this.padding, this.id, prefix, this.markers, this.enums, this.terminatedWithSemicolon);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public EnumValueSet withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValueSet(this.padding, this.id, this.prefix, markers, this.enums, this.terminatedWithSemicolon);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public EnumValueSet withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
            return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new EnumValueSet(this.padding, this.id, this.prefix, this.markers, this.enums, terminatedWithSemicolon);
        }

        @Generated
        public boolean isTerminatedWithSemicolon() {
            return this.terminatedWithSemicolon;
        }

        public static class Padding {
            private final EnumValueSet t;

            public List<JRightPadded<EnumValue>> getEnums() {
                return this.t.enums;
            }

            public EnumValueSet withEnums(List<JRightPadded<EnumValue>> enums) {
                return this.t.enums == enums ? this.t : new EnumValueSet(this.t.id, this.t.prefix, this.t.markers, enums, this.t.terminatedWithSemicolon);
            }

            @Generated
            public Padding(EnumValueSet t) {
                this.t = t;
            }
        }
    }

    public static final class EnumValue
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final Identifier name;
        @Nullable
        private final NewClass initializer;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValue(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue other = (EnumValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public EnumValue(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Identifier name, @Nullable NewClass initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.initializer = initializer;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Identifier getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public NewClass getInitializer() {
            return this.initializer;
        }

        @NonNull
        @Generated
        public EnumValue withId(UUID id) {
            return this.id == id ? this : new EnumValue(id, this.prefix, this.markers, this.annotations, this.name, this.initializer);
        }

        @NonNull
        @Generated
        public EnumValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValue(this.id, prefix, this.markers, this.annotations, this.name, this.initializer);
        }

        @NonNull
        @Generated
        public EnumValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValue(this.id, this.prefix, markers, this.annotations, this.name, this.initializer);
        }

        @NonNull
        @Generated
        public EnumValue withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new EnumValue(this.id, this.prefix, this.markers, annotations, this.name, this.initializer);
        }

        @NonNull
        @Generated
        public EnumValue withName(Identifier name) {
            return this.name == name ? this : new EnumValue(this.id, this.prefix, this.markers, this.annotations, name, this.initializer);
        }

        @NonNull
        @Generated
        public EnumValue withInitializer(@Nullable NewClass initializer) {
            return this.initializer == initializer ? this : new EnumValue(this.id, this.prefix, this.markers, this.annotations, this.name, initializer);
        }
    }

    public static final class Empty
    implements J,
    Statement,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public Empty withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Empty(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        @NonNull
        @Generated
        public Empty withId(UUID id) {
            return this.id == id ? this : new Empty(id, this.prefix, this.markers);
        }

        @NonNull
        @Generated
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        @Generated
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static final class DoWhileLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Statement> body;
        private final JLeftPadded<ControlParentheses<Expression>> whileCondition;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public DoWhileLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        public ControlParentheses<Expression> getWhileCondition() {
            return this.whileCondition.getElement();
        }

        public DoWhileLoop withWhileCondition(ControlParentheses<Expression> whileCondition) {
            return this.getPadding().withWhileCondition(this.whileCondition.withElement(whileCondition));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitDoWhileLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.DoWhileLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ", whileCondition=" + this.getWhileCondition() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileLoop)) {
                return false;
            }
            DoWhileLoop other = (DoWhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public DoWhileLoop(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        @Generated
        private DoWhileLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        @NonNull
        @Generated
        public DoWhileLoop withId(UUID id) {
            return this.id == id ? this : new DoWhileLoop(this.padding, id, this.prefix, this.markers, this.body, this.whileCondition);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public DoWhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DoWhileLoop(this.padding, this.id, prefix, this.markers, this.body, this.whileCondition);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public DoWhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new DoWhileLoop(this.padding, this.id, this.prefix, markers, this.body, this.whileCondition);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final DoWhileLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public DoWhileLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new DoWhileLoop(this.t.id, this.t.prefix, this.t.markers, body, this.t.whileCondition);
            }

            public JLeftPadded<ControlParentheses<Expression>> getWhileCondition() {
                return this.t.whileCondition;
            }

            public DoWhileLoop withWhileCondition(JLeftPadded<ControlParentheses<Expression>> whileCondition) {
                return this.t.whileCondition == whileCondition ? this.t : new DoWhileLoop(this.t.id, this.t.prefix, this.t.markers, this.t.body, whileCondition);
            }

            @Generated
            public Padding(DoWhileLoop t) {
                this.t = t;
            }
        }
    }

    public static final class Continue
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitContinue(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue other = (Continue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Continue(UUID id, Space prefix, Markers markers, @Nullable Identifier label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        @Generated
        public Identifier getLabel() {
            return this.label;
        }

        @NonNull
        @Generated
        public Continue withId(UUID id) {
            return this.id == id ? this : new Continue(id, this.prefix, this.markers, this.label);
        }

        @NonNull
        @Generated
        public Continue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Continue(this.id, prefix, this.markers, this.label);
        }

        @NonNull
        @Generated
        public Continue withMarkers(Markers markers) {
            return this.markers == markers ? this : new Continue(this.id, this.prefix, markers, this.label);
        }

        @NonNull
        @Generated
        public Continue withLabel(@Nullable Identifier label) {
            return this.label == label ? this : new Continue(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class CompilationUnit
    implements J,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        @Nullable
        private final JRightPadded<Package> packageDeclaration;
        private final List<JRightPadded<Import>> imports;
        private final List<ClassDeclaration> classes;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        @Nullable
        public Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : this.packageDeclaration.getElement();
        }

        @Override
        public CompilationUnit withPackageDeclaration(Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration(JRightPadded.withElement(this.packageDeclaration, packageDeclaration));
        }

        @Override
        public List<Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        @Override
        public CompilationUnit withImports(List<Import> imports) {
            return this.getPadding().withImports((List)JRightPadded.withElements(this.imports, imports));
        }

        @Transient
        public long getWeight(final Predicate<Object> uniqueIdentity) {
            AtomicInteger n = new AtomicInteger();
            new JavaVisitor<AtomicInteger>(){
                final JavaTypeVisitor<AtomicInteger> typeVisitor = new JavaTypeVisitor<AtomicInteger>(){

                    @Override
                    public JavaType visit(@Nullable JavaType javaType, AtomicInteger n) {
                        if (javaType != null && uniqueIdentity.test(javaType)) {
                            n.incrementAndGet();
                            return super.visit(javaType, n);
                        }
                        return javaType;
                    }
                };
                final JavadocVisitor<AtomicInteger> javadocVisitor = new JavadocVisitor<AtomicInteger>((JavaVisitor)this){

                    @Nullable
                    public Javadoc visit(@Nullable Tree tree, AtomicInteger n) {
                        if (tree != null) {
                            n.incrementAndGet();
                        }
                        return (Javadoc)super.visit(tree, (Object)n);
                    }
                };

                @Nullable
                public J preVisit(J tree, AtomicInteger n) {
                    n.incrementAndGet();
                    return tree;
                }

                @Override
                public JavaType visitType(@Nullable JavaType javaType, AtomicInteger n) {
                    return this.typeVisitor.visit(javaType, n);
                }

                @Override
                protected JavadocVisitor<AtomicInteger> getJavadocVisitor() {
                    return this.javadocVisitor;
                }
            }.visit(this, n);
            return n.get();
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public Set<NameTree> findType(String clazz) {
            return FindTypes.find(this, clazz);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JavaPrinter();
        }

        @Override
        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build(this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build(this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        @Override
        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<Package> packageDeclaration, List<JRightPadded<Import>> imports, List<ClassDeclaration> classes, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        @Generated
        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<Package> packageDeclaration, List<JRightPadded<Import>> imports, List<ClassDeclaration> classes, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        @NonNull
        @Generated
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        @NonNull
        @Generated
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Override
        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        @Generated
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Nullable
        @Generated
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @NonNull
        @Generated
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @NonNull
        @Generated
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        @Generated
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Nullable
        @Generated
        public Checksum getChecksum() {
            return this.checksum;
        }

        @Override
        @NonNull
        @Generated
        public CompilationUnit withClasses(List<ClassDeclaration> classes) {
            return this.classes == classes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, classes, this.eof);
        }

        @Override
        @Generated
        public List<ClassDeclaration> getClasses() {
            return this.classes;
        }

        @Override
        @NonNull
        @Generated
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, eof);
        }

        @Override
        @Generated
        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, packageDeclaration, this.t.imports, this.t.classes, this.t.eof);
            }

            @Override
            public List<JRightPadded<Import>> getImports() {
                return this.t.imports;
            }

            @Override
            public CompilationUnit withImports(List<JRightPadded<Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, this.t.packageDeclaration, imports, this.t.classes, this.t.eof);
            }

            @Generated
            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }

    public static final class ClassDeclaration
    implements J,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> leadingAnnotations;
        private final List<Modifier> modifiers;
        private final Kind kind;
        private final Identifier name;
        @Nullable
        private final JContainer<TypeParameter> typeParameters;
        @Nullable
        private final JContainer<Statement> primaryConstructor;
        @Nullable
        private final JLeftPadded<TypeTree> extendings;
        @Nullable
        private final JContainer<TypeTree> implementings;
        @Nullable
        private final JContainer<TypeTree> permitting;
        private final Block body;
        @Nullable
        private final JavaType.FullyQualified type;

        public Kind.Type getKind() {
            return this.kind.getType();
        }

        public ClassDeclaration withKind(Kind.Type type) {
            Kind k = this.getPadding().getKind();
            if (k.type == type) {
                return this;
            }
            return this.getPadding().withKind(k.withType(type));
        }

        @Nullable
        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public ClassDeclaration withTypeParameters(@Nullable List<TypeParameter> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Nullable
        public List<Statement> getPrimaryConstructor() {
            return this.primaryConstructor == null ? null : this.primaryConstructor.getElements();
        }

        public ClassDeclaration withPrimaryConstructor(@Nullable List<Statement> primaryConstructor) {
            return this.getPadding().withPrimaryConstructor(JContainer.withElementsNullable(this.primaryConstructor, primaryConstructor));
        }

        @Nullable
        public TypeTree getExtends() {
            return this.extendings == null ? null : this.extendings.getElement();
        }

        public ClassDeclaration withExtends(@Nullable TypeTree extendings) {
            return this.getPadding().withExtends(JLeftPadded.withElement(this.extendings, extendings));
        }

        @Nullable
        public List<TypeTree> getImplements() {
            return this.implementings == null ? null : this.implementings.getElements();
        }

        public ClassDeclaration withImplements(@Nullable List<TypeTree> implementings) {
            return this.getPadding().withImplements(JContainer.withElementsNullable(this.implementings, implementings));
        }

        @Nullable
        public List<TypeTree> getPermits() {
            return this.permitting == null ? null : this.permitting.getElements();
        }

        public ClassDeclaration withPermits(@Nullable List<TypeTree> permitting) {
            return this.getPadding().withPermits(JContainer.withElementsNullable(this.permitting, permitting));
        }

        public ClassDeclaration withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type != null && !(type instanceof JavaType.FullyQualified)) {
                throw new IllegalArgumentException("A class can only be type attributed with a fully qualified type name");
            }
            return new ClassDeclaration(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, (JavaType.FullyQualified)type);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitClassDeclaration(this, p);
        }

        @Deprecated
        public List<Annotation> getAllAnnotations() {
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.leadingAnnotations);
            for (Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            allAnnotations.addAll(this.kind.getAnnotations());
            return allAnnotations;
        }

        @Override
        @Transient
        public CoordinateBuilder.ClassDeclaration getCoordinates() {
            return new CoordinateBuilder.ClassDeclaration(this);
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDeclaration)) {
                return false;
            }
            ClassDeclaration other = (ClassDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ClassDeclaration(UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, Kind kind, Identifier name, @Nullable JContainer<TypeParameter> typeParameters, @Nullable JContainer<Statement> primaryConstructor, @Nullable JLeftPadded<TypeTree> extendings, @Nullable JContainer<TypeTree> implementings, @Nullable JContainer<TypeTree> permitting, Block body, @Nullable JavaType.FullyQualified type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.primaryConstructor = primaryConstructor;
            this.extendings = extendings;
            this.implementings = implementings;
            this.permitting = permitting;
            this.body = body;
            this.type = type;
        }

        @Generated
        private ClassDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, Kind kind, Identifier name, @Nullable JContainer<TypeParameter> typeParameters, @Nullable JContainer<Statement> primaryConstructor, @Nullable JLeftPadded<TypeTree> extendings, @Nullable JContainer<TypeTree> implementings, @Nullable JContainer<TypeTree> permitting, Block body, @Nullable JavaType.FullyQualified type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.primaryConstructor = primaryConstructor;
            this.extendings = extendings;
            this.implementings = implementings;
            this.permitting = permitting;
            this.body = body;
            this.type = type;
        }

        @NonNull
        @Generated
        public ClassDeclaration withId(UUID id) {
            return this.id == id ? this : new ClassDeclaration(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ClassDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ClassDeclaration(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ClassDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new ClassDeclaration(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ClassDeclaration withLeadingAnnotations(List<Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, this.type);
        }

        @Generated
        public List<Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        @Generated
        public ClassDeclaration withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, this.type);
        }

        @Generated
        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public ClassDeclaration withName(Identifier name) {
            return this.name == name ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, this.body, this.type);
        }

        @Generated
        public Identifier getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public ClassDeclaration withBody(Block body) {
            return this.body == body ? this : new ClassDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.permitting, body, this.type);
        }

        @Generated
        public Block getBody() {
            return this.body;
        }

        @Override
        @Nullable
        @Generated
        public JavaType.FullyQualified getType() {
            return this.type;
        }

        public static final class Kind
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final List<Annotation> annotations;
            private final Type type;

            @Generated
            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kind)) {
                    return false;
                }
                Kind other = (Kind)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Kind(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Type type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.annotations = annotations;
                this.type = type;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public List<Annotation> getAnnotations() {
                return this.annotations;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            @NonNull
            @Generated
            public String toString() {
                return "J.ClassDeclaration.Kind(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", type=" + (Object)((Object)this.getType()) + ")";
            }

            @NonNull
            @Generated
            public Kind withId(UUID id) {
                return this.id == id ? this : new Kind(id, this.prefix, this.markers, this.annotations, this.type);
            }

            @NonNull
            @Generated
            public Kind withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Kind(this.id, prefix, this.markers, this.annotations, this.type);
            }

            @NonNull
            @Generated
            public Kind withMarkers(Markers markers) {
                return this.markers == markers ? this : new Kind(this.id, this.prefix, markers, this.annotations, this.type);
            }

            @NonNull
            @Generated
            public Kind withAnnotations(List<Annotation> annotations) {
                return this.annotations == annotations ? this : new Kind(this.id, this.prefix, this.markers, annotations, this.type);
            }

            @NonNull
            @Generated
            public Kind withType(Type type) {
                return this.type == type ? this : new Kind(this.id, this.prefix, this.markers, this.annotations, type);
            }

            public static enum Type {
                Class,
                Enum,
                Interface,
                Annotation,
                Record,
                Value;

            }
        }

        public static class Padding {
            private final ClassDeclaration t;

            @Nullable
            public JContainer<Statement> getPrimaryConstructor() {
                return this.t.primaryConstructor;
            }

            public ClassDeclaration withPrimaryConstructor(@Nullable JContainer<Statement> primaryConstructor) {
                return this.t.primaryConstructor == primaryConstructor ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, primaryConstructor, this.t.extendings, this.t.implementings, this.t.permitting, this.t.body, this.t.type);
            }

            @Nullable
            public JLeftPadded<TypeTree> getExtends() {
                return this.t.extendings;
            }

            public ClassDeclaration withExtends(@Nullable JLeftPadded<TypeTree> extendings) {
                return this.t.extendings == extendings ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, extendings, this.t.implementings, this.t.permitting, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeTree> getImplements() {
                return this.t.implementings;
            }

            public ClassDeclaration withImplements(@Nullable JContainer<TypeTree> implementings) {
                return this.t.implementings == implementings ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, this.t.extendings, implementings, this.t.permitting, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeTree> getPermits() {
                return this.t.permitting;
            }

            public ClassDeclaration withPermits(@Nullable JContainer<TypeTree> permitting) {
                return this.t.permitting == permitting ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, this.t.extendings, this.t.implementings, permitting, this.t.body, this.t.type);
            }

            public Kind getKind() {
                return this.t.kind;
            }

            public ClassDeclaration withKind(Kind kind) {
                return this.t.kind == kind ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, this.t.extendings, this.t.implementings, this.t.permitting, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeParameter> getTypeParameters() {
                return this.t.typeParameters;
            }

            public ClassDeclaration withTypeParameters(@Nullable JContainer<TypeParameter> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, typeParameters, this.t.primaryConstructor, this.t.extendings, this.t.implementings, this.t.permitting, this.t.body, this.t.type);
            }

            @Generated
            public Padding(ClassDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class Case
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;
        private final JContainer<Expression> expressions;
        private final JContainer<Statement> statements;
        @Nullable
        private final JRightPadded<J> body;

        public Type getType() {
            return this.type == null ? Type.Statement : this.type;
        }

        @Deprecated
        public Expression getPattern() {
            return this.getExpressions().get(0);
        }

        @Deprecated
        public Case withPattern(@Nullable Expression pattern) {
            return this.withExpressions(ListUtils.mapFirst(this.getExpressions(), first -> pattern));
        }

        public List<Expression> getExpressions() {
            return this.expressions.getElements();
        }

        public Case withExpressions(List<Expression> expressions) {
            return this.getPadding().withExpressions(Objects.requireNonNull(JContainer.withElementsNullable(this.expressions, expressions)));
        }

        public List<Statement> getStatements() {
            return this.statements.getElements();
        }

        public Case withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JContainer.withElements(this.statements, statements));
        }

        @Nullable
        public J getBody() {
            return this.body == null ? null : this.body.getElement();
        }

        public Case withBody(J body) {
            return this.getPadding().withBody(JRightPadded.withElement(this.body, body));
        }

        @JsonCreator
        public Case(UUID id, Space prefix, Markers markers, Type type, @Deprecated @Nullable Expression pattern, JContainer<Expression> expressions, JContainer<Statement> statements, @Nullable JRightPadded<J> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.expressions = pattern != null ? Objects.requireNonNull(JContainer.withElementsNullable(null, Collections.singletonList(pattern))) : expressions;
            this.statements = statements;
            this.body = body;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCase(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Case)) {
                return false;
            }
            Case other = (Case)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Case(UUID id, Space prefix, Markers markers, Type type, JContainer<Expression> expressions, JContainer<Statement> statements, @Nullable JRightPadded<J> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.expressions = expressions;
            this.statements = statements;
            this.body = body;
        }

        @Generated
        private Case(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Type type, JContainer<Expression> expressions, JContainer<Statement> statements, @Nullable JRightPadded<J> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.expressions = expressions;
            this.statements = statements;
            this.body = body;
        }

        @NonNull
        @Generated
        public Case withId(UUID id) {
            return this.id == id ? this : new Case(this.padding, id, this.prefix, this.markers, this.type, this.expressions, this.statements, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Case withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Case(this.padding, this.id, prefix, this.markers, this.type, this.expressions, this.statements, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Case withMarkers(Markers markers) {
            return this.markers == markers ? this : new Case(this.padding, this.id, this.prefix, markers, this.type, this.expressions, this.statements, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Case withType(Type type) {
            return this.type == type ? this : new Case(this.padding, this.id, this.prefix, this.markers, type, this.expressions, this.statements, this.body);
        }

        public static enum Type {
            Statement,
            Rule;

        }

        public static class Padding {
            private final Case t;

            @Nullable
            public JRightPadded<J> getBody() {
                return this.t.body;
            }

            public Case withBody(@Nullable JRightPadded<J> body) {
                return this.t.body == body ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.type, null, (JContainer<Expression>)this.t.expressions, (JContainer<Statement>)this.t.statements, body);
            }

            public JContainer<Statement> getStatements() {
                return this.t.statements;
            }

            public Case withStatements(JContainer<Statement> statements) {
                return this.t.statements == statements ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.type, null, (JContainer<Expression>)this.t.expressions, statements, (JRightPadded<J>)this.t.body);
            }

            public JContainer<Expression> getExpressions() {
                return this.t.expressions;
            }

            public Case withExpressions(JContainer<Expression> expressions) {
                return this.t.expressions == expressions ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.type, null, expressions, (JContainer<Statement>)this.t.statements, (JRightPadded<J>)this.t.body);
            }

            @Generated
            public Padding(Case t) {
                this.t = t;
            }
        }
    }

    public static final class Break
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBreak(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Break)) {
                return false;
            }
            Break other = (Break)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Break(UUID id, Space prefix, Markers markers, @Nullable Identifier label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        @Generated
        public Identifier getLabel() {
            return this.label;
        }

        @NonNull
        @Generated
        public Break withId(UUID id) {
            return this.id == id ? this : new Break(id, this.prefix, this.markers, this.label);
        }

        @NonNull
        @Generated
        public Break withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Break(this.id, prefix, this.markers, this.label);
        }

        @NonNull
        @Generated
        public Break withMarkers(Markers markers) {
            return this.markers == markers ? this : new Break(this.id, this.prefix, markers, this.label);
        }

        @NonNull
        @Generated
        public Break withLabel(@Nullable Identifier label) {
            return this.label == label ? this : new Break(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class Block
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Boolean> statik;
        private final List<JRightPadded<Statement>> statements;
        private final Space end;

        public boolean isStatic() {
            return this.statik.getElement();
        }

        public Block withStatic(boolean statik) {
            return this.getPadding().withStatic(this.statik.withElement(statik));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public Block withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBlock(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Block getCoordinates() {
            return new CoordinateBuilder.Block(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public static Block createEmptyBlock() {
            return new Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build(false), Collections.emptyList(), Space.EMPTY);
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        @LoathingOfOthers(value="Who didn't encode this in the model?!")
        @Incubating(since="7.25.0")
        public static boolean isInitBlock(Cursor cursor) {
            if (!(cursor.getValue() instanceof Block)) {
                throw new IllegalArgumentException("Cursor must point to a J.Block!");
            }
            Block block = (Block)cursor.getValue();
            if (block.isStatic()) {
                return false;
            }
            Block parentBlock = null;
            Iterator path = cursor.getPath();
            if (path.hasNext()) {
                path.next();
            }
            while (path.hasNext()) {
                Object next = path.next();
                if (parentBlock != null && next instanceof Block) {
                    return false;
                }
                if (next instanceof Block) {
                    parentBlock = (Block)next;
                    if (parentBlock.getStatements().contains(block)) continue;
                    return false;
                }
                if (next instanceof ClassDeclaration) {
                    ClassDeclaration classDeclaration = (ClassDeclaration)next;
                    return classDeclaration.getBody() == parentBlock;
                }
                if (next instanceof NewClass) {
                    NewClass newClass = (NewClass)next;
                    return newClass.getBody() == parentBlock;
                }
                if (!(next instanceof Lambda)) continue;
                return false;
            }
            return false;
        }

        @Incubating(since="7.25.0")
        public static boolean isStaticOrInitBlock(Cursor cursor) {
            if (!(cursor.getValue() instanceof Block)) {
                throw new IllegalArgumentException("Cursor must point to a J.Block!");
            }
            Block block = (Block)cursor.getValue();
            return block.isStatic() || Block.isInitBlock(cursor);
        }

        @NonNull
        @Generated
        public String toString() {
            return "J.Block(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", statik=" + this.statik + ", statements=" + this.getStatements() + ", end=" + this.getEnd() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Block(UUID id, Space prefix, Markers markers, JRightPadded<Boolean> statik, List<JRightPadded<Statement>> statements, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        @Generated
        private Block(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Boolean> statik, List<JRightPadded<Statement>> statements, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        @NonNull
        @Generated
        public Block withId(UUID id) {
            return this.id == id ? this : new Block(this.padding, id, this.prefix, this.markers, this.statik, this.statements, this.end);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Block withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Block(this.padding, this.id, prefix, this.markers, this.statik, this.statements, this.end);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Block withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block(this.padding, this.id, this.prefix, markers, this.statik, this.statements, this.end);
        }

        @Generated
        public Space getEnd() {
            return this.end;
        }

        @NonNull
        @Generated
        public Block withEnd(Space end) {
            return this.end == end ? this : new Block(this.padding, this.id, this.prefix, this.markers, this.statik, this.statements, end);
        }

        public static class Padding {
            private final Block t;

            public JRightPadded<Boolean> getStatic() {
                return this.t.statik;
            }

            public Block withStatic(JRightPadded<Boolean> statik) {
                return this.t.statik == statik ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, statik, this.t.statements, this.t.end);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public Block withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, this.t.statik, statements, this.t.end);
            }

            @Generated
            public Padding(Block t) {
                this.t = t;
            }
        }
    }

    public static final class Binary
    implements J,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            ArrayList<J> sideEffects = new ArrayList<J>(2);
            sideEffects.addAll(this.left.getSideEffects());
            sideEffects.addAll(this.right.getSideEffects());
            return sideEffects;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLeft() {
            return this.left;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @NonNull
        @Generated
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            LessThan,
            GreaterThan,
            LessThanOrEqual,
            GreaterThanOrEqual,
            Equal,
            NotEqual,
            BitAnd,
            BitOr,
            BitXor,
            LeftShift,
            RightShift,
            UnsignedRightShift,
            Or,
            And;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            @Generated
            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class AssignmentOperation
    implements J,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Type> operator;
        private final Expression assignment;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public AssignmentOperation withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignmentOperation(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentOperation)) {
                return false;
            }
            AssignmentOperation other = (AssignmentOperation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public AssignmentOperation(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        @Generated
        private AssignmentOperation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        @NonNull
        @Generated
        public AssignmentOperation withId(UUID id) {
            return this.id == id ? this : new AssignmentOperation(this.padding, id, this.prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public AssignmentOperation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AssignmentOperation(this.padding, this.id, prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public AssignmentOperation withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssignmentOperation(this.padding, this.id, this.prefix, markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public AssignmentOperation withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, variable, this.operator, this.assignment, this.type);
        }

        @Generated
        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        @Generated
        public AssignmentOperation withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, assignment, this.type);
        }

        @Generated
        public Expression getAssignment() {
            return this.assignment;
        }

        @NonNull
        @Generated
        public AssignmentOperation withType(@Nullable JavaType type) {
            return this.type == type ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, this.assignment, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static enum Type {
            Addition,
            BitAnd,
            BitOr,
            BitXor,
            Division,
            Exponentiation,
            FloorDivision,
            LeftShift,
            MatrixMultiplication,
            Modulo,
            Multiplication,
            RightShift,
            Subtraction,
            UnsignedRightShift;

        }

        public static class Padding {
            private final AssignmentOperation t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public AssignmentOperation withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new AssignmentOperation(this.t.id, this.t.prefix, this.t.markers, this.t.variable, operator, this.t.assignment, this.t.type);
            }

            @Generated
            public Padding(AssignmentOperation t) {
                this.t = t;
            }
        }
    }

    public static final class Assignment
    implements J,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Expression> assignment;
        @Nullable
        private final JavaType type;

        public Expression getAssignment() {
            return this.assignment.getElement();
        }

        public Assignment withAssignment(Expression assignment) {
            return this.getPadding().withAssignment(this.assignment.withElement(assignment));
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignment(this, p);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Assignment(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        @Generated
        private Assignment(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        @NonNull
        @Generated
        public Assignment withId(UUID id) {
            return this.id == id ? this : new Assignment(this.padding, id, this.prefix, this.markers, this.variable, this.assignment, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Assignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assignment(this.padding, this.id, prefix, this.markers, this.variable, this.assignment, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Assignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assignment(this.padding, this.id, this.prefix, markers, this.variable, this.assignment, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Assignment withVariable(Expression variable) {
            return this.variable == variable ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, variable, this.assignment, this.type);
        }

        @Generated
        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        @Generated
        public Assignment withType(@Nullable JavaType type) {
            return this.type == type ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, this.variable, this.assignment, type);
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Assignment t;

            public JLeftPadded<Expression> getAssignment() {
                return this.t.assignment;
            }

            public Assignment withAssignment(JLeftPadded<Expression> assignment) {
                return this.t.assignment == assignment ? this.t : new Assignment(this.t.id, this.t.prefix, this.t.markers, this.t.variable, assignment, this.t.type);
            }

            @Generated
            public Padding(Assignment t) {
                this.t = t;
            }
        }
    }

    public static final class Assert
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        @Nullable
        private final JLeftPadded<Expression> detail;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssert(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert other = (Assert)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Assert(UUID id, Space prefix, Markers markers, Expression condition, @Nullable JLeftPadded<Expression> detail) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.detail = detail;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getCondition() {
            return this.condition;
        }

        @Nullable
        @Generated
        public JLeftPadded<Expression> getDetail() {
            return this.detail;
        }

        @NonNull
        @Generated
        public Assert withId(UUID id) {
            return this.id == id ? this : new Assert(id, this.prefix, this.markers, this.condition, this.detail);
        }

        @NonNull
        @Generated
        public Assert withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assert(this.id, prefix, this.markers, this.condition, this.detail);
        }

        @NonNull
        @Generated
        public Assert withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assert(this.id, this.prefix, markers, this.condition, this.detail);
        }

        @NonNull
        @Generated
        public Assert withCondition(Expression condition) {
            return this.condition == condition ? this : new Assert(this.id, this.prefix, this.markers, condition, this.detail);
        }

        @NonNull
        @Generated
        public Assert withDetail(@Nullable JLeftPadded<Expression> detail) {
            return this.detail == detail ? this : new Assert(this.id, this.prefix, this.markers, this.condition, detail);
        }
    }

    public static final class ArrayType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree elementType;
        @Nullable
        private final List<Annotation> annotations;
        @Nullable
        private final JLeftPadded<Space> dimension;
        private final JavaType type;

        @Deprecated
        @JsonCreator
        static ArrayType create(UUID id, Space prefix, Markers markers, TypeTree elementType, @Nullable List<JRightPadded<Space>> dimensions, @Nullable List<Annotation> annotations, @Nullable JLeftPadded<Space> dimension, @Nullable JavaType type) {
            if (dimensions != null) {
                JavaType updated = elementType.getType();
                while (updated instanceof JavaType.Array) {
                    updated = ((JavaType.Array)updated).getElemType();
                }
                elementType = (TypeTree)elementType.withType(updated);
                if (dimensions.isEmpty()) {
                    type = new JavaType.Array(null, elementType.getType(), null);
                } else {
                    int dimensionCount = dimensions.size();
                    elementType = ArrayType.mapOldFormat(elementType, dimensions.subList(0, dimensionCount - 1));
                    type = new JavaType.Array(null, elementType.getType(), null);
                    dimension = JLeftPadded.build(dimensions.get(dimensionCount - 1).getAfter()).withBefore(dimensions.get(dimensionCount - 1).getElement());
                }
            }
            return new ArrayType(id, prefix, markers, elementType, annotations, dimension, type == null ? JavaType.Unknown.getInstance() : type);
        }

        private static TypeTree mapOldFormat(TypeTree elementType, List<JRightPadded<Space>> dimensions) {
            int count = dimensions.size();
            if (count == 0) {
                return elementType;
            }
            return ArrayType.mapOldFormat(new ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, elementType, null, JLeftPadded.build(dimensions.get(0).getAfter()).withBefore(dimensions.get(0).getElement()), new JavaType.Array(null, elementType.getType(), null)), dimensions.subList(1, count));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayType(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ArrayType(UUID id, Space prefix, Markers markers, TypeTree elementType, @Nullable List<Annotation> annotations, @Nullable JLeftPadded<Space> dimension, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elementType = elementType;
            this.annotations = annotations;
            this.dimension = dimension;
            this.type = type;
        }

        @NonNull
        @Generated
        public ArrayType withId(UUID id) {
            return this.id == id ? this : new ArrayType(id, this.prefix, this.markers, this.elementType, this.annotations, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayType(this.id, prefix, this.markers, this.elementType, this.annotations, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayType(this.id, this.prefix, markers, this.elementType, this.annotations, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayType withElementType(TypeTree elementType) {
            return this.elementType == elementType ? this : new ArrayType(this.id, this.prefix, this.markers, elementType, this.annotations, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayType withAnnotations(@Nullable List<Annotation> annotations) {
            return this.annotations == annotations ? this : new ArrayType(this.id, this.prefix, this.markers, this.elementType, annotations, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayType withDimension(@Nullable JLeftPadded<Space> dimension) {
            return this.dimension == dimension ? this : new ArrayType(this.id, this.prefix, this.markers, this.elementType, this.annotations, dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayType withType(JavaType type) {
            return this.type == type ? this : new ArrayType(this.id, this.prefix, this.markers, this.elementType, this.annotations, this.dimension, type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public TypeTree getElementType() {
            return this.elementType;
        }

        @Nullable
        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Nullable
        @Generated
        public JLeftPadded<Space> getDimension() {
            return this.dimension;
        }

        @Override
        @Generated
        public JavaType getType() {
            return this.type;
        }
    }

    public static final class ArrayAccess
    implements J,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression indexed;
        private final ArrayDimension dimension;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayAccess(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ArrayAccess(UUID id, Space prefix, Markers markers, Expression indexed, ArrayDimension dimension, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.indexed = indexed;
            this.dimension = dimension;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getIndexed() {
            return this.indexed;
        }

        @Generated
        public ArrayDimension getDimension() {
            return this.dimension;
        }

        @Override
        @Nullable
        @Generated
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public ArrayAccess withId(UUID id) {
            return this.id == id ? this : new ArrayAccess(id, this.prefix, this.markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayAccess(this.id, prefix, this.markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayAccess(this.id, this.prefix, markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayAccess withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new ArrayAccess(this.id, this.prefix, this.markers, indexed, this.dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayAccess withDimension(ArrayDimension dimension) {
            return this.dimension == dimension ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, dimension, this.type);
        }

        @NonNull
        @Generated
        public ArrayAccess withType(@Nullable JavaType type) {
            return this.type == type ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, this.dimension, type);
        }
    }

    public static final class Annotation
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree annotationType;
        @Nullable
        private final JContainer<Expression> arguments;

        public String getSimpleName() {
            if (this.annotationType instanceof Identifier) {
                return ((Identifier)this.annotationType).getSimpleName();
            }
            if (this.annotationType instanceof FieldAccess) {
                return ((FieldAccess)this.annotationType).getSimpleName();
            }
            return this.annotationType.printTrimmed();
        }

        @Nullable
        public List<Expression> getArguments() {
            return this.arguments == null ? null : this.arguments.getElements();
        }

        public Annotation withArguments(@Nullable List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElementsNullable(this.arguments, arguments));
        }

        @Override
        public JavaType getType() {
            return this.annotationType.getType();
        }

        public Annotation withType(@Nullable JavaType type) {
            return this.withAnnotationType((NameTree)this.annotationType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotation(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Annotation getCoordinates() {
            return new CoordinateBuilder.Annotation(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation other = (Annotation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Annotation(UUID id, Space prefix, Markers markers, NameTree annotationType, @Nullable JContainer<Expression> arguments) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        @Generated
        private Annotation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, NameTree annotationType, @Nullable JContainer<Expression> arguments) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        @NonNull
        @Generated
        public Annotation withId(UUID id) {
            return this.id == id ? this : new Annotation(this.padding, id, this.prefix, this.markers, this.annotationType, this.arguments);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Annotation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Annotation(this.padding, this.id, prefix, this.markers, this.annotationType, this.arguments);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Annotation withMarkers(Markers markers) {
            return this.markers == markers ? this : new Annotation(this.padding, this.id, this.prefix, markers, this.annotationType, this.arguments);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Annotation withAnnotationType(NameTree annotationType) {
            return this.annotationType == annotationType ? this : new Annotation(this.padding, this.id, this.prefix, this.markers, annotationType, this.arguments);
        }

        @Generated
        public NameTree getAnnotationType() {
            return this.annotationType;
        }

        public static class Padding {
            private final Annotation t;

            @Nullable
            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public Annotation withArguments(@Nullable JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new Annotation(this.t.id, this.t.prefix, this.t.markers, this.t.annotationType, arguments);
            }

            @Generated
            public Padding(Annotation t) {
                this.t = t;
            }
        }
    }

    public static final class AnnotatedType
    implements J,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final TypeTree typeExpression;

        @Override
        public JavaType getType() {
            return this.typeExpression.getType();
        }

        public AnnotatedType withType(@Nullable JavaType type) {
            return this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        @Deprecated
        public List<Annotation> getAllAnnotations() {
            List<Annotation> moreAnnotations;
            List<Annotation> allAnnotations = this.annotations;
            if (this.typeExpression instanceof FieldAccess && !(moreAnnotations = ((FieldAccess)this.typeExpression).getName().getAnnotations()).isEmpty()) {
                if (allAnnotations.isEmpty()) {
                    allAnnotations = moreAnnotations;
                } else {
                    allAnnotations = new ArrayList<Annotation>(this.annotations);
                    allAnnotations.addAll(moreAnnotations);
                }
            }
            return allAnnotations;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotatedType(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedType)) {
                return false;
            }
            AnnotatedType other = (AnnotatedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public AnnotatedType(UUID id, Space prefix, Markers markers, List<Annotation> annotations, TypeTree typeExpression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeExpression = typeExpression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Generated
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        @Generated
        public AnnotatedType withId(UUID id) {
            return this.id == id ? this : new AnnotatedType(id, this.prefix, this.markers, this.annotations, this.typeExpression);
        }

        @NonNull
        @Generated
        public AnnotatedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AnnotatedType(this.id, prefix, this.markers, this.annotations, this.typeExpression);
        }

        @NonNull
        @Generated
        public AnnotatedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotatedType(this.id, this.prefix, markers, this.annotations, this.typeExpression);
        }

        @NonNull
        @Generated
        public AnnotatedType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedType(this.id, this.prefix, this.markers, annotations, this.typeExpression);
        }

        @NonNull
        @Generated
        public AnnotatedType withTypeExpression(TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new AnnotatedType(this.id, this.prefix, this.markers, this.annotations, typeExpression);
        }
    }
}

