/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.grammar.TemplateParameterLexer;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.internal.template.TemplateParameter;
import org.openrewrite.java.internal.template.TypeParameter;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;

public class Substitutions {
    private static final Pattern PATTERN_COMMENT = Pattern.compile("__p(\\d+)__");
    private final String code;
    private final Object[] parameters;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);

    public String substitute() {
        HashMap typedPatternByName;
        String previous;
        AtomicInteger requiredParameters = new AtomicInteger(0);
        AtomicInteger index = new AtomicInteger(0);
        String substituted = this.code;
        while (!(previous = substituted).equals(substituted = this.propertyPlaceholderHelper.replacePlaceholders(substituted, arg_0 -> this.lambda$substitute$0(typedPatternByName = new HashMap(), index, requiredParameters, arg_0)))) {
        }
        if (this.parameters.length != requiredParameters.get()) {
            throw new IllegalArgumentException("This template requires " + requiredParameters.get() + " parameters.");
        }
        return substituted;
    }

    private String substituteTypedPattern(String key, int index, TemplateParameterParser.TypedPatternContext typedPattern) {
        String s;
        Object parameter = this.parameters[index];
        String matcherName = typedPattern.patternType().matcherName().Identifier().getText();
        TemplateParameterParser.TypeContext param = typedPattern.patternType().type();
        if ("anyArray".equals(matcherName)) {
            JavaType.Array arrayType;
            if (!(parameter instanceof TypedTree)) {
                throw new IllegalArgumentException("anyArray can only be used on TypedTree parameters");
            }
            JavaType type = ((TypedTree)parameter).getType();
            if (type == null && parameter instanceof J.Empty && ((J.Empty)parameter).getMarkers().findFirst(TemplateParameter.class).isPresent()) {
                type = ((TemplateParameter)((J.Empty)parameter).getMarkers().findFirst(TemplateParameter.class).get()).getType();
            }
            if ((arrayType = TypeUtils.asArray(type)) == null && (arrayType = TypeUtils.asArray(type)) == null) {
                throw new IllegalArgumentException("anyArray can only be used on parameters containing JavaType.Array type attribution");
            }
            int dimensions = 1;
            while (arrayType.getElemType() instanceof JavaType.Array) {
                ++dimensions;
                arrayType = (JavaType.Array)arrayType.getElemType();
            }
            s = "(" + this.newArrayParameter(arrayType.getElemType(), dimensions, index) + ")";
        } else if ("any".equals(matcherName)) {
            JavaType type = param != null ? TypeParameter.toFullyQualifiedName(param) : (parameter instanceof J.NewClass && ((J.NewClass)parameter).getBody() != null && ((J.NewClass)parameter).getClazz() != null ? ((J.NewClass)parameter).getClazz().getType() : (parameter instanceof TypedTree ? ((TypedTree)parameter).getType() : null));
            String fqn = this.getTypeName(type);
            JavaType.Primitive primitive = JavaType.Primitive.fromKeyword(fqn);
            s = primitive == null || primitive.equals(JavaType.Primitive.String) ? this.newObjectParameter(fqn, index) : this.newPrimitiveParameter(fqn, index);
            this.parameters[index] = ((J)parameter).withPrefix(Space.EMPTY);
        } else {
            throw new IllegalArgumentException("Invalid template matcher '" + key + "'");
        }
        return s;
    }

    protected String newObjectParameter(String fqn, int index) {
        return "__P__.<" + fqn + ">/*__p" + index + "__*/p()";
    }

    protected String newPrimitiveParameter(String fqn, int index) {
        return "__P__./*__p" + index + "__*/" + fqn + "p()";
    }

    protected String newArrayParameter(JavaType elemType, int dimensions, int index) {
        StringBuilder builder = new StringBuilder("/*__p" + index + "__*/new ");
        if (elemType instanceof JavaType.Primitive) {
            builder.append(((JavaType.Primitive)elemType).getKeyword());
        } else if (elemType instanceof JavaType.FullyQualified) {
            builder.append(((JavaType.FullyQualified)elemType).getFullyQualifiedName().replace("$", "."));
        }
        for (int i = 0; i < dimensions; ++i) {
            builder.append("[0]");
        }
        return builder.toString();
    }

    private String getTypeName(@Nullable JavaType type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable genericTypeVariable = (JavaType.GenericTypeVariable)type;
            if (genericTypeVariable.getName().equals("?")) {
                return "java.lang.Object";
            }
            return TypeUtils.toString(type);
        }
        return TypeUtils.toString(type).replace("$", ".");
    }

    private String substituteUntyped(Object parameter, int index) {
        if (parameter instanceof J) {
            if (parameter instanceof J.Annotation) {
                return "@SubAnnotation(" + index + ")";
            }
            if (parameter instanceof J.Block) {
                return "/*__p" + index + "__*/{}";
            }
            if (parameter instanceof J.Literal || parameter instanceof J.VariableDeclarations) {
                return ((J)parameter).printTrimmed();
            }
            throw new IllegalArgumentException("Template parameter " + index + " cannot be used in an untyped template substitution. Instead of \"#{}\", indicate the template parameter's type with \"#{any(" + Substitutions.typeHintFor(parameter) + ")}\".");
        }
        if (parameter instanceof JRightPadded) {
            return this.substituteUntyped(((JRightPadded)parameter).getElement(), index);
        }
        if (parameter instanceof JLeftPadded) {
            return this.substituteUntyped(((JLeftPadded)parameter).getElement(), index);
        }
        return parameter.toString();
    }

    private static String typeHintFor(Object j) {
        if (j instanceof TypedTree) {
            return Substitutions.typeHintFor(((TypedTree)j).getType());
        }
        return "";
    }

    private static String typeHintFor(@Nullable JavaType t) {
        if (t instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)t).getKeyword();
        }
        if (t instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)t).getFullyQualifiedName();
        }
        return "";
    }

    public <J2 extends J> List<J2> unsubstitute(List<J2> js) {
        return ListUtils.map(js, this::unsubstitute);
    }

    public <J2 extends J> @Nullable J2 unsubstitute(J2 j) {
        if (this.parameters.length == 0) {
            return j;
        }
        J unsub = (J)new JavaVisitor<Integer>(){

            @Override
            public J visitAnnotation(J.Annotation annotation, Integer integer) {
                if (TypeUtils.isOfClassType(annotation.getType(), "SubAnnotation")) {
                    J.Literal index = (J.Literal)annotation.getArguments().get(0);
                    J a2 = (J)Substitutions.this.parameters[(Integer)index.getValue()];
                    return a2.withPrefix(a2.getPrefix().withWhitespace(annotation.getPrefix().getWhitespace()));
                }
                return super.visitAnnotation(annotation, integer);
            }

            @Override
            public J visitBlock(J.Block block, Integer integer) {
                J param = this.maybeParameter(block);
                if (param != null) {
                    return param;
                }
                return super.visitBlock(block, integer);
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                J param = this.maybeParameter(method.getName());
                if (param != null) {
                    return param;
                }
                return super.visitMethodInvocation(method, integer);
            }

            @Override
            public <T extends J> J visitParentheses(J.Parentheses<T> parens, Integer integer) {
                J param = this.maybeParameter((J)parens.getTree());
                if (param != null) {
                    return param;
                }
                return super.visitParentheses(parens, integer);
            }

            @Override
            public J visitLiteral(J.Literal literal, Integer integer) {
                J param = this.maybeParameter(literal);
                if (param != null) {
                    return param;
                }
                return super.visitLiteral(literal, integer);
            }

            private @Nullable J maybeParameter(J j) {
                Integer param = this.parameterIndex(j.getPrefix());
                if (param != null) {
                    J j2 = (J)Substitutions.this.parameters[param];
                    return j2.withPrefix(j2.getPrefix().withWhitespace(j.getPrefix().getWhitespace()));
                }
                return null;
            }

            private @Nullable Integer parameterIndex(Space space) {
                for (Comment comment : space.getComments()) {
                    Matcher matcher;
                    if (!(comment instanceof TextComment) || !(matcher = PATTERN_COMMENT.matcher(((TextComment)comment).getText())).matches()) continue;
                    return Integer.valueOf(matcher.group(1));
                }
                return null;
            }
        }.visit(j, 0);
        assert (unsub != null);
        return (J2)unsub;
    }

    @Generated
    public Substitutions(String code, Object[] parameters) {
        this.code = code;
        this.parameters = parameters;
    }

    @NonNull
    @Generated
    public String toString() {
        return "Substitutions(code=" + this.code + ", parameters=" + Arrays.deepToString(this.parameters) + ", propertyPlaceholderHelper=" + this.propertyPlaceholderHelper + ")";
    }

    private /* synthetic */ String lambda$substitute$0(Map typedPatternByName, AtomicInteger index, AtomicInteger requiredParameters, String key) {
        String s;
        if (!key.isEmpty()) {
            TemplateParameterParser parser = new TemplateParameterParser((TokenStream)new CommonTokenStream((TokenSource)new TemplateParameterLexer((CharStream)CharStreams.fromString((String)key))));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
            TemplateParameterParser.MatcherPatternContext ctx = parser.matcherPattern();
            TemplateParameterParser.TypedPatternContext typedPattern = ctx.typedPattern();
            if (typedPattern == null) {
                String paramName = ctx.parameterName().Identifier().getText();
                s = (String)typedPatternByName.get(paramName);
                if (s == null) {
                    throw new IllegalArgumentException("The parameter " + paramName + " must be defined before it is referenced.");
                }
            } else {
                int i = index.getAndIncrement();
                s = this.substituteTypedPattern(key, i, typedPattern);
                if (ctx.typedPattern().parameterName() != null) {
                    String paramName = ctx.typedPattern().parameterName().Identifier().getText();
                    typedPatternByName.put(paramName, s);
                }
                requiredParameters.incrementAndGet();
            }
        } else {
            int i = index.getAndIncrement();
            s = this.substituteUntyped(this.parameters[i], i);
            requiredParameters.incrementAndGet();
        }
        return s;
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new IllegalArgumentException(String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), e);
        }
    }
}

