/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class ShortenFullyQualifiedTypeReferences
extends Recipe {
    public String getDisplayName() {
        return "Add imports for fully qualified references to types";
    }

    public String getDescription() {
        return "Any fully qualified references to Java types will be replaced with corresponding simple names and import statements, provided that it doesn't result in any conflicts with other imports or types declared in the local compilation unit.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return ShortenFullyQualifiedTypeReferences.getVisitor(null);
    }

    public static TreeVisitor<?, ExecutionContext> modifyOnly(J subtree) {
        return ShortenFullyQualifiedTypeReferences.getVisitor(subtree);
    }

    @NonNull
    private static JavaVisitor<ExecutionContext> getVisitor(final @Nullable J scope) {
        return new JavaVisitor<ExecutionContext>(){
            final Map<String, JavaType> usedTypes = new HashMap<String, JavaType>();
            final JavaTypeSignatureBuilder signatureBuilder = new DefaultJavaTypeSignatureBuilder();
            boolean modify = scope == null;

            private void ensureInitialized() {
                if (!this.usedTypes.isEmpty()) {
                    return;
                }
                SourceFile sourceFile = (SourceFile)this.getCursor().firstEnclosing(SourceFile.class);
                if (sourceFile instanceof JavaSourceFile) {
                    JavaIsoVisitor<Map<String, JavaType>> typeCollector = new JavaIsoVisitor<Map<String, JavaType>>(){

                        @Override
                        public J.Import visitImport(J.Import import_, Map<String, JavaType> types) {
                            if (!import_.isStatic() && TypeUtils.isWellFormedType(import_.getQualid().getType())) {
                                types.put(import_.getQualid().getSimpleName(), import_.getQualid().getType());
                            }
                            return import_;
                        }

                        @Override
                        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Map<String, JavaType> types) {
                            return fieldAccess;
                        }

                        @Override
                        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, Map<String, JavaType> types) {
                            types.put(((J.Identifier)typeParam.getName()).getSimpleName(), null);
                            return typeParam;
                        }

                        @Override
                        public J.Identifier visitIdentifier(J.Identifier identifier, Map<String, JavaType> types) {
                            JavaType type = identifier.getType();
                            if (type instanceof JavaType.FullyQualified && identifier.getFieldType() == null) {
                                types.put(identifier.getSimpleName(), type);
                            }
                            return identifier;
                        }
                    };
                    typeCollector.visit((Tree)sourceFile, this.usedTypes);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                boolean subtreeRoot;
                boolean bl = subtreeRoot = !this.modify && (scope.equals(tree) || scope.isScope(tree));
                if (subtreeRoot) {
                    this.modify = true;
                }
                try {
                    J j = (J)super.visit(tree, (Object)ctx);
                    return j;
                }
                finally {
                    if (subtreeRoot) {
                        this.modify = false;
                    }
                }
            }

            @Override
            public J visitImport(J.Import import_, ExecutionContext ctx) {
                return import_;
            }

            @Override
            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space;
            }

            @Override
            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                if (!this.modify) {
                    return super.visitFieldAccess(fieldAccess, ctx);
                }
                JavaType type = fieldAccess.getType();
                if (fieldAccess.getName().getFieldType() == null && type instanceof JavaType.Class && ((JavaType.Class)type).getOwningClass() == null) {
                    String fullyQualifiedName;
                    this.ensureInitialized();
                    String simpleName = fieldAccess.getSimpleName();
                    JavaType usedType = this.usedTypes.get(simpleName);
                    if (type == usedType || this.signatureBuilder.signature(type).equals(this.signatureBuilder.signature(usedType))) {
                        return fieldAccess.getName().withPrefix(fieldAccess.getPrefix());
                    }
                    if (!this.usedTypes.containsKey(simpleName) && !(fullyQualifiedName = ((JavaType.FullyQualified)type).getFullyQualifiedName()).startsWith("java.lang.")) {
                        this.maybeAddImport(fullyQualifiedName);
                        this.usedTypes.put(simpleName, type);
                        return fieldAccess.getName().withPrefix(fieldAccess.getPrefix());
                    }
                }
                return super.visitFieldAccess(fieldAccess, ctx);
            }
        };
    }
}

