/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.trait;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.trait.SimpleTraitMatcher;
import org.openrewrite.trait.Trait;

public class Literal
implements Trait<Expression> {
    private final Cursor cursor;
    private final ObjectMapper mapper;

    public boolean isNull() {
        if (this.getTree() instanceof J.Literal) {
            return ((J.Literal)this.getTree()).getValue() == null;
        }
        if (this.getTree() instanceof J.NewArray) {
            J.NewArray newArray = (J.NewArray)this.getTree();
            return newArray.getInitializer() == null;
        }
        return true;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean isArray() {
        return this.getTree() instanceof J.NewArray;
    }

    public @Nullable String getString() {
        if (this.getTree() instanceof J.NewArray) {
            return null;
        }
        return this.getValue(String.class);
    }

    public List<String> getStrings() {
        if (this.getTree() instanceof J.Literal) {
            String stringValue = this.getString();
            return stringValue == null ? Collections.emptyList() : Collections.singletonList(stringValue);
        }
        List<String> result = this.getValue(new TypeReference<List<String>>(){});
        return result == null ? Collections.emptyList() : result;
    }

    public <T> @Nullable T getValue(Class<T> type) {
        return this.getValue(this.mapper.constructType(type));
    }

    public <T> @Nullable T getValue(TypeReference<T> type) {
        return this.getValue(this.mapper.constructType(type));
    }

    public <T> @Nullable T getValue(JavaType type) {
        Expression lit = (Expression)this.getTree();
        if (lit instanceof J.Literal) {
            J.Literal literal = (J.Literal)lit;
            if (literal.getValue() == null) {
                return null;
            }
            if (type.isCollectionLikeType()) {
                List<Object> l = Collections.singletonList(literal.getValue());
                return (T)this.mapper.convertValue(l, type);
            }
            return (T)this.mapper.convertValue(literal.getValue(), type);
        }
        if (lit instanceof J.NewArray) {
            List<Object> untyped = this.untypedInitializerLiterals((J.NewArray)lit);
            return (T)this.mapper.convertValue(untyped, type);
        }
        return null;
    }

    private List<Object> untypedInitializerLiterals(J.NewArray newArray) {
        ArrayList<Object> acc = new ArrayList<Object>();
        for (Expression init : Objects.requireNonNull(newArray.getInitializer())) {
            if (init instanceof J.Literal) {
                acc.add(((J.Literal)init).getValue());
                continue;
            }
            acc.add(this.untypedInitializerLiterals((J.NewArray)init));
        }
        return acc;
    }

    @Generated
    public Literal(Cursor cursor, ObjectMapper mapper) {
        this.cursor = cursor;
        this.mapper = mapper;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    public static class Matcher
    extends SimpleTraitMatcher<Literal> {
        private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
        private ObjectMapper mapper = DEFAULT_MAPPER;

        public Matcher mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        protected @Nullable Literal test(Cursor cursor) {
            Object value = cursor.getValue();
            return value instanceof J.Literal || this.isNewArrayWithLiteralInitializer(value) ? new Literal(cursor, this.mapper) : null;
        }

        private boolean isNewArrayWithLiteralInitializer(Object value) {
            if (value instanceof J.NewArray) {
                List<Expression> init = ((J.NewArray)value).getInitializer();
                if (init == null) {
                    return false;
                }
                for (Expression expr : init) {
                    if (expr instanceof J.Literal || this.isNewArrayWithLiteralInitializer(expr)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

