/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Stack;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaKeywordUtils;
import org.openrewrite.java.cleanup.RenameJavaDocParamNameVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class RenameVariable<P>
extends JavaIsoVisitor<P> {
    private final J.VariableDeclarations.NamedVariable variable;
    private final String toName;

    public RenameVariable(J.VariableDeclarations.NamedVariable variable, String toName) {
        this.variable = variable;
        this.toName = toName;
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        if (!JavaKeywordUtils.isReservedKeyword(this.toName) && !JavaKeywordUtils.isReservedLiteral(this.toName) && !StringUtils.isBlank((String)this.toName) && variable.equals(this.variable)) {
            this.doAfterVisit(new RenameVariableVisitor(variable, this.toName));
            return variable;
        }
        return super.visitVariable(variable, (Object)p);
    }

    private class RenameVariableVisitor
    extends JavaIsoVisitor<P> {
        private final Stack<Tree> currentNameScope = new Stack();
        private final J.VariableDeclarations.NamedVariable renameVariable;
        private final String newName;

        @Override
        public J.Block visitBlock(J.Block block, P p) {
            if (this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.ClassDeclaration) {
                boolean isClassScope = false;
                for (Statement statement : block.getStatements()) {
                    if (!(statement instanceof J.VariableDeclarations) || !((J.VariableDeclarations)statement).getVariables().contains(this.renameVariable)) continue;
                    isClassScope = true;
                    break;
                }
                if (isClassScope) {
                    this.currentNameScope.add(block);
                }
            }
            return super.visitBlock(block, p);
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier ident, P p) {
            if (this.getCursor().dropParentUntil(it -> it instanceof Javadoc.Parameter || it instanceof Comment || it instanceof J.ClassDeclaration || it instanceof J.MethodDeclaration || it instanceof J.VariableDeclarations || it instanceof SourceFile).getValue() instanceof Javadoc.Parameter) {
                return ident;
            }
            Cursor parent = this.getCursor().getParentTreeCursor();
            if (ident.getSimpleName().equals(this.renameVariable.getSimpleName())) {
                if (parent.getValue() instanceof J.FieldAccess) {
                    if (this.fieldAccessTargetsVariable((J.FieldAccess)parent.getValue())) {
                        if (ident.getFieldType() != null) {
                            ident = ident.withFieldType(ident.getFieldType().withName(this.newName));
                        }
                        parent.putMessage("renamed", (Object)true);
                        return ident.withSimpleName(this.newName);
                    }
                } else if (this.currentNameScope.size() == 1 && this.isVariableName(parent.getValue(), ident)) {
                    if (parent.getValue() instanceof J.VariableDeclarations.NamedVariable) {
                        J.MethodDeclaration methodDeclaration;
                        Tree variableDeclaration = (Tree)parent.getParentTreeCursor().getValue();
                        J maybeParameter = (J)this.getCursor().dropParentUntil(is -> is instanceof JavaSourceFile || is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration).getValue();
                        if (maybeParameter instanceof J.MethodDeclaration && (methodDeclaration = (J.MethodDeclaration)maybeParameter).getParameters().contains((Statement)variableDeclaration) && methodDeclaration.getComments().stream().anyMatch(it -> it instanceof Javadoc.DocComment) && ((J.MethodDeclaration)maybeParameter).getMethodType() != null) {
                            this.doAfterVisit(new RenameJavaDocParamNameVisitor((J.MethodDeclaration)maybeParameter, this.renameVariable.getSimpleName(), this.newName));
                        }
                    }
                    if (ident.getFieldType() != null) {
                        ident = ident.withFieldType(ident.getFieldType().withName(this.newName));
                    }
                    parent.putMessage("renamed", (Object)true);
                    return ident.withSimpleName(this.newName);
                }
            }
            return super.visitIdentifier(ident, p);
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
            J m = super.visitMemberReference(memberRef, p);
            if (m != memberRef && ((J.MemberReference)m).getVariableType() != null && ((J.MemberReference)m).getVariableType().getName().equals(this.renameVariable.getSimpleName())) {
                m = ((J.MemberReference)m).withVariableType(((J.MemberReference)m).getVariableType().withName(this.newName));
            }
            return m;
        }

        private boolean isVariableName(Object value, J.Identifier ident) {
            if (value instanceof J.MethodInvocation) {
                J.MethodInvocation m = (J.MethodInvocation)value;
                return m.getName() != ident;
            }
            if (value instanceof J.NewClass) {
                J.NewClass m = (J.NewClass)value;
                return m.getClazz() != ident;
            }
            if (value instanceof J.NewArray) {
                J.NewArray a = (J.NewArray)value;
                return a.getTypeExpression() != ident;
            }
            if (value instanceof J.VariableDeclarations) {
                J.VariableDeclarations v = (J.VariableDeclarations)value;
                return ident != v.getTypeExpression();
            }
            return !(value instanceof J.ParameterizedType);
        }

        private boolean fieldAccessTargetsVariable(J.FieldAccess fieldAccess) {
            if (this.renameVariable.getName().getFieldType() != null) {
                Expression target = this.getTarget(fieldAccess);
                JavaType targetType = this.resolveType(target.getType());
                JavaType.Variable variableNameFieldType = this.renameVariable.getName().getFieldType();
                if (TypeUtils.isOfType(variableNameFieldType.getOwner(), targetType)) {
                    return true;
                }
                if (target instanceof J.TypeCast) {
                    return TypeUtils.isOfType(variableNameFieldType, targetType);
                }
                if (target instanceof J.Identifier) {
                    return TypeUtils.isOfType(variableNameFieldType, ((J.Identifier)target).getFieldType());
                }
            }
            return false;
        }

        private @Nullable Expression getTarget(J.FieldAccess fieldAccess) {
            Expression target = fieldAccess.getTarget();
            if (target instanceof J.Identifier) {
                return target;
            }
            if (target instanceof J.FieldAccess) {
                return this.getTarget((J.FieldAccess)target);
            }
            if (target instanceof J.Parentheses) {
                Object tree = ((J.Parentheses)target).getTree();
                if (tree instanceof J.TypeCast) {
                    return (J.TypeCast)tree;
                }
                return null;
            }
            return null;
        }

        private @Nullable JavaType resolveType(@Nullable JavaType type) {
            return type instanceof JavaType.Parameterized ? ((JavaType.Parameterized)type).getType() : type;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable namedVariable, P p) {
            boolean nameEquals = namedVariable.getSimpleName().equals(this.renameVariable.getSimpleName());
            if (nameEquals) {
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                if (this.currentNameScope.isEmpty()) {
                    if (namedVariable.equals(this.renameVariable)) {
                        this.currentNameScope.add((Tree)parentScope.getValue());
                    }
                } else if (!parentScope.getValue().equals(this.currentNameScope.peek()) && this.getCursor().isScopeInPath(this.currentNameScope.peek())) {
                    this.currentNameScope.add((Tree)parentScope.getValue());
                }
            }
            J v = super.visitVariable(namedVariable, p);
            if (nameEquals && ((J.VariableDeclarations.NamedVariable)v).getVariableType() != null && Boolean.TRUE.equals(this.getCursor().pollMessage("renamed"))) {
                v = ((J.VariableDeclarations.NamedVariable)v).withVariableType(((J.VariableDeclarations.NamedVariable)v).getVariableType().withName(this.newName));
            }
            return v;
        }

        @Override
        public J.Try.Catch visitCatch(J.Try.Catch _catch, P p) {
            this.maybeChangeNameScope((Tree)this.getCursorToParentScope(this.getCursor()).getValue());
            return super.visitCatch(_catch, p);
        }

        public @Nullable J postVisit(J tree, P p) {
            this.maybeChangeNameScope(tree);
            return (J)super.postVisit((Tree)tree, p);
        }

        private void maybeChangeNameScope(Tree tree) {
            if (!this.currentNameScope.isEmpty() && this.currentNameScope.peek().equals(tree)) {
                this.currentNameScope.pop();
            }
        }

        private Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof JavaSourceFile || is instanceof J.ClassDeclaration || is instanceof J.MethodDeclaration || is instanceof J.Block || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.Lambda);
        }

        @Generated
        public RenameVariableVisitor(J.VariableDeclarations.NamedVariable renameVariable2, String newName) {
            this.renameVariable = renameVariable2;
            this.newName = newName;
        }
    }
}

