/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.JavaTemplateLanguageExtension;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public class JavaTemplateJavaExtension
extends JavaTemplateLanguageExtension {
    private static final J.Block EMPTY_BLOCK = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded<Boolean>(false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.format(" "));

    public JavaTemplateJavaExtension(JavaTemplateParser templateParser, Substitutions substitutions, String substitutedTemplate, JavaCoordinates coordinates) {
        super(templateParser, substitutions, substitutedTemplate, coordinates);
    }

    @Override
    public TreeVisitor<? extends J, Integer> getMixin() {
        return new JavaVisitor<Integer>(){
            private boolean substituted;

            @Override
            public J visitAnnotation(J.Annotation annotation, Integer integer) {
                if (JavaTemplateJavaExtension.this.loc == Space.Location.ANNOTATION_PREFIX && JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT && this.isScope(annotation)) {
                    List<J.Annotation> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseAnnotations(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                    if (gen.isEmpty()) {
                        throw new IllegalStateException("Unable to parse annotation from template: \n" + JavaTemplateJavaExtension.this.substitutedTemplate + "\nUse JavaTemplate.Builder.doBeforeParseTemplate() to see what stub is being generated and include it in any bug report.");
                    }
                    return gen.get(0).withPrefix(annotation.getPrefix());
                }
                if (JavaTemplateJavaExtension.this.loc == Space.Location.ANNOTATION_ARGUMENTS && JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT && this.isScope(annotation)) {
                    List<J.Annotation> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseAnnotations(this.getCursor(), "@Example(" + JavaTemplateJavaExtension.this.substitutedTemplate + ")"));
                    return annotation.withArguments(gen.get(0).getArguments());
                }
                return super.visitAnnotation(annotation, integer);
            }

            @Override
            public J visitBlock(J.Block block, Integer p) {
                switch (JavaTemplateJavaExtension.this.loc) {
                    case BLOCK_END: {
                        if (!this.isScope(block)) break;
                        List<Statement> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseBlockStatements(new Cursor(this.getCursor(), (Object)JavaTemplateJavaExtension.this.insertionPoint), Statement.class, JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc, JavaTemplateJavaExtension.this.mode));
                        if (JavaTemplateJavaExtension.this.coordinates.getComparator() != null) {
                            J.Block b = block;
                            for (Statement g : gen) {
                                b = b.withStatements(ListUtils.insertInOrder(block.getStatements(), (Object)this.autoFormat(g, p, this.getCursor()), (Comparator)JavaTemplateJavaExtension.this.getComparatorOrThrow()));
                            }
                            return b;
                        }
                        return block.withStatements(ListUtils.concatAll(block.getStatements(), (List)ListUtils.map(gen, (i, s) -> this.autoFormat(s, p, this.getCursor()))));
                    }
                    case STATEMENT_PREFIX: {
                        return block.withStatements(ListUtils.flatMap(block.getStatements(), statement -> {
                            if (this.isScope((J)statement)) {
                                List<Statement> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseBlockStatements(new Cursor(this.getCursor(), (Object)JavaTemplateJavaExtension.this.insertionPoint), Statement.class, JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc, JavaTemplateJavaExtension.this.mode));
                                Cursor parent = this.getCursor();
                                for (int i = 0; i < gen.size(); ++i) {
                                    Statement s = gen.get(i);
                                    Statement formattedS = this.autoFormat(i == 0 ? (Statement)s.withPrefix(statement.getPrefix().withComments(Collections.emptyList())) : s, p, parent);
                                    gen.set(i, formattedS);
                                }
                                switch (JavaTemplateJavaExtension.this.mode) {
                                    case REPLACEMENT: {
                                        return gen;
                                    }
                                    case BEFORE: {
                                        return ListUtils.concat(gen, (Object)statement);
                                    }
                                    case AFTER: {
                                        return ListUtils.concat((Object)statement, gen);
                                    }
                                }
                            }
                            return statement;
                        }));
                    }
                }
                return super.visitBlock(block, p);
            }

            @Override
            public J visitClassDeclaration(J.ClassDeclaration classDecl, Integer p) {
                if (this.isScope(classDecl)) {
                    switch (JavaTemplateJavaExtension.this.loc) {
                        case ANNOTATIONS: {
                            List<J.Annotation> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseAnnotations(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            J.ClassDeclaration c = classDecl;
                            if (JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT) {
                                if ((c = c.withLeadingAnnotations(gen)).getTypeParameters() != null) {
                                    c = c.withTypeParameters(ListUtils.map(c.getTypeParameters(), tp -> tp.withAnnotations(Collections.emptyList())));
                                }
                                c = c.withModifiers(ListUtils.map(c.getModifiers(), m -> m.withAnnotations(Collections.emptyList())));
                                c = c.getPadding().withKind(c.getPadding().getKind().withAnnotations(Collections.emptyList()));
                            } else {
                                for (J.Annotation a : gen) {
                                    c = c.withLeadingAnnotations(ListUtils.insertInOrder(c.getLeadingAnnotations(), (Object)a, (Comparator)JavaTemplateJavaExtension.this.getComparatorOrThrow()));
                                }
                            }
                            return this.autoFormat(c, c.getName(), p, this.getCursor().getParentOrThrow());
                        }
                        case EXTENDS: {
                            TypeTree anExtends = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseExtends(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            J.ClassDeclaration c = classDecl.withExtends(anExtends);
                            c = c.getPadding().withExtends(c.getPadding().getExtends().withBefore(Space.format(" ")));
                            return c;
                        }
                        case IMPLEMENTS: {
                            List<TypeTree> implementings = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseImplements(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            List implementsTypes = implementings.stream().map(TypedTree::getType).map(TypeUtils::asFullyQualified).filter(Objects::nonNull).collect(Collectors.toList());
                            J.ClassDeclaration c = classDecl;
                            if (JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT) {
                                c = c.withImplements(implementings);
                                c = c.getPadding().withImplements(c.getPadding().getImplements().withBefore(Space.EMPTY));
                            } else {
                                c = c.withImplements(ListUtils.concatAll(c.getImplements(), implementings));
                            }
                            if (c.getType() != null) {
                                c = c.withType(((JavaType.Class)c.getType()).withInterfaces(ListUtils.concatAll(c.getType().getInterfaces(), implementsTypes)));
                            }
                            return this.autoFormat(c, c.getImplements().get(c.getImplements().size() - 1), p, this.getCursor().getParentOrThrow());
                        }
                        case TYPE_PARAMETERS: {
                            List<J.TypeParameter> typeParameters = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseTypeParameters(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            return classDecl.withTypeParameters(typeParameters);
                        }
                    }
                }
                return super.visitClassDeclaration(classDecl, p);
            }

            @Override
            public J visitExpression(Expression expression, Integer p) {
                if ((JavaTemplateJavaExtension.this.loc == Space.Location.EXPRESSION_PREFIX || JavaTemplateJavaExtension.this.loc == Space.Location.STATEMENT_PREFIX && expression instanceof Statement) && this.isScope(expression)) {
                    return this.autoFormat(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseExpression(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc)).withPrefix(expression.getPrefix()), p);
                }
                return expression;
            }

            @Override
            public J visitFieldAccess(J.FieldAccess fa, Integer p) {
                if (JavaTemplateJavaExtension.this.loc == Space.Location.FIELD_ACCESS_PREFIX && this.isScope(fa)) {
                    return this.autoFormat(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseExpression(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc)).withPrefix(fa.getPrefix()), p);
                }
                if (JavaTemplateJavaExtension.this.loc == Space.Location.STATEMENT_PREFIX && this.isScope(fa)) {
                    return this.autoFormat(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseExpression(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc)).withPrefix(fa.getPrefix()), p);
                }
                return super.visitFieldAccess(fa, p);
            }

            @Override
            public J visitIdentifier(J.Identifier ident, Integer p) {
                if (JavaTemplateJavaExtension.this.loc == Space.Location.IDENTIFIER_PREFIX && this.isScope(ident)) {
                    return this.autoFormat(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseExpression(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc)).withPrefix(ident.getPrefix()), p);
                }
                return super.visitIdentifier(ident, p);
            }

            @Override
            public J visitLambda(J.Lambda lambda, Integer p) {
                if (JavaTemplateJavaExtension.this.loc == Space.Location.LAMBDA_PARAMETERS_PREFIX && this.isScope(lambda.getParameters())) {
                    return lambda.withParameters(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseLambdaParameters(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate)));
                }
                return this.maybeReplaceStatement(lambda, J.class, 0);
            }

            @Override
            public J visitMethodDeclaration(J.MethodDeclaration method, Integer p) {
                if (this.isScope(method)) {
                    switch (JavaTemplateJavaExtension.this.loc) {
                        case ANNOTATIONS: {
                            List<J.Annotation> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseAnnotations(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            J.MethodDeclaration m = method;
                            if (JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT) {
                                m = method.withLeadingAnnotations(gen);
                                if (m.getTypeParameters() != null) {
                                    m = m.withTypeParameters(ListUtils.map(m.getTypeParameters(), tp -> tp.withAnnotations(Collections.emptyList())));
                                }
                                if (m.getReturnTypeExpression() instanceof J.AnnotatedType) {
                                    m = m.withReturnTypeExpression(((J.AnnotatedType)m.getReturnTypeExpression()).getTypeExpression());
                                }
                                m = m.withModifiers(ListUtils.map(m.getModifiers(), m2 -> m2.withAnnotations(Collections.emptyList())));
                                m = m.getAnnotations().withName(m.getAnnotations().getName().withAnnotations(Collections.emptyList()));
                            } else {
                                for (J.Annotation a : gen) {
                                    m = m.withLeadingAnnotations(ListUtils.insertInOrder(m.getLeadingAnnotations(), (Object)a, (Comparator)JavaTemplateJavaExtension.this.getComparatorOrThrow()));
                                }
                            }
                            return this.autoFormat(m, m.getName(), p, this.getCursor().getParentOrThrow());
                        }
                        case BLOCK_PREFIX: {
                            List<Statement> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseBlockStatements(this.getCursor(), Statement.class, JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc, JavaTemplateJavaExtension.this.mode));
                            J.Block body = method.getBody();
                            if (body == null) {
                                body = EMPTY_BLOCK;
                            }
                            body = body.withStatements(gen);
                            return method.withBody(this.autoFormat(body, p, this.getCursor()));
                        }
                        case METHOD_DECLARATION_PARAMETERS: {
                            List<Statement> parameters = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseParameters(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            JavaType.Method type = method.getMethodType();
                            if (type != null) {
                                ArrayList<String> paramNames = new ArrayList<String>(parameters.size());
                                ArrayList<JavaType> paramTypes = new ArrayList<JavaType>(parameters.size());
                                for (Statement statement : parameters) {
                                    if (!(statement instanceof J.VariableDeclarations)) {
                                        throw new IllegalArgumentException("Only variable declarations may be part of a method declaration's parameter list:" + statement.print(this.getCursor()));
                                    }
                                    J.VariableDeclarations decl = (J.VariableDeclarations)statement;
                                    if (decl.getVariables().size() != 1) {
                                        throw new IllegalArgumentException("Multi-variable declarations may not be used in a method declaration's parameter list: " + statement.print(this.getCursor()));
                                    }
                                    J.VariableDeclarations.NamedVariable namedVariable = decl.getVariables().get(0);
                                    paramNames.add(namedVariable.getSimpleName());
                                    if (namedVariable.getType() == null && decl.getTypeExpression() instanceof J.Identifier) {
                                        J.Identifier declTypeIdent = (J.Identifier)decl.getTypeExpression();
                                        String typeParameterName = declTypeIdent.getSimpleName();
                                        List<Object> typeParameters = method.getTypeParameters() == null ? Collections.emptyList() : method.getTypeParameters();
                                        for (J.TypeParameter typeParameter : typeParameters) {
                                            J.Identifier typeParamIdent = (J.Identifier)typeParameter.getName();
                                            if (!typeParamIdent.getSimpleName().equals(typeParameterName)) continue;
                                            List<TypeTree> bounds = typeParameter.getBounds();
                                            JavaType.FullyQualified bound = bounds == null || bounds.isEmpty() ? JavaType.ShallowClass.build("java.lang.Object") : (JavaType.FullyQualified)((Object)bounds.get(0));
                                            JavaType.GenericTypeVariable genericType = new JavaType.GenericTypeVariable(null, typeParamIdent.getSimpleName(), JavaType.GenericTypeVariable.Variance.COVARIANT, Collections.singletonList(bound));
                                            paramTypes.add(genericType);
                                        }
                                        continue;
                                    }
                                    paramTypes.add(namedVariable.getType());
                                }
                                type = type.withParameterNames(paramNames).withParameterTypes(paramTypes);
                            }
                            return method.withParameters(parameters).withMethodType(type).withName(method.getName().withType(type));
                        }
                        case THROWS: {
                            J.MethodDeclaration m = method.withThrows(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseThrows(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate)));
                            JavaType.Method type = m.getMethodType();
                            if (type != null) {
                                ArrayList<JavaType> newThrows = new ArrayList<JavaType>();
                                List<Object> throws_ = m.getThrows() == null ? Collections.emptyList() : m.getThrows();
                                for (NameTree nameTree : throws_) {
                                    J.Identifier exceptionIdent = (J.Identifier)nameTree;
                                    newThrows.add(exceptionIdent.getType());
                                }
                                type = type.withThrownExceptions(newThrows);
                            }
                            m = m.getPadding().withThrows(m.getPadding().getThrows().withBefore(Space.format(" "))).withMethodType(type).withName(method.getName().withType(type));
                            return m;
                        }
                        case TYPE_PARAMETERS: {
                            List<J.TypeParameter> typeParameters = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseTypeParameters(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                            J.MethodDeclaration m = method.withTypeParameters(typeParameters);
                            if (m.getName().getType() != null) {
                                m = m.withName(method.getName().withType(m.getMethodType()));
                            }
                            return this.autoFormat(m, typeParameters.get(typeParameters.size() - 1), p, this.getCursor().getParentOrThrow());
                        }
                    }
                }
                return super.visitMethodDeclaration(method, p);
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                if ((JavaTemplateJavaExtension.this.loc == Space.Location.METHOD_INVOCATION_ARGUMENTS || JavaTemplateJavaExtension.this.loc == Space.Location.METHOD_INVOCATION_NAME) && this.isScope(method)) {
                    J.MethodInvocation m;
                    if (JavaTemplateJavaExtension.this.loc == Space.Location.METHOD_INVOCATION_ARGUMENTS) {
                        m = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseMethodArguments(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc));
                        m = this.autoFormat(m, 0);
                        m = ((J.MethodInvocation)method.withArguments((List)m.getArguments())).withMethodType(m.getMethodType());
                    } else {
                        m = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseMethod(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc));
                        m = this.autoFormat(m, 0);
                        m = ((J.MethodInvocation)method.withName(m.getName()).withArguments((List)m.getArguments())).withMethodType(m.getMethodType());
                    }
                    JavaType.Method mt = method.getMethodType();
                    if (m.getMethodType() == null && mt != null) {
                        List<JavaType> argTypes = m.getArguments().stream().map(Expression::getType).map(it -> {
                            if (it == JavaType.Primitive.String) {
                                return JavaType.ShallowClass.build("java.lang.String");
                            }
                            return it;
                        }).collect(Collectors.toList());
                        mt = mt.withParameterTypes(argTypes);
                        m = m.withMethodType(mt);
                    }
                    if (m.getName().getType() != null) {
                        m = m.withName(m.getName().withType(m.getType()));
                    }
                    return m;
                }
                return this.maybeReplaceStatement(method, J.class, 0);
            }

            @Override
            public J visitNewClass(J.NewClass newClass, Integer p) {
                if (this.isScope(newClass)) {
                    return this.maybeReplaceStatement(newClass, J.class, p);
                }
                return super.visitNewClass(newClass, p);
            }

            @Override
            public J visitPackage(J.Package pkg, Integer integer) {
                if (JavaTemplateJavaExtension.this.loc == Space.Location.PACKAGE_PREFIX && this.isScope(pkg)) {
                    return pkg.withExpression(this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parsePackage(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate)));
                }
                return super.visitPackage(pkg, integer);
            }

            @Override
            public J visitStatement(Statement statement, Integer p) {
                return this.maybeReplaceStatement(statement, Statement.class, p);
            }

            private <J3 extends J> J3 maybeReplaceStatement(Statement statement, Class<J3> expected, Integer p) {
                if (JavaTemplateJavaExtension.this.loc == Space.Location.STATEMENT_PREFIX && this.isScope(statement)) {
                    if (JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT) {
                        List<J3> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseBlockStatements(this.getCursor(), expected, JavaTemplateJavaExtension.this.substitutedTemplate, JavaTemplateJavaExtension.this.substitutions.getTypeVariables(), JavaTemplateJavaExtension.this.loc, JavaTemplateJavaExtension.this.mode));
                        if (gen.size() != 1) {
                            if (gen.size() == 2) {
                                if (gen.get(0) instanceof J.Empty) {
                                    return (J3)this.autoFormat(((J)gen.get(1)).withPrefix(statement.getPrefix()), p);
                                }
                                if (gen.get(1) instanceof J.Empty) {
                                    return (J3)this.autoFormat(((J)gen.get(0)).withPrefix(statement.getPrefix()), p);
                                }
                            }
                            throw new IllegalArgumentException("Expected a template that would generate exactly one statement to replace one statement, but generated " + gen.size() + ". Template:\n" + JavaTemplateJavaExtension.this.substitutedTemplate + "\nSubstitutions:\n" + JavaTemplateJavaExtension.this.substitutions + "\nStatement:\n" + statement);
                        }
                        return (J3)this.autoFormat(((J)gen.get(0)).withPrefix(statement.getPrefix()), p);
                    }
                    throw new IllegalArgumentException("Cannot insert a new statement before an existing statement and return both to a visit method that returns one statement.");
                }
                return (J3)super.visitStatement(statement, p);
            }

            @Override
            public J visitVariableDeclarations(J.VariableDeclarations multiVariable, Integer p) {
                if (this.isScope(multiVariable) && JavaTemplateJavaExtension.this.loc == Space.Location.ANNOTATIONS) {
                    J.VariableDeclarations v = multiVariable;
                    List<J.Annotation> gen = this.unsubstitute(JavaTemplateJavaExtension.this.templateParser.parseAnnotations(this.getCursor(), JavaTemplateJavaExtension.this.substitutedTemplate));
                    if (JavaTemplateJavaExtension.this.mode == JavaCoordinates.Mode.REPLACEMENT) {
                        if ((v = v.withLeadingAnnotations(gen)).getTypeExpression() instanceof J.AnnotatedType) {
                            v = v.withTypeExpression(((J.AnnotatedType)v.getTypeExpression()).getTypeExpression());
                        }
                        v = v.withModifiers(ListUtils.map(v.getModifiers(), m -> m.withAnnotations(Collections.emptyList())));
                    } else {
                        for (J.Annotation a : gen) {
                            v = v.withLeadingAnnotations(ListUtils.insertInOrder(v.getLeadingAnnotations(), (Object)a, (Comparator)JavaTemplateJavaExtension.this.getComparatorOrThrow()));
                        }
                    }
                    return this.autoFormat(v, v.getTypeExpression(), p, this.getCursor().getParentOrThrow());
                }
                return super.visitVariableDeclarations(multiVariable, p);
            }

            private boolean isScope(J test) {
                return !this.substituted && test.isScope(JavaTemplateJavaExtension.this.insertionPoint);
            }

            private <J2 extends J> @Nullable J2 unsubstitute(J2 j) {
                try {
                    J2 J2 = JavaTemplateJavaExtension.this.substitutions.unsubstitute(j);
                    return J2;
                }
                finally {
                    this.substituted = true;
                }
            }

            private <J2 extends J> List<J2> unsubstitute(List<J2> js) {
                try {
                    List<J2> list = JavaTemplateJavaExtension.this.substitutions.unsubstitute(js);
                    return list;
                }
                finally {
                    this.substituted = true;
                }
            }
        };
    }

    private <J2 extends J> Comparator<J2> getComparatorOrThrow() {
        return Objects.requireNonNull(this.coordinates.getComparator());
    }
}

