/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.CompileErrors;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class FindCompileErrors
extends Recipe {
    transient CompileErrors report = new CompileErrors(this);

    public String getDisplayName() {
        return "Find compile errors";
    }

    public String getDescription() {
        return "Compile errors result in a particular LST structure that can be searched for.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Erroneous visitErroneous(J.Erroneous erroneous, ExecutionContext ctx) {
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
                String sourceFile = cu != null ? cu.getSourcePath().toString() : "Unknown source file";
                String code = erroneous.print(this.getCursor());
                FindCompileErrors.this.report.insertRow(ctx, new CompileErrors.Row(sourceFile, code));
                return (J.Erroneous)SearchResult.found((Tree)erroneous);
            }
        };
    }
}

