/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.imports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.FileContents;
import org.openrewrite.tools.checkstyle.api.FullIdent;
import org.openrewrite.tools.checkstyle.api.TextBlock;
import org.openrewrite.tools.checkstyle.checks.javadoc.JavadocTag;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.JavadocUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@FileStatefulCheck
public class UnusedImportsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.unused";
    private static final Pattern CLASS_NAME = CommonUtil.createPattern("((:?[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)");
    private static final Pattern FIRST_CLASS_NAME = CommonUtil.createPattern("^" + CLASS_NAME);
    private static final Pattern ARGUMENT_NAME = CommonUtil.createPattern("[(,]\\s*" + CLASS_NAME.pattern());
    private static final Pattern JAVA_LANG_PACKAGE_PATTERN = CommonUtil.createPattern("^java\\.lang\\.[a-zA-Z]+$");
    private static final String STAR_IMPORT_SUFFIX = ".*";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private boolean collect;
    private boolean processJavadoc = true;
    private Frame currentFrame;

    public void setProcessJavadoc(boolean value) {
        this.processJavadoc = value;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.collect = false;
        this.currentFrame = Frame.compilationUnit();
        this.imports.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        this.currentFrame.finish();
        this.imports.stream().filter(imprt -> this.isUnusedImport(imprt.getText())).forEach(imprt -> this.log(imprt.getDetailAst(), MSG_KEY, imprt.getText()));
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 30, 152, 16, 157, 161, 154, 155, 14, 15, 9, 8, 10, 199, 203, 6, 7};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 58: {
                if (!this.collect) break;
                this.processIdent(ast);
                break;
            }
            case 30: {
                this.processImport(ast);
                break;
            }
            case 152: {
                this.processStaticImport(ast);
                break;
            }
            case 6: 
            case 7: {
                this.currentFrame = this.currentFrame.push();
                break;
            }
            default: {
                this.collect = true;
                if (!this.processJavadoc) break;
                this.collectReferencesFromJavadoc(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (TokenUtil.isOfType(ast, 6, 7)) {
            this.currentFrame = this.currentFrame.pop();
        }
    }

    private boolean isUnusedImport(String imprt) {
        Matcher javaLangPackageMatcher = JAVA_LANG_PACKAGE_PATTERN.matcher(imprt);
        return !this.currentFrame.isReferencedType(CommonUtil.baseClassName(imprt)) || javaLangPackageMatcher.matches();
    }

    private void processIdent(DetailAST ast) {
        boolean isQualifiedIdent;
        DetailAST parent = ast.getParent();
        int parentType = parent.getType();
        boolean isPossibleDotClassOrInMethod = parentType == 59 || parentType == 9;
        boolean bl = isQualifiedIdent = parentType == 59 && !TokenUtil.isOfType(ast.getPreviousSibling(), 59) && ast.getNextSibling() != null;
        if (TokenUtil.isTypeDeclaration(parentType)) {
            this.currentFrame.addDeclaredType(ast.getText());
        } else if (!isPossibleDotClassOrInMethod || isQualifiedIdent) {
            this.currentFrame.addReferencedType(ast.getText());
        }
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        if (!name.getText().endsWith(STAR_IMPORT_SUFFIX)) {
            this.imports.add(name);
        }
    }

    private void processStaticImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (!name.getText().endsWith(STAR_IMPORT_SUFFIX)) {
            this.imports.add(name);
        }
    }

    private void collectReferencesFromJavadoc(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock textBlock = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (textBlock != null) {
            this.currentFrame.addReferencedTypes(UnusedImportsCheck.collectReferencesFromJavadoc(textBlock));
        }
    }

    private static Set<String> collectReferencesFromJavadoc(TextBlock textBlock) {
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        tags.addAll(UnusedImportsCheck.getValidTags(textBlock, JavadocUtil.JavadocTagType.INLINE));
        tags.addAll(UnusedImportsCheck.getValidTags(textBlock, JavadocUtil.JavadocTagType.BLOCK));
        HashSet<String> references = new HashSet<String>();
        tags.stream().filter(JavadocTag::canReferenceImports).forEach(tag -> references.addAll(UnusedImportsCheck.processJavadocTag(tag)));
        return references;
    }

    private static List<JavadocTag> getValidTags(TextBlock cmt, JavadocUtil.JavadocTagType tagType) {
        return JavadocUtil.getJavadocTags(cmt, tagType).getValidTags();
    }

    private static Set<String> processJavadocTag(JavadocTag tag) {
        HashSet<String> references = new HashSet<String>();
        String identifier = tag.getFirstArg().trim();
        for (Pattern pattern : new Pattern[]{FIRST_CLASS_NAME, ARGUMENT_NAME}) {
            references.addAll(UnusedImportsCheck.matchPattern(identifier, pattern));
        }
        return references;
    }

    private static Set<String> matchPattern(String identifier, Pattern pattern) {
        HashSet<String> references = new HashSet<String>();
        Matcher matcher = pattern.matcher(identifier);
        while (matcher.find()) {
            references.add(UnusedImportsCheck.topLevelType(matcher.group(1)));
        }
        return references;
    }

    private static String topLevelType(String type) {
        int dotIndex = type.indexOf(46);
        String topLevelType = dotIndex == -1 ? type : type.substring(0, dotIndex);
        return topLevelType;
    }

    private static final class Frame {
        private final Frame parent;
        private final Set<String> declaredTypes;
        private final Set<String> referencedTypes;

        private Frame(Frame parent) {
            this.parent = parent;
            this.declaredTypes = new HashSet<String>();
            this.referencedTypes = new HashSet<String>();
        }

        public void addDeclaredType(String type) {
            this.declaredTypes.add(type);
        }

        public void addReferencedType(String type) {
            this.referencedTypes.add(type);
        }

        public void addReferencedTypes(Collection<String> types) {
            this.referencedTypes.addAll(types);
        }

        public void finish() {
            this.referencedTypes.removeAll(this.declaredTypes);
        }

        public Frame push() {
            return new Frame(this);
        }

        public Frame pop() {
            this.finish();
            this.parent.addReferencedTypes(this.referencedTypes);
            return this.parent;
        }

        public boolean isReferencedType(String type) {
            return this.referencedTypes.contains(type);
        }

        public static Frame compilationUnit() {
            return new Frame(null);
        }
    }
}

