/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.lang.reflect.Array;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.openrewrite.java.internal.parser.AnnotationAttributeApplier;
import org.openrewrite.java.internal.parser.AnnotationDeserializer;

class AnnotationSerializer {
    AnnotationSerializer() {
    }

    public static String serializeSimpleAnnotation(String annotationDescriptor) {
        return "@" + annotationDescriptor;
    }

    public static String serializeBoolean(boolean value) {
        return "Z" + value;
    }

    public static String serializeChar(char value) {
        return "C" + value;
    }

    public static String serializeNumber(Number value) {
        if (value instanceof Byte) {
            return "B" + value;
        }
        if (value instanceof Short) {
            return "S" + value;
        }
        if (value instanceof Integer) {
            return "I" + value;
        }
        if (value instanceof Long) {
            return "J" + value;
        }
        if (value instanceof Float) {
            return "F" + value;
        }
        if (value instanceof Double) {
            return "D" + value;
        }
        return "I" + value;
    }

    public static String serializeLong(long value) {
        return "J" + value;
    }

    public static String serializeFloat(float value) {
        return "F" + value;
    }

    public static String serializeDouble(double value) {
        return "D" + value;
    }

    public static String serializeClassConstant(Type type) {
        return "c" + type.getDescriptor();
    }

    public static String serializeEnumConstant(String enumDescriptor, String enumConstant) {
        return "e" + enumDescriptor + "." + enumConstant;
    }

    public static String serializeArray(String[] values) {
        if (values.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(values[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String serializeAnnotationWithAttributes(String annotationDescriptor, String[] attributes) {
        if (attributes.length == 0) {
            return AnnotationSerializer.serializeSimpleAnnotation(annotationDescriptor);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(annotationDescriptor).append("(");
        for (int i = 0; i < attributes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(attributes[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String serializeAttribute(String name, String value) {
        return name + "=" + value;
    }

    static String serializeValue(Object value) {
        return AnnotationSerializer.serializeValueInternal(value);
    }

    public static String convertAnnotationValueToString(Object value) {
        return AnnotationSerializer.serializeValueInternal(value);
    }

    public static String convertConstantValueWithType(Object value, String descriptor) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            switch (descriptor) {
                case "Z": {
                    return "Z" + (intValue != 0 ? "true" : "false");
                }
                case "C": {
                    return "C" + intValue;
                }
                case "B": {
                    return "B" + intValue;
                }
                case "S": {
                    return "S" + intValue;
                }
                case "I": {
                    return "I" + intValue;
                }
            }
            return AnnotationSerializer.convertAnnotationValueToString(value);
        }
        return AnnotationSerializer.convertAnnotationValueToString(value);
    }

    private static String serializeValueInternal(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "s\"" + AnnotationSerializer.escapeStringContentForTsv((String)value) + "\"";
        }
        if (value instanceof Type) {
            return AnnotationSerializer.serializeClassConstant((Type)value);
        }
        if (value.getClass().isArray()) {
            return AnnotationSerializer.serializeArrayValue(value);
        }
        if (value instanceof Boolean) {
            return AnnotationSerializer.serializeBoolean((Boolean)value);
        }
        if (value instanceof Character) {
            return AnnotationSerializer.serializeChar(((Character)value).charValue());
        }
        if (value instanceof Number) {
            return AnnotationSerializer.serializeNumericValue((Number)value);
        }
        return String.valueOf(value);
    }

    private static String escapeStringContentForTsv(String content) {
        StringBuilder sb = null;
        int start = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            String replacement = null;
            switch (c) {
                case '\\': {
                    replacement = "\\\\";
                    break;
                }
                case '\n': {
                    replacement = "\\n";
                    break;
                }
                case '\r': {
                    replacement = "\\r";
                    break;
                }
                case '\t': {
                    replacement = "\\t";
                    break;
                }
                case '\b': {
                    replacement = "\\b";
                    break;
                }
                case '\f': {
                    replacement = "\\f";
                    break;
                }
                case '\"': {
                    replacement = "\\\"";
                }
            }
            if (replacement != null) {
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append(content, start, i);
                }
                sb.append(replacement);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? content : sb.toString();
    }

    private static String serializeArrayValue(Object value) {
        StringBuilder elements = new StringBuilder();
        elements.append('[');
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    elements.append(',');
                }
                elements.append(AnnotationSerializer.serializeValueInternal(array[i]));
            }
        } else {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    elements.append(',');
                }
                elements.append(AnnotationSerializer.serializeValueInternal(Array.get(value, i)));
            }
        }
        elements.append(']');
        return elements.toString();
    }

    private static String serializeNumericValue(Number value) {
        if (value instanceof Long) {
            return AnnotationSerializer.serializeLong((Long)value);
        }
        if (value instanceof Float) {
            return AnnotationSerializer.serializeFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return AnnotationSerializer.serializeDouble((Double)value);
        }
        return AnnotationSerializer.serializeNumber(value);
    }

    public static void processAnnotationDefaultValue(AnnotationVisitor annotationDefaultVisitor, Object value) {
        if (value.getClass().isArray()) {
            AnnotationVisitor arrayVisitor = annotationDefaultVisitor.visitArray(null);
            for (Object v : (Object[])value) {
                AnnotationSerializer.processAnnotationDefaultValue(arrayVisitor, v);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof AnnotationDeserializer.ClassConstant) {
            annotationDefaultVisitor.visit(null, (Object)Type.getType((String)((AnnotationDeserializer.ClassConstant)value).getDescriptor()));
        } else if (value instanceof AnnotationDeserializer.EnumConstant) {
            AnnotationDeserializer.EnumConstant enumConstant = (AnnotationDeserializer.EnumConstant)value;
            annotationDefaultVisitor.visitEnum(null, enumConstant.getEnumDescriptor(), enumConstant.getConstantName());
        } else if (value instanceof AnnotationDeserializer.FieldConstant) {
            AnnotationDeserializer.FieldConstant fieldConstant = (AnnotationDeserializer.FieldConstant)value;
            annotationDefaultVisitor.visitEnum(null, fieldConstant.getClassName(), fieldConstant.getFieldName());
        } else if (value instanceof AnnotationDeserializer.AnnotationInfo) {
            AnnotationDeserializer.AnnotationInfo annotationInfo = (AnnotationDeserializer.AnnotationInfo)value;
            AnnotationVisitor nestedVisitor = annotationDefaultVisitor.visitAnnotation(null, annotationInfo.getDescriptor());
            AnnotationAttributeApplier.applyAttributes(nestedVisitor, annotationInfo.getAttributes());
            nestedVisitor.visitEnd();
        } else {
            annotationDefaultVisitor.visit(null, value);
        }
    }
}

