/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Year;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.java.internal.parser.AnnotationDeserializer;
import org.openrewrite.java.internal.parser.TypeTable;

public class InlineMethodCallsRecipeGenerator {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: InlineMethodCallsRecipeGenerator <input-tsv-path> <output-yaml-path> <recipe-name>");
            System.exit(1);
        }
        Path inputPath = Paths.get(args[0], new String[0]);
        Path outputPath = Paths.get(args[1], new String[0]);
        String recipeName = args[2];
        InlineMethodCallsRecipeGenerator.generate(inputPath, outputPath, recipeName);
    }

    static void generate(Path tsvFile, Path outputPath, String recipeName) {
        ArrayList<InlineMeMethod> inlineMethods = new ArrayList<InlineMeMethod>();
        TypeTable.Reader reader = new TypeTable.Reader((ExecutionContext)new InMemoryExecutionContext());
        try (InputStream is = Files.newInputStream(tsvFile, new OpenOption[0]);
             GZIPInputStream inflate = new GZIPInputStream(is);){
            reader.parseTsvAndProcess(inflate, TypeTable.Reader.Options.matchAll(), (gav, classes, nestedTypes) -> {
                if (gav == null) {
                    return;
                }
                for (TypeTable.ClassDefinition classDef : classes.values()) {
                    for (TypeTable.Member member : classDef.getMembers()) {
                        InlineMeMethod inlineMethod;
                        String annotations = member.getAnnotations();
                        if (annotations == null || !annotations.contains("InlineMe") || (inlineMethod = InlineMethodCallsRecipeGenerator.extractInlineMeMethod(gav, classDef, member)) == null) continue;
                        inlineMethods.add(inlineMethod);
                    }
                }
            });
            InlineMethodCallsRecipeGenerator.generateYamlRecipes(inlineMethods, outputPath, recipeName);
            System.out.println("Generated " + inlineMethods.size() + " inline recipes to " + outputPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static @Nullable InlineMeMethod extractInlineMeMethod(TypeTable.GroupArtifactVersion gav, TypeTable.ClassDefinition classDef, TypeTable.Member member) {
        try {
            List<AnnotationDeserializer.AnnotationInfo> annotations = AnnotationDeserializer.parseAnnotations(Objects.requireNonNull(member.getAnnotations()));
            for (AnnotationDeserializer.AnnotationInfo annotation : annotations) {
                List<AnnotationDeserializer.AttributeInfo> attributes;
                if (!annotation.getDescriptor().endsWith("/InlineMe;") || (attributes = annotation.getAttributes()) == null) continue;
                String replacement = null;
                ArrayList<String> imports = new ArrayList<String>();
                ArrayList<String> staticImports = new ArrayList<String>();
                block13: for (AnnotationDeserializer.AttributeInfo attr : attributes) {
                    switch (attr.getName()) {
                        case "replacement": {
                            replacement = (String)attr.getValue();
                            break;
                        }
                        case "imports": {
                            if (!(attr.getValue() instanceof Object[])) break;
                            for (Object imp : (Object[])attr.getValue()) {
                                imports.add((String)imp);
                            }
                            continue block13;
                        }
                        case "staticImports": {
                            if (!(attr.getValue() instanceof Object[])) break;
                            for (Object imp : (Object[])attr.getValue()) {
                                staticImports.add((String)imp);
                            }
                            break;
                        }
                    }
                }
                if (replacement == null) continue;
                String methodPattern = InlineMethodCallsRecipeGenerator.buildMethodPattern(classDef, member);
                return new InlineMeMethod(gav, methodPattern, replacement, imports, staticImports, gav.getArtifactId() + "-" + gav.getVersion());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse annotations for " + classDef.getName() + "." + member.getName() + ": " + e.getMessage());
        }
        return null;
    }

    private static String buildMethodPattern(TypeTable.ClassDefinition classDef, TypeTable.Member member) {
        String className = classDef.getName().replace('/', '.');
        String methodName = member.getName();
        if ("<init>".equals(methodName)) {
            methodName = className.substring(className.lastIndexOf(46) + 1);
        }
        String descriptor = member.getDescriptor();
        String paramPattern = InlineMethodCallsRecipeGenerator.parseMethodParameters(descriptor);
        return className + " " + methodName + paramPattern;
    }

    private static String parseMethodParameters(String descriptor) {
        if (!descriptor.startsWith("(")) {
            return "()";
        }
        ArrayList<String> paramTypes = new ArrayList<String>();
        for (int i = 1; i < descriptor.length() && descriptor.charAt(i) != ')'; i += InlineMethodCallsRecipeGenerator.getTypeLength(descriptor, i)) {
            String type = InlineMethodCallsRecipeGenerator.parseType(descriptor, i);
            paramTypes.add(type);
        }
        if (paramTypes.isEmpty()) {
            return "()";
        }
        return "(" + String.join((CharSequence)", ", paramTypes) + ")";
    }

    private static String parseType(String descriptor, int start) {
        char c = descriptor.charAt(start);
        switch (c) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'V': {
                return "void";
            }
            case 'L': {
                int semicolon = descriptor.indexOf(59, start);
                String className = descriptor.substring(start + 1, semicolon);
                return className.replace('/', '.');
            }
            case '[': {
                String elementType = InlineMethodCallsRecipeGenerator.parseType(descriptor, start + 1);
                return elementType + "[]";
            }
        }
        return "Object";
    }

    private static int getTypeLength(String descriptor, int start) {
        char c = descriptor.charAt(start);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1;
            }
            case 'L': {
                return descriptor.indexOf(59, start) - start + 1;
            }
            case '[': {
                return 1 + InlineMethodCallsRecipeGenerator.getTypeLength(descriptor, start + 1);
            }
        }
        return 1;
    }

    private static void generateYamlRecipes(List<InlineMeMethod> methods, Path outputPath, String recipeName) throws IOException {
        StringBuilder yaml = new StringBuilder();
        Path licenseHeader = Paths.get("gradle/licenseHeader.txt", new String[0]);
        if (Files.isRegularFile(licenseHeader, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(licenseHeader);){
                lines.forEach(line -> yaml.append("# ").append(line.replace("${year}", String.valueOf(Year.now().getValue()))).append("\n"));
            }
        }
        yaml.append("#\n");
        yaml.append("# Generated InlineMe recipes from TypeTable\n");
        yaml.append("#\n\n");
        yaml.append("type: specs.openrewrite.org/v1beta/recipe\n");
        yaml.append(String.format("name: %s\n", recipeName));
        yaml.append("displayName: Inline methods annotated with `@InlineMe`\n");
        yaml.append("description: >-\n");
        yaml.append("  Automatically generated recipes to inline method calls based on `@InlineMe` annotations\n");
        yaml.append("  discovered in the type table.\n");
        yaml.append("recipeList:\n");
        Map<TypeTable.GroupArtifactVersion, List<InlineMeMethod>> methodsByGav = methods.stream().collect(Collectors.groupingBy(m -> m.gav));
        for (Map.Entry<TypeTable.GroupArtifactVersion, List<InlineMeMethod>> entry : methodsByGav.entrySet()) {
            TypeTable.GroupArtifactVersion gav = entry.getKey();
            List<InlineMeMethod> gavMethods = entry.getValue();
            yaml.append("\n  # From ").append(gav.getGroupId()).append(":").append(gav.getArtifactId()).append(":").append(gav.getVersion()).append("\n");
            for (InlineMeMethod method : gavMethods) {
                yaml.append("  - org.openrewrite.java.InlineMethodCalls:\n");
                yaml.append("      methodPattern: '").append(InlineMethodCallsRecipeGenerator.escapeYaml(method.methodPattern)).append("'\n");
                yaml.append("      replacement: '").append(InlineMethodCallsRecipeGenerator.escapeYaml(method.replacement)).append("'\n");
                if (!method.imports.isEmpty()) {
                    yaml.append("      imports:\n");
                    for (String imp : method.imports) {
                        yaml.append("        - '").append(InlineMethodCallsRecipeGenerator.escapeYaml(imp)).append("'\n");
                    }
                }
                if (!method.staticImports.isEmpty()) {
                    yaml.append("      staticImports:\n");
                    for (String imp : method.staticImports) {
                        yaml.append("        - '").append(InlineMethodCallsRecipeGenerator.escapeYaml(imp)).append("'\n");
                    }
                }
                yaml.append("      classpathFromResources:\n");
                yaml.append("        - '").append(InlineMethodCallsRecipeGenerator.escapeYaml(method.classpathResource)).append("'\n");
            }
        }
        Files.write(outputPath, yaml.toString().getBytes(), new OpenOption[0]);
    }

    private static String escapeYaml(String value) {
        return value.replace("'", "''");
    }

    private static class InlineMeMethod {
        final TypeTable.GroupArtifactVersion gav;
        final String methodPattern;
        final String replacement;
        final List<String> imports;
        final List<String> staticImports;
        final String classpathResource;

        @Generated
        public InlineMeMethod(TypeTable.GroupArtifactVersion gav, String methodPattern, String replacement, List<String> imports, List<String> staticImports, String classpathResource) {
            this.gav = gav;
            this.methodPattern = methodPattern;
            this.replacement = replacement;
            this.imports = imports;
            this.staticImports = staticImports;
            this.classpathResource = classpathResource;
        }
    }
}

